/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESSOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processors/{processor}/dataset");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String processor;

    @Deprecated
    protected DatasetName() {
        this.project = null;
        this.location = null;
        this.processor = null;
    }

    private DatasetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.processor = (String)Preconditions.checkNotNull((Object)builder.getProcessor());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcessor() {
        return this.processor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatasetName of(String project, String location, String processor) {
        return DatasetName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).build();
    }

    public static String format(String project, String location, String processor) {
        return DatasetName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).build().toString();
    }

    public static DatasetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESSOR.validatedMatch(formattedString, "DatasetName.parse: formattedString not in valid format");
        return DatasetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("processor"));
    }

    public static List<DatasetName> parseList(List<String> formattedStrings) {
        ArrayList<DatasetName> list = new ArrayList<DatasetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatasetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatasetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatasetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESSOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatasetName datasetName = this;
            synchronized (datasetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.processor != null) {
                        fieldMapBuilder.put((Object)"processor", (Object)this.processor);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESSOR.instantiate(new String[]{"project", this.project, "location", this.location, "processor", this.processor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DatasetName that = (DatasetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.processor, that.processor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.processor);
    }

    public static class Builder {
        private String project;
        private String location;
        private String processor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcessor() {
            return this.processor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcessor(String processor) {
            this.processor = processor;
            return this;
        }

        private Builder(DatasetName datasetName) {
            this.project = datasetName.project;
            this.location = datasetName.location;
            this.processor = datasetName.processor;
        }

        public DatasetName build() {
            return new DatasetName(this);
        }
    }
}

