/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.cloud.documentai.v1beta3.DatasetSplitType;
import com.google.cloud.documentai.v1beta3.DocumentAiDocumentService;
import com.google.cloud.documentai.v1beta3.DocumentId;
import com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder;
import com.google.cloud.documentai.v1beta3.DocumentLabelingState;
import com.google.cloud.documentai.v1beta3.DocumentMetadataOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DocumentMetadata
extends GeneratedMessageV3
implements DocumentMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int DOCUMENT_ID_FIELD_NUMBER = 1;
    private DocumentId documentId_;
    public static final int PAGE_COUNT_FIELD_NUMBER = 2;
    private int pageCount_ = 0;
    public static final int DATASET_TYPE_FIELD_NUMBER = 3;
    private int datasetType_ = 0;
    public static final int LABELING_STATE_FIELD_NUMBER = 5;
    private int labelingState_ = 0;
    public static final int DISPLAY_NAME_FIELD_NUMBER = 6;
    private volatile Object displayName_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final DocumentMetadata DEFAULT_INSTANCE = new DocumentMetadata();
    private static final Parser<DocumentMetadata> PARSER = new AbstractParser<DocumentMetadata>(){

        public DocumentMetadata parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DocumentMetadata.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DocumentMetadata(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DocumentMetadata() {
        this.datasetType_ = 0;
        this.labelingState_ = 0;
        this.displayName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DocumentMetadata();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DocumentAiDocumentService.internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return DocumentAiDocumentService.internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(DocumentMetadata.class, Builder.class);
    }

    @Override
    public boolean hasDocumentId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public DocumentId getDocumentId() {
        return this.documentId_ == null ? DocumentId.getDefaultInstance() : this.documentId_;
    }

    @Override
    public DocumentIdOrBuilder getDocumentIdOrBuilder() {
        return this.documentId_ == null ? DocumentId.getDefaultInstance() : this.documentId_;
    }

    @Override
    public int getPageCount() {
        return this.pageCount_;
    }

    @Override
    public int getDatasetTypeValue() {
        return this.datasetType_;
    }

    @Override
    public DatasetSplitType getDatasetType() {
        DatasetSplitType result = DatasetSplitType.forNumber(this.datasetType_);
        return result == null ? DatasetSplitType.UNRECOGNIZED : result;
    }

    @Override
    public int getLabelingStateValue() {
        return this.labelingState_;
    }

    @Override
    public DocumentLabelingState getLabelingState() {
        DocumentLabelingState result = DocumentLabelingState.forNumber(this.labelingState_);
        return result == null ? DocumentLabelingState.UNRECOGNIZED : result;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getDocumentId());
        }
        if (this.pageCount_ != 0) {
            output.writeInt32(2, this.pageCount_);
        }
        if (this.datasetType_ != DatasetSplitType.DATASET_SPLIT_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.datasetType_);
        }
        if (this.labelingState_ != DocumentLabelingState.DOCUMENT_LABELING_STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.labelingState_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.displayName_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getDocumentId());
        }
        if (this.pageCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.pageCount_);
        }
        if (this.datasetType_ != DatasetSplitType.DATASET_SPLIT_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.datasetType_);
        }
        if (this.labelingState_ != DocumentLabelingState.DOCUMENT_LABELING_STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.labelingState_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.displayName_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return super.equals(obj);
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        if (this.hasDocumentId() != other.hasDocumentId()) {
            return false;
        }
        if (this.hasDocumentId() && !this.getDocumentId().equals(other.getDocumentId())) {
            return false;
        }
        if (this.getPageCount() != other.getPageCount()) {
            return false;
        }
        if (this.datasetType_ != other.datasetType_) {
            return false;
        }
        if (this.labelingState_ != other.labelingState_) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DocumentMetadata.getDescriptor().hashCode();
        if (this.hasDocumentId()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getDocumentId().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getPageCount();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.datasetType_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.labelingState_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getDisplayName().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static DocumentMetadata parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DocumentMetadata)PARSER.parseFrom(data);
    }

    public static DocumentMetadata parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DocumentMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DocumentMetadata parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DocumentMetadata)PARSER.parseFrom(data);
    }

    public static DocumentMetadata parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DocumentMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DocumentMetadata parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DocumentMetadata)PARSER.parseFrom(data);
    }

    public static DocumentMetadata parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DocumentMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DocumentMetadata parseFrom(InputStream input) throws IOException {
        return (DocumentMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DocumentMetadata parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DocumentMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DocumentMetadata parseDelimitedFrom(InputStream input) throws IOException {
        return (DocumentMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DocumentMetadata parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DocumentMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DocumentMetadata parseFrom(CodedInputStream input) throws IOException {
        return (DocumentMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DocumentMetadata parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DocumentMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DocumentMetadata.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DocumentMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DocumentMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DocumentMetadata> parser() {
        return PARSER;
    }

    public Parser<DocumentMetadata> getParserForType() {
        return PARSER;
    }

    public DocumentMetadata getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DocumentMetadataOrBuilder {
        private int bitField0_;
        private DocumentId documentId_;
        private SingleFieldBuilderV3<DocumentId, DocumentId.Builder, DocumentIdOrBuilder> documentIdBuilder_;
        private int pageCount_;
        private int datasetType_ = 0;
        private int labelingState_ = 0;
        private Object displayName_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return DocumentAiDocumentService.internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DocumentAiDocumentService.internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(DocumentMetadata.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getDocumentIdFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.documentId_ = null;
            if (this.documentIdBuilder_ != null) {
                this.documentIdBuilder_.dispose();
                this.documentIdBuilder_ = null;
            }
            this.pageCount_ = 0;
            this.datasetType_ = 0;
            this.labelingState_ = 0;
            this.displayName_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DocumentAiDocumentService.internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_descriptor;
        }

        public DocumentMetadata getDefaultInstanceForType() {
            return DocumentMetadata.getDefaultInstance();
        }

        public DocumentMetadata build() {
            DocumentMetadata result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DocumentMetadata buildPartial() {
            DocumentMetadata result = new DocumentMetadata(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(DocumentMetadata result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.documentId_ = this.documentIdBuilder_ == null ? this.documentId_ : (DocumentId)this.documentIdBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.pageCount_ = this.pageCount_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.datasetType_ = this.datasetType_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.labelingState_ = this.labelingState_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.displayName_ = this.displayName_;
            }
            DocumentMetadata documentMetadata = result;
            documentMetadata.bitField0_ = documentMetadata.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DocumentMetadata) {
                return this.mergeFrom((DocumentMetadata)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DocumentMetadata other) {
            if (other == DocumentMetadata.getDefaultInstance()) {
                return this;
            }
            if (other.hasDocumentId()) {
                this.mergeDocumentId(other.getDocumentId());
            }
            if (other.getPageCount() != 0) {
                this.setPageCount(other.getPageCount());
            }
            if (other.datasetType_ != 0) {
                this.setDatasetTypeValue(other.getDatasetTypeValue());
            }
            if (other.labelingState_ != 0) {
                this.setLabelingStateValue(other.getLabelingStateValue());
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getDocumentIdFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 16: {
                            this.pageCount_ = input.readInt32();
                            this.bitField0_ |= 2;
                            continue block13;
                        }
                        case 24: {
                            this.datasetType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block13;
                        }
                        case 40: {
                            this.labelingState_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block13;
                        }
                        case 50: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasDocumentId() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public DocumentId getDocumentId() {
            if (this.documentIdBuilder_ == null) {
                return this.documentId_ == null ? DocumentId.getDefaultInstance() : this.documentId_;
            }
            return (DocumentId)this.documentIdBuilder_.getMessage();
        }

        public Builder setDocumentId(DocumentId value) {
            if (this.documentIdBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.documentId_ = value;
            } else {
                this.documentIdBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setDocumentId(DocumentId.Builder builderForValue) {
            if (this.documentIdBuilder_ == null) {
                this.documentId_ = builderForValue.build();
            } else {
                this.documentIdBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeDocumentId(DocumentId value) {
            if (this.documentIdBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.documentId_ != null && this.documentId_ != DocumentId.getDefaultInstance()) {
                    this.getDocumentIdBuilder().mergeFrom(value);
                } else {
                    this.documentId_ = value;
                }
            } else {
                this.documentIdBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.documentId_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDocumentId() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.documentId_ = null;
            if (this.documentIdBuilder_ != null) {
                this.documentIdBuilder_.dispose();
                this.documentIdBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DocumentId.Builder getDocumentIdBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (DocumentId.Builder)this.getDocumentIdFieldBuilder().getBuilder();
        }

        @Override
        public DocumentIdOrBuilder getDocumentIdOrBuilder() {
            if (this.documentIdBuilder_ != null) {
                return (DocumentIdOrBuilder)this.documentIdBuilder_.getMessageOrBuilder();
            }
            return this.documentId_ == null ? DocumentId.getDefaultInstance() : this.documentId_;
        }

        private SingleFieldBuilderV3<DocumentId, DocumentId.Builder, DocumentIdOrBuilder> getDocumentIdFieldBuilder() {
            if (this.documentIdBuilder_ == null) {
                this.documentIdBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDocumentId(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.documentId_ = null;
            }
            return this.documentIdBuilder_;
        }

        @Override
        public int getPageCount() {
            return this.pageCount_;
        }

        public Builder setPageCount(int value) {
            this.pageCount_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearPageCount() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.pageCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getDatasetTypeValue() {
            return this.datasetType_;
        }

        public Builder setDatasetTypeValue(int value) {
            this.datasetType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public DatasetSplitType getDatasetType() {
            DatasetSplitType result = DatasetSplitType.forNumber(this.datasetType_);
            return result == null ? DatasetSplitType.UNRECOGNIZED : result;
        }

        public Builder setDatasetType(DatasetSplitType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.datasetType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDatasetType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.datasetType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getLabelingStateValue() {
            return this.labelingState_;
        }

        public Builder setLabelingStateValue(int value) {
            this.labelingState_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public DocumentLabelingState getLabelingState() {
            DocumentLabelingState result = DocumentLabelingState.forNumber(this.labelingState_);
            return result == null ? DocumentLabelingState.UNRECOGNIZED : result;
        }

        public Builder setLabelingState(DocumentLabelingState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.labelingState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearLabelingState() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.labelingState_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = DocumentMetadata.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DocumentMetadata.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

