/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HumanReviewConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processors/{processor}/humanReviewConfig");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String processor;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcessor() {
        return this.processor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private HumanReviewConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.processor = (String)Preconditions.checkNotNull((Object)builder.getProcessor());
    }

    public static HumanReviewConfigName of(String project, String location, String processor) {
        return HumanReviewConfigName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).build();
    }

    public static String format(String project, String location, String processor) {
        return HumanReviewConfigName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).build().toString();
    }

    public static HumanReviewConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "HumanReviewConfigName.parse: formattedString not in valid format");
        return HumanReviewConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("processor"));
    }

    public static List<HumanReviewConfigName> parseList(List<String> formattedStrings) {
        ArrayList<HumanReviewConfigName> list = new ArrayList<HumanReviewConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HumanReviewConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HumanReviewConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HumanReviewConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HumanReviewConfigName humanReviewConfigName = this;
            synchronized (humanReviewConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"processor", (Object)this.processor);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "processor", this.processor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HumanReviewConfigName) {
            HumanReviewConfigName that = (HumanReviewConfigName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.processor.equals(that.processor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.processor.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String processor;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcessor() {
            return this.processor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcessor(String processor) {
            this.processor = processor;
            return this;
        }

        private Builder() {
        }

        private Builder(HumanReviewConfigName humanReviewConfigName) {
            this.project = humanReviewConfigName.project;
            this.location = humanReviewConfigName.location;
            this.processor = humanReviewConfigName.processor;
        }

        public HumanReviewConfigName build() {
            return new HumanReviewConfigName(this);
        }
    }
}

