/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESSOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processors/{processor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String processor;

    @Deprecated
    protected ProcessorName() {
        this.project = null;
        this.location = null;
        this.processor = null;
    }

    private ProcessorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.processor = (String)Preconditions.checkNotNull((Object)builder.getProcessor());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcessor() {
        return this.processor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProcessorName of(String project, String location, String processor) {
        return ProcessorName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).build();
    }

    public static String format(String project, String location, String processor) {
        return ProcessorName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).build().toString();
    }

    public static ProcessorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESSOR.validatedMatch(formattedString, "ProcessorName.parse: formattedString not in valid format");
        return ProcessorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("processor"));
    }

    public static List<ProcessorName> parseList(List<String> formattedStrings) {
        ArrayList<ProcessorName> list = new ArrayList<ProcessorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProcessorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProcessorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProcessorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESSOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProcessorName processorName = this;
            synchronized (processorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.processor != null) {
                        fieldMapBuilder.put((Object)"processor", (Object)this.processor);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESSOR.instantiate(new String[]{"project", this.project, "location", this.location, "processor", this.processor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProcessorName that = (ProcessorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.processor, that.processor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.processor);
    }

    public static class Builder {
        private String project;
        private String location;
        private String processor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcessor() {
            return this.processor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcessor(String processor) {
            this.processor = processor;
            return this;
        }

        private Builder(ProcessorName processorName) {
            this.project = processorName.project;
            this.location = processorName.location;
            this.processor = processorName.processor;
        }

        public ProcessorName build() {
            return new ProcessorName(this);
        }
    }
}

