/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversionWorkspaceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSION_WORKSPACE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String conversionWorkspace;

    @Deprecated
    protected ConversionWorkspaceName() {
        this.project = null;
        this.location = null;
        this.conversionWorkspace = null;
    }

    private ConversionWorkspaceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversionWorkspace = (String)Preconditions.checkNotNull((Object)builder.getConversionWorkspace());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversionWorkspace() {
        return this.conversionWorkspace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionWorkspaceName of(String project, String location, String conversionWorkspace) {
        return ConversionWorkspaceName.newBuilder().setProject(project).setLocation(location).setConversionWorkspace(conversionWorkspace).build();
    }

    public static String format(String project, String location, String conversionWorkspace) {
        return ConversionWorkspaceName.newBuilder().setProject(project).setLocation(location).setConversionWorkspace(conversionWorkspace).build().toString();
    }

    public static ConversionWorkspaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONVERSION_WORKSPACE.validatedMatch(formattedString, "ConversionWorkspaceName.parse: formattedString not in valid format");
        return ConversionWorkspaceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversion_workspace"));
    }

    public static List<ConversionWorkspaceName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionWorkspaceName> list = new ArrayList<ConversionWorkspaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionWorkspaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionWorkspaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionWorkspaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSION_WORKSPACE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionWorkspaceName conversionWorkspaceName = this;
            synchronized (conversionWorkspaceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversionWorkspace != null) {
                        fieldMapBuilder.put((Object)"conversion_workspace", (Object)this.conversionWorkspace);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONVERSION_WORKSPACE.instantiate(new String[]{"project", this.project, "location", this.location, "conversion_workspace", this.conversionWorkspace});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ConversionWorkspaceName that = (ConversionWorkspaceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversionWorkspace, that.conversionWorkspace);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversionWorkspace);
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversionWorkspace;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversionWorkspace() {
            return this.conversionWorkspace;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversionWorkspace(String conversionWorkspace) {
            this.conversionWorkspace = conversionWorkspace;
            return this;
        }

        private Builder(ConversionWorkspaceName conversionWorkspaceName) {
            this.project = conversionWorkspaceName.project;
            this.location = conversionWorkspaceName.location;
            this.conversionWorkspace = conversionWorkspaceName.conversionWorkspace;
        }

        public ConversionWorkspaceName build() {
            return new ConversionWorkspaceName(this);
        }
    }
}

