/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DlpJobName
implements ResourceName {
    private static final PathTemplate PROJECT_DLP_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dlpJobs/{dlp_job}");
    private static final PathTemplate PROJECT_LOCATION_DLP_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dlpJobs/{dlp_job}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String dlpJob;
    private final String location;

    @Deprecated
    protected DlpJobName() {
        this.project = null;
        this.dlpJob = null;
        this.location = null;
    }

    private DlpJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dlpJob = (String)Preconditions.checkNotNull((Object)builder.getDlpJob());
        this.location = null;
        this.pathTemplate = PROJECT_DLP_JOB;
    }

    private DlpJobName(ProjectLocationDlpJobBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dlpJob = (String)Preconditions.checkNotNull((Object)builder.getDlpJob());
        this.pathTemplate = PROJECT_LOCATION_DLP_JOB;
    }

    public String getProject() {
        return this.project;
    }

    public String getDlpJob() {
        return this.dlpJob;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectDlpJobBuilder() {
        return new Builder();
    }

    public static ProjectLocationDlpJobBuilder newProjectLocationDlpJobBuilder() {
        return new ProjectLocationDlpJobBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DlpJobName of(String project, String dlpJob) {
        return DlpJobName.newBuilder().setProject(project).setDlpJob(dlpJob).build();
    }

    public static DlpJobName ofProjectDlpJobName(String project, String dlpJob) {
        return DlpJobName.newBuilder().setProject(project).setDlpJob(dlpJob).build();
    }

    public static DlpJobName ofProjectLocationDlpJobName(String project, String location, String dlpJob) {
        return DlpJobName.newProjectLocationDlpJobBuilder().setProject(project).setLocation(location).setDlpJob(dlpJob).build();
    }

    public static String format(String project, String dlpJob) {
        return DlpJobName.newBuilder().setProject(project).setDlpJob(dlpJob).build().toString();
    }

    public static String formatProjectDlpJobName(String project, String dlpJob) {
        return DlpJobName.newBuilder().setProject(project).setDlpJob(dlpJob).build().toString();
    }

    public static String formatProjectLocationDlpJobName(String project, String location, String dlpJob) {
        return DlpJobName.newProjectLocationDlpJobBuilder().setProject(project).setLocation(location).setDlpJob(dlpJob).build().toString();
    }

    public static DlpJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_DLP_JOB.matches(formattedString)) {
            Map matchMap = PROJECT_DLP_JOB.match(formattedString);
            return DlpJobName.ofProjectDlpJobName((String)matchMap.get("project"), (String)matchMap.get("dlp_job"));
        }
        if (PROJECT_LOCATION_DLP_JOB.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DLP_JOB.match(formattedString);
            return DlpJobName.ofProjectLocationDlpJobName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dlp_job"));
        }
        throw new ValidationException("DlpJobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<DlpJobName> parseList(List<String> formattedStrings) {
        ArrayList<DlpJobName> list = new ArrayList<DlpJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DlpJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DlpJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DlpJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DLP_JOB.matches(formattedString) || PROJECT_LOCATION_DLP_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DlpJobName dlpJobName = this;
            synchronized (dlpJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dlpJob != null) {
                        fieldMapBuilder.put((Object)"dlp_job", (Object)this.dlpJob);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DlpJobName that = (DlpJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dlpJob, that.dlpJob) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.dlpJob);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationDlpJobBuilder {
        private String project;
        private String location;
        private String dlpJob;

        protected ProjectLocationDlpJobBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDlpJob() {
            return this.dlpJob;
        }

        public ProjectLocationDlpJobBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationDlpJobBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationDlpJobBuilder setDlpJob(String dlpJob) {
            this.dlpJob = dlpJob;
            return this;
        }

        public DlpJobName build() {
            return new DlpJobName(this);
        }
    }

    public static class Builder {
        private String project;
        private String dlpJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDlpJob() {
            return this.dlpJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDlpJob(String dlpJob) {
            this.dlpJob = dlpJob;
            return this;
        }

        private Builder(DlpJobName dlpJobName) {
            Preconditions.checkArgument((boolean)Objects.equals(dlpJobName.pathTemplate, PROJECT_DLP_JOB), (Object)"toBuilder is only supported when DlpJobName has the pattern of projects/{project}/dlpJobs/{dlp_job}");
            this.project = dlpJobName.project;
            this.dlpJob = dlpJobName.dlpJob;
        }

        public DlpJobName build() {
            return new DlpJobName(this);
        }
    }
}

