/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableDataProfileName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_TABLE_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}");
    private static final PathTemplate PROJECT_LOCATION_TABLE_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tableDataProfiles/{table_data_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String tableDataProfile;
    private final String project;

    @Deprecated
    protected TableDataProfileName() {
        this.organization = null;
        this.location = null;
        this.tableDataProfile = null;
        this.project = null;
    }

    private TableDataProfileName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tableDataProfile = (String)Preconditions.checkNotNull((Object)builder.getTableDataProfile());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_TABLE_DATA_PROFILE;
    }

    private TableDataProfileName(ProjectLocationTableDataProfileBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tableDataProfile = (String)Preconditions.checkNotNull((Object)builder.getTableDataProfile());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_TABLE_DATA_PROFILE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTableDataProfile() {
        return this.tableDataProfile;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationTableDataProfileBuilder() {
        return new Builder();
    }

    public static ProjectLocationTableDataProfileBuilder newProjectLocationTableDataProfileBuilder() {
        return new ProjectLocationTableDataProfileBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TableDataProfileName of(String organization, String location, String tableDataProfile) {
        return TableDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setTableDataProfile(tableDataProfile).build();
    }

    public static TableDataProfileName ofOrganizationLocationTableDataProfileName(String organization, String location, String tableDataProfile) {
        return TableDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setTableDataProfile(tableDataProfile).build();
    }

    public static TableDataProfileName ofProjectLocationTableDataProfileName(String project, String location, String tableDataProfile) {
        return TableDataProfileName.newProjectLocationTableDataProfileBuilder().setProject(project).setLocation(location).setTableDataProfile(tableDataProfile).build();
    }

    public static String format(String organization, String location, String tableDataProfile) {
        return TableDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setTableDataProfile(tableDataProfile).build().toString();
    }

    public static String formatOrganizationLocationTableDataProfileName(String organization, String location, String tableDataProfile) {
        return TableDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setTableDataProfile(tableDataProfile).build().toString();
    }

    public static String formatProjectLocationTableDataProfileName(String project, String location, String tableDataProfile) {
        return TableDataProfileName.newProjectLocationTableDataProfileBuilder().setProject(project).setLocation(location).setTableDataProfile(tableDataProfile).build().toString();
    }

    public static TableDataProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_TABLE_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_TABLE_DATA_PROFILE.match(formattedString);
            return TableDataProfileName.ofOrganizationLocationTableDataProfileName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("table_data_profile"));
        }
        if (PROJECT_LOCATION_TABLE_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_TABLE_DATA_PROFILE.match(formattedString);
            return TableDataProfileName.ofProjectLocationTableDataProfileName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("table_data_profile"));
        }
        throw new ValidationException("TableDataProfileName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<TableDataProfileName> parseList(List<String> formattedStrings) {
        ArrayList<TableDataProfileName> list = new ArrayList<TableDataProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TableDataProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TableDataProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TableDataProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_TABLE_DATA_PROFILE.matches(formattedString) || PROJECT_LOCATION_TABLE_DATA_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TableDataProfileName tableDataProfileName = this;
            synchronized (tableDataProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tableDataProfile != null) {
                        fieldMapBuilder.put((Object)"table_data_profile", (Object)this.tableDataProfile);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TableDataProfileName that = (TableDataProfileName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.tableDataProfile, that.tableDataProfile) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.tableDataProfile);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationTableDataProfileBuilder {
        private String project;
        private String location;
        private String tableDataProfile;

        protected ProjectLocationTableDataProfileBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTableDataProfile() {
            return this.tableDataProfile;
        }

        public ProjectLocationTableDataProfileBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationTableDataProfileBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationTableDataProfileBuilder setTableDataProfile(String tableDataProfile) {
            this.tableDataProfile = tableDataProfile;
            return this;
        }

        public TableDataProfileName build() {
            return new TableDataProfileName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String tableDataProfile;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTableDataProfile() {
            return this.tableDataProfile;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTableDataProfile(String tableDataProfile) {
            this.tableDataProfile = tableDataProfile;
            return this;
        }

        private Builder(TableDataProfileName tableDataProfileName) {
            Preconditions.checkArgument((boolean)Objects.equals(tableDataProfileName.pathTemplate, ORGANIZATION_LOCATION_TABLE_DATA_PROFILE), (Object)"toBuilder is only supported when TableDataProfileName has the pattern of organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}");
            this.organization = tableDataProfileName.organization;
            this.location = tableDataProfileName.location;
            this.tableDataProfile = tableDataProfileName.tableDataProfile;
        }

        public TableDataProfileName build() {
            return new TableDataProfileName(this);
        }
    }
}

