/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class StoredInfoTypeName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_STORED_INFO_TYPE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/storedInfoTypes/{stored_info_type}");
    private static final PathTemplate PROJECT_STORED_INFO_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/storedInfoTypes/{stored_info_type}");
    private static final PathTemplate ORGANIZATION_LOCATION_STORED_INFO_TYPE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/storedInfoTypes/{stored_info_type}");
    private static final PathTemplate PROJECT_LOCATION_STORED_INFO_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/storedInfoTypes/{stored_info_type}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String storedInfoType;
    private final String project;
    private final String location;

    @Deprecated
    protected StoredInfoTypeName() {
        this.organization = null;
        this.storedInfoType = null;
        this.project = null;
        this.location = null;
    }

    private StoredInfoTypeName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.storedInfoType = (String)Preconditions.checkNotNull((Object)builder.getStoredInfoType());
        this.project = null;
        this.location = null;
        this.pathTemplate = ORGANIZATION_STORED_INFO_TYPE;
    }

    private StoredInfoTypeName(ProjectStoredInfoTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.storedInfoType = (String)Preconditions.checkNotNull((Object)builder.getStoredInfoType());
        this.organization = null;
        this.location = null;
        this.pathTemplate = PROJECT_STORED_INFO_TYPE;
    }

    private StoredInfoTypeName(OrganizationLocationStoredInfoTypeBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.storedInfoType = (String)Preconditions.checkNotNull((Object)builder.getStoredInfoType());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_STORED_INFO_TYPE;
    }

    private StoredInfoTypeName(ProjectLocationStoredInfoTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.storedInfoType = (String)Preconditions.checkNotNull((Object)builder.getStoredInfoType());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_STORED_INFO_TYPE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getStoredInfoType() {
        return this.storedInfoType;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationStoredInfoTypeBuilder() {
        return new Builder();
    }

    public static ProjectStoredInfoTypeBuilder newProjectStoredInfoTypeBuilder() {
        return new ProjectStoredInfoTypeBuilder();
    }

    public static OrganizationLocationStoredInfoTypeBuilder newOrganizationLocationStoredInfoTypeBuilder() {
        return new OrganizationLocationStoredInfoTypeBuilder();
    }

    public static ProjectLocationStoredInfoTypeBuilder newProjectLocationStoredInfoTypeBuilder() {
        return new ProjectLocationStoredInfoTypeBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static StoredInfoTypeName of(String organization, String storedInfoType) {
        return StoredInfoTypeName.newBuilder().setOrganization(organization).setStoredInfoType(storedInfoType).build();
    }

    public static StoredInfoTypeName ofOrganizationStoredInfoTypeName(String organization, String storedInfoType) {
        return StoredInfoTypeName.newBuilder().setOrganization(organization).setStoredInfoType(storedInfoType).build();
    }

    public static StoredInfoTypeName ofProjectStoredInfoTypeName(String project, String storedInfoType) {
        return StoredInfoTypeName.newProjectStoredInfoTypeBuilder().setProject(project).setStoredInfoType(storedInfoType).build();
    }

    public static StoredInfoTypeName ofOrganizationLocationStoredInfoTypeName(String organization, String location, String storedInfoType) {
        return StoredInfoTypeName.newOrganizationLocationStoredInfoTypeBuilder().setOrganization(organization).setLocation(location).setStoredInfoType(storedInfoType).build();
    }

    public static StoredInfoTypeName ofProjectLocationStoredInfoTypeName(String project, String location, String storedInfoType) {
        return StoredInfoTypeName.newProjectLocationStoredInfoTypeBuilder().setProject(project).setLocation(location).setStoredInfoType(storedInfoType).build();
    }

    public static String format(String organization, String storedInfoType) {
        return StoredInfoTypeName.newBuilder().setOrganization(organization).setStoredInfoType(storedInfoType).build().toString();
    }

    public static String formatOrganizationStoredInfoTypeName(String organization, String storedInfoType) {
        return StoredInfoTypeName.newBuilder().setOrganization(organization).setStoredInfoType(storedInfoType).build().toString();
    }

    public static String formatProjectStoredInfoTypeName(String project, String storedInfoType) {
        return StoredInfoTypeName.newProjectStoredInfoTypeBuilder().setProject(project).setStoredInfoType(storedInfoType).build().toString();
    }

    public static String formatOrganizationLocationStoredInfoTypeName(String organization, String location, String storedInfoType) {
        return StoredInfoTypeName.newOrganizationLocationStoredInfoTypeBuilder().setOrganization(organization).setLocation(location).setStoredInfoType(storedInfoType).build().toString();
    }

    public static String formatProjectLocationStoredInfoTypeName(String project, String location, String storedInfoType) {
        return StoredInfoTypeName.newProjectLocationStoredInfoTypeBuilder().setProject(project).setLocation(location).setStoredInfoType(storedInfoType).build().toString();
    }

    public static StoredInfoTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_STORED_INFO_TYPE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_STORED_INFO_TYPE.match(formattedString);
            return StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)matchMap.get("organization"), (String)matchMap.get("stored_info_type"));
        }
        if (PROJECT_STORED_INFO_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_STORED_INFO_TYPE.match(formattedString);
            return StoredInfoTypeName.ofProjectStoredInfoTypeName((String)matchMap.get("project"), (String)matchMap.get("stored_info_type"));
        }
        if (ORGANIZATION_LOCATION_STORED_INFO_TYPE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_STORED_INFO_TYPE.match(formattedString);
            return StoredInfoTypeName.ofOrganizationLocationStoredInfoTypeName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("stored_info_type"));
        }
        if (PROJECT_LOCATION_STORED_INFO_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_STORED_INFO_TYPE.match(formattedString);
            return StoredInfoTypeName.ofProjectLocationStoredInfoTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("stored_info_type"));
        }
        throw new ValidationException("StoredInfoTypeName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_STORED_INFO_TYPE.matches(formattedString) || PROJECT_STORED_INFO_TYPE.matches(formattedString) || ORGANIZATION_LOCATION_STORED_INFO_TYPE.matches(formattedString) || PROJECT_LOCATION_STORED_INFO_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StoredInfoTypeName storedInfoTypeName = this;
            synchronized (storedInfoTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.storedInfoType != null) {
                        fieldMapBuilder.put((Object)"stored_info_type", (Object)this.storedInfoType);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StoredInfoTypeName that = (StoredInfoTypeName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.storedInfoType, that.storedInfoType) && Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.storedInfoType);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationStoredInfoTypeBuilder {
        private String project;
        private String location;
        private String storedInfoType;

        protected ProjectLocationStoredInfoTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStoredInfoType() {
            return this.storedInfoType;
        }

        public ProjectLocationStoredInfoTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationStoredInfoTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationStoredInfoTypeBuilder setStoredInfoType(String storedInfoType) {
            this.storedInfoType = storedInfoType;
            return this;
        }

        public StoredInfoTypeName build() {
            return new StoredInfoTypeName(this);
        }
    }

    public static class OrganizationLocationStoredInfoTypeBuilder {
        private String organization;
        private String location;
        private String storedInfoType;

        protected OrganizationLocationStoredInfoTypeBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStoredInfoType() {
            return this.storedInfoType;
        }

        public OrganizationLocationStoredInfoTypeBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationStoredInfoTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationStoredInfoTypeBuilder setStoredInfoType(String storedInfoType) {
            this.storedInfoType = storedInfoType;
            return this;
        }

        public StoredInfoTypeName build() {
            return new StoredInfoTypeName(this);
        }
    }

    public static class ProjectStoredInfoTypeBuilder {
        private String project;
        private String storedInfoType;

        protected ProjectStoredInfoTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getStoredInfoType() {
            return this.storedInfoType;
        }

        public ProjectStoredInfoTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectStoredInfoTypeBuilder setStoredInfoType(String storedInfoType) {
            this.storedInfoType = storedInfoType;
            return this;
        }

        public StoredInfoTypeName build() {
            return new StoredInfoTypeName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String storedInfoType;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getStoredInfoType() {
            return this.storedInfoType;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setStoredInfoType(String storedInfoType) {
            this.storedInfoType = storedInfoType;
            return this;
        }

        private Builder(StoredInfoTypeName storedInfoTypeName) {
            Preconditions.checkArgument((boolean)Objects.equals(storedInfoTypeName.pathTemplate, ORGANIZATION_STORED_INFO_TYPE), (Object)"toBuilder is only supported when StoredInfoTypeName has the pattern of organizations/{organization}/storedInfoTypes/{stored_info_type}");
            this.organization = storedInfoTypeName.organization;
            this.storedInfoType = storedInfoTypeName.storedInfoType;
        }

        public StoredInfoTypeName build() {
            return new StoredInfoTypeName(this);
        }
    }
}

