/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONNECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/connections/{connection}");
    private static final PathTemplate ORGANIZATION_LOCATION_CONNECTION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/connections/{connection}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String connection;
    private final String organization;

    @Deprecated
    protected ConnectionName() {
        this.project = null;
        this.location = null;
        this.connection = null;
        this.organization = null;
    }

    private ConnectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connection = (String)Preconditions.checkNotNull((Object)builder.getConnection());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_CONNECTION;
    }

    private ConnectionName(OrganizationLocationConnectionBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connection = (String)Preconditions.checkNotNull((Object)builder.getConnection());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_CONNECTION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationConnectionBuilder() {
        return new Builder();
    }

    public static OrganizationLocationConnectionBuilder newOrganizationLocationConnectionBuilder() {
        return new OrganizationLocationConnectionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConnectionName of(String project, String location, String connection) {
        return ConnectionName.newBuilder().setProject(project).setLocation(location).setConnection(connection).build();
    }

    public static ConnectionName ofProjectLocationConnectionName(String project, String location, String connection) {
        return ConnectionName.newBuilder().setProject(project).setLocation(location).setConnection(connection).build();
    }

    public static ConnectionName ofOrganizationLocationConnectionName(String organization, String location, String connection) {
        return ConnectionName.newOrganizationLocationConnectionBuilder().setOrganization(organization).setLocation(location).setConnection(connection).build();
    }

    public static String format(String project, String location, String connection) {
        return ConnectionName.newBuilder().setProject(project).setLocation(location).setConnection(connection).build().toString();
    }

    public static String formatProjectLocationConnectionName(String project, String location, String connection) {
        return ConnectionName.newBuilder().setProject(project).setLocation(location).setConnection(connection).build().toString();
    }

    public static String formatOrganizationLocationConnectionName(String organization, String location, String connection) {
        return ConnectionName.newOrganizationLocationConnectionBuilder().setOrganization(organization).setLocation(location).setConnection(connection).build().toString();
    }

    public static ConnectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_CONNECTION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONNECTION.match(formattedString);
            return ConnectionName.ofProjectLocationConnectionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("connection"));
        }
        if (ORGANIZATION_LOCATION_CONNECTION.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_CONNECTION.match(formattedString);
            return ConnectionName.ofOrganizationLocationConnectionName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("connection"));
        }
        throw new ValidationException("ConnectionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConnectionName> parseList(List<String> formattedStrings) {
        ArrayList<ConnectionName> list = new ArrayList<ConnectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConnectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConnectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConnectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONNECTION.matches(formattedString) || ORGANIZATION_LOCATION_CONNECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConnectionName connectionName = this;
            synchronized (connectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.connection != null) {
                        fieldMapBuilder.put((Object)"connection", (Object)this.connection);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConnectionName that = (ConnectionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.connection, that.connection) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.connection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationConnectionBuilder {
        private String organization;
        private String location;
        private String connection;

        protected OrganizationLocationConnectionBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnection() {
            return this.connection;
        }

        public OrganizationLocationConnectionBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationConnectionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationConnectionBuilder setConnection(String connection) {
            this.connection = connection;
            return this;
        }

        public ConnectionName build() {
            return new ConnectionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String connection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnection() {
            return this.connection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConnection(String connection) {
            this.connection = connection;
            return this;
        }

        private Builder(ConnectionName connectionName) {
            Preconditions.checkArgument((boolean)Objects.equals(connectionName.pathTemplate, PROJECT_LOCATION_CONNECTION), (Object)"toBuilder is only supported when ConnectionName has the pattern of projects/{project}/locations/{location}/connections/{connection}");
            this.project = connectionName.project;
            this.location = connectionName.location;
            this.connection = connectionName.connection;
        }

        public ConnectionName build() {
            return new ConnectionName(this);
        }
    }
}

