/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobTriggerName
implements ResourceName {
    private static final PathTemplate PROJECT_JOB_TRIGGER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/jobTriggers/{job_trigger}");
    private static final PathTemplate PROJECT_LOCATION_JOB_TRIGGER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/jobTriggers/{job_trigger}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String jobTrigger;
    private final String location;

    @Deprecated
    protected JobTriggerName() {
        this.project = null;
        this.jobTrigger = null;
        this.location = null;
    }

    private JobTriggerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.jobTrigger = (String)Preconditions.checkNotNull((Object)builder.getJobTrigger());
        this.location = null;
        this.pathTemplate = PROJECT_JOB_TRIGGER;
    }

    private JobTriggerName(ProjectLocationJobTriggerBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.jobTrigger = (String)Preconditions.checkNotNull((Object)builder.getJobTrigger());
        this.pathTemplate = PROJECT_LOCATION_JOB_TRIGGER;
    }

    public String getProject() {
        return this.project;
    }

    public String getJobTrigger() {
        return this.jobTrigger;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectJobTriggerBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationJobTriggerBuilder newProjectLocationJobTriggerBuilder() {
        return new ProjectLocationJobTriggerBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static JobTriggerName of(String project, String jobTrigger) {
        return JobTriggerName.newBuilder().setProject(project).setJobTrigger(jobTrigger).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static JobTriggerName ofProjectJobTriggerName(String project, String jobTrigger) {
        return JobTriggerName.newBuilder().setProject(project).setJobTrigger(jobTrigger).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static JobTriggerName ofProjectLocationJobTriggerName(String project, String location, String jobTrigger) {
        return JobTriggerName.newProjectLocationJobTriggerBuilder().setProject(project).setLocation(location).setJobTrigger(jobTrigger).build();
    }

    public static String format(String project, String jobTrigger) {
        return JobTriggerName.newBuilder().setProject(project).setJobTrigger(jobTrigger).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectJobTriggerName(String project, String jobTrigger) {
        return JobTriggerName.newBuilder().setProject(project).setJobTrigger(jobTrigger).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationJobTriggerName(String project, String location, String jobTrigger) {
        return JobTriggerName.newProjectLocationJobTriggerBuilder().setProject(project).setLocation(location).setJobTrigger(jobTrigger).build().toString();
    }

    public static JobTriggerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_JOB_TRIGGER.matches(formattedString)) {
            Map matchMap = PROJECT_JOB_TRIGGER.match(formattedString);
            return JobTriggerName.ofProjectJobTriggerName((String)matchMap.get("project"), (String)matchMap.get("job_trigger"));
        }
        if (PROJECT_LOCATION_JOB_TRIGGER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_JOB_TRIGGER.match(formattedString);
            return JobTriggerName.ofProjectLocationJobTriggerName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("job_trigger"));
        }
        throw new ValidationException("JobTriggerName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<JobTriggerName> parseList(List<String> formattedStrings) {
        ArrayList<JobTriggerName> list = new ArrayList<JobTriggerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(JobTriggerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<JobTriggerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (JobTriggerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_JOB_TRIGGER.matches(formattedString) || PROJECT_LOCATION_JOB_TRIGGER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            JobTriggerName jobTriggerName = this;
            synchronized (jobTriggerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.jobTrigger != null) {
                        fieldMapBuilder.put((Object)"job_trigger", (Object)this.jobTrigger);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            JobTriggerName that = (JobTriggerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.jobTrigger, that.jobTrigger) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.jobTrigger);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationJobTriggerBuilder {
        private String project;
        private String location;
        private String jobTrigger;

        protected ProjectLocationJobTriggerBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getJobTrigger() {
            return this.jobTrigger;
        }

        public ProjectLocationJobTriggerBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationJobTriggerBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationJobTriggerBuilder setJobTrigger(String jobTrigger) {
            this.jobTrigger = jobTrigger;
            return this;
        }

        public JobTriggerName build() {
            return new JobTriggerName(this);
        }
    }

    public static class Builder {
        private String project;
        private String jobTrigger;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getJobTrigger() {
            return this.jobTrigger;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setJobTrigger(String jobTrigger) {
            this.jobTrigger = jobTrigger;
            return this;
        }

        private Builder(JobTriggerName jobTriggerName) {
            Preconditions.checkArgument((boolean)Objects.equals(jobTriggerName.pathTemplate, PROJECT_JOB_TRIGGER), (Object)"toBuilder is only supported when JobTriggerName has the pattern of projects/{project}/jobTriggers/{job_trigger}");
            this.project = jobTriggerName.project;
            this.jobTrigger = jobTriggerName.jobTrigger;
        }

        public JobTriggerName build() {
            return new JobTriggerName(this);
        }
    }
}

