/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DlpContentName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dlpContent");
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dlpContent");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;

    @Deprecated
    protected DlpContentName() {
        this.project = null;
        this.location = null;
    }

    private DlpContentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = null;
        this.pathTemplate = PROJECT;
    }

    private DlpContentName(ProjectLocationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.pathTemplate = PROJECT_LOCATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectBuilder() {
        return new Builder();
    }

    public static ProjectLocationBuilder newProjectLocationBuilder() {
        return new ProjectLocationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DlpContentName of(String project) {
        return DlpContentName.newBuilder().setProject(project).build();
    }

    public static DlpContentName ofProjectName(String project) {
        return DlpContentName.newBuilder().setProject(project).build();
    }

    public static DlpContentName ofProjectLocationName(String project, String location) {
        return DlpContentName.newProjectLocationBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project) {
        return DlpContentName.newBuilder().setProject(project).build().toString();
    }

    public static String formatProjectName(String project) {
        return DlpContentName.newBuilder().setProject(project).build().toString();
    }

    public static String formatProjectLocationName(String project, String location) {
        return DlpContentName.newProjectLocationBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static DlpContentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return DlpContentName.ofProjectName((String)matchMap.get("project"));
        }
        if (PROJECT_LOCATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION.match(formattedString);
            return DlpContentName.ofProjectLocationName((String)matchMap.get("project"), (String)matchMap.get("location"));
        }
        throw new ValidationException("DlpContentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<DlpContentName> parseList(List<String> formattedStrings) {
        ArrayList<DlpContentName> list = new ArrayList<DlpContentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DlpContentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DlpContentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DlpContentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DlpContentName dlpContentName = this;
            synchronized (dlpContentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DlpContentName that = (DlpContentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationBuilder {
        private String project;
        private String location;

        protected ProjectLocationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public ProjectLocationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public DlpContentName build() {
            return new DlpContentName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(DlpContentName dlpContentName) {
            Preconditions.checkArgument((boolean)Objects.equals(dlpContentName.pathTemplate, PROJECT), (Object)"toBuilder is only supported when DlpContentName has the pattern of projects/{project}/dlpContent");
            this.project = dlpContentName.project;
        }

        public DlpContentName build() {
            return new DlpContentName(this);
        }
    }
}

