/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class DeidentifyTemplateName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/deidentifyTemplates/{deidentify_template}");
    private static final PathTemplate PROJECT_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/deidentifyTemplates/{deidentify_template}");
    private static final PathTemplate ORGANIZATION_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}");
    private static final PathTemplate PROJECT_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String organization;
    private String deidentifyTemplate;
    private String project;
    private String location;

    @Deprecated
    protected DeidentifyTemplateName() {
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getDeidentifyTemplate() {
        return this.deidentifyTemplate;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    private DeidentifyTemplateName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.deidentifyTemplate = (String)Preconditions.checkNotNull((Object)builder.getDeidentifyTemplate());
        this.pathTemplate = ORGANIZATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE;
    }

    private DeidentifyTemplateName(ProjectDeidentifyTemplateBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.deidentifyTemplate = (String)Preconditions.checkNotNull((Object)builder.getDeidentifyTemplate());
        this.pathTemplate = PROJECT_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE;
    }

    private DeidentifyTemplateName(OrganizationLocationDeidentifyTemplateBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deidentifyTemplate = (String)Preconditions.checkNotNull((Object)builder.getDeidentifyTemplate());
        this.pathTemplate = ORGANIZATION_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE;
    }

    private DeidentifyTemplateName(ProjectLocationDeidentifyTemplateBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deidentifyTemplate = (String)Preconditions.checkNotNull((Object)builder.getDeidentifyTemplate());
        this.pathTemplate = PROJECT_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationDeidentifyTemplateBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectDeidentifyTemplateBuilder newProjectDeidentifyTemplateBuilder() {
        return new ProjectDeidentifyTemplateBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationLocationDeidentifyTemplateBuilder newOrganizationLocationDeidentifyTemplateBuilder() {
        return new OrganizationLocationDeidentifyTemplateBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationDeidentifyTemplateBuilder newProjectLocationDeidentifyTemplateBuilder() {
        return new ProjectLocationDeidentifyTemplateBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeidentifyTemplateName of(String organization, String deidentifyTemplate) {
        return DeidentifyTemplateName.newOrganizationDeidentifyTemplateBuilder().setOrganization(organization).setDeidentifyTemplate(deidentifyTemplate).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static DeidentifyTemplateName ofOrganizationDeidentifyTemplateName(String organization, String deidentifyTemplate) {
        return DeidentifyTemplateName.newOrganizationDeidentifyTemplateBuilder().setOrganization(organization).setDeidentifyTemplate(deidentifyTemplate).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static DeidentifyTemplateName ofProjectDeidentifyTemplateName(String project, String deidentifyTemplate) {
        return DeidentifyTemplateName.newProjectDeidentifyTemplateBuilder().setProject(project).setDeidentifyTemplate(deidentifyTemplate).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static DeidentifyTemplateName ofOrganizationLocationDeidentifyTemplateName(String organization, String location, String deidentifyTemplate) {
        return DeidentifyTemplateName.newOrganizationLocationDeidentifyTemplateBuilder().setOrganization(organization).setLocation(location).setDeidentifyTemplate(deidentifyTemplate).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static DeidentifyTemplateName ofProjectLocationDeidentifyTemplateName(String project, String location, String deidentifyTemplate) {
        return DeidentifyTemplateName.newProjectLocationDeidentifyTemplateBuilder().setProject(project).setLocation(location).setDeidentifyTemplate(deidentifyTemplate).build();
    }

    public static String format(String organization, String deidentifyTemplate) {
        return DeidentifyTemplateName.newBuilder().setOrganization(organization).setDeidentifyTemplate(deidentifyTemplate).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationDeidentifyTemplateName(String organization, String deidentifyTemplate) {
        return DeidentifyTemplateName.newBuilder().setOrganization(organization).setDeidentifyTemplate(deidentifyTemplate).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectDeidentifyTemplateName(String project, String deidentifyTemplate) {
        return DeidentifyTemplateName.newProjectDeidentifyTemplateBuilder().setProject(project).setDeidentifyTemplate(deidentifyTemplate).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLocationDeidentifyTemplateName(String organization, String location, String deidentifyTemplate) {
        return DeidentifyTemplateName.newOrganizationLocationDeidentifyTemplateBuilder().setOrganization(organization).setLocation(location).setDeidentifyTemplate(deidentifyTemplate).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationDeidentifyTemplateName(String project, String location, String deidentifyTemplate) {
        return DeidentifyTemplateName.newProjectLocationDeidentifyTemplateBuilder().setProject(project).setLocation(location).setDeidentifyTemplate(deidentifyTemplate).build().toString();
    }

    public static DeidentifyTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.match(formattedString);
            return DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)matchMap.get("organization"), (String)matchMap.get("deidentify_template"));
        }
        if (PROJECT_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.match(formattedString);
            return DeidentifyTemplateName.ofProjectDeidentifyTemplateName((String)matchMap.get("project"), (String)matchMap.get("deidentify_template"));
        }
        if (ORGANIZATION_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.match(formattedString);
            return DeidentifyTemplateName.ofOrganizationLocationDeidentifyTemplateName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("deidentify_template"));
        }
        if (PROJECT_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.match(formattedString);
            return DeidentifyTemplateName.ofProjectLocationDeidentifyTemplateName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("deidentify_template"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString) || PROJECT_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeidentifyTemplateName deidentifyTemplateName = this;
            synchronized (deidentifyTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.deidentifyTemplate != null) {
                        fieldMapBuilder.put((Object)"deidentify_template", (Object)this.deidentifyTemplate);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DeidentifyTemplateName that = (DeidentifyTemplateName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.deidentifyTemplate, that.deidentifyTemplate) && Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.deidentifyTemplate);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationDeidentifyTemplateBuilder {
        private String project;
        private String location;
        private String deidentifyTemplate;

        private ProjectLocationDeidentifyTemplateBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeidentifyTemplate() {
            return this.deidentifyTemplate;
        }

        public ProjectLocationDeidentifyTemplateBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationDeidentifyTemplateBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationDeidentifyTemplateBuilder setDeidentifyTemplate(String deidentifyTemplate) {
            this.deidentifyTemplate = deidentifyTemplate;
            return this;
        }

        public DeidentifyTemplateName build() {
            return new DeidentifyTemplateName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationLocationDeidentifyTemplateBuilder {
        private String organization;
        private String location;
        private String deidentifyTemplate;

        private OrganizationLocationDeidentifyTemplateBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeidentifyTemplate() {
            return this.deidentifyTemplate;
        }

        public OrganizationLocationDeidentifyTemplateBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationDeidentifyTemplateBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationDeidentifyTemplateBuilder setDeidentifyTemplate(String deidentifyTemplate) {
            this.deidentifyTemplate = deidentifyTemplate;
            return this;
        }

        public DeidentifyTemplateName build() {
            return new DeidentifyTemplateName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectDeidentifyTemplateBuilder {
        private String project;
        private String deidentifyTemplate;

        private ProjectDeidentifyTemplateBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDeidentifyTemplate() {
            return this.deidentifyTemplate;
        }

        public ProjectDeidentifyTemplateBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectDeidentifyTemplateBuilder setDeidentifyTemplate(String deidentifyTemplate) {
            this.deidentifyTemplate = deidentifyTemplate;
            return this;
        }

        public DeidentifyTemplateName build() {
            return new DeidentifyTemplateName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String deidentifyTemplate;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getDeidentifyTemplate() {
            return this.deidentifyTemplate;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setDeidentifyTemplate(String deidentifyTemplate) {
            this.deidentifyTemplate = deidentifyTemplate;
            return this;
        }

        private Builder(DeidentifyTemplateName deidentifyTemplateName) {
            Preconditions.checkArgument((deidentifyTemplateName.pathTemplate == ORGANIZATION_DEIDENTIFY_TEMPLATE_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when DeidentifyTemplateName has the pattern of organizations/{organization}/deidentifyTemplates/{deidentify_template}.");
            this.organization = deidentifyTemplateName.organization;
            this.deidentifyTemplate = deidentifyTemplateName.deidentifyTemplate;
        }

        public DeidentifyTemplateName build() {
            return new DeidentifyTemplateName(this);
        }
    }
}

