/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgecontainer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VpnConnectionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VPN_CONNECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vpnConnections/{vpn_connection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vpnConnection;

    @Deprecated
    protected VpnConnectionName() {
        this.project = null;
        this.location = null;
        this.vpnConnection = null;
    }

    private VpnConnectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vpnConnection = (String)Preconditions.checkNotNull((Object)builder.getVpnConnection());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVpnConnection() {
        return this.vpnConnection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VpnConnectionName of(String project, String location, String vpnConnection) {
        return VpnConnectionName.newBuilder().setProject(project).setLocation(location).setVpnConnection(vpnConnection).build();
    }

    public static String format(String project, String location, String vpnConnection) {
        return VpnConnectionName.newBuilder().setProject(project).setLocation(location).setVpnConnection(vpnConnection).build().toString();
    }

    public static VpnConnectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VPN_CONNECTION.validatedMatch(formattedString, "VpnConnectionName.parse: formattedString not in valid format");
        return VpnConnectionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vpn_connection"));
    }

    public static List<VpnConnectionName> parseList(List<String> formattedStrings) {
        ArrayList<VpnConnectionName> list = new ArrayList<VpnConnectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VpnConnectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VpnConnectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VpnConnectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VPN_CONNECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VpnConnectionName vpnConnectionName = this;
            synchronized (vpnConnectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vpnConnection != null) {
                        fieldMapBuilder.put((Object)"vpn_connection", (Object)this.vpnConnection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VPN_CONNECTION.instantiate(new String[]{"project", this.project, "location", this.location, "vpn_connection", this.vpnConnection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VpnConnectionName that = (VpnConnectionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vpnConnection, that.vpnConnection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vpnConnection);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vpnConnection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVpnConnection() {
            return this.vpnConnection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVpnConnection(String vpnConnection) {
            this.vpnConnection = vpnConnection;
            return this;
        }

        private Builder(VpnConnectionName vpnConnectionName) {
            this.project = vpnConnectionName.project;
            this.location = vpnConnectionName.location;
            this.vpnConnection = vpnConnectionName.vpnConnection;
        }

        public VpnConnectionName build() {
            return new VpnConnectionName(this);
        }
    }
}

