/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SitemapName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_SITEMAP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/siteSearchEngine/sitemaps/{sitemap}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_SITEMAP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/sitemaps/{sitemap}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String sitemap;
    private final String collection;

    @Deprecated
    protected SitemapName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.sitemap = null;
        this.collection = null;
    }

    private SitemapName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.sitemap = (String)Preconditions.checkNotNull((Object)builder.getSitemap());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_SITEMAP;
    }

    private SitemapName(ProjectLocationCollectionDataStoreSitemapBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.sitemap = (String)Preconditions.checkNotNull((Object)builder.getSitemap());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_SITEMAP;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getSitemap() {
        return this.sitemap;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreSitemapBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreSitemapBuilder newProjectLocationCollectionDataStoreSitemapBuilder() {
        return new ProjectLocationCollectionDataStoreSitemapBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SitemapName of(String project, String location, String dataStore, String sitemap) {
        return SitemapName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSitemap(sitemap).build();
    }

    public static SitemapName ofProjectLocationDataStoreSitemapName(String project, String location, String dataStore, String sitemap) {
        return SitemapName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSitemap(sitemap).build();
    }

    public static SitemapName ofProjectLocationCollectionDataStoreSitemapName(String project, String location, String collection, String dataStore, String sitemap) {
        return SitemapName.newProjectLocationCollectionDataStoreSitemapBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSitemap(sitemap).build();
    }

    public static String format(String project, String location, String dataStore, String sitemap) {
        return SitemapName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSitemap(sitemap).build().toString();
    }

    public static String formatProjectLocationDataStoreSitemapName(String project, String location, String dataStore, String sitemap) {
        return SitemapName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSitemap(sitemap).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreSitemapName(String project, String location, String collection, String dataStore, String sitemap) {
        return SitemapName.newProjectLocationCollectionDataStoreSitemapBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSitemap(sitemap).build().toString();
    }

    public static SitemapName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_SITEMAP.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_SITEMAP.match(formattedString);
            return SitemapName.ofProjectLocationDataStoreSitemapName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("sitemap"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_SITEMAP.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_SITEMAP.match(formattedString);
            return SitemapName.ofProjectLocationCollectionDataStoreSitemapName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("sitemap"));
        }
        throw new ValidationException("SitemapName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SitemapName> parseList(List<String> formattedStrings) {
        ArrayList<SitemapName> list = new ArrayList<SitemapName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SitemapName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SitemapName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SitemapName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_SITEMAP.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_SITEMAP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SitemapName sitemapName = this;
            synchronized (sitemapName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.sitemap != null) {
                        fieldMapBuilder.put((Object)"sitemap", (Object)this.sitemap);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SitemapName that = (SitemapName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.sitemap, that.sitemap) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.sitemap);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class ProjectLocationCollectionDataStoreSitemapBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String sitemap;

        protected ProjectLocationCollectionDataStoreSitemapBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSitemap() {
            return this.sitemap;
        }

        public ProjectLocationCollectionDataStoreSitemapBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreSitemapBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreSitemapBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreSitemapBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreSitemapBuilder setSitemap(String sitemap) {
            this.sitemap = sitemap;
            return this;
        }

        public SitemapName build() {
            return new SitemapName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String sitemap;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSitemap() {
            return this.sitemap;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setSitemap(String sitemap) {
            this.sitemap = sitemap;
            return this;
        }

        private Builder(SitemapName sitemapName) {
            Preconditions.checkArgument((boolean)Objects.equals(sitemapName.pathTemplate, PROJECT_LOCATION_DATA_STORE_SITEMAP), (Object)"toBuilder is only supported when SitemapName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/siteSearchEngine/sitemaps/{sitemap}");
            this.project = sitemapName.project;
            this.location = sitemapName.location;
            this.dataStore = sitemapName.dataStore;
            this.sitemap = sitemapName.sitemap;
        }

        public SitemapName build() {
            return new SitemapName(this);
        }
    }
}

