/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RankingConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RANKING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/rankingConfigs/{ranking_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String rankingConfig;

    @Deprecated
    protected RankingConfigName() {
        this.project = null;
        this.location = null;
        this.rankingConfig = null;
    }

    private RankingConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.rankingConfig = (String)Preconditions.checkNotNull((Object)builder.getRankingConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRankingConfig() {
        return this.rankingConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RankingConfigName of(String project, String location, String rankingConfig) {
        return RankingConfigName.newBuilder().setProject(project).setLocation(location).setRankingConfig(rankingConfig).build();
    }

    public static String format(String project, String location, String rankingConfig) {
        return RankingConfigName.newBuilder().setProject(project).setLocation(location).setRankingConfig(rankingConfig).build().toString();
    }

    public static RankingConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RANKING_CONFIG.validatedMatch(formattedString, "RankingConfigName.parse: formattedString not in valid format");
        return RankingConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("ranking_config"));
    }

    public static List<RankingConfigName> parseList(List<String> formattedStrings) {
        ArrayList<RankingConfigName> list = new ArrayList<RankingConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RankingConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RankingConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RankingConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RANKING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RankingConfigName rankingConfigName = this;
            synchronized (rankingConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.rankingConfig != null) {
                        fieldMapBuilder.put((Object)"ranking_config", (Object)this.rankingConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RANKING_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "ranking_config", this.rankingConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RankingConfigName that = (RankingConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.rankingConfig, that.rankingConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rankingConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String rankingConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRankingConfig() {
            return this.rankingConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRankingConfig(String rankingConfig) {
            this.rankingConfig = rankingConfig;
            return this;
        }

        private Builder(RankingConfigName rankingConfigName) {
            this.project = rankingConfigName.project;
            this.location = rankingConfigName.location;
            this.rankingConfig = rankingConfigName.rankingConfig;
        }

        public RankingConfigName build() {
            return new RankingConfigName(this);
        }
    }
}

