/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SiteSearchEngineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/siteSearchEngine");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String collection;

    @Deprecated
    protected SiteSearchEngineName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.collection = null;
    }

    private SiteSearchEngineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE;
    }

    private SiteSearchEngineName(ProjectLocationCollectionDataStoreBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreBuilder newProjectLocationCollectionDataStoreBuilder() {
        return new ProjectLocationCollectionDataStoreBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SiteSearchEngineName of(String project, String location, String dataStore) {
        return SiteSearchEngineName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static SiteSearchEngineName ofProjectLocationDataStoreName(String project, String location, String dataStore) {
        return SiteSearchEngineName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static SiteSearchEngineName ofProjectLocationCollectionDataStoreName(String project, String location, String collection, String dataStore) {
        return SiteSearchEngineName.newProjectLocationCollectionDataStoreBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).build();
    }

    public static String format(String project, String location, String dataStore) {
        return SiteSearchEngineName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationDataStoreName(String project, String location, String dataStore) {
        return SiteSearchEngineName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreName(String project, String location, String collection, String dataStore) {
        return SiteSearchEngineName.newProjectLocationCollectionDataStoreBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).build().toString();
    }

    public static SiteSearchEngineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE.match(formattedString);
            return SiteSearchEngineName.ofProjectLocationDataStoreName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE.match(formattedString);
            return SiteSearchEngineName.ofProjectLocationCollectionDataStoreName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"));
        }
        throw new ValidationException("SiteSearchEngineName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SiteSearchEngineName> parseList(List<String> formattedStrings) {
        ArrayList<SiteSearchEngineName> list = new ArrayList<SiteSearchEngineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SiteSearchEngineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SiteSearchEngineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SiteSearchEngineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SiteSearchEngineName siteSearchEngineName = this;
            synchronized (siteSearchEngineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SiteSearchEngineName that = (SiteSearchEngineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class ProjectLocationCollectionDataStoreBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;

        protected ProjectLocationCollectionDataStoreBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public ProjectLocationCollectionDataStoreBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public SiteSearchEngineName build() {
            return new SiteSearchEngineName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        private Builder(SiteSearchEngineName siteSearchEngineName) {
            Preconditions.checkArgument((boolean)Objects.equals(siteSearchEngineName.pathTemplate, PROJECT_LOCATION_DATA_STORE), (Object)"toBuilder is only supported when SiteSearchEngineName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/siteSearchEngine");
            this.project = siteSearchEngineName.project;
            this.location = siteSearchEngineName.location;
            this.dataStore = siteSearchEngineName.dataStore;
        }

        public SiteSearchEngineName build() {
            return new SiteSearchEngineName(this);
        }
    }
}

