/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IdentityMappingStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_IDENTITY_MAPPING_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String identityMappingStore;

    @Deprecated
    protected IdentityMappingStoreName() {
        this.project = null;
        this.location = null;
        this.identityMappingStore = null;
    }

    private IdentityMappingStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.identityMappingStore = (String)Preconditions.checkNotNull((Object)builder.getIdentityMappingStore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getIdentityMappingStore() {
        return this.identityMappingStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IdentityMappingStoreName of(String project, String location, String identityMappingStore) {
        return IdentityMappingStoreName.newBuilder().setProject(project).setLocation(location).setIdentityMappingStore(identityMappingStore).build();
    }

    public static String format(String project, String location, String identityMappingStore) {
        return IdentityMappingStoreName.newBuilder().setProject(project).setLocation(location).setIdentityMappingStore(identityMappingStore).build().toString();
    }

    public static IdentityMappingStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_IDENTITY_MAPPING_STORE.validatedMatch(formattedString, "IdentityMappingStoreName.parse: formattedString not in valid format");
        return IdentityMappingStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("identity_mapping_store"));
    }

    public static List<IdentityMappingStoreName> parseList(List<String> formattedStrings) {
        ArrayList<IdentityMappingStoreName> list = new ArrayList<IdentityMappingStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IdentityMappingStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IdentityMappingStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IdentityMappingStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_IDENTITY_MAPPING_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IdentityMappingStoreName identityMappingStoreName = this;
            synchronized (identityMappingStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.identityMappingStore != null) {
                        fieldMapBuilder.put((Object)"identity_mapping_store", (Object)this.identityMappingStore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_IDENTITY_MAPPING_STORE.instantiate(new String[]{"project", this.project, "location", this.location, "identity_mapping_store", this.identityMappingStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IdentityMappingStoreName that = (IdentityMappingStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.identityMappingStore, that.identityMappingStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.identityMappingStore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String identityMappingStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getIdentityMappingStore() {
            return this.identityMappingStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setIdentityMappingStore(String identityMappingStore) {
            this.identityMappingStore = identityMappingStore;
            return this;
        }

        private Builder(IdentityMappingStoreName identityMappingStoreName) {
            this.project = identityMappingStoreName.project;
            this.location = identityMappingStoreName.location;
            this.identityMappingStore = identityMappingStoreName.identityMappingStore;
        }

        public IdentityMappingStoreName build() {
            return new IdentityMappingStoreName(this);
        }
    }
}

