/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssistantName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE_ASSISTANT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/assistants/{assistant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String collection;
    private final String engine;
    private final String assistant;

    @Deprecated
    protected AssistantName() {
        this.project = null;
        this.location = null;
        this.collection = null;
        this.engine = null;
        this.assistant = null;
    }

    private AssistantName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
        this.assistant = (String)Preconditions.checkNotNull((Object)builder.getAssistant());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getAssistant() {
        return this.assistant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssistantName of(String project, String location, String collection, String engine, String assistant) {
        return AssistantName.newBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setAssistant(assistant).build();
    }

    public static String format(String project, String location, String collection, String engine, String assistant) {
        return AssistantName.newBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setAssistant(assistant).build().toString();
    }

    public static AssistantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE_ASSISTANT.validatedMatch(formattedString, "AssistantName.parse: formattedString not in valid format");
        return AssistantName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"), (String)matchMap.get("assistant"));
    }

    public static List<AssistantName> parseList(List<String> formattedStrings) {
        ArrayList<AssistantName> list = new ArrayList<AssistantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssistantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssistantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssistantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_COLLECTION_ENGINE_ASSISTANT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssistantName assistantName = this;
            synchronized (assistantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    if (this.assistant != null) {
                        fieldMapBuilder.put((Object)"assistant", (Object)this.assistant);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_COLLECTION_ENGINE_ASSISTANT.instantiate(new String[]{"project", this.project, "location", this.location, "collection", this.collection, "engine", this.engine, "assistant", this.assistant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssistantName that = (AssistantName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine) && Objects.equals(this.assistant, that.assistant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        h ^= Objects.hashCode(this.engine);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assistant);
    }

    public static class Builder {
        private String project;
        private String location;
        private String collection;
        private String engine;
        private String assistant;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getAssistant() {
            return this.assistant;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public Builder setAssistant(String assistant) {
            this.assistant = assistant;
            return this;
        }

        private Builder(AssistantName assistantName) {
            this.project = assistantName.project;
            this.location = assistantName.location;
            this.collection = assistantName.collection;
            this.engine = assistantName.engine;
            this.assistant = assistantName.assistant;
        }

        public AssistantName build() {
            return new AssistantName(this);
        }
    }
}

