/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AgentName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent");
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;

    @Deprecated
    protected AgentName() {
        this.project = null;
        this.location = null;
    }

    private AgentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = null;
        this.pathTemplate = PROJECT;
    }

    private AgentName(ProjectLocationAgentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.pathTemplate = PROJECT_LOCATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectAgentBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationAgentBuilder newProjectLocationAgentBuilder() {
        return new ProjectLocationAgentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AgentName of(String project) {
        return AgentName.newBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AgentName ofProjectName(String project) {
        return AgentName.newBuilder().setProject(project).build();
    }

    @Deprecated
    public static AgentName ofProjectAgentName(String project) {
        return AgentName.newBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AgentName ofProjectLocationName(String project, String location) {
        return AgentName.newProjectLocationAgentBuilder().setProject(project).setLocation(location).build();
    }

    @Deprecated
    public static AgentName ofProjectLocationAgentName(String project, String location) {
        return AgentName.newProjectLocationAgentBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project) {
        return AgentName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectAgentName(String project) {
        return AgentName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationAgentName(String project, String location) {
        return AgentName.newProjectLocationAgentBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static AgentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return AgentName.ofProjectAgentName((String)matchMap.get("project"));
        }
        if (PROJECT_LOCATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION.match(formattedString);
            return AgentName.ofProjectLocationAgentName((String)matchMap.get("project"), (String)matchMap.get("location"));
        }
        throw new ValidationException("AgentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AgentName> parseList(List<String> formattedStrings) {
        ArrayList<AgentName> list = new ArrayList<AgentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AgentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AgentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AgentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AgentName agentName = this;
            synchronized (agentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AgentName that = (AgentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationAgentBuilder {
        private String project;
        private String location;

        protected ProjectLocationAgentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public ProjectLocationAgentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAgentBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public AgentName build() {
            return new AgentName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(AgentName agentName) {
            Preconditions.checkArgument((boolean)Objects.equals(agentName.pathTemplate, PROJECT), (Object)"toBuilder is only supported when AgentName has the pattern of projects/{project}/agent");
            this.project = agentName.project;
        }

        public AgentName build() {
            return new AgentName(this);
        }
    }
}

