/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GeneratorEvaluationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GENERATOR_EVALUATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/generators/{generator}/evaluations/{evaluation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String generator;
    private final String evaluation;

    @Deprecated
    protected GeneratorEvaluationName() {
        this.project = null;
        this.location = null;
        this.generator = null;
        this.evaluation = null;
    }

    private GeneratorEvaluationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.generator = (String)Preconditions.checkNotNull((Object)builder.getGenerator());
        this.evaluation = (String)Preconditions.checkNotNull((Object)builder.getEvaluation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GeneratorEvaluationName of(String project, String location, String generator, String evaluation) {
        return GeneratorEvaluationName.newBuilder().setProject(project).setLocation(location).setGenerator(generator).setEvaluation(evaluation).build();
    }

    public static String format(String project, String location, String generator, String evaluation) {
        return GeneratorEvaluationName.newBuilder().setProject(project).setLocation(location).setGenerator(generator).setEvaluation(evaluation).build().toString();
    }

    public static GeneratorEvaluationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GENERATOR_EVALUATION.validatedMatch(formattedString, "GeneratorEvaluationName.parse: formattedString not in valid format");
        return GeneratorEvaluationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("generator"), (String)matchMap.get("evaluation"));
    }

    public static List<GeneratorEvaluationName> parseList(List<String> formattedStrings) {
        ArrayList<GeneratorEvaluationName> list = new ArrayList<GeneratorEvaluationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GeneratorEvaluationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GeneratorEvaluationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GeneratorEvaluationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GENERATOR_EVALUATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GeneratorEvaluationName generatorEvaluationName = this;
            synchronized (generatorEvaluationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.generator != null) {
                        fieldMapBuilder.put((Object)"generator", (Object)this.generator);
                    }
                    if (this.evaluation != null) {
                        fieldMapBuilder.put((Object)"evaluation", (Object)this.evaluation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GENERATOR_EVALUATION.instantiate(new String[]{"project", this.project, "location", this.location, "generator", this.generator, "evaluation", this.evaluation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GeneratorEvaluationName that = (GeneratorEvaluationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.generator, that.generator) && Objects.equals(this.evaluation, that.evaluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.generator);
        h *= 1000003;
        return h ^= Objects.hashCode(this.evaluation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String generator;
        private String evaluation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGenerator() {
            return this.generator;
        }

        public String getEvaluation() {
            return this.evaluation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGenerator(String generator) {
            this.generator = generator;
            return this;
        }

        public Builder setEvaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        private Builder(GeneratorEvaluationName generatorEvaluationName) {
            this.project = generatorEvaluationName.project;
            this.location = generatorEvaluationName.location;
            this.generator = generatorEvaluationName.generator;
            this.evaluation = generatorEvaluationName.evaluation;
        }

        public GeneratorEvaluationName build() {
            return new GeneratorEvaluationName(this);
        }
    }
}

