/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionEntityTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_SESSION_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}");
    private static final PathTemplate PROJECT_ENVIRONMENT_USER_SESSION_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}");
    private static final PathTemplate PROJECT_LOCATION_SESSION_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/sessions/{session}/entityTypes/{entity_type}");
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String session;
    private final String entityType;
    private final String environment;
    private final String user;
    private final String location;

    @Deprecated
    protected SessionEntityTypeName() {
        this.project = null;
        this.session = null;
        this.entityType = null;
        this.environment = null;
        this.user = null;
        this.location = null;
    }

    private SessionEntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.environment = null;
        this.user = null;
        this.location = null;
        this.pathTemplate = PROJECT_SESSION_ENTITY_TYPE;
    }

    private SessionEntityTypeName(ProjectEnvironmentUserSessionEntityTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.location = null;
        this.pathTemplate = PROJECT_ENVIRONMENT_USER_SESSION_ENTITY_TYPE;
    }

    private SessionEntityTypeName(ProjectLocationSessionEntityTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.environment = null;
        this.user = null;
        this.pathTemplate = PROJECT_LOCATION_SESSION_ENTITY_TYPE;
    }

    private SessionEntityTypeName(ProjectLocationEnvironmentUserSessionEntityTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.pathTemplate = PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_ENTITY_TYPE;
    }

    public String getProject() {
        return this.project;
    }

    public String getSession() {
        return this.session;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectSessionEntityTypeBuilder() {
        return new Builder();
    }

    public static ProjectEnvironmentUserSessionEntityTypeBuilder newProjectEnvironmentUserSessionEntityTypeBuilder() {
        return new ProjectEnvironmentUserSessionEntityTypeBuilder();
    }

    public static ProjectLocationSessionEntityTypeBuilder newProjectLocationSessionEntityTypeBuilder() {
        return new ProjectLocationSessionEntityTypeBuilder();
    }

    public static ProjectLocationEnvironmentUserSessionEntityTypeBuilder newProjectLocationEnvironmentUserSessionEntityTypeBuilder() {
        return new ProjectLocationEnvironmentUserSessionEntityTypeBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionEntityTypeName of(String project, String session, String entityType) {
        return SessionEntityTypeName.newBuilder().setProject(project).setSession(session).setEntityType(entityType).build();
    }

    public static SessionEntityTypeName ofProjectSessionEntityTypeName(String project, String session, String entityType) {
        return SessionEntityTypeName.newBuilder().setProject(project).setSession(session).setEntityType(entityType).build();
    }

    public static SessionEntityTypeName ofProjectEnvironmentUserSessionEntityTypeName(String project, String environment, String user, String session, String entityType) {
        return SessionEntityTypeName.newProjectEnvironmentUserSessionEntityTypeBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setEntityType(entityType).build();
    }

    public static SessionEntityTypeName ofProjectLocationSessionEntityTypeName(String project, String location, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationSessionEntityTypeBuilder().setProject(project).setLocation(location).setSession(session).setEntityType(entityType).build();
    }

    public static SessionEntityTypeName ofProjectLocationEnvironmentUserSessionEntityTypeName(String project, String location, String environment, String user, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationEnvironmentUserSessionEntityTypeBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUser(user).setSession(session).setEntityType(entityType).build();
    }

    public static String format(String project, String session, String entityType) {
        return SessionEntityTypeName.newBuilder().setProject(project).setSession(session).setEntityType(entityType).build().toString();
    }

    public static String formatProjectSessionEntityTypeName(String project, String session, String entityType) {
        return SessionEntityTypeName.newBuilder().setProject(project).setSession(session).setEntityType(entityType).build().toString();
    }

    public static String formatProjectEnvironmentUserSessionEntityTypeName(String project, String environment, String user, String session, String entityType) {
        return SessionEntityTypeName.newProjectEnvironmentUserSessionEntityTypeBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setEntityType(entityType).build().toString();
    }

    public static String formatProjectLocationSessionEntityTypeName(String project, String location, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationSessionEntityTypeBuilder().setProject(project).setLocation(location).setSession(session).setEntityType(entityType).build().toString();
    }

    public static String formatProjectLocationEnvironmentUserSessionEntityTypeName(String project, String location, String environment, String user, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationEnvironmentUserSessionEntityTypeBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUser(user).setSession(session).setEntityType(entityType).build().toString();
    }

    public static SessionEntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SESSION_ENTITY_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_SESSION_ENTITY_TYPE.match(formattedString);
            return SessionEntityTypeName.ofProjectSessionEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
        }
        if (PROJECT_ENVIRONMENT_USER_SESSION_ENTITY_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_ENVIRONMENT_USER_SESSION_ENTITY_TYPE.match(formattedString);
            return SessionEntityTypeName.ofProjectEnvironmentUserSessionEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
        }
        if (PROJECT_LOCATION_SESSION_ENTITY_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SESSION_ENTITY_TYPE.match(formattedString);
            return SessionEntityTypeName.ofProjectLocationSessionEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
        }
        if (PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_ENTITY_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_ENTITY_TYPE.match(formattedString);
            return SessionEntityTypeName.ofProjectLocationEnvironmentUserSessionEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
        }
        throw new ValidationException("SessionEntityTypeName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SessionEntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<SessionEntityTypeName> list = new ArrayList<SessionEntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionEntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionEntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionEntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SESSION_ENTITY_TYPE.matches(formattedString) || PROJECT_ENVIRONMENT_USER_SESSION_ENTITY_TYPE.matches(formattedString) || PROJECT_LOCATION_SESSION_ENTITY_TYPE.matches(formattedString) || PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_ENTITY_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionEntityTypeName sessionEntityTypeName = this;
            synchronized (sessionEntityTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.entityType != null) {
                        fieldMapBuilder.put((Object)"entity_type", (Object)this.entityType);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SessionEntityTypeName that = (SessionEntityTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.session, that.session) && Objects.equals(this.entityType, that.entityType) && Objects.equals(this.environment, that.environment) && Objects.equals(this.user, that.user) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.entityType);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationEnvironmentUserSessionEntityTypeBuilder {
        private String project;
        private String location;
        private String environment;
        private String user;
        private String session;
        private String entityType;

        protected ProjectLocationEnvironmentUserSessionEntityTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public ProjectLocationEnvironmentUserSessionEntityTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionEntityTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionEntityTypeBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionEntityTypeBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionEntityTypeBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionEntityTypeBuilder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public SessionEntityTypeName build() {
            return new SessionEntityTypeName(this);
        }
    }

    public static class ProjectLocationSessionEntityTypeBuilder {
        private String project;
        private String location;
        private String session;
        private String entityType;

        protected ProjectLocationSessionEntityTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public ProjectLocationSessionEntityTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationSessionEntityTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationSessionEntityTypeBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationSessionEntityTypeBuilder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public SessionEntityTypeName build() {
            return new SessionEntityTypeName(this);
        }
    }

    public static class ProjectEnvironmentUserSessionEntityTypeBuilder {
        private String project;
        private String environment;
        private String user;
        private String session;
        private String entityType;

        protected ProjectEnvironmentUserSessionEntityTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public ProjectEnvironmentUserSessionEntityTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectEnvironmentUserSessionEntityTypeBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectEnvironmentUserSessionEntityTypeBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectEnvironmentUserSessionEntityTypeBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectEnvironmentUserSessionEntityTypeBuilder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public SessionEntityTypeName build() {
            return new SessionEntityTypeName(this);
        }
    }

    public static class Builder {
        private String project;
        private String session;
        private String entityType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder(SessionEntityTypeName sessionEntityTypeName) {
            Preconditions.checkArgument((boolean)Objects.equals(sessionEntityTypeName.pathTemplate, PROJECT_SESSION_ENTITY_TYPE), (Object)"toBuilder is only supported when SessionEntityTypeName has the pattern of projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}");
            this.project = sessionEntityTypeName.project;
            this.session = sessionEntityTypeName.session;
            this.entityType = sessionEntityTypeName.entityType;
        }

        public SessionEntityTypeName build() {
            return new SessionEntityTypeName(this);
        }
    }
}

