/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationDatasetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_DATASET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversationDatasets/{conversation_dataset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String conversationDataset;

    @Deprecated
    protected ConversationDatasetName() {
        this.project = null;
        this.location = null;
        this.conversationDataset = null;
    }

    private ConversationDatasetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversationDataset = (String)Preconditions.checkNotNull((Object)builder.getConversationDataset());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversationDataset() {
        return this.conversationDataset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationDatasetName of(String project, String location, String conversationDataset) {
        return ConversationDatasetName.newBuilder().setProject(project).setLocation(location).setConversationDataset(conversationDataset).build();
    }

    public static String format(String project, String location, String conversationDataset) {
        return ConversationDatasetName.newBuilder().setProject(project).setLocation(location).setConversationDataset(conversationDataset).build().toString();
    }

    public static ConversationDatasetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONVERSATION_DATASET.validatedMatch(formattedString, "ConversationDatasetName.parse: formattedString not in valid format");
        return ConversationDatasetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation_dataset"));
    }

    public static List<ConversationDatasetName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationDatasetName> list = new ArrayList<ConversationDatasetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationDatasetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationDatasetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationDatasetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION_DATASET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationDatasetName conversationDatasetName = this;
            synchronized (conversationDatasetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversationDataset != null) {
                        fieldMapBuilder.put((Object)"conversation_dataset", (Object)this.conversationDataset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONVERSATION_DATASET.instantiate(new String[]{"project", this.project, "location", this.location, "conversation_dataset", this.conversationDataset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversationDatasetName that = (ConversationDatasetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversationDataset, that.conversationDataset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversationDataset);
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversationDataset;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversationDataset() {
            return this.conversationDataset;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversationDataset(String conversationDataset) {
            this.conversationDataset = conversationDataset;
            return this;
        }

        private Builder(ConversationDatasetName conversationDatasetName) {
            this.project = conversationDatasetName.project;
            this.location = conversationDatasetName.location;
            this.conversationDataset = conversationDatasetName.conversationDataset;
        }

        public ConversationDatasetName build() {
            return new ConversationDatasetName(this);
        }
    }
}

