/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnswerRecordName
implements ResourceName {
    private static final PathTemplate PROJECT_ANSWER_RECORD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/answerRecords/{answer_record}");
    private static final PathTemplate PROJECT_LOCATION_ANSWER_RECORD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/answerRecords/{answer_record}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String answerRecord;
    private final String location;

    @Deprecated
    protected AnswerRecordName() {
        this.project = null;
        this.answerRecord = null;
        this.location = null;
    }

    private AnswerRecordName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.answerRecord = (String)Preconditions.checkNotNull((Object)builder.getAnswerRecord());
        this.location = null;
        this.pathTemplate = PROJECT_ANSWER_RECORD;
    }

    private AnswerRecordName(ProjectLocationAnswerRecordBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.answerRecord = (String)Preconditions.checkNotNull((Object)builder.getAnswerRecord());
        this.pathTemplate = PROJECT_LOCATION_ANSWER_RECORD;
    }

    public String getProject() {
        return this.project;
    }

    public String getAnswerRecord() {
        return this.answerRecord;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectAnswerRecordBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationAnswerRecordBuilder newProjectLocationAnswerRecordBuilder() {
        return new ProjectLocationAnswerRecordBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnswerRecordName of(String project, String answerRecord) {
        return AnswerRecordName.newBuilder().setProject(project).setAnswerRecord(answerRecord).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AnswerRecordName ofProjectAnswerRecordName(String project, String answerRecord) {
        return AnswerRecordName.newBuilder().setProject(project).setAnswerRecord(answerRecord).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AnswerRecordName ofProjectLocationAnswerRecordName(String project, String location, String answerRecord) {
        return AnswerRecordName.newProjectLocationAnswerRecordBuilder().setProject(project).setLocation(location).setAnswerRecord(answerRecord).build();
    }

    public static String format(String project, String answerRecord) {
        return AnswerRecordName.newBuilder().setProject(project).setAnswerRecord(answerRecord).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectAnswerRecordName(String project, String answerRecord) {
        return AnswerRecordName.newBuilder().setProject(project).setAnswerRecord(answerRecord).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationAnswerRecordName(String project, String location, String answerRecord) {
        return AnswerRecordName.newProjectLocationAnswerRecordBuilder().setProject(project).setLocation(location).setAnswerRecord(answerRecord).build().toString();
    }

    public static AnswerRecordName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_ANSWER_RECORD.matches(formattedString)) {
            Map matchMap = PROJECT_ANSWER_RECORD.match(formattedString);
            return AnswerRecordName.ofProjectAnswerRecordName((String)matchMap.get("project"), (String)matchMap.get("answer_record"));
        }
        if (PROJECT_LOCATION_ANSWER_RECORD.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ANSWER_RECORD.match(formattedString);
            return AnswerRecordName.ofProjectLocationAnswerRecordName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("answer_record"));
        }
        throw new ValidationException("AnswerRecordName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AnswerRecordName> parseList(List<String> formattedStrings) {
        ArrayList<AnswerRecordName> list = new ArrayList<AnswerRecordName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnswerRecordName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnswerRecordName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnswerRecordName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ANSWER_RECORD.matches(formattedString) || PROJECT_LOCATION_ANSWER_RECORD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnswerRecordName answerRecordName = this;
            synchronized (answerRecordName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.answerRecord != null) {
                        fieldMapBuilder.put((Object)"answer_record", (Object)this.answerRecord);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AnswerRecordName that = (AnswerRecordName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.answerRecord, that.answerRecord) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.answerRecord);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationAnswerRecordBuilder {
        private String project;
        private String location;
        private String answerRecord;

        protected ProjectLocationAnswerRecordBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAnswerRecord() {
            return this.answerRecord;
        }

        public ProjectLocationAnswerRecordBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAnswerRecordBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAnswerRecordBuilder setAnswerRecord(String answerRecord) {
            this.answerRecord = answerRecord;
            return this;
        }

        public AnswerRecordName build() {
            return new AnswerRecordName(this);
        }
    }

    public static class Builder {
        private String project;
        private String answerRecord;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAnswerRecord() {
            return this.answerRecord;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAnswerRecord(String answerRecord) {
            this.answerRecord = answerRecord;
            return this;
        }

        private Builder(AnswerRecordName answerRecordName) {
            Preconditions.checkArgument((boolean)Objects.equals(answerRecordName.pathTemplate, PROJECT_ANSWER_RECORD), (Object)"toBuilder is only supported when AnswerRecordName has the pattern of projects/{project}/answerRecords/{answer_record}");
            this.project = answerRecordName.project;
            this.answerRecord = answerRecordName.answerRecord;
        }

        public AnswerRecordName build() {
            return new AnswerRecordName(this);
        }
    }
}

