/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectAgentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectAgentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectAgentName of(String project) {
        return ProjectAgentName.newBuilder().setProject(project).build();
    }

    public static String format(String project) {
        return ProjectAgentName.newBuilder().setProject(project).build().toString();
    }

    public static ProjectAgentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectAgentName.parse: formattedString not in valid format");
        return ProjectAgentName.of((String)matchMap.get("project"));
    }

    public static List<ProjectAgentName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectAgentName> list = new ArrayList<ProjectAgentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectAgentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectAgentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectAgentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectAgentName projectAgentName = this;
            synchronized (projectAgentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("ProjectAgentName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectAgentName) {
            ProjectAgentName that = (ProjectAgentName)o;
            return this.project.equals(that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.project.hashCode();
    }

    public static class Builder {
        private String project;

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectAgentName projectAgentName) {
            this.project = projectAgentName.project;
        }

        public ProjectAgentName build() {
            return new ProjectAgentName(this);
        }
    }
}

