/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrivateConnectionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRIVATE_CONNECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/privateConnections/{private_connection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String privateConnection;

    @Deprecated
    protected PrivateConnectionName() {
        this.project = null;
        this.location = null;
        this.privateConnection = null;
    }

    private PrivateConnectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.privateConnection = (String)Preconditions.checkNotNull((Object)builder.getPrivateConnection());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrivateConnection() {
        return this.privateConnection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PrivateConnectionName of(String project, String location, String privateConnection) {
        return PrivateConnectionName.newBuilder().setProject(project).setLocation(location).setPrivateConnection(privateConnection).build();
    }

    public static String format(String project, String location, String privateConnection) {
        return PrivateConnectionName.newBuilder().setProject(project).setLocation(location).setPrivateConnection(privateConnection).build().toString();
    }

    public static PrivateConnectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRIVATE_CONNECTION.validatedMatch(formattedString, "PrivateConnectionName.parse: formattedString not in valid format");
        return PrivateConnectionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("private_connection"));
    }

    public static List<PrivateConnectionName> parseList(List<String> formattedStrings) {
        ArrayList<PrivateConnectionName> list = new ArrayList<PrivateConnectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PrivateConnectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PrivateConnectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PrivateConnectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRIVATE_CONNECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PrivateConnectionName privateConnectionName = this;
            synchronized (privateConnectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.privateConnection != null) {
                        fieldMapBuilder.put((Object)"private_connection", (Object)this.privateConnection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRIVATE_CONNECTION.instantiate(new String[]{"project", this.project, "location", this.location, "private_connection", this.privateConnection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PrivateConnectionName that = (PrivateConnectionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.privateConnection, that.privateConnection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.privateConnection);
    }

    public static class Builder {
        private String project;
        private String location;
        private String privateConnection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrivateConnection() {
            return this.privateConnection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrivateConnection(String privateConnection) {
            this.privateConnection = privateConnection;
            return this;
        }

        private Builder(PrivateConnectionName privateConnectionName) {
            this.project = privateConnectionName.project;
            this.location = privateConnectionName.location;
            this.privateConnection = privateConnectionName.privateConnection;
        }

        public PrivateConnectionName build() {
            return new PrivateConnectionName(this);
        }
    }
}

