/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StreamObjectName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_STREAM_OBJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/streams/{stream}/objects/{object}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String stream;
    private final String object;

    @Deprecated
    protected StreamObjectName() {
        this.project = null;
        this.location = null;
        this.stream = null;
        this.object = null;
    }

    private StreamObjectName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.stream = (String)Preconditions.checkNotNull((Object)builder.getStream());
        this.object = (String)Preconditions.checkNotNull((Object)builder.getObject());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStream() {
        return this.stream;
    }

    public String getObject() {
        return this.object;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static StreamObjectName of(String project, String location, String stream, String object) {
        return StreamObjectName.newBuilder().setProject(project).setLocation(location).setStream(stream).setObject(object).build();
    }

    public static String format(String project, String location, String stream, String object) {
        return StreamObjectName.newBuilder().setProject(project).setLocation(location).setStream(stream).setObject(object).build().toString();
    }

    public static StreamObjectName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_STREAM_OBJECT.validatedMatch(formattedString, "StreamObjectName.parse: formattedString not in valid format");
        return StreamObjectName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("stream"), (String)matchMap.get("object"));
    }

    public static List<StreamObjectName> parseList(List<String> formattedStrings) {
        ArrayList<StreamObjectName> list = new ArrayList<StreamObjectName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(StreamObjectName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<StreamObjectName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (StreamObjectName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_STREAM_OBJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StreamObjectName streamObjectName = this;
            synchronized (streamObjectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.stream != null) {
                        fieldMapBuilder.put((Object)"stream", (Object)this.stream);
                    }
                    if (this.object != null) {
                        fieldMapBuilder.put((Object)"object", (Object)this.object);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_STREAM_OBJECT.instantiate(new String[]{"project", this.project, "location", this.location, "stream", this.stream, "object", this.object});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StreamObjectName that = (StreamObjectName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.stream, that.stream) && Objects.equals(this.object, that.object);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.stream);
        h *= 1000003;
        return h ^= Objects.hashCode(this.object);
    }

    public static class Builder {
        private String project;
        private String location;
        private String stream;
        private String object;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStream() {
            return this.stream;
        }

        public String getObject() {
            return this.object;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        public Builder setObject(String object) {
            this.object = object;
            return this;
        }

        private Builder(StreamObjectName streamObjectName) {
            this.project = streamObjectName.project;
            this.location = streamObjectName.location;
            this.stream = streamObjectName.stream;
            this.object = streamObjectName.object;
        }

        public StreamObjectName build() {
            return new StreamObjectName(this);
        }
    }
}

