/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Datastore.RunAggregationQuery][google.datastore.v1.Datastore.RunAggregationQuery].
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.RunAggregationQueryRequest}
 */
public final class RunAggregationQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.RunAggregationQueryRequest)
    RunAggregationQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RunAggregationQueryRequest.newBuilder() to construct.
  private RunAggregationQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunAggregationQueryRequest() {
    projectId_ = "";
    databaseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunAggregationQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_RunAggregationQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_RunAggregationQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.RunAggregationQueryRequest.class,
            com.google.datastore.v1.RunAggregationQueryRequest.Builder.class);
  }

  private int bitField0_;
  private int queryTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AGGREGATION_QUERY(3),
    GQL_QUERY(7),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return AGGREGATION_QUERY;
        case 7:
          return GQL_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The ID of the project against which to make the request.
   * </pre>
   *
   * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The ID of the project against which to make the request.
   * </pre>
   *
   * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseId_ = "";

  /**
   *
   *
   * <pre>
   * The ID of the database against which to make the request.
   *
   * '(default)' is not allowed; please use empty string '' to refer the default
   * database.
   * </pre>
   *
   * <code>string database_id = 9;</code>
   *
   * @return The databaseId.
   */
  @java.lang.Override
  public java.lang.String getDatabaseId() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The ID of the database against which to make the request.
   *
   * '(default)' is not allowed; please use empty string '' to refer the default
   * database.
   * </pre>
   *
   * <code>string database_id = 9;</code>
   *
   * @return The bytes for databaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseIdBytes() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTITION_ID_FIELD_NUMBER = 2;
  private com.google.datastore.v1.PartitionId partitionId_;

  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, identified by a partition ID.
   * Queries are scoped to a single partition.
   * This partition ID is normalized with the standard default context
   * partition ID.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
   *
   * @return Whether the partitionId field is set.
   */
  @java.lang.Override
  public boolean hasPartitionId() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, identified by a partition ID.
   * Queries are scoped to a single partition.
   * This partition ID is normalized with the standard default context
   * partition ID.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
   *
   * @return The partitionId.
   */
  @java.lang.Override
  public com.google.datastore.v1.PartitionId getPartitionId() {
    return partitionId_ == null
        ? com.google.datastore.v1.PartitionId.getDefaultInstance()
        : partitionId_;
  }

  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, identified by a partition ID.
   * Queries are scoped to a single partition.
   * This partition ID is normalized with the standard default context
   * partition ID.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PartitionIdOrBuilder getPartitionIdOrBuilder() {
    return partitionId_ == null
        ? com.google.datastore.v1.PartitionId.getDefaultInstance()
        : partitionId_;
  }

  public static final int READ_OPTIONS_FIELD_NUMBER = 1;
  private com.google.datastore.v1.ReadOptions readOptions_;

  /**
   *
   *
   * <pre>
   * The options for this query.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
   *
   * @return Whether the readOptions field is set.
   */
  @java.lang.Override
  public boolean hasReadOptions() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The options for this query.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
   *
   * @return The readOptions.
   */
  @java.lang.Override
  public com.google.datastore.v1.ReadOptions getReadOptions() {
    return readOptions_ == null
        ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
        : readOptions_;
  }

  /**
   *
   *
   * <pre>
   * The options for this query.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ReadOptionsOrBuilder getReadOptionsOrBuilder() {
    return readOptions_ == null
        ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
        : readOptions_;
  }

  public static final int AGGREGATION_QUERY_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * The query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
   *
   * @return Whether the aggregationQuery field is set.
   */
  @java.lang.Override
  public boolean hasAggregationQuery() {
    return queryTypeCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * The query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
   *
   * @return The aggregationQuery.
   */
  @java.lang.Override
  public com.google.datastore.v1.AggregationQuery getAggregationQuery() {
    if (queryTypeCase_ == 3) {
      return (com.google.datastore.v1.AggregationQuery) queryType_;
    }
    return com.google.datastore.v1.AggregationQuery.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.AggregationQueryOrBuilder getAggregationQueryOrBuilder() {
    if (queryTypeCase_ == 3) {
      return (com.google.datastore.v1.AggregationQuery) queryType_;
    }
    return com.google.datastore.v1.AggregationQuery.getDefaultInstance();
  }

  public static final int GQL_QUERY_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * The GQL query to run. This query must be an aggregation query.
   * </pre>
   *
   * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
   *
   * @return Whether the gqlQuery field is set.
   */
  @java.lang.Override
  public boolean hasGqlQuery() {
    return queryTypeCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * The GQL query to run. This query must be an aggregation query.
   * </pre>
   *
   * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
   *
   * @return The gqlQuery.
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQuery getGqlQuery() {
    if (queryTypeCase_ == 7) {
      return (com.google.datastore.v1.GqlQuery) queryType_;
    }
    return com.google.datastore.v1.GqlQuery.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The GQL query to run. This query must be an aggregation query.
   * </pre>
   *
   * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQueryOrBuilder getGqlQueryOrBuilder() {
    if (queryTypeCase_ == 7) {
      return (com.google.datastore.v1.GqlQuery) queryType_;
    }
    return com.google.datastore.v1.GqlQuery.getDefaultInstance();
  }

  public static final int EXPLAIN_OPTIONS_FIELD_NUMBER = 11;
  private com.google.datastore.v1.ExplainOptions explainOptions_;

  /**
   *
   *
   * <pre>
   * Optional. Explain options for the query. If set, additional query
   * statistics will be returned. If not, only query results will be returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the explainOptions field is set.
   */
  @java.lang.Override
  public boolean hasExplainOptions() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Explain options for the query. If set, additional query
   * statistics will be returned. If not, only query results will be returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The explainOptions.
   */
  @java.lang.Override
  public com.google.datastore.v1.ExplainOptions getExplainOptions() {
    return explainOptions_ == null
        ? com.google.datastore.v1.ExplainOptions.getDefaultInstance()
        : explainOptions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Explain options for the query. If set, additional query
   * statistics will be returned. If not, only query results will be returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ExplainOptionsOrBuilder getExplainOptionsOrBuilder() {
    return explainOptions_ == null
        ? com.google.datastore.v1.ExplainOptions.getDefaultInstance()
        : explainOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(1, getReadOptions());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getPartitionId());
    }
    if (queryTypeCase_ == 3) {
      output.writeMessage(3, (com.google.datastore.v1.AggregationQuery) queryType_);
    }
    if (queryTypeCase_ == 7) {
      output.writeMessage(7, (com.google.datastore.v1.GqlQuery) queryType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, databaseId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getExplainOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReadOptions());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPartitionId());
    }
    if (queryTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.datastore.v1.AggregationQuery) queryType_);
    }
    if (queryTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.datastore.v1.GqlQuery) queryType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, databaseId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getExplainOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.RunAggregationQueryRequest)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.RunAggregationQueryRequest other =
        (com.google.datastore.v1.RunAggregationQueryRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getDatabaseId().equals(other.getDatabaseId())) return false;
    if (hasPartitionId() != other.hasPartitionId()) return false;
    if (hasPartitionId()) {
      if (!getPartitionId().equals(other.getPartitionId())) return false;
    }
    if (hasReadOptions() != other.hasReadOptions()) return false;
    if (hasReadOptions()) {
      if (!getReadOptions().equals(other.getReadOptions())) return false;
    }
    if (hasExplainOptions() != other.hasExplainOptions()) return false;
    if (hasExplainOptions()) {
      if (!getExplainOptions().equals(other.getExplainOptions())) return false;
    }
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 3:
        if (!getAggregationQuery().equals(other.getAggregationQuery())) return false;
        break;
      case 7:
        if (!getGqlQuery().equals(other.getGqlQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + DATABASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseId().hashCode();
    if (hasPartitionId()) {
      hash = (37 * hash) + PARTITION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionId().hashCode();
    }
    if (hasReadOptions()) {
      hash = (37 * hash) + READ_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReadOptions().hashCode();
    }
    if (hasExplainOptions()) {
      hash = (37 * hash) + EXPLAIN_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExplainOptions().hashCode();
    }
    switch (queryTypeCase_) {
      case 3:
        hash = (37 * hash) + AGGREGATION_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getAggregationQuery().hashCode();
        break;
      case 7:
        hash = (37 * hash) + GQL_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getGqlQuery().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.RunAggregationQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [Datastore.RunAggregationQuery][google.datastore.v1.Datastore.RunAggregationQuery].
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.RunAggregationQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.RunAggregationQueryRequest)
      com.google.datastore.v1.RunAggregationQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_RunAggregationQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_RunAggregationQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.RunAggregationQueryRequest.class,
              com.google.datastore.v1.RunAggregationQueryRequest.Builder.class);
    }

    // Construct using com.google.datastore.v1.RunAggregationQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPartitionIdFieldBuilder();
        getReadOptionsFieldBuilder();
        getExplainOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      databaseId_ = "";
      partitionId_ = null;
      if (partitionIdBuilder_ != null) {
        partitionIdBuilder_.dispose();
        partitionIdBuilder_ = null;
      }
      readOptions_ = null;
      if (readOptionsBuilder_ != null) {
        readOptionsBuilder_.dispose();
        readOptionsBuilder_ = null;
      }
      if (aggregationQueryBuilder_ != null) {
        aggregationQueryBuilder_.clear();
      }
      if (gqlQueryBuilder_ != null) {
        gqlQueryBuilder_.clear();
      }
      explainOptions_ = null;
      if (explainOptionsBuilder_ != null) {
        explainOptionsBuilder_.dispose();
        explainOptionsBuilder_ = null;
      }
      queryTypeCase_ = 0;
      queryType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_RunAggregationQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.RunAggregationQueryRequest getDefaultInstanceForType() {
      return com.google.datastore.v1.RunAggregationQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.RunAggregationQueryRequest build() {
      com.google.datastore.v1.RunAggregationQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.RunAggregationQueryRequest buildPartial() {
      com.google.datastore.v1.RunAggregationQueryRequest result =
          new com.google.datastore.v1.RunAggregationQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.v1.RunAggregationQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.databaseId_ = databaseId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.partitionId_ =
            partitionIdBuilder_ == null ? partitionId_ : partitionIdBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.readOptions_ =
            readOptionsBuilder_ == null ? readOptions_ : readOptionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.explainOptions_ =
            explainOptionsBuilder_ == null ? explainOptions_ : explainOptionsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.datastore.v1.RunAggregationQueryRequest result) {
      result.queryTypeCase_ = queryTypeCase_;
      result.queryType_ = this.queryType_;
      if (queryTypeCase_ == 3 && aggregationQueryBuilder_ != null) {
        result.queryType_ = aggregationQueryBuilder_.build();
      }
      if (queryTypeCase_ == 7 && gqlQueryBuilder_ != null) {
        result.queryType_ = gqlQueryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.RunAggregationQueryRequest) {
        return mergeFrom((com.google.datastore.v1.RunAggregationQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.RunAggregationQueryRequest other) {
      if (other == com.google.datastore.v1.RunAggregationQueryRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDatabaseId().isEmpty()) {
        databaseId_ = other.databaseId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPartitionId()) {
        mergePartitionId(other.getPartitionId());
      }
      if (other.hasReadOptions()) {
        mergeReadOptions(other.getReadOptions());
      }
      if (other.hasExplainOptions()) {
        mergeExplainOptions(other.getExplainOptions());
      }
      switch (other.getQueryTypeCase()) {
        case AGGREGATION_QUERY:
          {
            mergeAggregationQuery(other.getAggregationQuery());
            break;
          }
        case GQL_QUERY:
          {
            mergeGqlQuery(other.getGqlQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReadOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPartitionIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAggregationQueryFieldBuilder().getBuilder(), extensionRegistry);
                queryTypeCase_ = 3;
                break;
              } // case 26
            case 58:
              {
                input.readMessage(getGqlQueryFieldBuilder().getBuilder(), extensionRegistry);
                queryTypeCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 66
            case 74:
              {
                databaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(getExplainOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object databaseId_ = "";

    /**
     *
     *
     * <pre>
     * The ID of the database against which to make the request.
     *
     * '(default)' is not allowed; please use empty string '' to refer the default
     * database.
     * </pre>
     *
     * <code>string database_id = 9;</code>
     *
     * @return The databaseId.
     */
    public java.lang.String getDatabaseId() {
      java.lang.Object ref = databaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the database against which to make the request.
     *
     * '(default)' is not allowed; please use empty string '' to refer the default
     * database.
     * </pre>
     *
     * <code>string database_id = 9;</code>
     *
     * @return The bytes for databaseId.
     */
    public com.google.protobuf.ByteString getDatabaseIdBytes() {
      java.lang.Object ref = databaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the database against which to make the request.
     *
     * '(default)' is not allowed; please use empty string '' to refer the default
     * database.
     * </pre>
     *
     * <code>string database_id = 9;</code>
     *
     * @param value The databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The ID of the database against which to make the request.
     *
     * '(default)' is not allowed; please use empty string '' to refer the default
     * database.
     * </pre>
     *
     * <code>string database_id = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseId() {
      databaseId_ = getDefaultInstance().getDatabaseId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The ID of the database against which to make the request.
     *
     * '(default)' is not allowed; please use empty string '' to refer the default
     * database.
     * </pre>
     *
     * <code>string database_id = 9;</code>
     *
     * @param value The bytes for databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.datastore.v1.PartitionId partitionId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PartitionId,
            com.google.datastore.v1.PartitionId.Builder,
            com.google.datastore.v1.PartitionIdOrBuilder>
        partitionIdBuilder_;

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     *
     * @return Whether the partitionId field is set.
     */
    public boolean hasPartitionId() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     *
     * @return The partitionId.
     */
    public com.google.datastore.v1.PartitionId getPartitionId() {
      if (partitionIdBuilder_ == null) {
        return partitionId_ == null
            ? com.google.datastore.v1.PartitionId.getDefaultInstance()
            : partitionId_;
      } else {
        return partitionIdBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder setPartitionId(com.google.datastore.v1.PartitionId value) {
      if (partitionIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionId_ = value;
      } else {
        partitionIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder setPartitionId(com.google.datastore.v1.PartitionId.Builder builderForValue) {
      if (partitionIdBuilder_ == null) {
        partitionId_ = builderForValue.build();
      } else {
        partitionIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder mergePartitionId(com.google.datastore.v1.PartitionId value) {
      if (partitionIdBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && partitionId_ != null
            && partitionId_ != com.google.datastore.v1.PartitionId.getDefaultInstance()) {
          getPartitionIdBuilder().mergeFrom(value);
        } else {
          partitionId_ = value;
        }
      } else {
        partitionIdBuilder_.mergeFrom(value);
      }
      if (partitionId_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder clearPartitionId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      partitionId_ = null;
      if (partitionIdBuilder_ != null) {
        partitionIdBuilder_.dispose();
        partitionIdBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public com.google.datastore.v1.PartitionId.Builder getPartitionIdBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPartitionIdFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public com.google.datastore.v1.PartitionIdOrBuilder getPartitionIdOrBuilder() {
      if (partitionIdBuilder_ != null) {
        return partitionIdBuilder_.getMessageOrBuilder();
      } else {
        return partitionId_ == null
            ? com.google.datastore.v1.PartitionId.getDefaultInstance()
            : partitionId_;
      }
    }

    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PartitionId,
            com.google.datastore.v1.PartitionId.Builder,
            com.google.datastore.v1.PartitionIdOrBuilder>
        getPartitionIdFieldBuilder() {
      if (partitionIdBuilder_ == null) {
        partitionIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.PartitionId,
                com.google.datastore.v1.PartitionId.Builder,
                com.google.datastore.v1.PartitionIdOrBuilder>(
                getPartitionId(), getParentForChildren(), isClean());
        partitionId_ = null;
      }
      return partitionIdBuilder_;
    }

    private com.google.datastore.v1.ReadOptions readOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ReadOptions,
            com.google.datastore.v1.ReadOptions.Builder,
            com.google.datastore.v1.ReadOptionsOrBuilder>
        readOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     *
     * @return Whether the readOptions field is set.
     */
    public boolean hasReadOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     *
     * @return The readOptions.
     */
    public com.google.datastore.v1.ReadOptions getReadOptions() {
      if (readOptionsBuilder_ == null) {
        return readOptions_ == null
            ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
            : readOptions_;
      } else {
        return readOptionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder setReadOptions(com.google.datastore.v1.ReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readOptions_ = value;
      } else {
        readOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder setReadOptions(com.google.datastore.v1.ReadOptions.Builder builderForValue) {
      if (readOptionsBuilder_ == null) {
        readOptions_ = builderForValue.build();
      } else {
        readOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder mergeReadOptions(com.google.datastore.v1.ReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && readOptions_ != null
            && readOptions_ != com.google.datastore.v1.ReadOptions.getDefaultInstance()) {
          getReadOptionsBuilder().mergeFrom(value);
        } else {
          readOptions_ = value;
        }
      } else {
        readOptionsBuilder_.mergeFrom(value);
      }
      if (readOptions_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder clearReadOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      readOptions_ = null;
      if (readOptionsBuilder_ != null) {
        readOptionsBuilder_.dispose();
        readOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public com.google.datastore.v1.ReadOptions.Builder getReadOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getReadOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public com.google.datastore.v1.ReadOptionsOrBuilder getReadOptionsOrBuilder() {
      if (readOptionsBuilder_ != null) {
        return readOptionsBuilder_.getMessageOrBuilder();
      } else {
        return readOptions_ == null
            ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
            : readOptions_;
      }
    }

    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ReadOptions,
            com.google.datastore.v1.ReadOptions.Builder,
            com.google.datastore.v1.ReadOptionsOrBuilder>
        getReadOptionsFieldBuilder() {
      if (readOptionsBuilder_ == null) {
        readOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.ReadOptions,
                com.google.datastore.v1.ReadOptions.Builder,
                com.google.datastore.v1.ReadOptionsOrBuilder>(
                getReadOptions(), getParentForChildren(), isClean());
        readOptions_ = null;
      }
      return readOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.AggregationQuery,
            com.google.datastore.v1.AggregationQuery.Builder,
            com.google.datastore.v1.AggregationQueryOrBuilder>
        aggregationQueryBuilder_;

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     *
     * @return Whether the aggregationQuery field is set.
     */
    @java.lang.Override
    public boolean hasAggregationQuery() {
      return queryTypeCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     *
     * @return The aggregationQuery.
     */
    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery getAggregationQuery() {
      if (aggregationQueryBuilder_ == null) {
        if (queryTypeCase_ == 3) {
          return (com.google.datastore.v1.AggregationQuery) queryType_;
        }
        return com.google.datastore.v1.AggregationQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 3) {
          return aggregationQueryBuilder_.getMessage();
        }
        return com.google.datastore.v1.AggregationQuery.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    public Builder setAggregationQuery(com.google.datastore.v1.AggregationQuery value) {
      if (aggregationQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        aggregationQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    public Builder setAggregationQuery(
        com.google.datastore.v1.AggregationQuery.Builder builderForValue) {
      if (aggregationQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        aggregationQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    public Builder mergeAggregationQuery(com.google.datastore.v1.AggregationQuery value) {
      if (aggregationQueryBuilder_ == null) {
        if (queryTypeCase_ == 3
            && queryType_ != com.google.datastore.v1.AggregationQuery.getDefaultInstance()) {
          queryType_ =
              com.google.datastore.v1.AggregationQuery.newBuilder(
                      (com.google.datastore.v1.AggregationQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 3) {
          aggregationQueryBuilder_.mergeFrom(value);
        } else {
          aggregationQueryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    public Builder clearAggregationQuery() {
      if (aggregationQueryBuilder_ == null) {
        if (queryTypeCase_ == 3) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 3) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        aggregationQueryBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    public com.google.datastore.v1.AggregationQuery.Builder getAggregationQueryBuilder() {
      return getAggregationQueryFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.AggregationQueryOrBuilder getAggregationQueryOrBuilder() {
      if ((queryTypeCase_ == 3) && (aggregationQueryBuilder_ != null)) {
        return aggregationQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 3) {
          return (com.google.datastore.v1.AggregationQuery) queryType_;
        }
        return com.google.datastore.v1.AggregationQuery.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery aggregation_query = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.AggregationQuery,
            com.google.datastore.v1.AggregationQuery.Builder,
            com.google.datastore.v1.AggregationQueryOrBuilder>
        getAggregationQueryFieldBuilder() {
      if (aggregationQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 3)) {
          queryType_ = com.google.datastore.v1.AggregationQuery.getDefaultInstance();
        }
        aggregationQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.AggregationQuery,
                com.google.datastore.v1.AggregationQuery.Builder,
                com.google.datastore.v1.AggregationQueryOrBuilder>(
                (com.google.datastore.v1.AggregationQuery) queryType_,
                getParentForChildren(),
                isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 3;
      onChanged();
      return aggregationQueryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.GqlQuery,
            com.google.datastore.v1.GqlQuery.Builder,
            com.google.datastore.v1.GqlQueryOrBuilder>
        gqlQueryBuilder_;

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     *
     * @return Whether the gqlQuery field is set.
     */
    @java.lang.Override
    public boolean hasGqlQuery() {
      return queryTypeCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     *
     * @return The gqlQuery.
     */
    @java.lang.Override
    public com.google.datastore.v1.GqlQuery getGqlQuery() {
      if (gqlQueryBuilder_ == null) {
        if (queryTypeCase_ == 7) {
          return (com.google.datastore.v1.GqlQuery) queryType_;
        }
        return com.google.datastore.v1.GqlQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 7) {
          return gqlQueryBuilder_.getMessage();
        }
        return com.google.datastore.v1.GqlQuery.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder setGqlQuery(com.google.datastore.v1.GqlQuery value) {
      if (gqlQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        gqlQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder setGqlQuery(com.google.datastore.v1.GqlQuery.Builder builderForValue) {
      if (gqlQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        gqlQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder mergeGqlQuery(com.google.datastore.v1.GqlQuery value) {
      if (gqlQueryBuilder_ == null) {
        if (queryTypeCase_ == 7
            && queryType_ != com.google.datastore.v1.GqlQuery.getDefaultInstance()) {
          queryType_ =
              com.google.datastore.v1.GqlQuery.newBuilder(
                      (com.google.datastore.v1.GqlQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 7) {
          gqlQueryBuilder_.mergeFrom(value);
        } else {
          gqlQueryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder clearGqlQuery() {
      if (gqlQueryBuilder_ == null) {
        if (queryTypeCase_ == 7) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 7) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        gqlQueryBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public com.google.datastore.v1.GqlQuery.Builder getGqlQueryBuilder() {
      return getGqlQueryFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.GqlQueryOrBuilder getGqlQueryOrBuilder() {
      if ((queryTypeCase_ == 7) && (gqlQueryBuilder_ != null)) {
        return gqlQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 7) {
          return (com.google.datastore.v1.GqlQuery) queryType_;
        }
        return com.google.datastore.v1.GqlQuery.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The GQL query to run. This query must be an aggregation query.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.GqlQuery,
            com.google.datastore.v1.GqlQuery.Builder,
            com.google.datastore.v1.GqlQueryOrBuilder>
        getGqlQueryFieldBuilder() {
      if (gqlQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 7)) {
          queryType_ = com.google.datastore.v1.GqlQuery.getDefaultInstance();
        }
        gqlQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.GqlQuery,
                com.google.datastore.v1.GqlQuery.Builder,
                com.google.datastore.v1.GqlQueryOrBuilder>(
                (com.google.datastore.v1.GqlQuery) queryType_, getParentForChildren(), isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 7;
      onChanged();
      return gqlQueryBuilder_;
    }

    private com.google.datastore.v1.ExplainOptions explainOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ExplainOptions,
            com.google.datastore.v1.ExplainOptions.Builder,
            com.google.datastore.v1.ExplainOptionsOrBuilder>
        explainOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the explainOptions field is set.
     */
    public boolean hasExplainOptions() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The explainOptions.
     */
    public com.google.datastore.v1.ExplainOptions getExplainOptions() {
      if (explainOptionsBuilder_ == null) {
        return explainOptions_ == null
            ? com.google.datastore.v1.ExplainOptions.getDefaultInstance()
            : explainOptions_;
      } else {
        return explainOptionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExplainOptions(com.google.datastore.v1.ExplainOptions value) {
      if (explainOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explainOptions_ = value;
      } else {
        explainOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExplainOptions(
        com.google.datastore.v1.ExplainOptions.Builder builderForValue) {
      if (explainOptionsBuilder_ == null) {
        explainOptions_ = builderForValue.build();
      } else {
        explainOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeExplainOptions(com.google.datastore.v1.ExplainOptions value) {
      if (explainOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && explainOptions_ != null
            && explainOptions_ != com.google.datastore.v1.ExplainOptions.getDefaultInstance()) {
          getExplainOptionsBuilder().mergeFrom(value);
        } else {
          explainOptions_ = value;
        }
      } else {
        explainOptionsBuilder_.mergeFrom(value);
      }
      if (explainOptions_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExplainOptions() {
      bitField0_ = (bitField0_ & ~0x00000040);
      explainOptions_ = null;
      if (explainOptionsBuilder_ != null) {
        explainOptionsBuilder_.dispose();
        explainOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.ExplainOptions.Builder getExplainOptionsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getExplainOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.ExplainOptionsOrBuilder getExplainOptionsOrBuilder() {
      if (explainOptionsBuilder_ != null) {
        return explainOptionsBuilder_.getMessageOrBuilder();
      } else {
        return explainOptions_ == null
            ? com.google.datastore.v1.ExplainOptions.getDefaultInstance()
            : explainOptions_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Explain options for the query. If set, additional query
     * statistics will be returned. If not, only query results will be returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.ExplainOptions explain_options = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ExplainOptions,
            com.google.datastore.v1.ExplainOptions.Builder,
            com.google.datastore.v1.ExplainOptionsOrBuilder>
        getExplainOptionsFieldBuilder() {
      if (explainOptionsBuilder_ == null) {
        explainOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.ExplainOptions,
                com.google.datastore.v1.ExplainOptions.Builder,
                com.google.datastore.v1.ExplainOptionsOrBuilder>(
                getExplainOptions(), getParentForChildren(), isClean());
        explainOptions_ = null;
      }
      return explainOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.RunAggregationQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.RunAggregationQueryRequest)
  private static final com.google.datastore.v1.RunAggregationQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.RunAggregationQueryRequest();
  }

  public static com.google.datastore.v1.RunAggregationQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunAggregationQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunAggregationQueryRequest>() {
        @java.lang.Override
        public RunAggregationQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunAggregationQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunAggregationQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.RunAggregationQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
