/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.cloud.dataproc.v1.ClustersProto;
import com.google.cloud.dataproc.v1.InstanceGroupConfig;
import com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder;
import com.google.cloud.dataproc.v1.NodeGroupOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NodeGroup
extends GeneratedMessageV3
implements NodeGroupOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_;
    public static final int ROLES_FIELD_NUMBER = 2;
    private List<Integer> roles_;
    private static final Internal.ListAdapter.Converter<Integer, Role> roles_converter_ = new Internal.ListAdapter.Converter<Integer, Role>(){

        public Role convert(Integer from) {
            Role result = Role.valueOf(from);
            return result == null ? Role.UNRECOGNIZED : result;
        }
    };
    private int rolesMemoizedSerializedSize;
    public static final int NODE_GROUP_CONFIG_FIELD_NUMBER = 3;
    private InstanceGroupConfig nodeGroupConfig_;
    public static final int LABELS_FIELD_NUMBER = 4;
    private MapField<String, String> labels_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final NodeGroup DEFAULT_INSTANCE = new NodeGroup();
    private static final Parser<NodeGroup> PARSER = new AbstractParser<NodeGroup>(){

        public NodeGroup parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = NodeGroup.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private NodeGroup(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private NodeGroup() {
        this.name_ = "";
        this.roles_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new NodeGroup();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ClustersProto.internal_static_google_cloud_dataproc_v1_NodeGroup_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 4: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ClustersProto.internal_static_google_cloud_dataproc_v1_NodeGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeGroup.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<Role> getRolesList() {
        return new Internal.ListAdapter(this.roles_, roles_converter_);
    }

    @Override
    public int getRolesCount() {
        return this.roles_.size();
    }

    @Override
    public Role getRoles(int index) {
        return (Role)((Object)roles_converter_.convert((Object)this.roles_.get(index)));
    }

    @Override
    public List<Integer> getRolesValueList() {
        return this.roles_;
    }

    @Override
    public int getRolesValue(int index) {
        return this.roles_.get(index);
    }

    @Override
    public boolean hasNodeGroupConfig() {
        return this.nodeGroupConfig_ != null;
    }

    @Override
    public InstanceGroupConfig getNodeGroupConfig() {
        return this.nodeGroupConfig_ == null ? InstanceGroupConfig.getDefaultInstance() : this.nodeGroupConfig_;
    }

    @Override
    public InstanceGroupConfigOrBuilder getNodeGroupConfigOrBuilder() {
        return this.getNodeGroupConfig();
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.getRolesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.rolesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.roles_.size(); ++i) {
            output.writeEnumNoTag(this.roles_.get(i).intValue());
        }
        if (this.nodeGroupConfig_ != null) {
            output.writeMessage(3, (MessageLite)this.getNodeGroupConfig());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)4);
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.roles_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.roles_.get(i));
        }
        size += dataSize;
        if (!this.getRolesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.rolesMemoizedSerializedSize = dataSize;
        if (this.nodeGroupConfig_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getNodeGroupConfig());
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)labels__);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeGroup)) {
            return super.equals(obj);
        }
        NodeGroup other = (NodeGroup)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.roles_.equals(other.roles_)) {
            return false;
        }
        if (this.hasNodeGroupConfig() != other.hasNodeGroupConfig()) {
            return false;
        }
        if (this.hasNodeGroupConfig() && !this.getNodeGroupConfig().equals(other.getNodeGroupConfig())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + NodeGroup.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.getRolesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.roles_.hashCode();
        }
        if (this.hasNodeGroupConfig()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getNodeGroupConfig().hashCode();
        }
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static NodeGroup parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NodeGroup)PARSER.parseFrom(data);
    }

    public static NodeGroup parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeGroup parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NodeGroup)PARSER.parseFrom(data);
    }

    public static NodeGroup parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeGroup parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NodeGroup)PARSER.parseFrom(data);
    }

    public static NodeGroup parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeGroup parseFrom(InputStream input) throws IOException {
        return (NodeGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static NodeGroup parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeGroup parseDelimitedFrom(InputStream input) throws IOException {
        return (NodeGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static NodeGroup parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeGroup parseFrom(CodedInputStream input) throws IOException {
        return (NodeGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static NodeGroup parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return NodeGroup.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static NodeGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NodeGroup> parser() {
        return PARSER;
    }

    public Parser<NodeGroup> getParserForType() {
        return PARSER;
    }

    public NodeGroup getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements NodeGroupOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private List<Integer> roles_ = Collections.emptyList();
        private InstanceGroupConfig nodeGroupConfig_;
        private SingleFieldBuilderV3<InstanceGroupConfig, InstanceGroupConfig.Builder, InstanceGroupConfigOrBuilder> nodeGroupConfigBuilder_;
        private MapField<String, String> labels_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_NodeGroup_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_NodeGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeGroup.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.name_ = "";
            this.roles_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.nodeGroupConfigBuilder_ == null) {
                this.nodeGroupConfig_ = null;
            } else {
                this.nodeGroupConfig_ = null;
                this.nodeGroupConfigBuilder_ = null;
            }
            this.internalGetMutableLabels().clear();
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_NodeGroup_descriptor;
        }

        public NodeGroup getDefaultInstanceForType() {
            return NodeGroup.getDefaultInstance();
        }

        public NodeGroup build() {
            NodeGroup result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public NodeGroup buildPartial() {
            NodeGroup result = new NodeGroup(this);
            int from_bitField0_ = this.bitField0_;
            result.name_ = this.name_;
            if ((this.bitField0_ & 1) != 0) {
                this.roles_ = Collections.unmodifiableList(this.roles_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.roles_ = this.roles_;
            if (this.nodeGroupConfigBuilder_ == null) {
                result.nodeGroupConfig_ = this.nodeGroupConfig_;
            } else {
                result.nodeGroupConfig_ = (InstanceGroupConfig)this.nodeGroupConfigBuilder_.build();
            }
            result.labels_ = this.internalGetLabels();
            result.labels_.makeImmutable();
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof NodeGroup) {
                return this.mergeFrom((NodeGroup)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(NodeGroup other) {
            if (other == NodeGroup.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (!other.roles_.isEmpty()) {
                if (this.roles_.isEmpty()) {
                    this.roles_ = other.roles_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureRolesIsMutable();
                    this.roles_.addAll(other.roles_);
                }
                this.onChanged();
            }
            if (other.hasNodeGroupConfig()) {
                this.mergeNodeGroupConfig(other.getNodeGroupConfig());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            continue block13;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureRolesIsMutable();
                            this.roles_.add(tmpRaw);
                            continue block13;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureRolesIsMutable();
                                this.roles_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block13;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getNodeGroupConfigFieldBuilder().getBuilder(), extensionRegistry);
                            continue block13;
                        }
                        case 34: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = NodeGroup.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeGroup.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        private void ensureRolesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.roles_ = new ArrayList<Integer>(this.roles_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<Role> getRolesList() {
            return new Internal.ListAdapter(this.roles_, roles_converter_);
        }

        @Override
        public int getRolesCount() {
            return this.roles_.size();
        }

        @Override
        public Role getRoles(int index) {
            return (Role)((Object)roles_converter_.convert((Object)this.roles_.get(index)));
        }

        public Builder setRoles(int index, Role value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRolesIsMutable();
            this.roles_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addRoles(Role value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRolesIsMutable();
            this.roles_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllRoles(Iterable<? extends Role> values) {
            this.ensureRolesIsMutable();
            for (Role role : values) {
                this.roles_.add(role.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearRoles() {
            this.roles_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getRolesValueList() {
            return Collections.unmodifiableList(this.roles_);
        }

        @Override
        public int getRolesValue(int index) {
            return this.roles_.get(index);
        }

        public Builder setRolesValue(int index, int value) {
            this.ensureRolesIsMutable();
            this.roles_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRolesValue(int value) {
            this.ensureRolesIsMutable();
            this.roles_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRolesValue(Iterable<Integer> values) {
            this.ensureRolesIsMutable();
            for (int value : values) {
                this.roles_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasNodeGroupConfig() {
            return this.nodeGroupConfigBuilder_ != null || this.nodeGroupConfig_ != null;
        }

        @Override
        public InstanceGroupConfig getNodeGroupConfig() {
            if (this.nodeGroupConfigBuilder_ == null) {
                return this.nodeGroupConfig_ == null ? InstanceGroupConfig.getDefaultInstance() : this.nodeGroupConfig_;
            }
            return (InstanceGroupConfig)this.nodeGroupConfigBuilder_.getMessage();
        }

        public Builder setNodeGroupConfig(InstanceGroupConfig value) {
            if (this.nodeGroupConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.nodeGroupConfig_ = value;
                this.onChanged();
            } else {
                this.nodeGroupConfigBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setNodeGroupConfig(InstanceGroupConfig.Builder builderForValue) {
            if (this.nodeGroupConfigBuilder_ == null) {
                this.nodeGroupConfig_ = builderForValue.build();
                this.onChanged();
            } else {
                this.nodeGroupConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeNodeGroupConfig(InstanceGroupConfig value) {
            if (this.nodeGroupConfigBuilder_ == null) {
                this.nodeGroupConfig_ = this.nodeGroupConfig_ != null ? InstanceGroupConfig.newBuilder(this.nodeGroupConfig_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.nodeGroupConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearNodeGroupConfig() {
            if (this.nodeGroupConfigBuilder_ == null) {
                this.nodeGroupConfig_ = null;
                this.onChanged();
            } else {
                this.nodeGroupConfig_ = null;
                this.nodeGroupConfigBuilder_ = null;
            }
            return this;
        }

        public InstanceGroupConfig.Builder getNodeGroupConfigBuilder() {
            this.onChanged();
            return (InstanceGroupConfig.Builder)this.getNodeGroupConfigFieldBuilder().getBuilder();
        }

        @Override
        public InstanceGroupConfigOrBuilder getNodeGroupConfigOrBuilder() {
            if (this.nodeGroupConfigBuilder_ != null) {
                return (InstanceGroupConfigOrBuilder)this.nodeGroupConfigBuilder_.getMessageOrBuilder();
            }
            return this.nodeGroupConfig_ == null ? InstanceGroupConfig.getDefaultInstance() : this.nodeGroupConfig_;
        }

        private SingleFieldBuilderV3<InstanceGroupConfig, InstanceGroupConfig.Builder, InstanceGroupConfigOrBuilder> getNodeGroupConfigFieldBuilder() {
            if (this.nodeGroupConfigBuilder_ == null) {
                this.nodeGroupConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getNodeGroupConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.nodeGroupConfig_ = null;
            }
            return this.nodeGroupConfigBuilder_;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            this.onChanged();
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ClustersProto.internal_static_google_cloud_dataproc_v1_NodeGroup_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum Role implements ProtocolMessageEnum
    {
        ROLE_UNSPECIFIED(0),
        DRIVER(1),
        UNRECOGNIZED(-1);

        public static final int ROLE_UNSPECIFIED_VALUE = 0;
        public static final int DRIVER_VALUE = 1;
        private static final Internal.EnumLiteMap<Role> internalValueMap;
        private static final Role[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Role valueOf(int value) {
            return Role.forNumber(value);
        }

        public static Role forNumber(int value) {
            switch (value) {
                case 0: {
                    return ROLE_UNSPECIFIED;
                }
                case 1: {
                    return DRIVER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Role> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Role.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Role.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)NodeGroup.getDescriptor().getEnumTypes().get(0);
        }

        public static Role valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Role.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Role(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Role>(){

                public Role findValueByNumber(int number) {
                    return Role.forNumber(number);
                }
            };
            VALUES = Role.values();
        }
    }
}

