/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowTemplateName
implements ResourceName {
    private static final PathTemplate PROJECT_REGION_WORKFLOW_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/workflowTemplates/{workflow_template}");
    private static final PathTemplate PROJECT_LOCATION_WORKFLOW_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workflowTemplates/{workflow_template}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String region;
    private final String workflowTemplate;
    private final String location;

    @Deprecated
    protected WorkflowTemplateName() {
        this.project = null;
        this.region = null;
        this.workflowTemplate = null;
        this.location = null;
    }

    private WorkflowTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.workflowTemplate = (String)Preconditions.checkNotNull((Object)builder.getWorkflowTemplate());
        this.location = null;
        this.pathTemplate = PROJECT_REGION_WORKFLOW_TEMPLATE;
    }

    private WorkflowTemplateName(ProjectLocationWorkflowTemplateBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workflowTemplate = (String)Preconditions.checkNotNull((Object)builder.getWorkflowTemplate());
        this.region = null;
        this.pathTemplate = PROJECT_LOCATION_WORKFLOW_TEMPLATE;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getWorkflowTemplate() {
        return this.workflowTemplate;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectRegionWorkflowTemplateBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationWorkflowTemplateBuilder newProjectLocationWorkflowTemplateBuilder() {
        return new ProjectLocationWorkflowTemplateBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkflowTemplateName of(String project, String region, String workflowTemplate) {
        return WorkflowTemplateName.newBuilder().setProject(project).setRegion(region).setWorkflowTemplate(workflowTemplate).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static WorkflowTemplateName ofProjectRegionWorkflowTemplateName(String project, String region, String workflowTemplate) {
        return WorkflowTemplateName.newBuilder().setProject(project).setRegion(region).setWorkflowTemplate(workflowTemplate).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static WorkflowTemplateName ofProjectLocationWorkflowTemplateName(String project, String location, String workflowTemplate) {
        return WorkflowTemplateName.newProjectLocationWorkflowTemplateBuilder().setProject(project).setLocation(location).setWorkflowTemplate(workflowTemplate).build();
    }

    public static String format(String project, String region, String workflowTemplate) {
        return WorkflowTemplateName.newBuilder().setProject(project).setRegion(region).setWorkflowTemplate(workflowTemplate).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectRegionWorkflowTemplateName(String project, String region, String workflowTemplate) {
        return WorkflowTemplateName.newBuilder().setProject(project).setRegion(region).setWorkflowTemplate(workflowTemplate).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationWorkflowTemplateName(String project, String location, String workflowTemplate) {
        return WorkflowTemplateName.newProjectLocationWorkflowTemplateBuilder().setProject(project).setLocation(location).setWorkflowTemplate(workflowTemplate).build().toString();
    }

    public static WorkflowTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_REGION_WORKFLOW_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_REGION_WORKFLOW_TEMPLATE.match(formattedString);
            return WorkflowTemplateName.ofProjectRegionWorkflowTemplateName((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("workflow_template"));
        }
        if (PROJECT_LOCATION_WORKFLOW_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_WORKFLOW_TEMPLATE.match(formattedString);
            return WorkflowTemplateName.ofProjectLocationWorkflowTemplateName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workflow_template"));
        }
        throw new ValidationException("WorkflowTemplateName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<WorkflowTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<WorkflowTemplateName> list = new ArrayList<WorkflowTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkflowTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkflowTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkflowTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_REGION_WORKFLOW_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_WORKFLOW_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkflowTemplateName workflowTemplateName = this;
            synchronized (workflowTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.workflowTemplate != null) {
                        fieldMapBuilder.put((Object)"workflow_template", (Object)this.workflowTemplate);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkflowTemplateName that = (WorkflowTemplateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.region, that.region) && Objects.equals(this.workflowTemplate, that.workflowTemplate) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        h ^= Objects.hashCode(this.workflowTemplate);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationWorkflowTemplateBuilder {
        private String project;
        private String location;
        private String workflowTemplate;

        protected ProjectLocationWorkflowTemplateBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkflowTemplate() {
            return this.workflowTemplate;
        }

        public ProjectLocationWorkflowTemplateBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationWorkflowTemplateBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationWorkflowTemplateBuilder setWorkflowTemplate(String workflowTemplate) {
            this.workflowTemplate = workflowTemplate;
            return this;
        }

        public WorkflowTemplateName build() {
            return new WorkflowTemplateName(this);
        }
    }

    public static class Builder {
        private String project;
        private String region;
        private String workflowTemplate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getWorkflowTemplate() {
            return this.workflowTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setWorkflowTemplate(String workflowTemplate) {
            this.workflowTemplate = workflowTemplate;
            return this;
        }

        private Builder(WorkflowTemplateName workflowTemplateName) {
            Preconditions.checkArgument((boolean)Objects.equals(workflowTemplateName.pathTemplate, PROJECT_REGION_WORKFLOW_TEMPLATE), (Object)"toBuilder is only supported when WorkflowTemplateName has the pattern of projects/{project}/regions/{region}/workflowTemplates/{workflow_template}");
            this.project = workflowTemplateName.project;
            this.region = workflowTemplateName.region;
            this.workflowTemplate = workflowTemplateName.workflowTemplate;
        }

        public WorkflowTemplateName build() {
            return new WorkflowTemplateName(this);
        }
    }
}

