/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClusterRegionName
implements ResourceName {
    private static final PathTemplate PROJECT_REGION_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/clusters/{cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;
    private final String cluster;

    @Deprecated
    protected ClusterRegionName() {
        this.project = null;
        this.region = null;
        this.cluster = null;
    }

    private ClusterRegionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCluster() {
        return this.cluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ClusterRegionName of(String project, String region, String cluster) {
        return ClusterRegionName.newBuilder().setProject(project).setRegion(region).setCluster(cluster).build();
    }

    public static String format(String project, String region, String cluster) {
        return ClusterRegionName.newBuilder().setProject(project).setRegion(region).setCluster(cluster).build().toString();
    }

    public static ClusterRegionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_REGION_CLUSTER.validatedMatch(formattedString, "ClusterRegionName.parse: formattedString not in valid format");
        return ClusterRegionName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("cluster"));
    }

    public static List<ClusterRegionName> parseList(List<String> formattedStrings) {
        ArrayList<ClusterRegionName> list = new ArrayList<ClusterRegionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClusterRegionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClusterRegionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClusterRegionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_REGION_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClusterRegionName clusterRegionName = this;
            synchronized (clusterRegionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_REGION_CLUSTER.instantiate(new String[]{"project", this.project, "region", this.region, "cluster", this.cluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ClusterRegionName that = (ClusterRegionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.region, that.region) && Objects.equals(this.cluster, that.cluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cluster);
    }

    public static class Builder {
        private String project;
        private String region;
        private String cluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCluster() {
            return this.cluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        private Builder(ClusterRegionName clusterRegionName) {
            this.project = clusterRegionName.project;
            this.region = clusterRegionName.region;
            this.cluster = clusterRegionName.cluster;
        }

        public ClusterRegionName build() {
            return new ClusterRegionName(this);
        }
    }
}

