/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BatchName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BATCH = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/batches/{batch}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String batch;

    @Deprecated
    protected BatchName() {
        this.project = null;
        this.location = null;
        this.batch = null;
    }

    private BatchName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.batch = (String)Preconditions.checkNotNull((Object)builder.getBatch());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBatch() {
        return this.batch;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BatchName of(String project, String location, String batch) {
        return BatchName.newBuilder().setProject(project).setLocation(location).setBatch(batch).build();
    }

    public static String format(String project, String location, String batch) {
        return BatchName.newBuilder().setProject(project).setLocation(location).setBatch(batch).build().toString();
    }

    public static BatchName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BATCH.validatedMatch(formattedString, "BatchName.parse: formattedString not in valid format");
        return BatchName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("batch"));
    }

    public static List<BatchName> parseList(List<String> formattedStrings) {
        ArrayList<BatchName> list = new ArrayList<BatchName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BatchName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BatchName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BatchName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BATCH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BatchName batchName = this;
            synchronized (batchName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.batch != null) {
                        fieldMapBuilder.put((Object)"batch", (Object)this.batch);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BATCH.instantiate(new String[]{"project", this.project, "location", this.location, "batch", this.batch});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BatchName that = (BatchName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.batch, that.batch);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.batch);
    }

    public static class Builder {
        private String project;
        private String location;
        private String batch;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBatch() {
            return this.batch;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBatch(String batch) {
            this.batch = batch;
            return this;
        }

        private Builder(BatchName batchName) {
            this.project = batchName.project;
            this.location = batchName.location;
            this.batch = batchName.batch;
        }

        public BatchName build() {
            return new BatchName(this);
        }
    }
}

