/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.cloud.dataproc.v1.AcceleratorConfig;
import com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder;
import com.google.cloud.dataproc.v1.ClustersProto;
import com.google.cloud.dataproc.v1.DiskConfig;
import com.google.cloud.dataproc.v1.DiskConfigOrBuilder;
import com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder;
import com.google.cloud.dataproc.v1.ManagedGroupConfig;
import com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class InstanceGroupConfig
extends GeneratedMessageV3
implements InstanceGroupConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NUM_INSTANCES_FIELD_NUMBER = 1;
    private int numInstances_;
    public static final int INSTANCE_NAMES_FIELD_NUMBER = 2;
    private LazyStringList instanceNames_;
    public static final int IMAGE_URI_FIELD_NUMBER = 3;
    private volatile Object imageUri_;
    public static final int MACHINE_TYPE_URI_FIELD_NUMBER = 4;
    private volatile Object machineTypeUri_;
    public static final int DISK_CONFIG_FIELD_NUMBER = 5;
    private DiskConfig diskConfig_;
    public static final int IS_PREEMPTIBLE_FIELD_NUMBER = 6;
    private boolean isPreemptible_;
    public static final int PREEMPTIBILITY_FIELD_NUMBER = 10;
    private int preemptibility_;
    public static final int MANAGED_GROUP_CONFIG_FIELD_NUMBER = 7;
    private ManagedGroupConfig managedGroupConfig_;
    public static final int ACCELERATORS_FIELD_NUMBER = 8;
    private List<AcceleratorConfig> accelerators_;
    public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 9;
    private volatile Object minCpuPlatform_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final InstanceGroupConfig DEFAULT_INSTANCE = new InstanceGroupConfig();
    private static final Parser<InstanceGroupConfig> PARSER = new AbstractParser<InstanceGroupConfig>(){

        public InstanceGroupConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = InstanceGroupConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private InstanceGroupConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private InstanceGroupConfig() {
        this.instanceNames_ = LazyStringArrayList.EMPTY;
        this.imageUri_ = "";
        this.machineTypeUri_ = "";
        this.preemptibility_ = 0;
        this.accelerators_ = Collections.emptyList();
        this.minCpuPlatform_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new InstanceGroupConfig();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(InstanceGroupConfig.class, Builder.class);
    }

    @Override
    public int getNumInstances() {
        return this.numInstances_;
    }

    public ProtocolStringList getInstanceNamesList() {
        return this.instanceNames_;
    }

    @Override
    public int getInstanceNamesCount() {
        return this.instanceNames_.size();
    }

    @Override
    public String getInstanceNames(int index) {
        return (String)this.instanceNames_.get(index);
    }

    @Override
    public ByteString getInstanceNamesBytes(int index) {
        return this.instanceNames_.getByteString(index);
    }

    @Override
    public String getImageUri() {
        Object ref = this.imageUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.imageUri_ = s;
        return s;
    }

    @Override
    public ByteString getImageUriBytes() {
        Object ref = this.imageUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.imageUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getMachineTypeUri() {
        Object ref = this.machineTypeUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.machineTypeUri_ = s;
        return s;
    }

    @Override
    public ByteString getMachineTypeUriBytes() {
        Object ref = this.machineTypeUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.machineTypeUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasDiskConfig() {
        return this.diskConfig_ != null;
    }

    @Override
    public DiskConfig getDiskConfig() {
        return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
    }

    @Override
    public DiskConfigOrBuilder getDiskConfigOrBuilder() {
        return this.getDiskConfig();
    }

    @Override
    public boolean getIsPreemptible() {
        return this.isPreemptible_;
    }

    @Override
    public int getPreemptibilityValue() {
        return this.preemptibility_;
    }

    @Override
    public Preemptibility getPreemptibility() {
        Preemptibility result = Preemptibility.valueOf(this.preemptibility_);
        return result == null ? Preemptibility.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasManagedGroupConfig() {
        return this.managedGroupConfig_ != null;
    }

    @Override
    public ManagedGroupConfig getManagedGroupConfig() {
        return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
    }

    @Override
    public ManagedGroupConfigOrBuilder getManagedGroupConfigOrBuilder() {
        return this.getManagedGroupConfig();
    }

    @Override
    public List<AcceleratorConfig> getAcceleratorsList() {
        return this.accelerators_;
    }

    @Override
    public List<? extends AcceleratorConfigOrBuilder> getAcceleratorsOrBuilderList() {
        return this.accelerators_;
    }

    @Override
    public int getAcceleratorsCount() {
        return this.accelerators_.size();
    }

    @Override
    public AcceleratorConfig getAccelerators(int index) {
        return this.accelerators_.get(index);
    }

    @Override
    public AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
        return this.accelerators_.get(index);
    }

    @Override
    public String getMinCpuPlatform() {
        Object ref = this.minCpuPlatform_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.minCpuPlatform_ = s;
        return s;
    }

    @Override
    public ByteString getMinCpuPlatformBytes() {
        Object ref = this.minCpuPlatform_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.minCpuPlatform_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.numInstances_ != 0) {
            output.writeInt32(1, this.numInstances_);
        }
        for (i = 0; i < this.instanceNames_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.instanceNames_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.imageUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.imageUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.machineTypeUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.machineTypeUri_);
        }
        if (this.diskConfig_ != null) {
            output.writeMessage(5, (MessageLite)this.getDiskConfig());
        }
        if (this.isPreemptible_) {
            output.writeBool(6, this.isPreemptible_);
        }
        if (this.managedGroupConfig_ != null) {
            output.writeMessage(7, (MessageLite)this.getManagedGroupConfig());
        }
        for (i = 0; i < this.accelerators_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.accelerators_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.minCpuPlatform_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.minCpuPlatform_);
        }
        if (this.preemptibility_ != Preemptibility.PREEMPTIBILITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.preemptibility_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.numInstances_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)1, (int)this.numInstances_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.instanceNames_.size(); ++i) {
            dataSize += InstanceGroupConfig.computeStringSizeNoTag((Object)this.instanceNames_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getInstanceNamesList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.imageUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.imageUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.machineTypeUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.machineTypeUri_);
        }
        if (this.diskConfig_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getDiskConfig());
        }
        if (this.isPreemptible_) {
            size += CodedOutputStream.computeBoolSize((int)6, (boolean)this.isPreemptible_);
        }
        if (this.managedGroupConfig_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getManagedGroupConfig());
        }
        for (int i = 0; i < this.accelerators_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.accelerators_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.minCpuPlatform_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.minCpuPlatform_);
        }
        if (this.preemptibility_ != Preemptibility.PREEMPTIBILITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.preemptibility_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InstanceGroupConfig)) {
            return super.equals(obj);
        }
        InstanceGroupConfig other = (InstanceGroupConfig)obj;
        if (this.getNumInstances() != other.getNumInstances()) {
            return false;
        }
        if (!this.getInstanceNamesList().equals(other.getInstanceNamesList())) {
            return false;
        }
        if (!this.getImageUri().equals(other.getImageUri())) {
            return false;
        }
        if (!this.getMachineTypeUri().equals(other.getMachineTypeUri())) {
            return false;
        }
        if (this.hasDiskConfig() != other.hasDiskConfig()) {
            return false;
        }
        if (this.hasDiskConfig() && !this.getDiskConfig().equals(other.getDiskConfig())) {
            return false;
        }
        if (this.getIsPreemptible() != other.getIsPreemptible()) {
            return false;
        }
        if (this.preemptibility_ != other.preemptibility_) {
            return false;
        }
        if (this.hasManagedGroupConfig() != other.hasManagedGroupConfig()) {
            return false;
        }
        if (this.hasManagedGroupConfig() && !this.getManagedGroupConfig().equals(other.getManagedGroupConfig())) {
            return false;
        }
        if (!this.getAcceleratorsList().equals(other.getAcceleratorsList())) {
            return false;
        }
        if (!this.getMinCpuPlatform().equals(other.getMinCpuPlatform())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + InstanceGroupConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getNumInstances();
        if (this.getInstanceNamesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getInstanceNamesList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getImageUri().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getMachineTypeUri().hashCode();
        if (this.hasDiskConfig()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDiskConfig().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsPreemptible());
        hash = 37 * hash + 10;
        hash = 53 * hash + this.preemptibility_;
        if (this.hasManagedGroupConfig()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getManagedGroupConfig().hashCode();
        }
        if (this.getAcceleratorsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAcceleratorsList().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getMinCpuPlatform().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static InstanceGroupConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data);
    }

    public static InstanceGroupConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data);
    }

    public static InstanceGroupConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data);
    }

    public static InstanceGroupConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(InputStream input) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static InstanceGroupConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InstanceGroupConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static InstanceGroupConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(CodedInputStream input) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static InstanceGroupConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return InstanceGroupConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static InstanceGroupConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<InstanceGroupConfig> parser() {
        return PARSER;
    }

    public Parser<InstanceGroupConfig> getParserForType() {
        return PARSER;
    }

    public InstanceGroupConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InstanceGroupConfigOrBuilder {
        private int bitField0_;
        private int numInstances_;
        private LazyStringList instanceNames_ = LazyStringArrayList.EMPTY;
        private Object imageUri_ = "";
        private Object machineTypeUri_ = "";
        private DiskConfig diskConfig_;
        private SingleFieldBuilderV3<DiskConfig, DiskConfig.Builder, DiskConfigOrBuilder> diskConfigBuilder_;
        private boolean isPreemptible_;
        private int preemptibility_ = 0;
        private ManagedGroupConfig managedGroupConfig_;
        private SingleFieldBuilderV3<ManagedGroupConfig, ManagedGroupConfig.Builder, ManagedGroupConfigOrBuilder> managedGroupConfigBuilder_;
        private List<AcceleratorConfig> accelerators_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AcceleratorConfig, AcceleratorConfig.Builder, AcceleratorConfigOrBuilder> acceleratorsBuilder_;
        private Object minCpuPlatform_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(InstanceGroupConfig.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.numInstances_ = 0;
            this.instanceNames_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.imageUri_ = "";
            this.machineTypeUri_ = "";
            if (this.diskConfigBuilder_ == null) {
                this.diskConfig_ = null;
            } else {
                this.diskConfig_ = null;
                this.diskConfigBuilder_ = null;
            }
            this.isPreemptible_ = false;
            this.preemptibility_ = 0;
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfig_ = null;
            } else {
                this.managedGroupConfig_ = null;
                this.managedGroupConfigBuilder_ = null;
            }
            if (this.acceleratorsBuilder_ == null) {
                this.accelerators_ = Collections.emptyList();
            } else {
                this.accelerators_ = null;
                this.acceleratorsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.minCpuPlatform_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
        }

        public InstanceGroupConfig getDefaultInstanceForType() {
            return InstanceGroupConfig.getDefaultInstance();
        }

        public InstanceGroupConfig build() {
            InstanceGroupConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public InstanceGroupConfig buildPartial() {
            InstanceGroupConfig result = new InstanceGroupConfig(this);
            int from_bitField0_ = this.bitField0_;
            result.numInstances_ = this.numInstances_;
            if ((this.bitField0_ & 1) != 0) {
                this.instanceNames_ = this.instanceNames_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.instanceNames_ = this.instanceNames_;
            result.imageUri_ = this.imageUri_;
            result.machineTypeUri_ = this.machineTypeUri_;
            if (this.diskConfigBuilder_ == null) {
                result.diskConfig_ = this.diskConfig_;
            } else {
                result.diskConfig_ = (DiskConfig)this.diskConfigBuilder_.build();
            }
            result.isPreemptible_ = this.isPreemptible_;
            result.preemptibility_ = this.preemptibility_;
            if (this.managedGroupConfigBuilder_ == null) {
                result.managedGroupConfig_ = this.managedGroupConfig_;
            } else {
                result.managedGroupConfig_ = (ManagedGroupConfig)this.managedGroupConfigBuilder_.build();
            }
            if (this.acceleratorsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.accelerators_ = Collections.unmodifiableList(this.accelerators_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.accelerators_ = this.accelerators_;
            } else {
                result.accelerators_ = this.acceleratorsBuilder_.build();
            }
            result.minCpuPlatform_ = this.minCpuPlatform_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof InstanceGroupConfig) {
                return this.mergeFrom((InstanceGroupConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(InstanceGroupConfig other) {
            if (other == InstanceGroupConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getNumInstances() != 0) {
                this.setNumInstances(other.getNumInstances());
            }
            if (!other.instanceNames_.isEmpty()) {
                if (this.instanceNames_.isEmpty()) {
                    this.instanceNames_ = other.instanceNames_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureInstanceNamesIsMutable();
                    this.instanceNames_.addAll((Collection)other.instanceNames_);
                }
                this.onChanged();
            }
            if (!other.getImageUri().isEmpty()) {
                this.imageUri_ = other.imageUri_;
                this.onChanged();
            }
            if (!other.getMachineTypeUri().isEmpty()) {
                this.machineTypeUri_ = other.machineTypeUri_;
                this.onChanged();
            }
            if (other.hasDiskConfig()) {
                this.mergeDiskConfig(other.getDiskConfig());
            }
            if (other.getIsPreemptible()) {
                this.setIsPreemptible(other.getIsPreemptible());
            }
            if (other.preemptibility_ != 0) {
                this.setPreemptibilityValue(other.getPreemptibilityValue());
            }
            if (other.hasManagedGroupConfig()) {
                this.mergeManagedGroupConfig(other.getManagedGroupConfig());
            }
            if (this.acceleratorsBuilder_ == null) {
                if (!other.accelerators_.isEmpty()) {
                    if (this.accelerators_.isEmpty()) {
                        this.accelerators_ = other.accelerators_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureAcceleratorsIsMutable();
                        this.accelerators_.addAll(other.accelerators_);
                    }
                    this.onChanged();
                }
            } else if (!other.accelerators_.isEmpty()) {
                if (this.acceleratorsBuilder_.isEmpty()) {
                    this.acceleratorsBuilder_.dispose();
                    this.acceleratorsBuilder_ = null;
                    this.accelerators_ = other.accelerators_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.acceleratorsBuilder_ = alwaysUseFieldBuilders ? this.getAcceleratorsFieldBuilder() : null;
                } else {
                    this.acceleratorsBuilder_.addAllMessages((Iterable)other.accelerators_);
                }
            }
            if (!other.getMinCpuPlatform().isEmpty()) {
                this.minCpuPlatform_ = other.minCpuPlatform_;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 8: {
                            this.numInstances_ = input.readInt32();
                            continue block18;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.ensureInstanceNamesIsMutable();
                            this.instanceNames_.add((Object)s);
                            continue block18;
                        }
                        case 26: {
                            this.imageUri_ = input.readStringRequireUtf8();
                            continue block18;
                        }
                        case 34: {
                            this.machineTypeUri_ = input.readStringRequireUtf8();
                            continue block18;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getDiskConfigFieldBuilder().getBuilder(), extensionRegistry);
                            continue block18;
                        }
                        case 48: {
                            this.isPreemptible_ = input.readBool();
                            continue block18;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getManagedGroupConfigFieldBuilder().getBuilder(), extensionRegistry);
                            continue block18;
                        }
                        case 66: {
                            AcceleratorConfig m = (AcceleratorConfig)input.readMessage(AcceleratorConfig.parser(), extensionRegistry);
                            if (this.acceleratorsBuilder_ == null) {
                                this.ensureAcceleratorsIsMutable();
                                this.accelerators_.add(m);
                                continue block18;
                            }
                            this.acceleratorsBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 74: {
                            this.minCpuPlatform_ = input.readStringRequireUtf8();
                            continue block18;
                        }
                        case 80: {
                            this.preemptibility_ = input.readEnum();
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getNumInstances() {
            return this.numInstances_;
        }

        public Builder setNumInstances(int value) {
            this.numInstances_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearNumInstances() {
            this.numInstances_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureInstanceNamesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.instanceNames_ = new LazyStringArrayList(this.instanceNames_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getInstanceNamesList() {
            return this.instanceNames_.getUnmodifiableView();
        }

        @Override
        public int getInstanceNamesCount() {
            return this.instanceNames_.size();
        }

        @Override
        public String getInstanceNames(int index) {
            return (String)this.instanceNames_.get(index);
        }

        @Override
        public ByteString getInstanceNamesBytes(int index) {
            return this.instanceNames_.getByteString(index);
        }

        public Builder setInstanceNames(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureInstanceNamesIsMutable();
            this.instanceNames_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addInstanceNames(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureInstanceNamesIsMutable();
            this.instanceNames_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllInstanceNames(Iterable<String> values) {
            this.ensureInstanceNamesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.instanceNames_);
            this.onChanged();
            return this;
        }

        public Builder clearInstanceNames() {
            this.instanceNames_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addInstanceNamesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.ensureInstanceNamesIsMutable();
            this.instanceNames_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public String getImageUri() {
            Object ref = this.imageUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.imageUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getImageUriBytes() {
            Object ref = this.imageUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.imageUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setImageUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.imageUri_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearImageUri() {
            this.imageUri_ = InstanceGroupConfig.getDefaultInstance().getImageUri();
            this.onChanged();
            return this;
        }

        public Builder setImageUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.imageUri_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getMachineTypeUri() {
            Object ref = this.machineTypeUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.machineTypeUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMachineTypeUriBytes() {
            Object ref = this.machineTypeUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.machineTypeUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMachineTypeUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.machineTypeUri_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMachineTypeUri() {
            this.machineTypeUri_ = InstanceGroupConfig.getDefaultInstance().getMachineTypeUri();
            this.onChanged();
            return this;
        }

        public Builder setMachineTypeUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.machineTypeUri_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDiskConfig() {
            return this.diskConfigBuilder_ != null || this.diskConfig_ != null;
        }

        @Override
        public DiskConfig getDiskConfig() {
            if (this.diskConfigBuilder_ == null) {
                return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
            }
            return (DiskConfig)this.diskConfigBuilder_.getMessage();
        }

        public Builder setDiskConfig(DiskConfig value) {
            if (this.diskConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.diskConfig_ = value;
                this.onChanged();
            } else {
                this.diskConfigBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setDiskConfig(DiskConfig.Builder builderForValue) {
            if (this.diskConfigBuilder_ == null) {
                this.diskConfig_ = builderForValue.build();
                this.onChanged();
            } else {
                this.diskConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeDiskConfig(DiskConfig value) {
            if (this.diskConfigBuilder_ == null) {
                this.diskConfig_ = this.diskConfig_ != null ? DiskConfig.newBuilder(this.diskConfig_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.diskConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearDiskConfig() {
            if (this.diskConfigBuilder_ == null) {
                this.diskConfig_ = null;
                this.onChanged();
            } else {
                this.diskConfig_ = null;
                this.diskConfigBuilder_ = null;
            }
            return this;
        }

        public DiskConfig.Builder getDiskConfigBuilder() {
            this.onChanged();
            return (DiskConfig.Builder)this.getDiskConfigFieldBuilder().getBuilder();
        }

        @Override
        public DiskConfigOrBuilder getDiskConfigOrBuilder() {
            if (this.diskConfigBuilder_ != null) {
                return (DiskConfigOrBuilder)this.diskConfigBuilder_.getMessageOrBuilder();
            }
            return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
        }

        private SingleFieldBuilderV3<DiskConfig, DiskConfig.Builder, DiskConfigOrBuilder> getDiskConfigFieldBuilder() {
            if (this.diskConfigBuilder_ == null) {
                this.diskConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDiskConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.diskConfig_ = null;
            }
            return this.diskConfigBuilder_;
        }

        @Override
        public boolean getIsPreemptible() {
            return this.isPreemptible_;
        }

        public Builder setIsPreemptible(boolean value) {
            this.isPreemptible_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearIsPreemptible() {
            this.isPreemptible_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getPreemptibilityValue() {
            return this.preemptibility_;
        }

        public Builder setPreemptibilityValue(int value) {
            this.preemptibility_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Preemptibility getPreemptibility() {
            Preemptibility result = Preemptibility.valueOf(this.preemptibility_);
            return result == null ? Preemptibility.UNRECOGNIZED : result;
        }

        public Builder setPreemptibility(Preemptibility value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.preemptibility_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPreemptibility() {
            this.preemptibility_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasManagedGroupConfig() {
            return this.managedGroupConfigBuilder_ != null || this.managedGroupConfig_ != null;
        }

        @Override
        public ManagedGroupConfig getManagedGroupConfig() {
            if (this.managedGroupConfigBuilder_ == null) {
                return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
            }
            return (ManagedGroupConfig)this.managedGroupConfigBuilder_.getMessage();
        }

        public Builder setManagedGroupConfig(ManagedGroupConfig value) {
            if (this.managedGroupConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.managedGroupConfig_ = value;
                this.onChanged();
            } else {
                this.managedGroupConfigBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setManagedGroupConfig(ManagedGroupConfig.Builder builderForValue) {
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfig_ = builderForValue.build();
                this.onChanged();
            } else {
                this.managedGroupConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeManagedGroupConfig(ManagedGroupConfig value) {
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfig_ = this.managedGroupConfig_ != null ? ManagedGroupConfig.newBuilder(this.managedGroupConfig_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.managedGroupConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearManagedGroupConfig() {
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfig_ = null;
                this.onChanged();
            } else {
                this.managedGroupConfig_ = null;
                this.managedGroupConfigBuilder_ = null;
            }
            return this;
        }

        public ManagedGroupConfig.Builder getManagedGroupConfigBuilder() {
            this.onChanged();
            return (ManagedGroupConfig.Builder)this.getManagedGroupConfigFieldBuilder().getBuilder();
        }

        @Override
        public ManagedGroupConfigOrBuilder getManagedGroupConfigOrBuilder() {
            if (this.managedGroupConfigBuilder_ != null) {
                return (ManagedGroupConfigOrBuilder)this.managedGroupConfigBuilder_.getMessageOrBuilder();
            }
            return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
        }

        private SingleFieldBuilderV3<ManagedGroupConfig, ManagedGroupConfig.Builder, ManagedGroupConfigOrBuilder> getManagedGroupConfigFieldBuilder() {
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getManagedGroupConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.managedGroupConfig_ = null;
            }
            return this.managedGroupConfigBuilder_;
        }

        private void ensureAcceleratorsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.accelerators_ = new ArrayList<AcceleratorConfig>(this.accelerators_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AcceleratorConfig> getAcceleratorsList() {
            if (this.acceleratorsBuilder_ == null) {
                return Collections.unmodifiableList(this.accelerators_);
            }
            return this.acceleratorsBuilder_.getMessageList();
        }

        @Override
        public int getAcceleratorsCount() {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.size();
            }
            return this.acceleratorsBuilder_.getCount();
        }

        @Override
        public AcceleratorConfig getAccelerators(int index) {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.get(index);
            }
            return (AcceleratorConfig)this.acceleratorsBuilder_.getMessage(index);
        }

        public Builder setAccelerators(int index, AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.set(index, value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAccelerators(int index, AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccelerators(AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccelerators(int index, AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(index, value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccelerators(AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccelerators(int index, AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAccelerators(Iterable<? extends AcceleratorConfig> values) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.accelerators_);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAccelerators() {
            if (this.acceleratorsBuilder_ == null) {
                this.accelerators_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAccelerators(int index) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.remove(index);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.remove(index);
            }
            return this;
        }

        public AcceleratorConfig.Builder getAcceleratorsBuilder(int index) {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().getBuilder(index);
        }

        @Override
        public AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.get(index);
            }
            return (AcceleratorConfigOrBuilder)this.acceleratorsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AcceleratorConfigOrBuilder> getAcceleratorsOrBuilderList() {
            if (this.acceleratorsBuilder_ != null) {
                return this.acceleratorsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.accelerators_);
        }

        public AcceleratorConfig.Builder addAcceleratorsBuilder() {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().addBuilder((AbstractMessage)AcceleratorConfig.getDefaultInstance());
        }

        public AcceleratorConfig.Builder addAcceleratorsBuilder(int index) {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().addBuilder(index, (AbstractMessage)AcceleratorConfig.getDefaultInstance());
        }

        public List<AcceleratorConfig.Builder> getAcceleratorsBuilderList() {
            return this.getAcceleratorsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AcceleratorConfig, AcceleratorConfig.Builder, AcceleratorConfigOrBuilder> getAcceleratorsFieldBuilder() {
            if (this.acceleratorsBuilder_ == null) {
                this.acceleratorsBuilder_ = new RepeatedFieldBuilderV3(this.accelerators_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.accelerators_ = null;
            }
            return this.acceleratorsBuilder_;
        }

        @Override
        public String getMinCpuPlatform() {
            Object ref = this.minCpuPlatform_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.minCpuPlatform_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMinCpuPlatformBytes() {
            Object ref = this.minCpuPlatform_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.minCpuPlatform_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMinCpuPlatform(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.minCpuPlatform_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMinCpuPlatform() {
            this.minCpuPlatform_ = InstanceGroupConfig.getDefaultInstance().getMinCpuPlatform();
            this.onChanged();
            return this;
        }

        public Builder setMinCpuPlatformBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.minCpuPlatform_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum Preemptibility implements ProtocolMessageEnum
    {
        PREEMPTIBILITY_UNSPECIFIED(0),
        NON_PREEMPTIBLE(1),
        PREEMPTIBLE(2),
        UNRECOGNIZED(-1);

        public static final int PREEMPTIBILITY_UNSPECIFIED_VALUE = 0;
        public static final int NON_PREEMPTIBLE_VALUE = 1;
        public static final int PREEMPTIBLE_VALUE = 2;
        private static final Internal.EnumLiteMap<Preemptibility> internalValueMap;
        private static final Preemptibility[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Preemptibility valueOf(int value) {
            return Preemptibility.forNumber(value);
        }

        public static Preemptibility forNumber(int value) {
            switch (value) {
                case 0: {
                    return PREEMPTIBILITY_UNSPECIFIED;
                }
                case 1: {
                    return NON_PREEMPTIBLE;
                }
                case 2: {
                    return PREEMPTIBLE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Preemptibility> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Preemptibility.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Preemptibility.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)InstanceGroupConfig.getDescriptor().getEnumTypes().get(0);
        }

        public static Preemptibility valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Preemptibility.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Preemptibility(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Preemptibility>(){

                public Preemptibility findValueByNumber(int number) {
                    return Preemptibility.forNumber(number);
                }
            };
            VALUES = Preemptibility.values();
        }
    }
}

