/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntryLinkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTRY_GROUP_ENTRY_LINK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}/entryLinks/{entry_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entryGroup;
    private final String entryLink;

    @Deprecated
    protected EntryLinkName() {
        this.project = null;
        this.location = null;
        this.entryGroup = null;
        this.entryLink = null;
    }

    private EntryLinkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entryGroup = (String)Preconditions.checkNotNull((Object)builder.getEntryGroup());
        this.entryLink = (String)Preconditions.checkNotNull((Object)builder.getEntryLink());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntryGroup() {
        return this.entryGroup;
    }

    public String getEntryLink() {
        return this.entryLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntryLinkName of(String project, String location, String entryGroup, String entryLink) {
        return EntryLinkName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).setEntryLink(entryLink).build();
    }

    public static String format(String project, String location, String entryGroup, String entryLink) {
        return EntryLinkName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).setEntryLink(entryLink).build().toString();
    }

    public static EntryLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENTRY_GROUP_ENTRY_LINK.validatedMatch(formattedString, "EntryLinkName.parse: formattedString not in valid format");
        return EntryLinkName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entry_group"), (String)matchMap.get("entry_link"));
    }

    public static List<EntryLinkName> parseList(List<String> formattedStrings) {
        ArrayList<EntryLinkName> list = new ArrayList<EntryLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntryLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntryLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntryLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTRY_GROUP_ENTRY_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntryLinkName entryLinkName = this;
            synchronized (entryLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entryGroup != null) {
                        fieldMapBuilder.put((Object)"entry_group", (Object)this.entryGroup);
                    }
                    if (this.entryLink != null) {
                        fieldMapBuilder.put((Object)"entry_link", (Object)this.entryLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENTRY_GROUP_ENTRY_LINK.instantiate(new String[]{"project", this.project, "location", this.location, "entry_group", this.entryGroup, "entry_link", this.entryLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntryLinkName that = (EntryLinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entryGroup, that.entryGroup) && Objects.equals(this.entryLink, that.entryLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.entryGroup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entryLink);
    }

    public static class Builder {
        private String project;
        private String location;
        private String entryGroup;
        private String entryLink;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntryGroup() {
            return this.entryGroup;
        }

        public String getEntryLink() {
            return this.entryLink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntryGroup(String entryGroup) {
            this.entryGroup = entryGroup;
            return this;
        }

        public Builder setEntryLink(String entryLink) {
            this.entryLink = entryLink;
            return this;
        }

        private Builder(EntryLinkName entryLinkName) {
            this.project = entryLinkName.project;
            this.location = entryLinkName.location;
            this.entryGroup = entryLinkName.entryGroup;
            this.entryLink = entryLinkName.entryLink;
        }

        public EntryLinkName build() {
            return new EntryLinkName(this);
        }
    }
}

