/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataScanName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASCAN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataScans/{dataScan}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataScan;

    @Deprecated
    protected DataScanName() {
        this.project = null;
        this.location = null;
        this.dataScan = null;
    }

    private DataScanName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataScan = (String)Preconditions.checkNotNull((Object)builder.getDataScan());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataScan() {
        return this.dataScan;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataScanName of(String project, String location, String dataScan) {
        return DataScanName.newBuilder().setProject(project).setLocation(location).setDataScan(dataScan).build();
    }

    public static String format(String project, String location, String dataScan) {
        return DataScanName.newBuilder().setProject(project).setLocation(location).setDataScan(dataScan).build().toString();
    }

    public static DataScanName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASCAN.validatedMatch(formattedString, "DataScanName.parse: formattedString not in valid format");
        return DataScanName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataScan"));
    }

    public static List<DataScanName> parseList(List<String> formattedStrings) {
        ArrayList<DataScanName> list = new ArrayList<DataScanName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataScanName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataScanName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataScanName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASCAN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataScanName dataScanName = this;
            synchronized (dataScanName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataScan != null) {
                        fieldMapBuilder.put((Object)"dataScan", (Object)this.dataScan);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASCAN.instantiate(new String[]{"project", this.project, "location", this.location, "dataScan", this.dataScan});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DataScanName that = (DataScanName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataScan, that.dataScan);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataScan);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataScan;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataScan() {
            return this.dataScan;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataScan(String dataScan) {
            this.dataScan = dataScan;
            return this;
        }

        private Builder(DataScanName dataScanName) {
            this.project = dataScanName.project;
            this.location = dataScanName.location;
            this.dataScan = dataScanName.dataScan;
        }

        public DataScanName build() {
            return new DataScanName(this);
        }
    }
}

