/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EvaluationName
implements ResourceName {
    private static final PathTemplate PROJECT_DATASET_EVALUATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/evaluations/{evaluation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String evaluation;

    @Deprecated
    protected EvaluationName() {
        this.project = null;
        this.dataset = null;
        this.evaluation = null;
    }

    private EvaluationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.evaluation = (String)Preconditions.checkNotNull((Object)builder.getEvaluation());
    }

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EvaluationName of(String project, String dataset, String evaluation) {
        return EvaluationName.newBuilder().setProject(project).setDataset(dataset).setEvaluation(evaluation).build();
    }

    public static String format(String project, String dataset, String evaluation) {
        return EvaluationName.newBuilder().setProject(project).setDataset(dataset).setEvaluation(evaluation).build().toString();
    }

    public static EvaluationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATASET_EVALUATION.validatedMatch(formattedString, "EvaluationName.parse: formattedString not in valid format");
        return EvaluationName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("evaluation"));
    }

    public static List<EvaluationName> parseList(List<String> formattedStrings) {
        ArrayList<EvaluationName> list = new ArrayList<EvaluationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EvaluationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EvaluationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EvaluationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATASET_EVALUATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EvaluationName evaluationName = this;
            synchronized (evaluationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.evaluation != null) {
                        fieldMapBuilder.put((Object)"evaluation", (Object)this.evaluation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATASET_EVALUATION.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "evaluation", this.evaluation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EvaluationName that = (EvaluationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.evaluation, that.evaluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.evaluation);
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String evaluation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getEvaluation() {
            return this.evaluation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setEvaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        private Builder(EvaluationName evaluationName) {
            this.project = evaluationName.project;
            this.dataset = evaluationName.dataset;
            this.evaluation = evaluationName.evaluation;
        }

        public EvaluationName build() {
            return new EvaluationName(this);
        }
    }
}

