/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

public interface WorkflowConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. The workflow config's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. The workflow config's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The name of the release config whose release_compilation_result
   * should be executed. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The releaseConfig.
   */
  java.lang.String getReleaseConfig();

  /**
   *
   *
   * <pre>
   * Required. The name of the release config whose release_compilation_result
   * should be executed. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for releaseConfig.
   */
  com.google.protobuf.ByteString getReleaseConfigBytes();

  /**
   *
   *
   * <pre>
   * Optional. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the invocationConfig field is set.
   */
  boolean hasInvocationConfig();

  /**
   *
   *
   * <pre>
   * Optional. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The invocationConfig.
   */
  com.google.cloud.dataform.v1.InvocationConfig getInvocationConfig();

  /**
   *
   *
   * <pre>
   * Optional. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dataform.v1.InvocationConfigOrBuilder getInvocationConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Optional schedule (in cron format) for automatic execution of
   * this workflow config.
   * </pre>
   *
   * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The cronSchedule.
   */
  java.lang.String getCronSchedule();

  /**
   *
   *
   * <pre>
   * Optional. Optional schedule (in cron format) for automatic execution of
   * this workflow config.
   * </pre>
   *
   * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for cronSchedule.
   */
  com.google.protobuf.ByteString getCronScheduleBytes();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the time zone to be used when interpreting
   * cron_schedule. Must be a time zone name from the time zone database
   * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
   * unspecified, the default is UTC.
   * </pre>
   *
   * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The timeZone.
   */
  java.lang.String getTimeZone();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the time zone to be used when interpreting
   * cron_schedule. Must be a time zone name from the time zone database
   * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
   * unspecified, the default is UTC.
   * </pre>
   *
   * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for timeZone.
   */
  com.google.protobuf.ByteString getTimeZoneBytes();

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>
      getRecentScheduledExecutionRecordsList();

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
      getRecentScheduledExecutionRecords(int index);

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getRecentScheduledExecutionRecordsCount();

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder>
      getRecentScheduledExecutionRecordsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder
      getRecentScheduledExecutionRecordsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Disables automatic creation of workflow invocations.
   * </pre>
   *
   * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  boolean getDisabled();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  boolean hasInternalMetadata();

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  java.lang.String getInternalMetadata();

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  com.google.protobuf.ByteString getInternalMetadataBytes();
}
