/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Configures various aspects of Dataform code compilation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.CodeCompilationConfig}
 */
public final class CodeCompilationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CodeCompilationConfig)
    CodeCompilationConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CodeCompilationConfig.newBuilder() to construct.
  private CodeCompilationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CodeCompilationConfig() {
    defaultDatabase_ = "";
    defaultSchema_ = "";
    defaultLocation_ = "";
    assertionSchema_ = "";
    databaseSuffix_ = "";
    schemaSuffix_ = "";
    tablePrefix_ = "";
    builtinAssertionNamePrefix_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CodeCompilationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_CodeCompilationConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetVars();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_CodeCompilationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.CodeCompilationConfig.class,
            com.google.cloud.dataform.v1.CodeCompilationConfig.Builder.class);
  }

  private int bitField0_;
  public static final int DEFAULT_DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultDatabase_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The default database (Google Cloud project ID).
   * </pre>
   *
   * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultDatabase.
   */
  @java.lang.Override
  public java.lang.String getDefaultDatabase() {
    java.lang.Object ref = defaultDatabase_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultDatabase_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The default database (Google Cloud project ID).
   * </pre>
   *
   * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for defaultDatabase.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultDatabaseBytes() {
    java.lang.Object ref = defaultDatabase_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultDatabase_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_SCHEMA_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultSchema_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The default schema (BigQuery dataset ID).
   * </pre>
   *
   * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultSchema.
   */
  @java.lang.Override
  public java.lang.String getDefaultSchema() {
    java.lang.Object ref = defaultSchema_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultSchema_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The default schema (BigQuery dataset ID).
   * </pre>
   *
   * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for defaultSchema.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultSchemaBytes() {
    java.lang.Object ref = defaultSchema_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultSchema_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LOCATION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultLocation_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The default BigQuery location to use. Defaults to "US".
   * See the BigQuery docs for a full list of locations:
   * https://cloud.google.com/bigquery/docs/locations.
   * </pre>
   *
   * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultLocation.
   */
  @java.lang.Override
  public java.lang.String getDefaultLocation() {
    java.lang.Object ref = defaultLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultLocation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The default BigQuery location to use. Defaults to "US".
   * See the BigQuery docs for a full list of locations:
   * https://cloud.google.com/bigquery/docs/locations.
   * </pre>
   *
   * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for defaultLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultLocationBytes() {
    java.lang.Object ref = defaultLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSERTION_SCHEMA_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object assertionSchema_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The default schema (BigQuery dataset ID) for assertions.
   * </pre>
   *
   * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The assertionSchema.
   */
  @java.lang.Override
  public java.lang.String getAssertionSchema() {
    java.lang.Object ref = assertionSchema_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assertionSchema_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The default schema (BigQuery dataset ID) for assertions.
   * </pre>
   *
   * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for assertionSchema.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAssertionSchemaBytes() {
    java.lang.Object ref = assertionSchema_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      assertionSchema_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VARS_FIELD_NUMBER = 4;

  private static final class VarsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataform.v1.DataformProto
                .internal_static_google_cloud_dataform_v1_CodeCompilationConfig_VarsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> vars_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetVars() {
    if (vars_ == null) {
      return com.google.protobuf.MapField.emptyMapField(VarsDefaultEntryHolder.defaultEntry);
    }
    return vars_;
  }

  public int getVarsCount() {
    return internalGetVars().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-defined variables that are made available to project code
   * during compilation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsVars(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetVars().getMap().containsKey(key);
  }

  /** Use {@link #getVarsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getVars() {
    return getVarsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-defined variables that are made available to project code
   * during compilation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getVarsMap() {
    return internalGetVars().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-defined variables that are made available to project code
   * during compilation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getVarsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetVars().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. User-defined variables that are made available to project code
   * during compilation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getVarsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetVars().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DATABASE_SUFFIX_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseSuffix_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The suffix that should be appended to all database (Google Cloud
   * project ID) names.
   * </pre>
   *
   * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The databaseSuffix.
   */
  @java.lang.Override
  public java.lang.String getDatabaseSuffix() {
    java.lang.Object ref = databaseSuffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseSuffix_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The suffix that should be appended to all database (Google Cloud
   * project ID) names.
   * </pre>
   *
   * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for databaseSuffix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseSuffixBytes() {
    java.lang.Object ref = databaseSuffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseSuffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_SUFFIX_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schemaSuffix_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The suffix that should be appended to all schema (BigQuery
   * dataset ID) names.
   * </pre>
   *
   * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The schemaSuffix.
   */
  @java.lang.Override
  public java.lang.String getSchemaSuffix() {
    java.lang.Object ref = schemaSuffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schemaSuffix_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The suffix that should be appended to all schema (BigQuery
   * dataset ID) names.
   * </pre>
   *
   * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for schemaSuffix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaSuffixBytes() {
    java.lang.Object ref = schemaSuffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schemaSuffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_PREFIX_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tablePrefix_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The prefix that should be prepended to all table names.
   * </pre>
   *
   * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The tablePrefix.
   */
  @java.lang.Override
  public java.lang.String getTablePrefix() {
    java.lang.Object ref = tablePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tablePrefix_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The prefix that should be prepended to all table names.
   * </pre>
   *
   * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for tablePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTablePrefixBytes() {
    java.lang.Object ref = tablePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tablePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILTIN_ASSERTION_NAME_PREFIX_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object builtinAssertionNamePrefix_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The prefix to prepend to built-in assertion names.
   * </pre>
   *
   * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The builtinAssertionNamePrefix.
   */
  @java.lang.Override
  public java.lang.String getBuiltinAssertionNamePrefix() {
    java.lang.Object ref = builtinAssertionNamePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      builtinAssertionNamePrefix_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The prefix to prepend to built-in assertion names.
   * </pre>
   *
   * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for builtinAssertionNamePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuiltinAssertionNamePrefixBytes() {
    java.lang.Object ref = builtinAssertionNamePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      builtinAssertionNamePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_NOTEBOOK_RUNTIME_OPTIONS_FIELD_NUMBER = 9;
  private com.google.cloud.dataform.v1.NotebookRuntimeOptions defaultNotebookRuntimeOptions_;

  /**
   *
   *
   * <pre>
   * Optional. The default notebook runtime options.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the defaultNotebookRuntimeOptions field is set.
   */
  @java.lang.Override
  public boolean hasDefaultNotebookRuntimeOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The default notebook runtime options.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The defaultNotebookRuntimeOptions.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.NotebookRuntimeOptions getDefaultNotebookRuntimeOptions() {
    return defaultNotebookRuntimeOptions_ == null
        ? com.google.cloud.dataform.v1.NotebookRuntimeOptions.getDefaultInstance()
        : defaultNotebookRuntimeOptions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The default notebook runtime options.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.NotebookRuntimeOptionsOrBuilder
      getDefaultNotebookRuntimeOptionsOrBuilder() {
    return defaultNotebookRuntimeOptions_ == null
        ? com.google.cloud.dataform.v1.NotebookRuntimeOptions.getDefaultInstance()
        : defaultNotebookRuntimeOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultDatabase_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultDatabase_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultSchema_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, defaultSchema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assertionSchema_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, assertionSchema_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetVars(), VarsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseSuffix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, databaseSuffix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaSuffix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, schemaSuffix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tablePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tablePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLocation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, defaultLocation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getDefaultNotebookRuntimeOptions());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(builtinAssertionNamePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, builtinAssertionNamePrefix_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultDatabase_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultDatabase_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultSchema_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, defaultSchema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assertionSchema_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, assertionSchema_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetVars().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> vars__ =
          VarsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, vars__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseSuffix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, databaseSuffix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaSuffix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, schemaSuffix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tablePrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, tablePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLocation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, defaultLocation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getDefaultNotebookRuntimeOptions());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(builtinAssertionNamePrefix_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(10, builtinAssertionNamePrefix_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.CodeCompilationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.CodeCompilationConfig other =
        (com.google.cloud.dataform.v1.CodeCompilationConfig) obj;

    if (!getDefaultDatabase().equals(other.getDefaultDatabase())) return false;
    if (!getDefaultSchema().equals(other.getDefaultSchema())) return false;
    if (!getDefaultLocation().equals(other.getDefaultLocation())) return false;
    if (!getAssertionSchema().equals(other.getAssertionSchema())) return false;
    if (!internalGetVars().equals(other.internalGetVars())) return false;
    if (!getDatabaseSuffix().equals(other.getDatabaseSuffix())) return false;
    if (!getSchemaSuffix().equals(other.getSchemaSuffix())) return false;
    if (!getTablePrefix().equals(other.getTablePrefix())) return false;
    if (!getBuiltinAssertionNamePrefix().equals(other.getBuiltinAssertionNamePrefix()))
      return false;
    if (hasDefaultNotebookRuntimeOptions() != other.hasDefaultNotebookRuntimeOptions())
      return false;
    if (hasDefaultNotebookRuntimeOptions()) {
      if (!getDefaultNotebookRuntimeOptions().equals(other.getDefaultNotebookRuntimeOptions()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DEFAULT_DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultDatabase().hashCode();
    hash = (37 * hash) + DEFAULT_SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultSchema().hashCode();
    hash = (37 * hash) + DEFAULT_LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultLocation().hashCode();
    hash = (37 * hash) + ASSERTION_SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + getAssertionSchema().hashCode();
    if (!internalGetVars().getMap().isEmpty()) {
      hash = (37 * hash) + VARS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetVars().hashCode();
    }
    hash = (37 * hash) + DATABASE_SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseSuffix().hashCode();
    hash = (37 * hash) + SCHEMA_SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getSchemaSuffix().hashCode();
    hash = (37 * hash) + TABLE_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getTablePrefix().hashCode();
    hash = (37 * hash) + BUILTIN_ASSERTION_NAME_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getBuiltinAssertionNamePrefix().hashCode();
    if (hasDefaultNotebookRuntimeOptions()) {
      hash = (37 * hash) + DEFAULT_NOTEBOOK_RUNTIME_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultNotebookRuntimeOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.CodeCompilationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configures various aspects of Dataform code compilation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CodeCompilationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CodeCompilationConfig)
      com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CodeCompilationConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetVars();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableVars();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CodeCompilationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CodeCompilationConfig.class,
              com.google.cloud.dataform.v1.CodeCompilationConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.CodeCompilationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultNotebookRuntimeOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      defaultDatabase_ = "";
      defaultSchema_ = "";
      defaultLocation_ = "";
      assertionSchema_ = "";
      internalGetMutableVars().clear();
      databaseSuffix_ = "";
      schemaSuffix_ = "";
      tablePrefix_ = "";
      builtinAssertionNamePrefix_ = "";
      defaultNotebookRuntimeOptions_ = null;
      if (defaultNotebookRuntimeOptionsBuilder_ != null) {
        defaultNotebookRuntimeOptionsBuilder_.dispose();
        defaultNotebookRuntimeOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CodeCompilationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CodeCompilationConfig getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CodeCompilationConfig build() {
      com.google.cloud.dataform.v1.CodeCompilationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CodeCompilationConfig buildPartial() {
      com.google.cloud.dataform.v1.CodeCompilationConfig result =
          new com.google.cloud.dataform.v1.CodeCompilationConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataform.v1.CodeCompilationConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.defaultDatabase_ = defaultDatabase_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.defaultSchema_ = defaultSchema_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultLocation_ = defaultLocation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.assertionSchema_ = assertionSchema_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.vars_ = internalGetVars();
        result.vars_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.databaseSuffix_ = databaseSuffix_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.schemaSuffix_ = schemaSuffix_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.tablePrefix_ = tablePrefix_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.builtinAssertionNamePrefix_ = builtinAssertionNamePrefix_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.defaultNotebookRuntimeOptions_ =
            defaultNotebookRuntimeOptionsBuilder_ == null
                ? defaultNotebookRuntimeOptions_
                : defaultNotebookRuntimeOptionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.CodeCompilationConfig) {
        return mergeFrom((com.google.cloud.dataform.v1.CodeCompilationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.CodeCompilationConfig other) {
      if (other == com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance())
        return this;
      if (!other.getDefaultDatabase().isEmpty()) {
        defaultDatabase_ = other.defaultDatabase_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDefaultSchema().isEmpty()) {
        defaultSchema_ = other.defaultSchema_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDefaultLocation().isEmpty()) {
        defaultLocation_ = other.defaultLocation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getAssertionSchema().isEmpty()) {
        assertionSchema_ = other.assertionSchema_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableVars().mergeFrom(other.internalGetVars());
      bitField0_ |= 0x00000010;
      if (!other.getDatabaseSuffix().isEmpty()) {
        databaseSuffix_ = other.databaseSuffix_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getSchemaSuffix().isEmpty()) {
        schemaSuffix_ = other.schemaSuffix_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getTablePrefix().isEmpty()) {
        tablePrefix_ = other.tablePrefix_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getBuiltinAssertionNamePrefix().isEmpty()) {
        builtinAssertionNamePrefix_ = other.builtinAssertionNamePrefix_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasDefaultNotebookRuntimeOptions()) {
        mergeDefaultNotebookRuntimeOptions(other.getDefaultNotebookRuntimeOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                defaultDatabase_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                defaultSchema_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                assertionSchema_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> vars__ =
                    input.readMessage(
                        VarsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableVars().getMutableMap().put(vars__.getKey(), vars__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                databaseSuffix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                schemaSuffix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                tablePrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                defaultLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getDefaultNotebookRuntimeOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                builtinAssertionNamePrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object defaultDatabase_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultDatabase.
     */
    public java.lang.String getDefaultDatabase() {
      java.lang.Object ref = defaultDatabase_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultDatabase_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultDatabase.
     */
    public com.google.protobuf.ByteString getDefaultDatabaseBytes() {
      java.lang.Object ref = defaultDatabase_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultDatabase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultDatabase to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultDatabase_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultDatabase() {
      defaultDatabase_ = getDefaultInstance().getDefaultDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for defaultDatabase to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultDatabase_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object defaultSchema_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID).
     * </pre>
     *
     * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultSchema.
     */
    public java.lang.String getDefaultSchema() {
      java.lang.Object ref = defaultSchema_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultSchema_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID).
     * </pre>
     *
     * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultSchema.
     */
    public com.google.protobuf.ByteString getDefaultSchemaBytes() {
      java.lang.Object ref = defaultSchema_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultSchema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID).
     * </pre>
     *
     * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultSchema to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSchema(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultSchema_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID).
     * </pre>
     *
     * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultSchema() {
      defaultSchema_ = getDefaultInstance().getDefaultSchema();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID).
     * </pre>
     *
     * <code>string default_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for defaultSchema to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSchemaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultSchema_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object defaultLocation_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The default BigQuery location to use. Defaults to "US".
     * See the BigQuery docs for a full list of locations:
     * https://cloud.google.com/bigquery/docs/locations.
     * </pre>
     *
     * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultLocation.
     */
    public java.lang.String getDefaultLocation() {
      java.lang.Object ref = defaultLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default BigQuery location to use. Defaults to "US".
     * See the BigQuery docs for a full list of locations:
     * https://cloud.google.com/bigquery/docs/locations.
     * </pre>
     *
     * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultLocation.
     */
    public com.google.protobuf.ByteString getDefaultLocationBytes() {
      java.lang.Object ref = defaultLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default BigQuery location to use. Defaults to "US".
     * See the BigQuery docs for a full list of locations:
     * https://cloud.google.com/bigquery/docs/locations.
     * </pre>
     *
     * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultLocation to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultLocation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default BigQuery location to use. Defaults to "US".
     * See the BigQuery docs for a full list of locations:
     * https://cloud.google.com/bigquery/docs/locations.
     * </pre>
     *
     * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLocation() {
      defaultLocation_ = getDefaultInstance().getDefaultLocation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default BigQuery location to use. Defaults to "US".
     * See the BigQuery docs for a full list of locations:
     * https://cloud.google.com/bigquery/docs/locations.
     * </pre>
     *
     * <code>string default_location = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for defaultLocation to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultLocation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object assertionSchema_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID) for assertions.
     * </pre>
     *
     * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The assertionSchema.
     */
    public java.lang.String getAssertionSchema() {
      java.lang.Object ref = assertionSchema_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assertionSchema_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID) for assertions.
     * </pre>
     *
     * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for assertionSchema.
     */
    public com.google.protobuf.ByteString getAssertionSchemaBytes() {
      java.lang.Object ref = assertionSchema_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assertionSchema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID) for assertions.
     * </pre>
     *
     * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The assertionSchema to set.
     * @return This builder for chaining.
     */
    public Builder setAssertionSchema(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      assertionSchema_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID) for assertions.
     * </pre>
     *
     * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssertionSchema() {
      assertionSchema_ = getDefaultInstance().getAssertionSchema();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default schema (BigQuery dataset ID) for assertions.
     * </pre>
     *
     * <code>string assertion_schema = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for assertionSchema to set.
     * @return This builder for chaining.
     */
    public Builder setAssertionSchemaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      assertionSchema_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> vars_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetVars() {
      if (vars_ == null) {
        return com.google.protobuf.MapField.emptyMapField(VarsDefaultEntryHolder.defaultEntry);
      }
      return vars_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableVars() {
      if (vars_ == null) {
        vars_ = com.google.protobuf.MapField.newMapField(VarsDefaultEntryHolder.defaultEntry);
      }
      if (!vars_.isMutable()) {
        vars_ = vars_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return vars_;
    }

    public int getVarsCount() {
      return internalGetVars().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsVars(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetVars().getMap().containsKey(key);
    }

    /** Use {@link #getVarsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getVars() {
      return getVarsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getVarsMap() {
      return internalGetVars().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getVarsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetVars().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getVarsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetVars().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearVars() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableVars().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeVars(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableVars().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableVars() {
      bitField0_ |= 0x00000010;
      return internalGetMutableVars().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putVars(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableVars().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined variables that are made available to project code
     * during compilation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; vars = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllVars(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableVars().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.lang.Object databaseSuffix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all database (Google Cloud
     * project ID) names.
     * </pre>
     *
     * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The databaseSuffix.
     */
    public java.lang.String getDatabaseSuffix() {
      java.lang.Object ref = databaseSuffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseSuffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all database (Google Cloud
     * project ID) names.
     * </pre>
     *
     * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for databaseSuffix.
     */
    public com.google.protobuf.ByteString getDatabaseSuffixBytes() {
      java.lang.Object ref = databaseSuffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all database (Google Cloud
     * project ID) names.
     * </pre>
     *
     * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The databaseSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseSuffix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseSuffix_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all database (Google Cloud
     * project ID) names.
     * </pre>
     *
     * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseSuffix() {
      databaseSuffix_ = getDefaultInstance().getDatabaseSuffix();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all database (Google Cloud
     * project ID) names.
     * </pre>
     *
     * <code>string database_suffix = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for databaseSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseSuffixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseSuffix_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object schemaSuffix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The schemaSuffix.
     */
    public java.lang.String getSchemaSuffix() {
      java.lang.Object ref = schemaSuffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaSuffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for schemaSuffix.
     */
    public com.google.protobuf.ByteString getSchemaSuffixBytes() {
      java.lang.Object ref = schemaSuffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The schemaSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaSuffix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schemaSuffix_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaSuffix() {
      schemaSuffix_ = getDefaultInstance().getSchemaSuffix();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for schemaSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaSuffixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schemaSuffix_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object tablePrefix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tablePrefix.
     */
    public java.lang.String getTablePrefix() {
      java.lang.Object ref = tablePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tablePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tablePrefix.
     */
    public com.google.protobuf.ByteString getTablePrefixBytes() {
      java.lang.Object ref = tablePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tablePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The tablePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setTablePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tablePrefix_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTablePrefix() {
      tablePrefix_ = getDefaultInstance().getTablePrefix();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for tablePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setTablePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tablePrefix_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object builtinAssertionNamePrefix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The prefix to prepend to built-in assertion names.
     * </pre>
     *
     * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The builtinAssertionNamePrefix.
     */
    public java.lang.String getBuiltinAssertionNamePrefix() {
      java.lang.Object ref = builtinAssertionNamePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        builtinAssertionNamePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix to prepend to built-in assertion names.
     * </pre>
     *
     * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for builtinAssertionNamePrefix.
     */
    public com.google.protobuf.ByteString getBuiltinAssertionNamePrefixBytes() {
      java.lang.Object ref = builtinAssertionNamePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        builtinAssertionNamePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix to prepend to built-in assertion names.
     * </pre>
     *
     * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The builtinAssertionNamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setBuiltinAssertionNamePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      builtinAssertionNamePrefix_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix to prepend to built-in assertion names.
     * </pre>
     *
     * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuiltinAssertionNamePrefix() {
      builtinAssertionNamePrefix_ = getDefaultInstance().getBuiltinAssertionNamePrefix();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix to prepend to built-in assertion names.
     * </pre>
     *
     * <code>string builtin_assertion_name_prefix = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for builtinAssertionNamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setBuiltinAssertionNamePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      builtinAssertionNamePrefix_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.NotebookRuntimeOptions defaultNotebookRuntimeOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.NotebookRuntimeOptions,
            com.google.cloud.dataform.v1.NotebookRuntimeOptions.Builder,
            com.google.cloud.dataform.v1.NotebookRuntimeOptionsOrBuilder>
        defaultNotebookRuntimeOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the defaultNotebookRuntimeOptions field is set.
     */
    public boolean hasDefaultNotebookRuntimeOptions() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultNotebookRuntimeOptions.
     */
    public com.google.cloud.dataform.v1.NotebookRuntimeOptions getDefaultNotebookRuntimeOptions() {
      if (defaultNotebookRuntimeOptionsBuilder_ == null) {
        return defaultNotebookRuntimeOptions_ == null
            ? com.google.cloud.dataform.v1.NotebookRuntimeOptions.getDefaultInstance()
            : defaultNotebookRuntimeOptions_;
      } else {
        return defaultNotebookRuntimeOptionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDefaultNotebookRuntimeOptions(
        com.google.cloud.dataform.v1.NotebookRuntimeOptions value) {
      if (defaultNotebookRuntimeOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultNotebookRuntimeOptions_ = value;
      } else {
        defaultNotebookRuntimeOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDefaultNotebookRuntimeOptions(
        com.google.cloud.dataform.v1.NotebookRuntimeOptions.Builder builderForValue) {
      if (defaultNotebookRuntimeOptionsBuilder_ == null) {
        defaultNotebookRuntimeOptions_ = builderForValue.build();
      } else {
        defaultNotebookRuntimeOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDefaultNotebookRuntimeOptions(
        com.google.cloud.dataform.v1.NotebookRuntimeOptions value) {
      if (defaultNotebookRuntimeOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && defaultNotebookRuntimeOptions_ != null
            && defaultNotebookRuntimeOptions_
                != com.google.cloud.dataform.v1.NotebookRuntimeOptions.getDefaultInstance()) {
          getDefaultNotebookRuntimeOptionsBuilder().mergeFrom(value);
        } else {
          defaultNotebookRuntimeOptions_ = value;
        }
      } else {
        defaultNotebookRuntimeOptionsBuilder_.mergeFrom(value);
      }
      if (defaultNotebookRuntimeOptions_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDefaultNotebookRuntimeOptions() {
      bitField0_ = (bitField0_ & ~0x00000200);
      defaultNotebookRuntimeOptions_ = null;
      if (defaultNotebookRuntimeOptionsBuilder_ != null) {
        defaultNotebookRuntimeOptionsBuilder_.dispose();
        defaultNotebookRuntimeOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.NotebookRuntimeOptions.Builder
        getDefaultNotebookRuntimeOptionsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDefaultNotebookRuntimeOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.NotebookRuntimeOptionsOrBuilder
        getDefaultNotebookRuntimeOptionsOrBuilder() {
      if (defaultNotebookRuntimeOptionsBuilder_ != null) {
        return defaultNotebookRuntimeOptionsBuilder_.getMessageOrBuilder();
      } else {
        return defaultNotebookRuntimeOptions_ == null
            ? com.google.cloud.dataform.v1.NotebookRuntimeOptions.getDefaultInstance()
            : defaultNotebookRuntimeOptions_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default notebook runtime options.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.NotebookRuntimeOptions default_notebook_runtime_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.NotebookRuntimeOptions,
            com.google.cloud.dataform.v1.NotebookRuntimeOptions.Builder,
            com.google.cloud.dataform.v1.NotebookRuntimeOptionsOrBuilder>
        getDefaultNotebookRuntimeOptionsFieldBuilder() {
      if (defaultNotebookRuntimeOptionsBuilder_ == null) {
        defaultNotebookRuntimeOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.NotebookRuntimeOptions,
                com.google.cloud.dataform.v1.NotebookRuntimeOptions.Builder,
                com.google.cloud.dataform.v1.NotebookRuntimeOptionsOrBuilder>(
                getDefaultNotebookRuntimeOptions(), getParentForChildren(), isClean());
        defaultNotebookRuntimeOptions_ = null;
      }
      return defaultNotebookRuntimeOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CodeCompilationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CodeCompilationConfig)
  private static final com.google.cloud.dataform.v1.CodeCompilationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CodeCompilationConfig();
  }

  public static com.google.cloud.dataform.v1.CodeCompilationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CodeCompilationConfig> PARSER =
      new com.google.protobuf.AbstractParser<CodeCompilationConfig>() {
        @java.lang.Override
        public CodeCompilationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CodeCompilationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CodeCompilationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.CodeCompilationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
