/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3;

import com.google.dataflow.v1beta3.DebugOptions;
import com.google.dataflow.v1beta3.DebugOptionsOrBuilder;
import com.google.dataflow.v1beta3.EnvironmentOrBuilder;
import com.google.dataflow.v1beta3.EnvironmentProto;
import com.google.dataflow.v1beta3.FlexResourceSchedulingGoal;
import com.google.dataflow.v1beta3.ShuffleMode;
import com.google.dataflow.v1beta3.StreamingMode;
import com.google.dataflow.v1beta3.WorkerPool;
import com.google.dataflow.v1beta3.WorkerPoolOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.Any;
import com.google.protobuf.AnyOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Struct;
import com.google.protobuf.StructOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Environment
extends GeneratedMessageV3
implements EnvironmentOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int TEMP_STORAGE_PREFIX_FIELD_NUMBER = 1;
    private volatile Object tempStoragePrefix_ = "";
    public static final int CLUSTER_MANAGER_API_SERVICE_FIELD_NUMBER = 2;
    private volatile Object clusterManagerApiService_ = "";
    public static final int EXPERIMENTS_FIELD_NUMBER = 3;
    private LazyStringArrayList experiments_ = LazyStringArrayList.emptyList();
    public static final int SERVICE_OPTIONS_FIELD_NUMBER = 16;
    private LazyStringArrayList serviceOptions_ = LazyStringArrayList.emptyList();
    public static final int SERVICE_KMS_KEY_NAME_FIELD_NUMBER = 12;
    private volatile Object serviceKmsKeyName_ = "";
    public static final int WORKER_POOLS_FIELD_NUMBER = 4;
    private List<WorkerPool> workerPools_;
    public static final int USER_AGENT_FIELD_NUMBER = 5;
    private Struct userAgent_;
    public static final int VERSION_FIELD_NUMBER = 6;
    private Struct version_;
    public static final int DATASET_FIELD_NUMBER = 7;
    private volatile Object dataset_ = "";
    public static final int SDK_PIPELINE_OPTIONS_FIELD_NUMBER = 8;
    private Struct sdkPipelineOptions_;
    public static final int INTERNAL_EXPERIMENTS_FIELD_NUMBER = 9;
    private Any internalExperiments_;
    public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 10;
    private volatile Object serviceAccountEmail_ = "";
    public static final int FLEX_RESOURCE_SCHEDULING_GOAL_FIELD_NUMBER = 11;
    private int flexResourceSchedulingGoal_ = 0;
    public static final int WORKER_REGION_FIELD_NUMBER = 13;
    private volatile Object workerRegion_ = "";
    public static final int WORKER_ZONE_FIELD_NUMBER = 14;
    private volatile Object workerZone_ = "";
    public static final int SHUFFLE_MODE_FIELD_NUMBER = 15;
    private int shuffleMode_ = 0;
    public static final int DEBUG_OPTIONS_FIELD_NUMBER = 17;
    private DebugOptions debugOptions_;
    public static final int USE_STREAMING_ENGINE_RESOURCE_BASED_BILLING_FIELD_NUMBER = 18;
    private boolean useStreamingEngineResourceBasedBilling_ = false;
    public static final int STREAMING_MODE_FIELD_NUMBER = 19;
    private int streamingMode_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Environment DEFAULT_INSTANCE = new Environment();
    private static final Parser<Environment> PARSER = new AbstractParser<Environment>(){

        public Environment parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Environment.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Environment(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Environment() {
        this.tempStoragePrefix_ = "";
        this.clusterManagerApiService_ = "";
        this.experiments_ = LazyStringArrayList.emptyList();
        this.serviceOptions_ = LazyStringArrayList.emptyList();
        this.serviceKmsKeyName_ = "";
        this.workerPools_ = Collections.emptyList();
        this.dataset_ = "";
        this.serviceAccountEmail_ = "";
        this.flexResourceSchedulingGoal_ = 0;
        this.workerRegion_ = "";
        this.workerZone_ = "";
        this.shuffleMode_ = 0;
        this.streamingMode_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Environment();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return EnvironmentProto.internal_static_google_dataflow_v1beta3_Environment_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return EnvironmentProto.internal_static_google_dataflow_v1beta3_Environment_fieldAccessorTable.ensureFieldAccessorsInitialized(Environment.class, Builder.class);
    }

    @Override
    public String getTempStoragePrefix() {
        Object ref = this.tempStoragePrefix_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.tempStoragePrefix_ = s;
        return s;
    }

    @Override
    public ByteString getTempStoragePrefixBytes() {
        Object ref = this.tempStoragePrefix_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.tempStoragePrefix_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getClusterManagerApiService() {
        Object ref = this.clusterManagerApiService_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterManagerApiService_ = s;
        return s;
    }

    @Override
    public ByteString getClusterManagerApiServiceBytes() {
        Object ref = this.clusterManagerApiService_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterManagerApiService_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getExperimentsList() {
        return this.experiments_;
    }

    @Override
    public int getExperimentsCount() {
        return this.experiments_.size();
    }

    @Override
    public String getExperiments(int index) {
        return this.experiments_.get(index);
    }

    @Override
    public ByteString getExperimentsBytes(int index) {
        return this.experiments_.getByteString(index);
    }

    public ProtocolStringList getServiceOptionsList() {
        return this.serviceOptions_;
    }

    @Override
    public int getServiceOptionsCount() {
        return this.serviceOptions_.size();
    }

    @Override
    public String getServiceOptions(int index) {
        return this.serviceOptions_.get(index);
    }

    @Override
    public ByteString getServiceOptionsBytes(int index) {
        return this.serviceOptions_.getByteString(index);
    }

    @Override
    public String getServiceKmsKeyName() {
        Object ref = this.serviceKmsKeyName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceKmsKeyName_ = s;
        return s;
    }

    @Override
    public ByteString getServiceKmsKeyNameBytes() {
        Object ref = this.serviceKmsKeyName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceKmsKeyName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<WorkerPool> getWorkerPoolsList() {
        return this.workerPools_;
    }

    @Override
    public List<? extends WorkerPoolOrBuilder> getWorkerPoolsOrBuilderList() {
        return this.workerPools_;
    }

    @Override
    public int getWorkerPoolsCount() {
        return this.workerPools_.size();
    }

    @Override
    public WorkerPool getWorkerPools(int index) {
        return this.workerPools_.get(index);
    }

    @Override
    public WorkerPoolOrBuilder getWorkerPoolsOrBuilder(int index) {
        return this.workerPools_.get(index);
    }

    @Override
    public boolean hasUserAgent() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Struct getUserAgent() {
        return this.userAgent_ == null ? Struct.getDefaultInstance() : this.userAgent_;
    }

    @Override
    public StructOrBuilder getUserAgentOrBuilder() {
        return this.userAgent_ == null ? Struct.getDefaultInstance() : this.userAgent_;
    }

    @Override
    public boolean hasVersion() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Struct getVersion() {
        return this.version_ == null ? Struct.getDefaultInstance() : this.version_;
    }

    @Override
    public StructOrBuilder getVersionOrBuilder() {
        return this.version_ == null ? Struct.getDefaultInstance() : this.version_;
    }

    @Override
    public String getDataset() {
        Object ref = this.dataset_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dataset_ = s;
        return s;
    }

    @Override
    public ByteString getDatasetBytes() {
        Object ref = this.dataset_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dataset_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasSdkPipelineOptions() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Struct getSdkPipelineOptions() {
        return this.sdkPipelineOptions_ == null ? Struct.getDefaultInstance() : this.sdkPipelineOptions_;
    }

    @Override
    public StructOrBuilder getSdkPipelineOptionsOrBuilder() {
        return this.sdkPipelineOptions_ == null ? Struct.getDefaultInstance() : this.sdkPipelineOptions_;
    }

    @Override
    public boolean hasInternalExperiments() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Any getInternalExperiments() {
        return this.internalExperiments_ == null ? Any.getDefaultInstance() : this.internalExperiments_;
    }

    @Override
    public AnyOrBuilder getInternalExperimentsOrBuilder() {
        return this.internalExperiments_ == null ? Any.getDefaultInstance() : this.internalExperiments_;
    }

    @Override
    public String getServiceAccountEmail() {
        Object ref = this.serviceAccountEmail_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceAccountEmail_ = s;
        return s;
    }

    @Override
    public ByteString getServiceAccountEmailBytes() {
        Object ref = this.serviceAccountEmail_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceAccountEmail_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getFlexResourceSchedulingGoalValue() {
        return this.flexResourceSchedulingGoal_;
    }

    @Override
    public FlexResourceSchedulingGoal getFlexResourceSchedulingGoal() {
        FlexResourceSchedulingGoal result = FlexResourceSchedulingGoal.forNumber(this.flexResourceSchedulingGoal_);
        return result == null ? FlexResourceSchedulingGoal.UNRECOGNIZED : result;
    }

    @Override
    public String getWorkerRegion() {
        Object ref = this.workerRegion_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.workerRegion_ = s;
        return s;
    }

    @Override
    public ByteString getWorkerRegionBytes() {
        Object ref = this.workerRegion_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.workerRegion_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getWorkerZone() {
        Object ref = this.workerZone_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.workerZone_ = s;
        return s;
    }

    @Override
    public ByteString getWorkerZoneBytes() {
        Object ref = this.workerZone_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.workerZone_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getShuffleModeValue() {
        return this.shuffleMode_;
    }

    @Override
    public ShuffleMode getShuffleMode() {
        ShuffleMode result = ShuffleMode.forNumber(this.shuffleMode_);
        return result == null ? ShuffleMode.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasDebugOptions() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public DebugOptions getDebugOptions() {
        return this.debugOptions_ == null ? DebugOptions.getDefaultInstance() : this.debugOptions_;
    }

    @Override
    public DebugOptionsOrBuilder getDebugOptionsOrBuilder() {
        return this.debugOptions_ == null ? DebugOptions.getDefaultInstance() : this.debugOptions_;
    }

    @Override
    public boolean getUseStreamingEngineResourceBasedBilling() {
        return this.useStreamingEngineResourceBasedBilling_;
    }

    @Override
    public int getStreamingModeValue() {
        return this.streamingMode_;
    }

    @Override
    public StreamingMode getStreamingMode() {
        StreamingMode result = StreamingMode.forNumber(this.streamingMode_);
        return result == null ? StreamingMode.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tempStoragePrefix_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.tempStoragePrefix_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterManagerApiService_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.clusterManagerApiService_);
        }
        for (i = 0; i < this.experiments_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.experiments_.getRaw(i));
        }
        for (i = 0; i < this.workerPools_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.workerPools_.get(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(5, (MessageLite)this.getUserAgent());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(6, (MessageLite)this.getVersion());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dataset_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.dataset_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(8, (MessageLite)this.getSdkPipelineOptions());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(9, (MessageLite)this.getInternalExperiments());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAccountEmail_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.serviceAccountEmail_);
        }
        if (this.flexResourceSchedulingGoal_ != FlexResourceSchedulingGoal.FLEXRS_UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.flexResourceSchedulingGoal_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceKmsKeyName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.serviceKmsKeyName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workerRegion_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.workerRegion_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workerZone_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.workerZone_);
        }
        if (this.shuffleMode_ != ShuffleMode.SHUFFLE_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(15, this.shuffleMode_);
        }
        for (i = 0; i < this.serviceOptions_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.serviceOptions_.getRaw(i));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(17, (MessageLite)this.getDebugOptions());
        }
        if (this.useStreamingEngineResourceBasedBilling_) {
            output.writeBool(18, this.useStreamingEngineResourceBasedBilling_);
        }
        if (this.streamingMode_ != StreamingMode.STREAMING_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(19, this.streamingMode_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tempStoragePrefix_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.tempStoragePrefix_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterManagerApiService_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.clusterManagerApiService_);
        }
        int dataSize = 0;
        for (i = 0; i < this.experiments_.size(); ++i) {
            dataSize += Environment.computeStringSizeNoTag((Object)this.experiments_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getExperimentsList().size();
        for (int i2 = 0; i2 < this.workerPools_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.workerPools_.get(i2)));
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getUserAgent());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getVersion());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dataset_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.dataset_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getSdkPipelineOptions());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getInternalExperiments());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAccountEmail_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.serviceAccountEmail_);
        }
        if (this.flexResourceSchedulingGoal_ != FlexResourceSchedulingGoal.FLEXRS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.flexResourceSchedulingGoal_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceKmsKeyName_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.serviceKmsKeyName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workerRegion_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.workerRegion_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workerZone_)) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.workerZone_);
        }
        if (this.shuffleMode_ != ShuffleMode.SHUFFLE_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)15, (int)this.shuffleMode_);
        }
        dataSize = 0;
        for (i = 0; i < this.serviceOptions_.size(); ++i) {
            dataSize += Environment.computeStringSizeNoTag((Object)this.serviceOptions_.getRaw(i));
        }
        size += dataSize;
        size += 2 * this.getServiceOptionsList().size();
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)this.getDebugOptions());
        }
        if (this.useStreamingEngineResourceBasedBilling_) {
            size += CodedOutputStream.computeBoolSize((int)18, (boolean)this.useStreamingEngineResourceBasedBilling_);
        }
        if (this.streamingMode_ != StreamingMode.STREAMING_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)19, (int)this.streamingMode_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Environment)) {
            return super.equals(obj);
        }
        Environment other = (Environment)obj;
        if (!this.getTempStoragePrefix().equals(other.getTempStoragePrefix())) {
            return false;
        }
        if (!this.getClusterManagerApiService().equals(other.getClusterManagerApiService())) {
            return false;
        }
        if (!this.getExperimentsList().equals(other.getExperimentsList())) {
            return false;
        }
        if (!this.getServiceOptionsList().equals(other.getServiceOptionsList())) {
            return false;
        }
        if (!this.getServiceKmsKeyName().equals(other.getServiceKmsKeyName())) {
            return false;
        }
        if (!this.getWorkerPoolsList().equals(other.getWorkerPoolsList())) {
            return false;
        }
        if (this.hasUserAgent() != other.hasUserAgent()) {
            return false;
        }
        if (this.hasUserAgent() && !this.getUserAgent().equals((Object)other.getUserAgent())) {
            return false;
        }
        if (this.hasVersion() != other.hasVersion()) {
            return false;
        }
        if (this.hasVersion() && !this.getVersion().equals((Object)other.getVersion())) {
            return false;
        }
        if (!this.getDataset().equals(other.getDataset())) {
            return false;
        }
        if (this.hasSdkPipelineOptions() != other.hasSdkPipelineOptions()) {
            return false;
        }
        if (this.hasSdkPipelineOptions() && !this.getSdkPipelineOptions().equals((Object)other.getSdkPipelineOptions())) {
            return false;
        }
        if (this.hasInternalExperiments() != other.hasInternalExperiments()) {
            return false;
        }
        if (this.hasInternalExperiments() && !this.getInternalExperiments().equals((Object)other.getInternalExperiments())) {
            return false;
        }
        if (!this.getServiceAccountEmail().equals(other.getServiceAccountEmail())) {
            return false;
        }
        if (this.flexResourceSchedulingGoal_ != other.flexResourceSchedulingGoal_) {
            return false;
        }
        if (!this.getWorkerRegion().equals(other.getWorkerRegion())) {
            return false;
        }
        if (!this.getWorkerZone().equals(other.getWorkerZone())) {
            return false;
        }
        if (this.shuffleMode_ != other.shuffleMode_) {
            return false;
        }
        if (this.hasDebugOptions() != other.hasDebugOptions()) {
            return false;
        }
        if (this.hasDebugOptions() && !this.getDebugOptions().equals(other.getDebugOptions())) {
            return false;
        }
        if (this.getUseStreamingEngineResourceBasedBilling() != other.getUseStreamingEngineResourceBasedBilling()) {
            return false;
        }
        if (this.streamingMode_ != other.streamingMode_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Environment.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTempStoragePrefix().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getClusterManagerApiService().hashCode();
        if (this.getExperimentsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getExperimentsList().hashCode();
        }
        if (this.getServiceOptionsCount() > 0) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getServiceOptionsList().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getServiceKmsKeyName().hashCode();
        if (this.getWorkerPoolsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getWorkerPoolsList().hashCode();
        }
        if (this.hasUserAgent()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getUserAgent().hashCode();
        }
        if (this.hasVersion()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getVersion().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getDataset().hashCode();
        if (this.hasSdkPipelineOptions()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getSdkPipelineOptions().hashCode();
        }
        if (this.hasInternalExperiments()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getInternalExperiments().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getServiceAccountEmail().hashCode();
        hash = 37 * hash + 11;
        hash = 53 * hash + this.flexResourceSchedulingGoal_;
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getWorkerRegion().hashCode();
        hash = 37 * hash + 14;
        hash = 53 * hash + this.getWorkerZone().hashCode();
        hash = 37 * hash + 15;
        hash = 53 * hash + this.shuffleMode_;
        if (this.hasDebugOptions()) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getDebugOptions().hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getUseStreamingEngineResourceBasedBilling());
        hash = 37 * hash + 19;
        hash = 53 * hash + this.streamingMode_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Environment parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Environment)PARSER.parseFrom(data);
    }

    public static Environment parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Environment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Environment parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Environment)PARSER.parseFrom(data);
    }

    public static Environment parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Environment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Environment parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Environment)PARSER.parseFrom(data);
    }

    public static Environment parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Environment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Environment parseFrom(InputStream input) throws IOException {
        return (Environment)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Environment parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Environment)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Environment parseDelimitedFrom(InputStream input) throws IOException {
        return (Environment)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Environment parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Environment)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Environment parseFrom(CodedInputStream input) throws IOException {
        return (Environment)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Environment parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Environment)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Environment.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Environment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Environment getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Environment> parser() {
        return PARSER;
    }

    public Parser<Environment> getParserForType() {
        return PARSER;
    }

    public Environment getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements EnvironmentOrBuilder {
        private int bitField0_;
        private Object tempStoragePrefix_ = "";
        private Object clusterManagerApiService_ = "";
        private LazyStringArrayList experiments_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList serviceOptions_ = LazyStringArrayList.emptyList();
        private Object serviceKmsKeyName_ = "";
        private List<WorkerPool> workerPools_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<WorkerPool, WorkerPool.Builder, WorkerPoolOrBuilder> workerPoolsBuilder_;
        private Struct userAgent_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> userAgentBuilder_;
        private Struct version_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> versionBuilder_;
        private Object dataset_ = "";
        private Struct sdkPipelineOptions_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> sdkPipelineOptionsBuilder_;
        private Any internalExperiments_;
        private SingleFieldBuilderV3<Any, Any.Builder, AnyOrBuilder> internalExperimentsBuilder_;
        private Object serviceAccountEmail_ = "";
        private int flexResourceSchedulingGoal_ = 0;
        private Object workerRegion_ = "";
        private Object workerZone_ = "";
        private int shuffleMode_ = 0;
        private DebugOptions debugOptions_;
        private SingleFieldBuilderV3<DebugOptions, DebugOptions.Builder, DebugOptionsOrBuilder> debugOptionsBuilder_;
        private boolean useStreamingEngineResourceBasedBilling_;
        private int streamingMode_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return EnvironmentProto.internal_static_google_dataflow_v1beta3_Environment_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return EnvironmentProto.internal_static_google_dataflow_v1beta3_Environment_fieldAccessorTable.ensureFieldAccessorsInitialized(Environment.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getWorkerPoolsFieldBuilder();
                this.getUserAgentFieldBuilder();
                this.getVersionFieldBuilder();
                this.getSdkPipelineOptionsFieldBuilder();
                this.getInternalExperimentsFieldBuilder();
                this.getDebugOptionsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.tempStoragePrefix_ = "";
            this.clusterManagerApiService_ = "";
            this.experiments_ = LazyStringArrayList.emptyList();
            this.serviceOptions_ = LazyStringArrayList.emptyList();
            this.serviceKmsKeyName_ = "";
            if (this.workerPoolsBuilder_ == null) {
                this.workerPools_ = Collections.emptyList();
            } else {
                this.workerPools_ = null;
                this.workerPoolsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.userAgent_ = null;
            if (this.userAgentBuilder_ != null) {
                this.userAgentBuilder_.dispose();
                this.userAgentBuilder_ = null;
            }
            this.version_ = null;
            if (this.versionBuilder_ != null) {
                this.versionBuilder_.dispose();
                this.versionBuilder_ = null;
            }
            this.dataset_ = "";
            this.sdkPipelineOptions_ = null;
            if (this.sdkPipelineOptionsBuilder_ != null) {
                this.sdkPipelineOptionsBuilder_.dispose();
                this.sdkPipelineOptionsBuilder_ = null;
            }
            this.internalExperiments_ = null;
            if (this.internalExperimentsBuilder_ != null) {
                this.internalExperimentsBuilder_.dispose();
                this.internalExperimentsBuilder_ = null;
            }
            this.serviceAccountEmail_ = "";
            this.flexResourceSchedulingGoal_ = 0;
            this.workerRegion_ = "";
            this.workerZone_ = "";
            this.shuffleMode_ = 0;
            this.debugOptions_ = null;
            if (this.debugOptionsBuilder_ != null) {
                this.debugOptionsBuilder_.dispose();
                this.debugOptionsBuilder_ = null;
            }
            this.useStreamingEngineResourceBasedBilling_ = false;
            this.streamingMode_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return EnvironmentProto.internal_static_google_dataflow_v1beta3_Environment_descriptor;
        }

        public Environment getDefaultInstanceForType() {
            return Environment.getDefaultInstance();
        }

        public Environment build() {
            Environment result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Environment buildPartial() {
            Environment result = new Environment(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Environment result) {
            if (this.workerPoolsBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.workerPools_ = Collections.unmodifiableList(this.workerPools_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.workerPools_ = this.workerPools_;
            } else {
                result.workerPools_ = this.workerPoolsBuilder_.build();
            }
        }

        private void buildPartial0(Environment result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.tempStoragePrefix_ = this.tempStoragePrefix_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.clusterManagerApiService_ = this.clusterManagerApiService_;
            }
            if ((from_bitField0_ & 4) != 0) {
                this.experiments_.makeImmutable();
                result.experiments_ = this.experiments_;
            }
            if ((from_bitField0_ & 8) != 0) {
                this.serviceOptions_.makeImmutable();
                result.serviceOptions_ = this.serviceOptions_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.serviceKmsKeyName_ = this.serviceKmsKeyName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x40) != 0) {
                result.userAgent_ = this.userAgentBuilder_ == null ? this.userAgent_ : (Struct)this.userAgentBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.version_ = this.versionBuilder_ == null ? this.version_ : (Struct)this.versionBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.dataset_ = this.dataset_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.sdkPipelineOptions_ = this.sdkPipelineOptionsBuilder_ == null ? this.sdkPipelineOptions_ : (Struct)this.sdkPipelineOptionsBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.internalExperiments_ = this.internalExperimentsBuilder_ == null ? this.internalExperiments_ : (Any)this.internalExperimentsBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.serviceAccountEmail_ = this.serviceAccountEmail_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.flexResourceSchedulingGoal_ = this.flexResourceSchedulingGoal_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.workerRegion_ = this.workerRegion_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.workerZone_ = this.workerZone_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.shuffleMode_ = this.shuffleMode_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.debugOptions_ = this.debugOptionsBuilder_ == null ? this.debugOptions_ : (DebugOptions)this.debugOptionsBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.useStreamingEngineResourceBasedBilling_ = this.useStreamingEngineResourceBasedBilling_;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.streamingMode_ = this.streamingMode_;
            }
            Environment environment = result;
            environment.bitField0_ = environment.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Environment) {
                return this.mergeFrom((Environment)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Environment other) {
            if (other == Environment.getDefaultInstance()) {
                return this;
            }
            if (!other.getTempStoragePrefix().isEmpty()) {
                this.tempStoragePrefix_ = other.tempStoragePrefix_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getClusterManagerApiService().isEmpty()) {
                this.clusterManagerApiService_ = other.clusterManagerApiService_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.experiments_.isEmpty()) {
                if (this.experiments_.isEmpty()) {
                    this.experiments_ = other.experiments_;
                    this.bitField0_ |= 4;
                } else {
                    this.ensureExperimentsIsMutable();
                    this.experiments_.addAll((Collection)other.experiments_);
                }
                this.onChanged();
            }
            if (!other.serviceOptions_.isEmpty()) {
                if (this.serviceOptions_.isEmpty()) {
                    this.serviceOptions_ = other.serviceOptions_;
                    this.bitField0_ |= 8;
                } else {
                    this.ensureServiceOptionsIsMutable();
                    this.serviceOptions_.addAll((Collection)other.serviceOptions_);
                }
                this.onChanged();
            }
            if (!other.getServiceKmsKeyName().isEmpty()) {
                this.serviceKmsKeyName_ = other.serviceKmsKeyName_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (this.workerPoolsBuilder_ == null) {
                if (!other.workerPools_.isEmpty()) {
                    if (this.workerPools_.isEmpty()) {
                        this.workerPools_ = other.workerPools_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureWorkerPoolsIsMutable();
                        this.workerPools_.addAll(other.workerPools_);
                    }
                    this.onChanged();
                }
            } else if (!other.workerPools_.isEmpty()) {
                if (this.workerPoolsBuilder_.isEmpty()) {
                    this.workerPoolsBuilder_.dispose();
                    this.workerPoolsBuilder_ = null;
                    this.workerPools_ = other.workerPools_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.workerPoolsBuilder_ = alwaysUseFieldBuilders ? this.getWorkerPoolsFieldBuilder() : null;
                } else {
                    this.workerPoolsBuilder_.addAllMessages((Iterable)other.workerPools_);
                }
            }
            if (other.hasUserAgent()) {
                this.mergeUserAgent(other.getUserAgent());
            }
            if (other.hasVersion()) {
                this.mergeVersion(other.getVersion());
            }
            if (!other.getDataset().isEmpty()) {
                this.dataset_ = other.dataset_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            if (other.hasSdkPipelineOptions()) {
                this.mergeSdkPipelineOptions(other.getSdkPipelineOptions());
            }
            if (other.hasInternalExperiments()) {
                this.mergeInternalExperiments(other.getInternalExperiments());
            }
            if (!other.getServiceAccountEmail().isEmpty()) {
                this.serviceAccountEmail_ = other.serviceAccountEmail_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (other.flexResourceSchedulingGoal_ != 0) {
                this.setFlexResourceSchedulingGoalValue(other.getFlexResourceSchedulingGoalValue());
            }
            if (!other.getWorkerRegion().isEmpty()) {
                this.workerRegion_ = other.workerRegion_;
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            if (!other.getWorkerZone().isEmpty()) {
                this.workerZone_ = other.workerZone_;
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            if (other.shuffleMode_ != 0) {
                this.setShuffleModeValue(other.getShuffleModeValue());
            }
            if (other.hasDebugOptions()) {
                this.mergeDebugOptions(other.getDebugOptions());
            }
            if (other.getUseStreamingEngineResourceBasedBilling()) {
                this.setUseStreamingEngineResourceBasedBilling(other.getUseStreamingEngineResourceBasedBilling());
            }
            if (other.streamingMode_ != 0) {
                this.setStreamingModeValue(other.getStreamingModeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            this.tempStoragePrefix_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block27;
                        }
                        case 18: {
                            this.clusterManagerApiService_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block27;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.ensureExperimentsIsMutable();
                            this.experiments_.add((Object)s);
                            continue block27;
                        }
                        case 34: {
                            WorkerPool m = (WorkerPool)input.readMessage(WorkerPool.parser(), extensionRegistry);
                            if (this.workerPoolsBuilder_ == null) {
                                this.ensureWorkerPoolsIsMutable();
                                this.workerPools_.add(m);
                                continue block27;
                            }
                            this.workerPoolsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getUserAgentFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getVersionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block27;
                        }
                        case 58: {
                            this.dataset_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getSdkPipelineOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block27;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getInternalExperimentsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block27;
                        }
                        case 82: {
                            this.serviceAccountEmail_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block27;
                        }
                        case 88: {
                            this.flexResourceSchedulingGoal_ = input.readEnum();
                            this.bitField0_ |= 0x1000;
                            continue block27;
                        }
                        case 98: {
                            this.serviceKmsKeyName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 106: {
                            this.workerRegion_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000;
                            continue block27;
                        }
                        case 114: {
                            this.workerZone_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 120: {
                            this.shuffleMode_ = input.readEnum();
                            this.bitField0_ |= 0x8000;
                            continue block27;
                        }
                        case 130: {
                            String s = input.readStringRequireUtf8();
                            this.ensureServiceOptionsIsMutable();
                            this.serviceOptions_.add((Object)s);
                            continue block27;
                        }
                        case 138: {
                            input.readMessage((MessageLite.Builder)this.getDebugOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 144: {
                            this.useStreamingEngineResourceBasedBilling_ = input.readBool();
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                        case 152: {
                            this.streamingMode_ = input.readEnum();
                            this.bitField0_ |= 0x40000;
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getTempStoragePrefix() {
            Object ref = this.tempStoragePrefix_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.tempStoragePrefix_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTempStoragePrefixBytes() {
            Object ref = this.tempStoragePrefix_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.tempStoragePrefix_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTempStoragePrefix(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.tempStoragePrefix_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearTempStoragePrefix() {
            this.tempStoragePrefix_ = Environment.getDefaultInstance().getTempStoragePrefix();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setTempStoragePrefixBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.tempStoragePrefix_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getClusterManagerApiService() {
            Object ref = this.clusterManagerApiService_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterManagerApiService_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterManagerApiServiceBytes() {
            Object ref = this.clusterManagerApiService_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterManagerApiService_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterManagerApiService(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterManagerApiService_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearClusterManagerApiService() {
            this.clusterManagerApiService_ = Environment.getDefaultInstance().getClusterManagerApiService();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setClusterManagerApiServiceBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.clusterManagerApiService_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private void ensureExperimentsIsMutable() {
            if (!this.experiments_.isModifiable()) {
                this.experiments_ = new LazyStringArrayList((LazyStringList)this.experiments_);
            }
            this.bitField0_ |= 4;
        }

        public ProtocolStringList getExperimentsList() {
            this.experiments_.makeImmutable();
            return this.experiments_;
        }

        @Override
        public int getExperimentsCount() {
            return this.experiments_.size();
        }

        @Override
        public String getExperiments(int index) {
            return this.experiments_.get(index);
        }

        @Override
        public ByteString getExperimentsBytes(int index) {
            return this.experiments_.getByteString(index);
        }

        public Builder setExperiments(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExperimentsIsMutable();
            this.experiments_.set(index, value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addExperiments(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExperimentsIsMutable();
            this.experiments_.add((Object)value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addAllExperiments(Iterable<String> values) {
            this.ensureExperimentsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.experiments_);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearExperiments() {
            this.experiments_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addExperimentsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.ensureExperimentsIsMutable();
            this.experiments_.add(value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensureServiceOptionsIsMutable() {
            if (!this.serviceOptions_.isModifiable()) {
                this.serviceOptions_ = new LazyStringArrayList((LazyStringList)this.serviceOptions_);
            }
            this.bitField0_ |= 8;
        }

        public ProtocolStringList getServiceOptionsList() {
            this.serviceOptions_.makeImmutable();
            return this.serviceOptions_;
        }

        @Override
        public int getServiceOptionsCount() {
            return this.serviceOptions_.size();
        }

        @Override
        public String getServiceOptions(int index) {
            return this.serviceOptions_.get(index);
        }

        @Override
        public ByteString getServiceOptionsBytes(int index) {
            return this.serviceOptions_.getByteString(index);
        }

        public Builder setServiceOptions(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureServiceOptionsIsMutable();
            this.serviceOptions_.set(index, value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addServiceOptions(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureServiceOptionsIsMutable();
            this.serviceOptions_.add((Object)value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAllServiceOptions(Iterable<String> values) {
            this.ensureServiceOptionsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.serviceOptions_);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearServiceOptions() {
            this.serviceOptions_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addServiceOptionsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.ensureServiceOptionsIsMutable();
            this.serviceOptions_.add(value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceKmsKeyName() {
            Object ref = this.serviceKmsKeyName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceKmsKeyName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceKmsKeyNameBytes() {
            Object ref = this.serviceKmsKeyName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceKmsKeyName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceKmsKeyName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceKmsKeyName_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearServiceKmsKeyName() {
            this.serviceKmsKeyName_ = Environment.getDefaultInstance().getServiceKmsKeyName();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setServiceKmsKeyNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.serviceKmsKeyName_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        private void ensureWorkerPoolsIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.workerPools_ = new ArrayList<WorkerPool>(this.workerPools_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<WorkerPool> getWorkerPoolsList() {
            if (this.workerPoolsBuilder_ == null) {
                return Collections.unmodifiableList(this.workerPools_);
            }
            return this.workerPoolsBuilder_.getMessageList();
        }

        @Override
        public int getWorkerPoolsCount() {
            if (this.workerPoolsBuilder_ == null) {
                return this.workerPools_.size();
            }
            return this.workerPoolsBuilder_.getCount();
        }

        @Override
        public WorkerPool getWorkerPools(int index) {
            if (this.workerPoolsBuilder_ == null) {
                return this.workerPools_.get(index);
            }
            return (WorkerPool)this.workerPoolsBuilder_.getMessage(index);
        }

        public Builder setWorkerPools(int index, WorkerPool value) {
            if (this.workerPoolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.set(index, value);
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setWorkerPools(int index, WorkerPool.Builder builderForValue) {
            if (this.workerPoolsBuilder_ == null) {
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addWorkerPools(WorkerPool value) {
            if (this.workerPoolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.add(value);
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addWorkerPools(int index, WorkerPool value) {
            if (this.workerPoolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.add(index, value);
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addWorkerPools(WorkerPool.Builder builderForValue) {
            if (this.workerPoolsBuilder_ == null) {
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addWorkerPools(int index, WorkerPool.Builder builderForValue) {
            if (this.workerPoolsBuilder_ == null) {
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllWorkerPools(Iterable<? extends WorkerPool> values) {
            if (this.workerPoolsBuilder_ == null) {
                this.ensureWorkerPoolsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.workerPools_);
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearWorkerPools() {
            if (this.workerPoolsBuilder_ == null) {
                this.workerPools_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.clear();
            }
            return this;
        }

        public Builder removeWorkerPools(int index) {
            if (this.workerPoolsBuilder_ == null) {
                this.ensureWorkerPoolsIsMutable();
                this.workerPools_.remove(index);
                this.onChanged();
            } else {
                this.workerPoolsBuilder_.remove(index);
            }
            return this;
        }

        public WorkerPool.Builder getWorkerPoolsBuilder(int index) {
            return (WorkerPool.Builder)this.getWorkerPoolsFieldBuilder().getBuilder(index);
        }

        @Override
        public WorkerPoolOrBuilder getWorkerPoolsOrBuilder(int index) {
            if (this.workerPoolsBuilder_ == null) {
                return this.workerPools_.get(index);
            }
            return (WorkerPoolOrBuilder)this.workerPoolsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends WorkerPoolOrBuilder> getWorkerPoolsOrBuilderList() {
            if (this.workerPoolsBuilder_ != null) {
                return this.workerPoolsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.workerPools_);
        }

        public WorkerPool.Builder addWorkerPoolsBuilder() {
            return (WorkerPool.Builder)this.getWorkerPoolsFieldBuilder().addBuilder((AbstractMessage)WorkerPool.getDefaultInstance());
        }

        public WorkerPool.Builder addWorkerPoolsBuilder(int index) {
            return (WorkerPool.Builder)this.getWorkerPoolsFieldBuilder().addBuilder(index, (AbstractMessage)WorkerPool.getDefaultInstance());
        }

        public List<WorkerPool.Builder> getWorkerPoolsBuilderList() {
            return this.getWorkerPoolsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<WorkerPool, WorkerPool.Builder, WorkerPoolOrBuilder> getWorkerPoolsFieldBuilder() {
            if (this.workerPoolsBuilder_ == null) {
                this.workerPoolsBuilder_ = new RepeatedFieldBuilderV3(this.workerPools_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.workerPools_ = null;
            }
            return this.workerPoolsBuilder_;
        }

        @Override
        public boolean hasUserAgent() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Struct getUserAgent() {
            if (this.userAgentBuilder_ == null) {
                return this.userAgent_ == null ? Struct.getDefaultInstance() : this.userAgent_;
            }
            return (Struct)this.userAgentBuilder_.getMessage();
        }

        public Builder setUserAgent(Struct value) {
            if (this.userAgentBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.userAgent_ = value;
            } else {
                this.userAgentBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setUserAgent(Struct.Builder builderForValue) {
            if (this.userAgentBuilder_ == null) {
                this.userAgent_ = builderForValue.build();
            } else {
                this.userAgentBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeUserAgent(Struct value) {
            if (this.userAgentBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.userAgent_ != null && this.userAgent_ != Struct.getDefaultInstance()) {
                    this.getUserAgentBuilder().mergeFrom(value);
                } else {
                    this.userAgent_ = value;
                }
            } else {
                this.userAgentBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.userAgent_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUserAgent() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.userAgent_ = null;
            if (this.userAgentBuilder_ != null) {
                this.userAgentBuilder_.dispose();
                this.userAgentBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Struct.Builder getUserAgentBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Struct.Builder)this.getUserAgentFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getUserAgentOrBuilder() {
            if (this.userAgentBuilder_ != null) {
                return (StructOrBuilder)this.userAgentBuilder_.getMessageOrBuilder();
            }
            return this.userAgent_ == null ? Struct.getDefaultInstance() : this.userAgent_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getUserAgentFieldBuilder() {
            if (this.userAgentBuilder_ == null) {
                this.userAgentBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUserAgent(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.userAgent_ = null;
            }
            return this.userAgentBuilder_;
        }

        @Override
        public boolean hasVersion() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Struct getVersion() {
            if (this.versionBuilder_ == null) {
                return this.version_ == null ? Struct.getDefaultInstance() : this.version_;
            }
            return (Struct)this.versionBuilder_.getMessage();
        }

        public Builder setVersion(Struct value) {
            if (this.versionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.version_ = value;
            } else {
                this.versionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setVersion(Struct.Builder builderForValue) {
            if (this.versionBuilder_ == null) {
                this.version_ = builderForValue.build();
            } else {
                this.versionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeVersion(Struct value) {
            if (this.versionBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.version_ != null && this.version_ != Struct.getDefaultInstance()) {
                    this.getVersionBuilder().mergeFrom(value);
                } else {
                    this.version_ = value;
                }
            } else {
                this.versionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.version_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearVersion() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.version_ = null;
            if (this.versionBuilder_ != null) {
                this.versionBuilder_.dispose();
                this.versionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Struct.Builder getVersionBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Struct.Builder)this.getVersionFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getVersionOrBuilder() {
            if (this.versionBuilder_ != null) {
                return (StructOrBuilder)this.versionBuilder_.getMessageOrBuilder();
            }
            return this.version_ == null ? Struct.getDefaultInstance() : this.version_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getVersionFieldBuilder() {
            if (this.versionBuilder_ == null) {
                this.versionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getVersion(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.version_ = null;
            }
            return this.versionBuilder_;
        }

        @Override
        public String getDataset() {
            Object ref = this.dataset_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dataset_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDatasetBytes() {
            Object ref = this.dataset_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dataset_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDataset(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dataset_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearDataset() {
            this.dataset_ = Environment.getDefaultInstance().getDataset();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setDatasetBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.dataset_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSdkPipelineOptions() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public Struct getSdkPipelineOptions() {
            if (this.sdkPipelineOptionsBuilder_ == null) {
                return this.sdkPipelineOptions_ == null ? Struct.getDefaultInstance() : this.sdkPipelineOptions_;
            }
            return (Struct)this.sdkPipelineOptionsBuilder_.getMessage();
        }

        public Builder setSdkPipelineOptions(Struct value) {
            if (this.sdkPipelineOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.sdkPipelineOptions_ = value;
            } else {
                this.sdkPipelineOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setSdkPipelineOptions(Struct.Builder builderForValue) {
            if (this.sdkPipelineOptionsBuilder_ == null) {
                this.sdkPipelineOptions_ = builderForValue.build();
            } else {
                this.sdkPipelineOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeSdkPipelineOptions(Struct value) {
            if (this.sdkPipelineOptionsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.sdkPipelineOptions_ != null && this.sdkPipelineOptions_ != Struct.getDefaultInstance()) {
                    this.getSdkPipelineOptionsBuilder().mergeFrom(value);
                } else {
                    this.sdkPipelineOptions_ = value;
                }
            } else {
                this.sdkPipelineOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.sdkPipelineOptions_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSdkPipelineOptions() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.sdkPipelineOptions_ = null;
            if (this.sdkPipelineOptionsBuilder_ != null) {
                this.sdkPipelineOptionsBuilder_.dispose();
                this.sdkPipelineOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Struct.Builder getSdkPipelineOptionsBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (Struct.Builder)this.getSdkPipelineOptionsFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getSdkPipelineOptionsOrBuilder() {
            if (this.sdkPipelineOptionsBuilder_ != null) {
                return (StructOrBuilder)this.sdkPipelineOptionsBuilder_.getMessageOrBuilder();
            }
            return this.sdkPipelineOptions_ == null ? Struct.getDefaultInstance() : this.sdkPipelineOptions_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getSdkPipelineOptionsFieldBuilder() {
            if (this.sdkPipelineOptionsBuilder_ == null) {
                this.sdkPipelineOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSdkPipelineOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.sdkPipelineOptions_ = null;
            }
            return this.sdkPipelineOptionsBuilder_;
        }

        @Override
        public boolean hasInternalExperiments() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public Any getInternalExperiments() {
            if (this.internalExperimentsBuilder_ == null) {
                return this.internalExperiments_ == null ? Any.getDefaultInstance() : this.internalExperiments_;
            }
            return (Any)this.internalExperimentsBuilder_.getMessage();
        }

        public Builder setInternalExperiments(Any value) {
            if (this.internalExperimentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.internalExperiments_ = value;
            } else {
                this.internalExperimentsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setInternalExperiments(Any.Builder builderForValue) {
            if (this.internalExperimentsBuilder_ == null) {
                this.internalExperiments_ = builderForValue.build();
            } else {
                this.internalExperimentsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeInternalExperiments(Any value) {
            if (this.internalExperimentsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.internalExperiments_ != null && this.internalExperiments_ != Any.getDefaultInstance()) {
                    this.getInternalExperimentsBuilder().mergeFrom(value);
                } else {
                    this.internalExperiments_ = value;
                }
            } else {
                this.internalExperimentsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.internalExperiments_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInternalExperiments() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.internalExperiments_ = null;
            if (this.internalExperimentsBuilder_ != null) {
                this.internalExperimentsBuilder_.dispose();
                this.internalExperimentsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Any.Builder getInternalExperimentsBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (Any.Builder)this.getInternalExperimentsFieldBuilder().getBuilder();
        }

        @Override
        public AnyOrBuilder getInternalExperimentsOrBuilder() {
            if (this.internalExperimentsBuilder_ != null) {
                return (AnyOrBuilder)this.internalExperimentsBuilder_.getMessageOrBuilder();
            }
            return this.internalExperiments_ == null ? Any.getDefaultInstance() : this.internalExperiments_;
        }

        private SingleFieldBuilderV3<Any, Any.Builder, AnyOrBuilder> getInternalExperimentsFieldBuilder() {
            if (this.internalExperimentsBuilder_ == null) {
                this.internalExperimentsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInternalExperiments(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.internalExperiments_ = null;
            }
            return this.internalExperimentsBuilder_;
        }

        @Override
        public String getServiceAccountEmail() {
            Object ref = this.serviceAccountEmail_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceAccountEmail_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceAccountEmailBytes() {
            Object ref = this.serviceAccountEmail_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAccountEmail_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceAccountEmail(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceAccountEmail_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearServiceAccountEmail() {
            this.serviceAccountEmail_ = Environment.getDefaultInstance().getServiceAccountEmail();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setServiceAccountEmailBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.serviceAccountEmail_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public int getFlexResourceSchedulingGoalValue() {
            return this.flexResourceSchedulingGoal_;
        }

        public Builder setFlexResourceSchedulingGoalValue(int value) {
            this.flexResourceSchedulingGoal_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public FlexResourceSchedulingGoal getFlexResourceSchedulingGoal() {
            FlexResourceSchedulingGoal result = FlexResourceSchedulingGoal.forNumber(this.flexResourceSchedulingGoal_);
            return result == null ? FlexResourceSchedulingGoal.UNRECOGNIZED : result;
        }

        public Builder setFlexResourceSchedulingGoal(FlexResourceSchedulingGoal value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x1000;
            this.flexResourceSchedulingGoal_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearFlexResourceSchedulingGoal() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.flexResourceSchedulingGoal_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getWorkerRegion() {
            Object ref = this.workerRegion_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.workerRegion_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getWorkerRegionBytes() {
            Object ref = this.workerRegion_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.workerRegion_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setWorkerRegion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.workerRegion_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearWorkerRegion() {
            this.workerRegion_ = Environment.getDefaultInstance().getWorkerRegion();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        public Builder setWorkerRegionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.workerRegion_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public String getWorkerZone() {
            Object ref = this.workerZone_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.workerZone_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getWorkerZoneBytes() {
            Object ref = this.workerZone_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.workerZone_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setWorkerZone(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.workerZone_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearWorkerZone() {
            this.workerZone_ = Environment.getDefaultInstance().getWorkerZone();
            this.bitField0_ &= 0xFFFFBFFF;
            this.onChanged();
            return this;
        }

        public Builder setWorkerZoneBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Environment.checkByteStringIsUtf8((ByteString)value);
            this.workerZone_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        @Override
        public int getShuffleModeValue() {
            return this.shuffleMode_;
        }

        public Builder setShuffleModeValue(int value) {
            this.shuffleMode_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public ShuffleMode getShuffleMode() {
            ShuffleMode result = ShuffleMode.forNumber(this.shuffleMode_);
            return result == null ? ShuffleMode.UNRECOGNIZED : result;
        }

        public Builder setShuffleMode(ShuffleMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x8000;
            this.shuffleMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearShuffleMode() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.shuffleMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDebugOptions() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public DebugOptions getDebugOptions() {
            if (this.debugOptionsBuilder_ == null) {
                return this.debugOptions_ == null ? DebugOptions.getDefaultInstance() : this.debugOptions_;
            }
            return (DebugOptions)this.debugOptionsBuilder_.getMessage();
        }

        public Builder setDebugOptions(DebugOptions value) {
            if (this.debugOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.debugOptions_ = value;
            } else {
                this.debugOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setDebugOptions(DebugOptions.Builder builderForValue) {
            if (this.debugOptionsBuilder_ == null) {
                this.debugOptions_ = builderForValue.build();
            } else {
                this.debugOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeDebugOptions(DebugOptions value) {
            if (this.debugOptionsBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.debugOptions_ != null && this.debugOptions_ != DebugOptions.getDefaultInstance()) {
                    this.getDebugOptionsBuilder().mergeFrom(value);
                } else {
                    this.debugOptions_ = value;
                }
            } else {
                this.debugOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.debugOptions_ != null) {
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDebugOptions() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.debugOptions_ = null;
            if (this.debugOptionsBuilder_ != null) {
                this.debugOptionsBuilder_.dispose();
                this.debugOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DebugOptions.Builder getDebugOptionsBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (DebugOptions.Builder)this.getDebugOptionsFieldBuilder().getBuilder();
        }

        @Override
        public DebugOptionsOrBuilder getDebugOptionsOrBuilder() {
            if (this.debugOptionsBuilder_ != null) {
                return (DebugOptionsOrBuilder)this.debugOptionsBuilder_.getMessageOrBuilder();
            }
            return this.debugOptions_ == null ? DebugOptions.getDefaultInstance() : this.debugOptions_;
        }

        private SingleFieldBuilderV3<DebugOptions, DebugOptions.Builder, DebugOptionsOrBuilder> getDebugOptionsFieldBuilder() {
            if (this.debugOptionsBuilder_ == null) {
                this.debugOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDebugOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.debugOptions_ = null;
            }
            return this.debugOptionsBuilder_;
        }

        @Override
        public boolean getUseStreamingEngineResourceBasedBilling() {
            return this.useStreamingEngineResourceBasedBilling_;
        }

        public Builder setUseStreamingEngineResourceBasedBilling(boolean value) {
            this.useStreamingEngineResourceBasedBilling_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearUseStreamingEngineResourceBasedBilling() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.useStreamingEngineResourceBasedBilling_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getStreamingModeValue() {
            return this.streamingMode_;
        }

        public Builder setStreamingModeValue(int value) {
            this.streamingMode_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        @Override
        public StreamingMode getStreamingMode() {
            StreamingMode result = StreamingMode.forNumber(this.streamingMode_);
            return result == null ? StreamingMode.UNRECOGNIZED : result;
        }

        public Builder setStreamingMode(StreamingMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40000;
            this.streamingMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStreamingMode() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.streamingMode_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

