/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentLinkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DOCUMENT_DOCUMENT_LINK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/documents/{document}/documentLinks/{document_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String document;
    private final String documentLink;

    @Deprecated
    protected DocumentLinkName() {
        this.project = null;
        this.location = null;
        this.document = null;
        this.documentLink = null;
    }

    private DocumentLinkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.documentLink = (String)Preconditions.checkNotNull((Object)builder.getDocumentLink());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDocument() {
        return this.document;
    }

    public String getDocumentLink() {
        return this.documentLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DocumentLinkName of(String project, String location, String document, String documentLink) {
        return DocumentLinkName.newBuilder().setProject(project).setLocation(location).setDocument(document).setDocumentLink(documentLink).build();
    }

    public static String format(String project, String location, String document, String documentLink) {
        return DocumentLinkName.newBuilder().setProject(project).setLocation(location).setDocument(document).setDocumentLink(documentLink).build().toString();
    }

    public static DocumentLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DOCUMENT_DOCUMENT_LINK.validatedMatch(formattedString, "DocumentLinkName.parse: formattedString not in valid format");
        return DocumentLinkName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("document"), (String)matchMap.get("document_link"));
    }

    public static List<DocumentLinkName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentLinkName> list = new ArrayList<DocumentLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DOCUMENT_DOCUMENT_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentLinkName documentLinkName = this;
            synchronized (documentLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.document != null) {
                        fieldMapBuilder.put((Object)"document", (Object)this.document);
                    }
                    if (this.documentLink != null) {
                        fieldMapBuilder.put((Object)"document_link", (Object)this.documentLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DOCUMENT_DOCUMENT_LINK.instantiate(new String[]{"project", this.project, "location", this.location, "document", this.document, "document_link", this.documentLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DocumentLinkName that = (DocumentLinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.document, that.document) && Objects.equals(this.documentLink, that.documentLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.document);
        h *= 1000003;
        return h ^= Objects.hashCode(this.documentLink);
    }

    public static class Builder {
        private String project;
        private String location;
        private String document;
        private String documentLink;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDocument() {
            return this.document;
        }

        public String getDocumentLink() {
            return this.documentLink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        public Builder setDocumentLink(String documentLink) {
            this.documentLink = documentLink;
            return this;
        }

        private Builder(DocumentLinkName documentLinkName) {
            this.project = documentLinkName.project;
            this.location = documentLinkName.location;
            this.document = documentLinkName.document;
            this.documentLink = documentLinkName.documentLink;
        }

        public DocumentLinkName build() {
            return new DocumentLinkName(this);
        }
    }
}

