/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentSchemaName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DOCUMENT_SCHEMA = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/documentSchemas/{document_schema}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String documentSchema;

    @Deprecated
    protected DocumentSchemaName() {
        this.project = null;
        this.location = null;
        this.documentSchema = null;
    }

    private DocumentSchemaName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.documentSchema = (String)Preconditions.checkNotNull((Object)builder.getDocumentSchema());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDocumentSchema() {
        return this.documentSchema;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DocumentSchemaName of(String project, String location, String documentSchema) {
        return DocumentSchemaName.newBuilder().setProject(project).setLocation(location).setDocumentSchema(documentSchema).build();
    }

    public static String format(String project, String location, String documentSchema) {
        return DocumentSchemaName.newBuilder().setProject(project).setLocation(location).setDocumentSchema(documentSchema).build().toString();
    }

    public static DocumentSchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DOCUMENT_SCHEMA.validatedMatch(formattedString, "DocumentSchemaName.parse: formattedString not in valid format");
        return DocumentSchemaName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("document_schema"));
    }

    public static List<DocumentSchemaName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentSchemaName> list = new ArrayList<DocumentSchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentSchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentSchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentSchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DOCUMENT_SCHEMA.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentSchemaName documentSchemaName = this;
            synchronized (documentSchemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.documentSchema != null) {
                        fieldMapBuilder.put((Object)"document_schema", (Object)this.documentSchema);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DOCUMENT_SCHEMA.instantiate(new String[]{"project", this.project, "location", this.location, "document_schema", this.documentSchema});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DocumentSchemaName that = (DocumentSchemaName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.documentSchema, that.documentSchema);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.documentSchema);
    }

    public static class Builder {
        private String project;
        private String location;
        private String documentSchema;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDocumentSchema() {
            return this.documentSchema;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDocumentSchema(String documentSchema) {
            this.documentSchema = documentSchema;
            return this;
        }

        private Builder(DocumentSchemaName documentSchemaName) {
            this.project = documentSchemaName.project;
            this.location = documentSchemaName.location;
            this.documentSchema = documentSchemaName.documentSchema;
        }

        public DocumentSchemaName build() {
            return new DocumentSchemaName(this);
        }
    }
}

