/*
 * Decompiled with CFR 0.152.
 */
package com.google.container.v1;

import com.google.container.v1.AcceleratorConfig;
import com.google.container.v1.AcceleratorConfigOrBuilder;
import com.google.container.v1.ClusterServiceProto;
import com.google.container.v1.NodeConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NodeConfig
extends GeneratedMessageV3
implements NodeConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int MACHINE_TYPE_FIELD_NUMBER = 1;
    private volatile Object machineType_;
    public static final int DISK_SIZE_GB_FIELD_NUMBER = 2;
    private int diskSizeGb_;
    public static final int OAUTH_SCOPES_FIELD_NUMBER = 3;
    private LazyStringList oauthScopes_;
    public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 9;
    private volatile Object serviceAccount_;
    public static final int METADATA_FIELD_NUMBER = 4;
    private MapField<String, String> metadata_;
    public static final int IMAGE_TYPE_FIELD_NUMBER = 5;
    private volatile Object imageType_;
    public static final int LABELS_FIELD_NUMBER = 6;
    private MapField<String, String> labels_;
    public static final int LOCAL_SSD_COUNT_FIELD_NUMBER = 7;
    private int localSsdCount_;
    public static final int TAGS_FIELD_NUMBER = 8;
    private LazyStringList tags_;
    public static final int PREEMPTIBLE_FIELD_NUMBER = 10;
    private boolean preemptible_;
    public static final int ACCELERATORS_FIELD_NUMBER = 11;
    private List<AcceleratorConfig> accelerators_;
    public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 13;
    private volatile Object minCpuPlatform_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final NodeConfig DEFAULT_INSTANCE = new NodeConfig();
    private static final Parser<NodeConfig> PARSER = new AbstractParser<NodeConfig>(){

        public NodeConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new NodeConfig(input, extensionRegistry);
        }
    };

    private NodeConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private NodeConfig() {
        this.machineType_ = "";
        this.diskSizeGb_ = 0;
        this.oauthScopes_ = LazyStringArrayList.EMPTY;
        this.serviceAccount_ = "";
        this.imageType_ = "";
        this.localSsdCount_ = 0;
        this.tags_ = LazyStringArrayList.EMPTY;
        this.preemptible_ = false;
        this.accelerators_ = Collections.emptyList();
        this.minCpuPlatform_ = "";
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private NodeConfig(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block21: while (!done) {
                String s;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block21;
                    }
                    default: {
                        if (this.parseUnknownFieldProto3(input, unknownFields, extensionRegistry, tag)) continue block21;
                        done = true;
                        continue block21;
                    }
                    case 10: {
                        s = input.readStringRequireUtf8();
                        this.machineType_ = s;
                        continue block21;
                    }
                    case 16: {
                        this.diskSizeGb_ = input.readInt32();
                        continue block21;
                    }
                    case 26: {
                        s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 4) != 4) {
                            this.oauthScopes_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 4;
                        }
                        this.oauthScopes_.add((Object)s);
                        continue block21;
                    }
                    case 34: {
                        if ((mutable_bitField0_ & 0x10) != 16) {
                            this.metadata_ = MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 0x10;
                        }
                        MapEntry metadata__ = (MapEntry)input.readMessage(MetadataDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.metadata_.getMutableMap().put(metadata__.getKey(), metadata__.getValue());
                        continue block21;
                    }
                    case 42: {
                        s = input.readStringRequireUtf8();
                        this.imageType_ = s;
                        continue block21;
                    }
                    case 50: {
                        if ((mutable_bitField0_ & 0x40) != 64) {
                            this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 0x40;
                        }
                        MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
                        continue block21;
                    }
                    case 56: {
                        this.localSsdCount_ = input.readInt32();
                        continue block21;
                    }
                    case 66: {
                        s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 0x100) != 256) {
                            this.tags_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 0x100;
                        }
                        this.tags_.add((Object)s);
                        continue block21;
                    }
                    case 74: {
                        s = input.readStringRequireUtf8();
                        this.serviceAccount_ = s;
                        continue block21;
                    }
                    case 80: {
                        this.preemptible_ = input.readBool();
                        continue block21;
                    }
                    case 90: {
                        if ((mutable_bitField0_ & 0x400) != 1024) {
                            this.accelerators_ = new ArrayList<AcceleratorConfig>();
                            mutable_bitField0_ |= 0x400;
                        }
                        this.accelerators_.add((AcceleratorConfig)input.readMessage(AcceleratorConfig.parser(), extensionRegistry));
                        continue block21;
                    }
                    case 106: 
                }
                s = input.readStringRequireUtf8();
                this.minCpuPlatform_ = s;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if ((mutable_bitField0_ & 4) == 4) {
                this.oauthScopes_ = this.oauthScopes_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 0x100) == 256) {
                this.tags_ = this.tags_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 0x400) == 1024) {
                this.accelerators_ = Collections.unmodifiableList(this.accelerators_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ClusterServiceProto.internal_static_google_container_v1_NodeConfig_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 4: {
                return this.internalGetMetadata();
            }
            case 6: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ClusterServiceProto.internal_static_google_container_v1_NodeConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeConfig.class, Builder.class);
    }

    @Override
    public String getMachineType() {
        Object ref = this.machineType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.machineType_ = s;
        return s;
    }

    @Override
    public ByteString getMachineTypeBytes() {
        Object ref = this.machineType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.machineType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getDiskSizeGb() {
        return this.diskSizeGb_;
    }

    public ProtocolStringList getOauthScopesList() {
        return this.oauthScopes_;
    }

    @Override
    public int getOauthScopesCount() {
        return this.oauthScopes_.size();
    }

    @Override
    public String getOauthScopes(int index) {
        return (String)this.oauthScopes_.get(index);
    }

    @Override
    public ByteString getOauthScopesBytes(int index) {
        return this.oauthScopes_.getByteString(index);
    }

    @Override
    public String getServiceAccount() {
        Object ref = this.serviceAccount_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceAccount_ = s;
        return s;
    }

    @Override
    public ByteString getServiceAccountBytes() {
        Object ref = this.serviceAccount_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceAccount_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetMetadata() {
        if (this.metadata_ == null) {
            return MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
        }
        return this.metadata_;
    }

    @Override
    public int getMetadataCount() {
        return this.internalGetMetadata().getMap().size();
    }

    @Override
    public boolean containsMetadata(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetMetadata().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getMetadata() {
        return this.getMetadataMap();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        return this.internalGetMetadata().getMap();
    }

    @Override
    public String getMetadataOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetMetadata().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getMetadataOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetMetadata().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getImageType() {
        Object ref = this.imageType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.imageType_ = s;
        return s;
    }

    @Override
    public ByteString getImageTypeBytes() {
        Object ref = this.imageType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.imageType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public int getLocalSsdCount() {
        return this.localSsdCount_;
    }

    public ProtocolStringList getTagsList() {
        return this.tags_;
    }

    @Override
    public int getTagsCount() {
        return this.tags_.size();
    }

    @Override
    public String getTags(int index) {
        return (String)this.tags_.get(index);
    }

    @Override
    public ByteString getTagsBytes(int index) {
        return this.tags_.getByteString(index);
    }

    @Override
    public boolean getPreemptible() {
        return this.preemptible_;
    }

    @Override
    public List<AcceleratorConfig> getAcceleratorsList() {
        return this.accelerators_;
    }

    @Override
    public List<? extends AcceleratorConfigOrBuilder> getAcceleratorsOrBuilderList() {
        return this.accelerators_;
    }

    @Override
    public int getAcceleratorsCount() {
        return this.accelerators_.size();
    }

    @Override
    public AcceleratorConfig getAccelerators(int index) {
        return this.accelerators_.get(index);
    }

    @Override
    public AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
        return this.accelerators_.get(index);
    }

    @Override
    public String getMinCpuPlatform() {
        Object ref = this.minCpuPlatform_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.minCpuPlatform_ = s;
        return s;
    }

    @Override
    public ByteString getMinCpuPlatformBytes() {
        Object ref = this.minCpuPlatform_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.minCpuPlatform_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!this.getMachineTypeBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.machineType_);
        }
        if (this.diskSizeGb_ != 0) {
            output.writeInt32(2, this.diskSizeGb_);
        }
        for (i = 0; i < this.oauthScopes_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.oauthScopes_.getRaw(i));
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, (int)4);
        if (!this.getImageTypeBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.imageType_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)6);
        if (this.localSsdCount_ != 0) {
            output.writeInt32(7, this.localSsdCount_);
        }
        for (i = 0; i < this.tags_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.tags_.getRaw(i));
        }
        if (!this.getServiceAccountBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.serviceAccount_);
        }
        if (this.preemptible_) {
            output.writeBool(10, this.preemptible_);
        }
        for (i = 0; i < this.accelerators_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.accelerators_.get(i));
        }
        if (!this.getMinCpuPlatformBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.minCpuPlatform_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getMachineTypeBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.machineType_);
        }
        if (this.diskSizeGb_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.diskSizeGb_);
        }
        int dataSize = 0;
        for (i = 0; i < this.oauthScopes_.size(); ++i) {
            dataSize += NodeConfig.computeStringSizeNoTag((Object)this.oauthScopes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getOauthScopesList().size();
        for (Map.Entry entry : this.internalGetMetadata().getMap().entrySet()) {
            MapEntry metadata__ = MetadataDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)metadata__);
        }
        if (!this.getImageTypeBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.imageType_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)labels__);
        }
        if (this.localSsdCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)7, (int)this.localSsdCount_);
        }
        dataSize = 0;
        for (i = 0; i < this.tags_.size(); ++i) {
            dataSize += NodeConfig.computeStringSizeNoTag((Object)this.tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getTagsList().size();
        if (!this.getServiceAccountBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.serviceAccount_);
        }
        if (this.preemptible_) {
            size += CodedOutputStream.computeBoolSize((int)10, (boolean)this.preemptible_);
        }
        for (int i2 = 0; i2 < this.accelerators_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.accelerators_.get(i2)));
        }
        if (!this.getMinCpuPlatformBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.minCpuPlatform_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeConfig)) {
            return super.equals(obj);
        }
        NodeConfig other = (NodeConfig)obj;
        boolean result = true;
        result = result && this.getMachineType().equals(other.getMachineType());
        result = result && this.getDiskSizeGb() == other.getDiskSizeGb();
        result = result && this.getOauthScopesList().equals(other.getOauthScopesList());
        result = result && this.getServiceAccount().equals(other.getServiceAccount());
        result = result && this.internalGetMetadata().equals(other.internalGetMetadata());
        result = result && this.getImageType().equals(other.getImageType());
        result = result && this.internalGetLabels().equals(other.internalGetLabels());
        result = result && this.getLocalSsdCount() == other.getLocalSsdCount();
        result = result && this.getTagsList().equals(other.getTagsList());
        result = result && this.getPreemptible() == other.getPreemptible();
        result = result && this.getAcceleratorsList().equals(other.getAcceleratorsList());
        result = result && this.getMinCpuPlatform().equals(other.getMinCpuPlatform());
        result = result && this.unknownFields.equals((Object)other.unknownFields);
        return result;
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + NodeConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getMachineType().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDiskSizeGb();
        if (this.getOauthScopesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getOauthScopesList().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getServiceAccount().hashCode();
        if (!this.internalGetMetadata().getMap().isEmpty()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.internalGetMetadata().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getImageType().hashCode();
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getLocalSsdCount();
        if (this.getTagsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getTagsList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPreemptible());
        if (this.getAcceleratorsCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getAcceleratorsList().hashCode();
        }
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getMinCpuPlatform().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static NodeConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NodeConfig)PARSER.parseFrom(data);
    }

    public static NodeConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NodeConfig)PARSER.parseFrom(data);
    }

    public static NodeConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NodeConfig)PARSER.parseFrom(data);
    }

    public static NodeConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeConfig parseFrom(InputStream input) throws IOException {
        return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static NodeConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (NodeConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static NodeConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeConfig parseFrom(CodedInputStream input) throws IOException {
        return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static NodeConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return NodeConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static NodeConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NodeConfig> parser() {
        return PARSER;
    }

    public Parser<NodeConfig> getParserForType() {
        return PARSER;
    }

    public NodeConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements NodeConfigOrBuilder {
        private int bitField0_;
        private Object machineType_ = "";
        private int diskSizeGb_;
        private LazyStringList oauthScopes_ = LazyStringArrayList.EMPTY;
        private Object serviceAccount_ = "";
        private MapField<String, String> metadata_;
        private Object imageType_ = "";
        private MapField<String, String> labels_;
        private int localSsdCount_;
        private LazyStringList tags_ = LazyStringArrayList.EMPTY;
        private boolean preemptible_;
        private List<AcceleratorConfig> accelerators_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AcceleratorConfig, AcceleratorConfig.Builder, AcceleratorConfigOrBuilder> acceleratorsBuilder_;
        private Object minCpuPlatform_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return ClusterServiceProto.internal_static_google_container_v1_NodeConfig_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMetadata();
                }
                case 6: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMutableMetadata();
                }
                case 6: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClusterServiceProto.internal_static_google_container_v1_NodeConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeConfig.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAcceleratorsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.machineType_ = "";
            this.diskSizeGb_ = 0;
            this.oauthScopes_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFB;
            this.serviceAccount_ = "";
            this.internalGetMutableMetadata().clear();
            this.imageType_ = "";
            this.internalGetMutableLabels().clear();
            this.localSsdCount_ = 0;
            this.tags_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFEFF;
            this.preemptible_ = false;
            if (this.acceleratorsBuilder_ == null) {
                this.accelerators_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
            } else {
                this.acceleratorsBuilder_.clear();
            }
            this.minCpuPlatform_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ClusterServiceProto.internal_static_google_container_v1_NodeConfig_descriptor;
        }

        public NodeConfig getDefaultInstanceForType() {
            return NodeConfig.getDefaultInstance();
        }

        public NodeConfig build() {
            NodeConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public NodeConfig buildPartial() {
            NodeConfig result = new NodeConfig(this);
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            result.machineType_ = this.machineType_;
            result.diskSizeGb_ = this.diskSizeGb_;
            if ((this.bitField0_ & 4) == 4) {
                this.oauthScopes_ = this.oauthScopes_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.oauthScopes_ = this.oauthScopes_;
            result.serviceAccount_ = this.serviceAccount_;
            result.metadata_ = this.internalGetMetadata();
            result.metadata_.makeImmutable();
            result.imageType_ = this.imageType_;
            result.labels_ = this.internalGetLabels();
            result.labels_.makeImmutable();
            result.localSsdCount_ = this.localSsdCount_;
            if ((this.bitField0_ & 0x100) == 256) {
                this.tags_ = this.tags_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.tags_ = this.tags_;
            result.preemptible_ = this.preemptible_;
            if (this.acceleratorsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) == 1024) {
                    this.accelerators_ = Collections.unmodifiableList(this.accelerators_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.accelerators_ = this.accelerators_;
            } else {
                result.accelerators_ = this.acceleratorsBuilder_.build();
            }
            result.minCpuPlatform_ = this.minCpuPlatform_;
            result.bitField0_ = to_bitField0_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof NodeConfig) {
                return this.mergeFrom((NodeConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(NodeConfig other) {
            if (other == NodeConfig.getDefaultInstance()) {
                return this;
            }
            if (!other.getMachineType().isEmpty()) {
                this.machineType_ = other.machineType_;
                this.onChanged();
            }
            if (other.getDiskSizeGb() != 0) {
                this.setDiskSizeGb(other.getDiskSizeGb());
            }
            if (!other.oauthScopes_.isEmpty()) {
                if (this.oauthScopes_.isEmpty()) {
                    this.oauthScopes_ = other.oauthScopes_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureOauthScopesIsMutable();
                    this.oauthScopes_.addAll((Collection)other.oauthScopes_);
                }
                this.onChanged();
            }
            if (!other.getServiceAccount().isEmpty()) {
                this.serviceAccount_ = other.serviceAccount_;
                this.onChanged();
            }
            this.internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
            if (!other.getImageType().isEmpty()) {
                this.imageType_ = other.imageType_;
                this.onChanged();
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            if (other.getLocalSsdCount() != 0) {
                this.setLocalSsdCount(other.getLocalSsdCount());
            }
            if (!other.tags_.isEmpty()) {
                if (this.tags_.isEmpty()) {
                    this.tags_ = other.tags_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensureTagsIsMutable();
                    this.tags_.addAll((Collection)other.tags_);
                }
                this.onChanged();
            }
            if (other.getPreemptible()) {
                this.setPreemptible(other.getPreemptible());
            }
            if (this.acceleratorsBuilder_ == null) {
                if (!other.accelerators_.isEmpty()) {
                    if (this.accelerators_.isEmpty()) {
                        this.accelerators_ = other.accelerators_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureAcceleratorsIsMutable();
                        this.accelerators_.addAll(other.accelerators_);
                    }
                    this.onChanged();
                }
            } else if (!other.accelerators_.isEmpty()) {
                if (this.acceleratorsBuilder_.isEmpty()) {
                    this.acceleratorsBuilder_.dispose();
                    this.acceleratorsBuilder_ = null;
                    this.accelerators_ = other.accelerators_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.acceleratorsBuilder_ = alwaysUseFieldBuilders ? this.getAcceleratorsFieldBuilder() : null;
                } else {
                    this.acceleratorsBuilder_.addAllMessages((Iterable)other.accelerators_);
                }
            }
            if (!other.getMinCpuPlatform().isEmpty()) {
                this.minCpuPlatform_ = other.minCpuPlatform_;
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            NodeConfig parsedMessage = null;
            try {
                parsedMessage = (NodeConfig)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (NodeConfig)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getMachineType() {
            Object ref = this.machineType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.machineType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMachineTypeBytes() {
            Object ref = this.machineType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.machineType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMachineType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.machineType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMachineType() {
            this.machineType_ = NodeConfig.getDefaultInstance().getMachineType();
            this.onChanged();
            return this;
        }

        public Builder setMachineTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeConfig.checkByteStringIsUtf8((ByteString)value);
            this.machineType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getDiskSizeGb() {
            return this.diskSizeGb_;
        }

        public Builder setDiskSizeGb(int value) {
            this.diskSizeGb_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDiskSizeGb() {
            this.diskSizeGb_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureOauthScopesIsMutable() {
            if ((this.bitField0_ & 4) != 4) {
                this.oauthScopes_ = new LazyStringArrayList(this.oauthScopes_);
                this.bitField0_ |= 4;
            }
        }

        public ProtocolStringList getOauthScopesList() {
            return this.oauthScopes_.getUnmodifiableView();
        }

        @Override
        public int getOauthScopesCount() {
            return this.oauthScopes_.size();
        }

        @Override
        public String getOauthScopes(int index) {
            return (String)this.oauthScopes_.get(index);
        }

        @Override
        public ByteString getOauthScopesBytes(int index) {
            return this.oauthScopes_.getByteString(index);
        }

        public Builder setOauthScopes(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureOauthScopesIsMutable();
            this.oauthScopes_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addOauthScopes(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureOauthScopesIsMutable();
            this.oauthScopes_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllOauthScopes(Iterable<String> values) {
            this.ensureOauthScopesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.oauthScopes_);
            this.onChanged();
            return this;
        }

        public Builder clearOauthScopes() {
            this.oauthScopes_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addOauthScopesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeConfig.checkByteStringIsUtf8((ByteString)value);
            this.ensureOauthScopesIsMutable();
            this.oauthScopes_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceAccount() {
            Object ref = this.serviceAccount_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceAccount_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceAccountBytes() {
            Object ref = this.serviceAccount_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAccount_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceAccount(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceAccount_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearServiceAccount() {
            this.serviceAccount_ = NodeConfig.getDefaultInstance().getServiceAccount();
            this.onChanged();
            return this;
        }

        public Builder setServiceAccountBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeConfig.checkByteStringIsUtf8((ByteString)value);
            this.serviceAccount_ = value;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetMetadata() {
            if (this.metadata_ == null) {
                return MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
            }
            return this.metadata_;
        }

        private MapField<String, String> internalGetMutableMetadata() {
            this.onChanged();
            if (this.metadata_ == null) {
                this.metadata_ = MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
            }
            if (!this.metadata_.isMutable()) {
                this.metadata_ = this.metadata_.copy();
            }
            return this.metadata_;
        }

        @Override
        public int getMetadataCount() {
            return this.internalGetMetadata().getMap().size();
        }

        @Override
        public boolean containsMetadata(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetMetadata().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getMetadata() {
            return this.getMetadataMap();
        }

        @Override
        public Map<String, String> getMetadataMap() {
            return this.internalGetMetadata().getMap();
        }

        @Override
        public String getMetadataOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetMetadata().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getMetadataOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetMetadata().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearMetadata() {
            this.internalGetMutableMetadata().getMutableMap().clear();
            return this;
        }

        public Builder removeMetadata(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableMetadata().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableMetadata() {
            return this.internalGetMutableMetadata().getMutableMap();
        }

        public Builder putMetadata(String key, String value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableMetadata().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> values) {
            this.internalGetMutableMetadata().getMutableMap().putAll(values);
            return this;
        }

        @Override
        public String getImageType() {
            Object ref = this.imageType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.imageType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getImageTypeBytes() {
            Object ref = this.imageType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.imageType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setImageType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.imageType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearImageType() {
            this.imageType_ = NodeConfig.getDefaultInstance().getImageType();
            this.onChanged();
            return this;
        }

        public Builder setImageTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeConfig.checkByteStringIsUtf8((ByteString)value);
            this.imageType_ = value;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            this.onChanged();
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            return this;
        }

        @Override
        public int getLocalSsdCount() {
            return this.localSsdCount_;
        }

        public Builder setLocalSsdCount(int value) {
            this.localSsdCount_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearLocalSsdCount() {
            this.localSsdCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTagsIsMutable() {
            if ((this.bitField0_ & 0x100) != 256) {
                this.tags_ = new LazyStringArrayList(this.tags_);
                this.bitField0_ |= 0x100;
            }
        }

        public ProtocolStringList getTagsList() {
            return this.tags_.getUnmodifiableView();
        }

        @Override
        public int getTagsCount() {
            return this.tags_.size();
        }

        @Override
        public String getTags(int index) {
            return (String)this.tags_.get(index);
        }

        @Override
        public ByteString getTagsBytes(int index) {
            return this.tags_.getByteString(index);
        }

        public Builder setTags(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTagsIsMutable();
            this.tags_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addTags(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTagsIsMutable();
            this.tags_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllTags(Iterable<String> values) {
            this.ensureTagsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.tags_);
            this.onChanged();
            return this;
        }

        public Builder clearTags() {
            this.tags_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addTagsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeConfig.checkByteStringIsUtf8((ByteString)value);
            this.ensureTagsIsMutable();
            this.tags_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public boolean getPreemptible() {
            return this.preemptible_;
        }

        public Builder setPreemptible(boolean value) {
            this.preemptible_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPreemptible() {
            this.preemptible_ = false;
            this.onChanged();
            return this;
        }

        private void ensureAcceleratorsIsMutable() {
            if ((this.bitField0_ & 0x400) != 1024) {
                this.accelerators_ = new ArrayList<AcceleratorConfig>(this.accelerators_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<AcceleratorConfig> getAcceleratorsList() {
            if (this.acceleratorsBuilder_ == null) {
                return Collections.unmodifiableList(this.accelerators_);
            }
            return this.acceleratorsBuilder_.getMessageList();
        }

        @Override
        public int getAcceleratorsCount() {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.size();
            }
            return this.acceleratorsBuilder_.getCount();
        }

        @Override
        public AcceleratorConfig getAccelerators(int index) {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.get(index);
            }
            return (AcceleratorConfig)this.acceleratorsBuilder_.getMessage(index);
        }

        public Builder setAccelerators(int index, AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.set(index, value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAccelerators(int index, AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccelerators(AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccelerators(int index, AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(index, value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccelerators(AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccelerators(int index, AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAccelerators(Iterable<? extends AcceleratorConfig> values) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.accelerators_);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAccelerators() {
            if (this.acceleratorsBuilder_ == null) {
                this.accelerators_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAccelerators(int index) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.remove(index);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.remove(index);
            }
            return this;
        }

        public AcceleratorConfig.Builder getAcceleratorsBuilder(int index) {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().getBuilder(index);
        }

        @Override
        public AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.get(index);
            }
            return (AcceleratorConfigOrBuilder)this.acceleratorsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AcceleratorConfigOrBuilder> getAcceleratorsOrBuilderList() {
            if (this.acceleratorsBuilder_ != null) {
                return this.acceleratorsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.accelerators_);
        }

        public AcceleratorConfig.Builder addAcceleratorsBuilder() {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().addBuilder((AbstractMessage)AcceleratorConfig.getDefaultInstance());
        }

        public AcceleratorConfig.Builder addAcceleratorsBuilder(int index) {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().addBuilder(index, (AbstractMessage)AcceleratorConfig.getDefaultInstance());
        }

        public List<AcceleratorConfig.Builder> getAcceleratorsBuilderList() {
            return this.getAcceleratorsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AcceleratorConfig, AcceleratorConfig.Builder, AcceleratorConfigOrBuilder> getAcceleratorsFieldBuilder() {
            if (this.acceleratorsBuilder_ == null) {
                this.acceleratorsBuilder_ = new RepeatedFieldBuilderV3(this.accelerators_, (this.bitField0_ & 0x400) == 1024, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.accelerators_ = null;
            }
            return this.acceleratorsBuilder_;
        }

        @Override
        public String getMinCpuPlatform() {
            Object ref = this.minCpuPlatform_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.minCpuPlatform_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMinCpuPlatformBytes() {
            Object ref = this.minCpuPlatform_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.minCpuPlatform_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMinCpuPlatform(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.minCpuPlatform_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMinCpuPlatform() {
            this.minCpuPlatform_ = NodeConfig.getDefaultInstance().getMinCpuPlatform();
            this.onChanged();
            return this;
        }

        public Builder setMinCpuPlatformBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeConfig.checkByteStringIsUtf8((ByteString)value);
            this.minCpuPlatform_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ClusterServiceProto.internal_static_google_container_v1_NodeConfig_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    private static final class MetadataDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ClusterServiceProto.internal_static_google_container_v1_NodeConfig_MetadataEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private MetadataDefaultEntryHolder() {
        }
    }
}

