/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The current IP utilization of all subnetwork ranges. Contains the total number of allocated and free IPs in each range.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SubnetworkUtilizationDetails}
 */
public final class SubnetworkUtilizationDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SubnetworkUtilizationDetails)
    SubnetworkUtilizationDetailsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SubnetworkUtilizationDetails.newBuilder() to construct.
  private SubnetworkUtilizationDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SubnetworkUtilizationDetails() {
    ipv4Utilizations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SubnetworkUtilizationDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SubnetworkUtilizationDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SubnetworkUtilizationDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SubnetworkUtilizationDetails.class,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetails.Builder.class);
  }

  private int bitField0_;
  public static final int EXTERNAL_IPV6_INSTANCE_UTILIZATION_FIELD_NUMBER = 419750236;
  private com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
      externalIpv6InstanceUtilization_;

  /**
   *
   *
   * <pre>
   * Utilizations of external IPV6 IP range.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
   * </code>
   *
   * @return Whether the externalIpv6InstanceUtilization field is set.
   */
  @java.lang.Override
  public boolean hasExternalIpv6InstanceUtilization() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Utilizations of external IPV6 IP range.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
   * </code>
   *
   * @return The externalIpv6InstanceUtilization.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
      getExternalIpv6InstanceUtilization() {
    return externalIpv6InstanceUtilization_ == null
        ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
            .getDefaultInstance()
        : externalIpv6InstanceUtilization_;
  }

  /**
   *
   *
   * <pre>
   * Utilizations of external IPV6 IP range.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder
      getExternalIpv6InstanceUtilizationOrBuilder() {
    return externalIpv6InstanceUtilization_ == null
        ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
            .getDefaultInstance()
        : externalIpv6InstanceUtilization_;
  }

  public static final int EXTERNAL_IPV6_LB_UTILIZATION_FIELD_NUMBER = 136563645;
  private com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
      externalIpv6LbUtilization_;

  /**
   *
   *
   * <pre>
   * Utilizations of external IPV6 IP range for NetLB.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
   * </code>
   *
   * @return Whether the externalIpv6LbUtilization field is set.
   */
  @java.lang.Override
  public boolean hasExternalIpv6LbUtilization() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Utilizations of external IPV6 IP range for NetLB.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
   * </code>
   *
   * @return The externalIpv6LbUtilization.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
      getExternalIpv6LbUtilization() {
    return externalIpv6LbUtilization_ == null
        ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
            .getDefaultInstance()
        : externalIpv6LbUtilization_;
  }

  /**
   *
   *
   * <pre>
   * Utilizations of external IPV6 IP range for NetLB.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder
      getExternalIpv6LbUtilizationOrBuilder() {
    return externalIpv6LbUtilization_ == null
        ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
            .getDefaultInstance()
        : externalIpv6LbUtilization_;
  }

  public static final int INTERNAL_IPV6_UTILIZATION_FIELD_NUMBER = 69707020;
  private com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
      internalIpv6Utilization_;

  /**
   *
   *
   * <pre>
   * Utilizations of internal IPV6 IP range.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
   * </code>
   *
   * @return Whether the internalIpv6Utilization field is set.
   */
  @java.lang.Override
  public boolean hasInternalIpv6Utilization() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Utilizations of internal IPV6 IP range.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
   * </code>
   *
   * @return The internalIpv6Utilization.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
      getInternalIpv6Utilization() {
    return internalIpv6Utilization_ == null
        ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
            .getDefaultInstance()
        : internalIpv6Utilization_;
  }

  /**
   *
   *
   * <pre>
   * Utilizations of internal IPV6 IP range.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder
      getInternalIpv6UtilizationOrBuilder() {
    return internalIpv6Utilization_ == null
        ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
            .getDefaultInstance()
        : internalIpv6Utilization_;
  }

  public static final int IPV4_UTILIZATIONS_FIELD_NUMBER = 206180011;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization>
      ipv4Utilizations_;

  /**
   *
   *
   * <pre>
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization>
      getIpv4UtilizationsList() {
    return ipv4Utilizations_;
  }

  /**
   *
   *
   * <pre>
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder>
      getIpv4UtilizationsOrBuilderList() {
    return ipv4Utilizations_;
  }

  /**
   *
   *
   * <pre>
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
   * </code>
   */
  @java.lang.Override
  public int getIpv4UtilizationsCount() {
    return ipv4Utilizations_.size();
  }

  /**
   *
   *
   * <pre>
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization
      getIpv4Utilizations(int index) {
    return ipv4Utilizations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder
      getIpv4UtilizationsOrBuilder(int index) {
    return ipv4Utilizations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(69707020, getInternalIpv6Utilization());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(136563645, getExternalIpv6LbUtilization());
    }
    for (int i = 0; i < ipv4Utilizations_.size(); i++) {
      output.writeMessage(206180011, ipv4Utilizations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(419750236, getExternalIpv6InstanceUtilization());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              69707020, getInternalIpv6Utilization());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              136563645, getExternalIpv6LbUtilization());
    }
    for (int i = 0; i < ipv4Utilizations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              206180011, ipv4Utilizations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              419750236, getExternalIpv6InstanceUtilization());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SubnetworkUtilizationDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SubnetworkUtilizationDetails other =
        (com.google.cloud.compute.v1.SubnetworkUtilizationDetails) obj;

    if (hasExternalIpv6InstanceUtilization() != other.hasExternalIpv6InstanceUtilization())
      return false;
    if (hasExternalIpv6InstanceUtilization()) {
      if (!getExternalIpv6InstanceUtilization().equals(other.getExternalIpv6InstanceUtilization()))
        return false;
    }
    if (hasExternalIpv6LbUtilization() != other.hasExternalIpv6LbUtilization()) return false;
    if (hasExternalIpv6LbUtilization()) {
      if (!getExternalIpv6LbUtilization().equals(other.getExternalIpv6LbUtilization()))
        return false;
    }
    if (hasInternalIpv6Utilization() != other.hasInternalIpv6Utilization()) return false;
    if (hasInternalIpv6Utilization()) {
      if (!getInternalIpv6Utilization().equals(other.getInternalIpv6Utilization())) return false;
    }
    if (!getIpv4UtilizationsList().equals(other.getIpv4UtilizationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExternalIpv6InstanceUtilization()) {
      hash = (37 * hash) + EXTERNAL_IPV6_INSTANCE_UTILIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getExternalIpv6InstanceUtilization().hashCode();
    }
    if (hasExternalIpv6LbUtilization()) {
      hash = (37 * hash) + EXTERNAL_IPV6_LB_UTILIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getExternalIpv6LbUtilization().hashCode();
    }
    if (hasInternalIpv6Utilization()) {
      hash = (37 * hash) + INTERNAL_IPV6_UTILIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getInternalIpv6Utilization().hashCode();
    }
    if (getIpv4UtilizationsCount() > 0) {
      hash = (37 * hash) + IPV4_UTILIZATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getIpv4UtilizationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SubnetworkUtilizationDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The current IP utilization of all subnetwork ranges. Contains the total number of allocated and free IPs in each range.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SubnetworkUtilizationDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SubnetworkUtilizationDetails)
      com.google.cloud.compute.v1.SubnetworkUtilizationDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SubnetworkUtilizationDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SubnetworkUtilizationDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SubnetworkUtilizationDetails.class,
              com.google.cloud.compute.v1.SubnetworkUtilizationDetails.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SubnetworkUtilizationDetails.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExternalIpv6InstanceUtilizationFieldBuilder();
        getExternalIpv6LbUtilizationFieldBuilder();
        getInternalIpv6UtilizationFieldBuilder();
        getIpv4UtilizationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      externalIpv6InstanceUtilization_ = null;
      if (externalIpv6InstanceUtilizationBuilder_ != null) {
        externalIpv6InstanceUtilizationBuilder_.dispose();
        externalIpv6InstanceUtilizationBuilder_ = null;
      }
      externalIpv6LbUtilization_ = null;
      if (externalIpv6LbUtilizationBuilder_ != null) {
        externalIpv6LbUtilizationBuilder_.dispose();
        externalIpv6LbUtilizationBuilder_ = null;
      }
      internalIpv6Utilization_ = null;
      if (internalIpv6UtilizationBuilder_ != null) {
        internalIpv6UtilizationBuilder_.dispose();
        internalIpv6UtilizationBuilder_ = null;
      }
      if (ipv4UtilizationsBuilder_ == null) {
        ipv4Utilizations_ = java.util.Collections.emptyList();
      } else {
        ipv4Utilizations_ = null;
        ipv4UtilizationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SubnetworkUtilizationDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetails getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SubnetworkUtilizationDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetails build() {
      com.google.cloud.compute.v1.SubnetworkUtilizationDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetails buildPartial() {
      com.google.cloud.compute.v1.SubnetworkUtilizationDetails result =
          new com.google.cloud.compute.v1.SubnetworkUtilizationDetails(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetails result) {
      if (ipv4UtilizationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          ipv4Utilizations_ = java.util.Collections.unmodifiableList(ipv4Utilizations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.ipv4Utilizations_ = ipv4Utilizations_;
      } else {
        result.ipv4Utilizations_ = ipv4UtilizationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.SubnetworkUtilizationDetails result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.externalIpv6InstanceUtilization_ =
            externalIpv6InstanceUtilizationBuilder_ == null
                ? externalIpv6InstanceUtilization_
                : externalIpv6InstanceUtilizationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.externalIpv6LbUtilization_ =
            externalIpv6LbUtilizationBuilder_ == null
                ? externalIpv6LbUtilization_
                : externalIpv6LbUtilizationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.internalIpv6Utilization_ =
            internalIpv6UtilizationBuilder_ == null
                ? internalIpv6Utilization_
                : internalIpv6UtilizationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SubnetworkUtilizationDetails) {
        return mergeFrom((com.google.cloud.compute.v1.SubnetworkUtilizationDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SubnetworkUtilizationDetails other) {
      if (other == com.google.cloud.compute.v1.SubnetworkUtilizationDetails.getDefaultInstance())
        return this;
      if (other.hasExternalIpv6InstanceUtilization()) {
        mergeExternalIpv6InstanceUtilization(other.getExternalIpv6InstanceUtilization());
      }
      if (other.hasExternalIpv6LbUtilization()) {
        mergeExternalIpv6LbUtilization(other.getExternalIpv6LbUtilization());
      }
      if (other.hasInternalIpv6Utilization()) {
        mergeInternalIpv6Utilization(other.getInternalIpv6Utilization());
      }
      if (ipv4UtilizationsBuilder_ == null) {
        if (!other.ipv4Utilizations_.isEmpty()) {
          if (ipv4Utilizations_.isEmpty()) {
            ipv4Utilizations_ = other.ipv4Utilizations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureIpv4UtilizationsIsMutable();
            ipv4Utilizations_.addAll(other.ipv4Utilizations_);
          }
          onChanged();
        }
      } else {
        if (!other.ipv4Utilizations_.isEmpty()) {
          if (ipv4UtilizationsBuilder_.isEmpty()) {
            ipv4UtilizationsBuilder_.dispose();
            ipv4UtilizationsBuilder_ = null;
            ipv4Utilizations_ = other.ipv4Utilizations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            ipv4UtilizationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIpv4UtilizationsFieldBuilder()
                    : null;
          } else {
            ipv4UtilizationsBuilder_.addAllMessages(other.ipv4Utilizations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 557656162:
              {
                input.readMessage(
                    getInternalIpv6UtilizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 557656162
            case 1092509162:
              {
                input.readMessage(
                    getExternalIpv6LbUtilizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 1092509162
            case 1649440090:
              {
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization
                            .parser(),
                        extensionRegistry);
                if (ipv4UtilizationsBuilder_ == null) {
                  ensureIpv4UtilizationsIsMutable();
                  ipv4Utilizations_.add(m);
                } else {
                  ipv4UtilizationsBuilder_.addMessage(m);
                }
                break;
              } // case 1649440090
            case -936965406:
              {
                input.readMessage(
                    getExternalIpv6InstanceUtilizationFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -936965406
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
        externalIpv6InstanceUtilization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>
        externalIpv6InstanceUtilizationBuilder_;

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     *
     * @return Whether the externalIpv6InstanceUtilization field is set.
     */
    public boolean hasExternalIpv6InstanceUtilization() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     *
     * @return The externalIpv6InstanceUtilization.
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
        getExternalIpv6InstanceUtilization() {
      if (externalIpv6InstanceUtilizationBuilder_ == null) {
        return externalIpv6InstanceUtilization_ == null
            ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                .getDefaultInstance()
            : externalIpv6InstanceUtilization_;
      } else {
        return externalIpv6InstanceUtilizationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    public Builder setExternalIpv6InstanceUtilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization value) {
      if (externalIpv6InstanceUtilizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalIpv6InstanceUtilization_ = value;
      } else {
        externalIpv6InstanceUtilizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    public Builder setExternalIpv6InstanceUtilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder
            builderForValue) {
      if (externalIpv6InstanceUtilizationBuilder_ == null) {
        externalIpv6InstanceUtilization_ = builderForValue.build();
      } else {
        externalIpv6InstanceUtilizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    public Builder mergeExternalIpv6InstanceUtilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization value) {
      if (externalIpv6InstanceUtilizationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && externalIpv6InstanceUtilization_ != null
            && externalIpv6InstanceUtilization_
                != com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                    .getDefaultInstance()) {
          getExternalIpv6InstanceUtilizationBuilder().mergeFrom(value);
        } else {
          externalIpv6InstanceUtilization_ = value;
        }
      } else {
        externalIpv6InstanceUtilizationBuilder_.mergeFrom(value);
      }
      if (externalIpv6InstanceUtilization_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    public Builder clearExternalIpv6InstanceUtilization() {
      bitField0_ = (bitField0_ & ~0x00000001);
      externalIpv6InstanceUtilization_ = null;
      if (externalIpv6InstanceUtilizationBuilder_ != null) {
        externalIpv6InstanceUtilizationBuilder_.dispose();
        externalIpv6InstanceUtilizationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder
        getExternalIpv6InstanceUtilizationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getExternalIpv6InstanceUtilizationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder
        getExternalIpv6InstanceUtilizationOrBuilder() {
      if (externalIpv6InstanceUtilizationBuilder_ != null) {
        return externalIpv6InstanceUtilizationBuilder_.getMessageOrBuilder();
      } else {
        return externalIpv6InstanceUtilization_ == null
            ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                .getDefaultInstance()
            : externalIpv6InstanceUtilization_;
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_instance_utilization = 419750236;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>
        getExternalIpv6InstanceUtilizationFieldBuilder() {
      if (externalIpv6InstanceUtilizationBuilder_ == null) {
        externalIpv6InstanceUtilizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>(
                getExternalIpv6InstanceUtilization(), getParentForChildren(), isClean());
        externalIpv6InstanceUtilization_ = null;
      }
      return externalIpv6InstanceUtilizationBuilder_;
    }

    private com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
        externalIpv6LbUtilization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>
        externalIpv6LbUtilizationBuilder_;

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     *
     * @return Whether the externalIpv6LbUtilization field is set.
     */
    public boolean hasExternalIpv6LbUtilization() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     *
     * @return The externalIpv6LbUtilization.
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
        getExternalIpv6LbUtilization() {
      if (externalIpv6LbUtilizationBuilder_ == null) {
        return externalIpv6LbUtilization_ == null
            ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                .getDefaultInstance()
            : externalIpv6LbUtilization_;
      } else {
        return externalIpv6LbUtilizationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    public Builder setExternalIpv6LbUtilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization value) {
      if (externalIpv6LbUtilizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalIpv6LbUtilization_ = value;
      } else {
        externalIpv6LbUtilizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    public Builder setExternalIpv6LbUtilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder
            builderForValue) {
      if (externalIpv6LbUtilizationBuilder_ == null) {
        externalIpv6LbUtilization_ = builderForValue.build();
      } else {
        externalIpv6LbUtilizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    public Builder mergeExternalIpv6LbUtilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization value) {
      if (externalIpv6LbUtilizationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && externalIpv6LbUtilization_ != null
            && externalIpv6LbUtilization_
                != com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                    .getDefaultInstance()) {
          getExternalIpv6LbUtilizationBuilder().mergeFrom(value);
        } else {
          externalIpv6LbUtilization_ = value;
        }
      } else {
        externalIpv6LbUtilizationBuilder_.mergeFrom(value);
      }
      if (externalIpv6LbUtilization_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    public Builder clearExternalIpv6LbUtilization() {
      bitField0_ = (bitField0_ & ~0x00000002);
      externalIpv6LbUtilization_ = null;
      if (externalIpv6LbUtilizationBuilder_ != null) {
        externalIpv6LbUtilizationBuilder_.dispose();
        externalIpv6LbUtilizationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder
        getExternalIpv6LbUtilizationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getExternalIpv6LbUtilizationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder
        getExternalIpv6LbUtilizationOrBuilder() {
      if (externalIpv6LbUtilizationBuilder_ != null) {
        return externalIpv6LbUtilizationBuilder_.getMessageOrBuilder();
      } else {
        return externalIpv6LbUtilization_ == null
            ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                .getDefaultInstance()
            : externalIpv6LbUtilization_;
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of external IPV6 IP range for NetLB.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization external_ipv6_lb_utilization = 136563645;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>
        getExternalIpv6LbUtilizationFieldBuilder() {
      if (externalIpv6LbUtilizationBuilder_ == null) {
        externalIpv6LbUtilizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>(
                getExternalIpv6LbUtilization(), getParentForChildren(), isClean());
        externalIpv6LbUtilization_ = null;
      }
      return externalIpv6LbUtilizationBuilder_;
    }

    private com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
        internalIpv6Utilization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>
        internalIpv6UtilizationBuilder_;

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     *
     * @return Whether the internalIpv6Utilization field is set.
     */
    public boolean hasInternalIpv6Utilization() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     *
     * @return The internalIpv6Utilization.
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
        getInternalIpv6Utilization() {
      if (internalIpv6UtilizationBuilder_ == null) {
        return internalIpv6Utilization_ == null
            ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                .getDefaultInstance()
            : internalIpv6Utilization_;
      } else {
        return internalIpv6UtilizationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    public Builder setInternalIpv6Utilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization value) {
      if (internalIpv6UtilizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        internalIpv6Utilization_ = value;
      } else {
        internalIpv6UtilizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    public Builder setInternalIpv6Utilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder
            builderForValue) {
      if (internalIpv6UtilizationBuilder_ == null) {
        internalIpv6Utilization_ = builderForValue.build();
      } else {
        internalIpv6UtilizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    public Builder mergeInternalIpv6Utilization(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization value) {
      if (internalIpv6UtilizationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && internalIpv6Utilization_ != null
            && internalIpv6Utilization_
                != com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                    .getDefaultInstance()) {
          getInternalIpv6UtilizationBuilder().mergeFrom(value);
        } else {
          internalIpv6Utilization_ = value;
        }
      } else {
        internalIpv6UtilizationBuilder_.mergeFrom(value);
      }
      if (internalIpv6Utilization_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    public Builder clearInternalIpv6Utilization() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalIpv6Utilization_ = null;
      if (internalIpv6UtilizationBuilder_ != null) {
        internalIpv6UtilizationBuilder_.dispose();
        internalIpv6UtilizationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder
        getInternalIpv6UtilizationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInternalIpv6UtilizationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder
        getInternalIpv6UtilizationOrBuilder() {
      if (internalIpv6UtilizationBuilder_ != null) {
        return internalIpv6UtilizationBuilder_.getMessageOrBuilder();
      } else {
        return internalIpv6Utilization_ == null
            ? com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization
                .getDefaultInstance()
            : internalIpv6Utilization_;
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of internal IPV6 IP range.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization internal_ipv6_utilization = 69707020;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>
        getInternalIpv6UtilizationFieldBuilder() {
      if (internalIpv6UtilizationBuilder_ == null) {
        internalIpv6UtilizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6Utilization.Builder,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV6UtilizationOrBuilder>(
                getInternalIpv6Utilization(), getParentForChildren(), isClean());
        internalIpv6Utilization_ = null;
      }
      return internalIpv6UtilizationBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization>
        ipv4Utilizations_ = java.util.Collections.emptyList();

    private void ensureIpv4UtilizationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        ipv4Utilizations_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization>(
                ipv4Utilizations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder>
        ipv4UtilizationsBuilder_;

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization>
        getIpv4UtilizationsList() {
      if (ipv4UtilizationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ipv4Utilizations_);
      } else {
        return ipv4UtilizationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public int getIpv4UtilizationsCount() {
      if (ipv4UtilizationsBuilder_ == null) {
        return ipv4Utilizations_.size();
      } else {
        return ipv4UtilizationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization
        getIpv4Utilizations(int index) {
      if (ipv4UtilizationsBuilder_ == null) {
        return ipv4Utilizations_.get(index);
      } else {
        return ipv4UtilizationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder setIpv4Utilizations(
        int index, com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization value) {
      if (ipv4UtilizationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.set(index, value);
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder setIpv4Utilizations(
        int index,
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder
            builderForValue) {
      if (ipv4UtilizationsBuilder_ == null) {
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.set(index, builderForValue.build());
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder addIpv4Utilizations(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization value) {
      if (ipv4UtilizationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.add(value);
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder addIpv4Utilizations(
        int index, com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization value) {
      if (ipv4UtilizationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.add(index, value);
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder addIpv4Utilizations(
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder
            builderForValue) {
      if (ipv4UtilizationsBuilder_ == null) {
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.add(builderForValue.build());
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder addIpv4Utilizations(
        int index,
        com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder
            builderForValue) {
      if (ipv4UtilizationsBuilder_ == null) {
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.add(index, builderForValue.build());
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder addAllIpv4Utilizations(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization>
            values) {
      if (ipv4UtilizationsBuilder_ == null) {
        ensureIpv4UtilizationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipv4Utilizations_);
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder clearIpv4Utilizations() {
      if (ipv4UtilizationsBuilder_ == null) {
        ipv4Utilizations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public Builder removeIpv4Utilizations(int index) {
      if (ipv4UtilizationsBuilder_ == null) {
        ensureIpv4UtilizationsIsMutable();
        ipv4Utilizations_.remove(index);
        onChanged();
      } else {
        ipv4UtilizationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder
        getIpv4UtilizationsBuilder(int index) {
      return getIpv4UtilizationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder
        getIpv4UtilizationsOrBuilder(int index) {
      if (ipv4UtilizationsBuilder_ == null) {
        return ipv4Utilizations_.get(index);
      } else {
        return ipv4UtilizationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder>
        getIpv4UtilizationsOrBuilderList() {
      if (ipv4UtilizationsBuilder_ != null) {
        return ipv4UtilizationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ipv4Utilizations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder
        addIpv4UtilizationsBuilder() {
      return getIpv4UtilizationsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder
        addIpv4UtilizationsBuilder(int index) {
      return getIpv4UtilizationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization ipv4_utilizations = 206180011;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder>
        getIpv4UtilizationsBuilderList() {
      return getIpv4UtilizationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder,
            com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder>
        getIpv4UtilizationsFieldBuilder() {
      if (ipv4UtilizationsBuilder_ == null) {
        ipv4UtilizationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4Utilization.Builder,
                com.google.cloud.compute.v1.SubnetworkUtilizationDetailsIPV4UtilizationOrBuilder>(
                ipv4Utilizations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        ipv4Utilizations_ = null;
      }
      return ipv4UtilizationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SubnetworkUtilizationDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SubnetworkUtilizationDetails)
  private static final com.google.cloud.compute.v1.SubnetworkUtilizationDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SubnetworkUtilizationDetails();
  }

  public static com.google.cloud.compute.v1.SubnetworkUtilizationDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SubnetworkUtilizationDetails> PARSER =
      new com.google.protobuf.AbstractParser<SubnetworkUtilizationDetails>() {
        @java.lang.Override
        public SubnetworkUtilizationDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SubnetworkUtilizationDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SubnetworkUtilizationDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkUtilizationDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
