/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterNatRule}
 */
public final class RouterNatRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterNatRule)
    RouterNatRuleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterNatRule.newBuilder() to construct.
  private RouterNatRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterNatRule() {
    description_ = "";
    match_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterNatRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNatRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNatRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterNatRule.class,
            com.google.cloud.compute.v1.RouterNatRule.Builder.class);
  }

  private int bitField0_;
  public static final int ACTION_FIELD_NUMBER = 187661878;
  private com.google.cloud.compute.v1.RouterNatRuleAction action_;

  /**
   *
   *
   * <pre>
   * The action to be enforced for traffic that matches this rule.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
   *
   * @return Whether the action field is set.
   */
  @java.lang.Override
  public boolean hasAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The action to be enforced for traffic that matches this rule.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatRuleAction getAction() {
    return action_ == null
        ? com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance()
        : action_;
  }

  /**
   *
   *
   * <pre>
   * The action to be enforced for traffic that matches this rule.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatRuleActionOrBuilder getActionOrBuilder() {
    return action_ == null
        ? com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance()
        : action_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this rule.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this rule.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this rule.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCH_FIELD_NUMBER = 103668165;

  @SuppressWarnings("serial")
  private volatile java.lang.Object match_ = "";

  /**
   *
   *
   * <pre>
   * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
   * </pre>
   *
   * <code>optional string match = 103668165;</code>
   *
   * @return Whether the match field is set.
   */
  @java.lang.Override
  public boolean hasMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
   * </pre>
   *
   * <code>optional string match = 103668165;</code>
   *
   * @return The match.
   */
  @java.lang.Override
  public java.lang.String getMatch() {
    java.lang.Object ref = match_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      match_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
   * </pre>
   *
   * <code>optional string match = 103668165;</code>
   *
   * @return The bytes for match.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMatchBytes() {
    java.lang.Object ref = match_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      match_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RULE_NUMBER_FIELD_NUMBER = 535211500;
  private int ruleNumber_ = 0;

  /**
   *
   *
   * <pre>
   * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
   * </pre>
   *
   * <code>optional uint32 rule_number = 535211500;</code>
   *
   * @return Whether the ruleNumber field is set.
   */
  @java.lang.Override
  public boolean hasRuleNumber() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
   * </pre>
   *
   * <code>optional uint32 rule_number = 535211500;</code>
   *
   * @return The ruleNumber.
   */
  @java.lang.Override
  public int getRuleNumber() {
    return ruleNumber_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 103668165, match_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(187661878, getAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt32(535211500, ruleNumber_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(103668165, match_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(187661878, getAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(535211500, ruleNumber_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterNatRule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterNatRule other =
        (com.google.cloud.compute.v1.RouterNatRule) obj;

    if (hasAction() != other.hasAction()) return false;
    if (hasAction()) {
      if (!getAction().equals(other.getAction())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasMatch() != other.hasMatch()) return false;
    if (hasMatch()) {
      if (!getMatch().equals(other.getMatch())) return false;
    }
    if (hasRuleNumber() != other.hasRuleNumber()) return false;
    if (hasRuleNumber()) {
      if (getRuleNumber() != other.getRuleNumber()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAction()) {
      hash = (37 * hash) + ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getAction().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasMatch()) {
      hash = (37 * hash) + MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getMatch().hashCode();
    }
    if (hasRuleNumber()) {
      hash = (37 * hash) + RULE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getRuleNumber();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterNatRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterNatRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterNatRule)
      com.google.cloud.compute.v1.RouterNatRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterNatRule.class,
              com.google.cloud.compute.v1.RouterNatRule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterNatRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getActionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = null;
      if (actionBuilder_ != null) {
        actionBuilder_.dispose();
        actionBuilder_ = null;
      }
      description_ = "";
      match_ = "";
      ruleNumber_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatRule getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterNatRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatRule build() {
      com.google.cloud.compute.v1.RouterNatRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatRule buildPartial() {
      com.google.cloud.compute.v1.RouterNatRule result =
          new com.google.cloud.compute.v1.RouterNatRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterNatRule result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = actionBuilder_ == null ? action_ : actionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.match_ = match_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ruleNumber_ = ruleNumber_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterNatRule) {
        return mergeFrom((com.google.cloud.compute.v1.RouterNatRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterNatRule other) {
      if (other == com.google.cloud.compute.v1.RouterNatRule.getDefaultInstance()) return this;
      if (other.hasAction()) {
        mergeAction(other.getAction());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMatch()) {
        match_ = other.match_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRuleNumber()) {
        setRuleNumber(other.getRuleNumber());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 829345322:
              {
                match_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 829345322
            case 1501295026:
              {
                input.readMessage(getActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 1501295026
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -13275296:
              {
                ruleNumber_ = input.readUInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case -13275296
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.RouterNatRuleAction action_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatRuleAction,
            com.google.cloud.compute.v1.RouterNatRuleAction.Builder,
            com.google.cloud.compute.v1.RouterNatRuleActionOrBuilder>
        actionBuilder_;

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     *
     * @return Whether the action field is set.
     */
    public boolean hasAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     *
     * @return The action.
     */
    public com.google.cloud.compute.v1.RouterNatRuleAction getAction() {
      if (actionBuilder_ == null) {
        return action_ == null
            ? com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance()
            : action_;
      } else {
        return actionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    public Builder setAction(com.google.cloud.compute.v1.RouterNatRuleAction value) {
      if (actionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
      } else {
        actionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    public Builder setAction(
        com.google.cloud.compute.v1.RouterNatRuleAction.Builder builderForValue) {
      if (actionBuilder_ == null) {
        action_ = builderForValue.build();
      } else {
        actionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    public Builder mergeAction(com.google.cloud.compute.v1.RouterNatRuleAction value) {
      if (actionBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && action_ != null
            && action_ != com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance()) {
          getActionBuilder().mergeFrom(value);
        } else {
          action_ = value;
        }
      } else {
        actionBuilder_.mergeFrom(value);
      }
      if (action_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    public Builder clearAction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      action_ = null;
      if (actionBuilder_ != null) {
        actionBuilder_.dispose();
        actionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRuleAction.Builder getActionBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRuleActionOrBuilder getActionOrBuilder() {
      if (actionBuilder_ != null) {
        return actionBuilder_.getMessageOrBuilder();
      } else {
        return action_ == null
            ? com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance()
            : action_;
      }
    }

    /**
     *
     *
     * <pre>
     * The action to be enforced for traffic that matches this rule.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatRuleAction action = 187661878;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatRuleAction,
            com.google.cloud.compute.v1.RouterNatRuleAction.Builder,
            com.google.cloud.compute.v1.RouterNatRuleActionOrBuilder>
        getActionFieldBuilder() {
      if (actionBuilder_ == null) {
        actionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RouterNatRuleAction,
                com.google.cloud.compute.v1.RouterNatRuleAction.Builder,
                com.google.cloud.compute.v1.RouterNatRuleActionOrBuilder>(
                getAction(), getParentForChildren(), isClean());
        action_ = null;
      }
      return actionBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this rule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this rule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this rule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this rule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this rule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this rule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object match_ = "";

    /**
     *
     *
     * <pre>
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
     * </pre>
     *
     * <code>optional string match = 103668165;</code>
     *
     * @return Whether the match field is set.
     */
    public boolean hasMatch() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
     * </pre>
     *
     * <code>optional string match = 103668165;</code>
     *
     * @return The match.
     */
    public java.lang.String getMatch() {
      java.lang.Object ref = match_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        match_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
     * </pre>
     *
     * <code>optional string match = 103668165;</code>
     *
     * @return The bytes for match.
     */
    public com.google.protobuf.ByteString getMatchBytes() {
      java.lang.Object ref = match_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        match_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
     * </pre>
     *
     * <code>optional string match = 103668165;</code>
     *
     * @param value The match to set.
     * @return This builder for chaining.
     */
    public Builder setMatch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      match_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
     * </pre>
     *
     * <code>optional string match = 103668165;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatch() {
      match_ = getDefaultInstance().getMatch();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: `inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')` `destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'` The following example is a valid match expression for private NAT: `nexthop.hub == '//networkconnectivity.googleapis.com/projects/my-project/locations/global/hubs/hub-1'`
     * </pre>
     *
     * <code>optional string match = 103668165;</code>
     *
     * @param value The bytes for match to set.
     * @return This builder for chaining.
     */
    public Builder setMatchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      match_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int ruleNumber_;

    /**
     *
     *
     * <pre>
     * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
     * </pre>
     *
     * <code>optional uint32 rule_number = 535211500;</code>
     *
     * @return Whether the ruleNumber field is set.
     */
    @java.lang.Override
    public boolean hasRuleNumber() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
     * </pre>
     *
     * <code>optional uint32 rule_number = 535211500;</code>
     *
     * @return The ruleNumber.
     */
    @java.lang.Override
    public int getRuleNumber() {
      return ruleNumber_;
    }

    /**
     *
     *
     * <pre>
     * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
     * </pre>
     *
     * <code>optional uint32 rule_number = 535211500;</code>
     *
     * @param value The ruleNumber to set.
     * @return This builder for chaining.
     */
    public Builder setRuleNumber(int value) {

      ruleNumber_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
     * </pre>
     *
     * <code>optional uint32 rule_number = 535211500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleNumber() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ruleNumber_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterNatRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterNatRule)
  private static final com.google.cloud.compute.v1.RouterNatRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterNatRule();
  }

  public static com.google.cloud.compute.v1.RouterNatRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterNatRule> PARSER =
      new com.google.protobuf.AbstractParser<RouterNatRule>() {
        @java.lang.Override
        public RouterNatRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterNatRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterNatRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
