/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Health information for the reservation subBlock.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ReservationSubBlockHealthInfo}
 */
public final class ReservationSubBlockHealthInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ReservationSubBlockHealthInfo)
    ReservationSubBlockHealthInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReservationSubBlockHealthInfo.newBuilder() to construct.
  private ReservationSubBlockHealthInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReservationSubBlockHealthInfo() {
    healthStatus_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReservationSubBlockHealthInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ReservationSubBlockHealthInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ReservationSubBlockHealthInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.class,
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The health status of the reservation subBlock.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ReservationSubBlockHealthInfo.HealthStatus}
   */
  public enum HealthStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_HEALTH_STATUS = 0;</code>
     */
    UNDEFINED_HEALTH_STATUS(0),
    /**
     *
     *
     * <pre>
     * The reservation subBlock is degraded.
     * </pre>
     *
     * <code>DEGRADED = 396890926;</code>
     */
    DEGRADED(396890926),
    /**
     *
     *
     * <pre>
     * The reservation subBlock is healthy.
     * </pre>
     *
     * <code>HEALTHY = 439801213;</code>
     */
    HEALTHY(439801213),
    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock is unspecified.
     * </pre>
     *
     * <code>HEALTH_STATUS_UNSPECIFIED = 482246925;</code>
     */
    HEALTH_STATUS_UNSPECIFIED(482246925),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_HEALTH_STATUS = 0;</code>
     */
    public static final int UNDEFINED_HEALTH_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The reservation subBlock is degraded.
     * </pre>
     *
     * <code>DEGRADED = 396890926;</code>
     */
    public static final int DEGRADED_VALUE = 396890926;

    /**
     *
     *
     * <pre>
     * The reservation subBlock is healthy.
     * </pre>
     *
     * <code>HEALTHY = 439801213;</code>
     */
    public static final int HEALTHY_VALUE = 439801213;

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock is unspecified.
     * </pre>
     *
     * <code>HEALTH_STATUS_UNSPECIFIED = 482246925;</code>
     */
    public static final int HEALTH_STATUS_UNSPECIFIED_VALUE = 482246925;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HealthStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HealthStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_HEALTH_STATUS;
        case 396890926:
          return DEGRADED;
        case 439801213:
          return HEALTHY;
        case 482246925:
          return HEALTH_STATUS_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HealthStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HealthStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<HealthStatus>() {
          public HealthStatus findValueByNumber(int number) {
            return HealthStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final HealthStatus[] VALUES = values();

    public static HealthStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HealthStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ReservationSubBlockHealthInfo.HealthStatus)
  }

  private int bitField0_;
  public static final int DEGRADED_HOST_COUNT_FIELD_NUMBER = 535025001;
  private int degradedHostCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of degraded hosts in the reservation subBlock.
   * </pre>
   *
   * <code>optional int32 degraded_host_count = 535025001;</code>
   *
   * @return Whether the degradedHostCount field is set.
   */
  @java.lang.Override
  public boolean hasDegradedHostCount() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The number of degraded hosts in the reservation subBlock.
   * </pre>
   *
   * <code>optional int32 degraded_host_count = 535025001;</code>
   *
   * @return The degradedHostCount.
   */
  @java.lang.Override
  public int getDegradedHostCount() {
    return degradedHostCount_;
  }

  public static final int DEGRADED_INFRA_COUNT_FIELD_NUMBER = 138638927;
  private int degradedInfraCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
   * </pre>
   *
   * <code>optional int32 degraded_infra_count = 138638927;</code>
   *
   * @return Whether the degradedInfraCount field is set.
   */
  @java.lang.Override
  public boolean hasDegradedInfraCount() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
   * </pre>
   *
   * <code>optional int32 degraded_infra_count = 138638927;</code>
   *
   * @return The degradedInfraCount.
   */
  @java.lang.Override
  public int getDegradedInfraCount() {
    return degradedInfraCount_;
  }

  public static final int HEALTH_STATUS_FIELD_NUMBER = 380545845;

  @SuppressWarnings("serial")
  private volatile java.lang.Object healthStatus_ = "";

  /**
   *
   *
   * <pre>
   * The health status of the reservation subBlock.
   * Check the HealthStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_status = 380545845;</code>
   *
   * @return Whether the healthStatus field is set.
   */
  @java.lang.Override
  public boolean hasHealthStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The health status of the reservation subBlock.
   * Check the HealthStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_status = 380545845;</code>
   *
   * @return The healthStatus.
   */
  @java.lang.Override
  public java.lang.String getHealthStatus() {
    java.lang.Object ref = healthStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The health status of the reservation subBlock.
   * Check the HealthStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_status = 380545845;</code>
   *
   * @return The bytes for healthStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthStatusBytes() {
    java.lang.Object ref = healthStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTHY_HOST_COUNT_FIELD_NUMBER = 40739738;
  private int healthyHostCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of healthy hosts in the reservation subBlock.
   * </pre>
   *
   * <code>optional int32 healthy_host_count = 40739738;</code>
   *
   * @return Whether the healthyHostCount field is set.
   */
  @java.lang.Override
  public boolean hasHealthyHostCount() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The number of healthy hosts in the reservation subBlock.
   * </pre>
   *
   * <code>optional int32 healthy_host_count = 40739738;</code>
   *
   * @return The healthyHostCount.
   */
  @java.lang.Override
  public int getHealthyHostCount() {
    return healthyHostCount_;
  }

  public static final int HEALTHY_INFRA_COUNT_FIELD_NUMBER = 385052222;
  private int healthyInfraCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
   * </pre>
   *
   * <code>optional int32 healthy_infra_count = 385052222;</code>
   *
   * @return Whether the healthyInfraCount field is set.
   */
  @java.lang.Override
  public boolean hasHealthyInfraCount() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
   * </pre>
   *
   * <code>optional int32 healthy_infra_count = 385052222;</code>
   *
   * @return The healthyInfraCount.
   */
  @java.lang.Override
  public int getHealthyInfraCount() {
    return healthyInfraCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(40739738, healthyHostCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(138638927, degradedInfraCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 380545845, healthStatus_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(385052222, healthyInfraCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(535025001, degradedHostCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(40739738, healthyHostCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(138638927, degradedInfraCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(380545845, healthStatus_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(385052222, healthyInfraCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(535025001, degradedHostCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ReservationSubBlockHealthInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ReservationSubBlockHealthInfo other =
        (com.google.cloud.compute.v1.ReservationSubBlockHealthInfo) obj;

    if (hasDegradedHostCount() != other.hasDegradedHostCount()) return false;
    if (hasDegradedHostCount()) {
      if (getDegradedHostCount() != other.getDegradedHostCount()) return false;
    }
    if (hasDegradedInfraCount() != other.hasDegradedInfraCount()) return false;
    if (hasDegradedInfraCount()) {
      if (getDegradedInfraCount() != other.getDegradedInfraCount()) return false;
    }
    if (hasHealthStatus() != other.hasHealthStatus()) return false;
    if (hasHealthStatus()) {
      if (!getHealthStatus().equals(other.getHealthStatus())) return false;
    }
    if (hasHealthyHostCount() != other.hasHealthyHostCount()) return false;
    if (hasHealthyHostCount()) {
      if (getHealthyHostCount() != other.getHealthyHostCount()) return false;
    }
    if (hasHealthyInfraCount() != other.hasHealthyInfraCount()) return false;
    if (hasHealthyInfraCount()) {
      if (getHealthyInfraCount() != other.getHealthyInfraCount()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDegradedHostCount()) {
      hash = (37 * hash) + DEGRADED_HOST_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDegradedHostCount();
    }
    if (hasDegradedInfraCount()) {
      hash = (37 * hash) + DEGRADED_INFRA_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDegradedInfraCount();
    }
    if (hasHealthStatus()) {
      hash = (37 * hash) + HEALTH_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getHealthStatus().hashCode();
    }
    if (hasHealthyHostCount()) {
      hash = (37 * hash) + HEALTHY_HOST_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getHealthyHostCount();
    }
    if (hasHealthyInfraCount()) {
      hash = (37 * hash) + HEALTHY_INFRA_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getHealthyInfraCount();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.ReservationSubBlockHealthInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Health information for the reservation subBlock.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ReservationSubBlockHealthInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ReservationSubBlockHealthInfo)
      com.google.cloud.compute.v1.ReservationSubBlockHealthInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ReservationSubBlockHealthInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ReservationSubBlockHealthInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.class,
              com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      degradedHostCount_ = 0;
      degradedInfraCount_ = 0;
      healthStatus_ = "";
      healthyHostCount_ = 0;
      healthyInfraCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ReservationSubBlockHealthInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo build() {
      com.google.cloud.compute.v1.ReservationSubBlockHealthInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo buildPartial() {
      com.google.cloud.compute.v1.ReservationSubBlockHealthInfo result =
          new com.google.cloud.compute.v1.ReservationSubBlockHealthInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.ReservationSubBlockHealthInfo result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.degradedHostCount_ = degradedHostCount_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.degradedInfraCount_ = degradedInfraCount_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.healthStatus_ = healthStatus_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.healthyHostCount_ = healthyHostCount_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.healthyInfraCount_ = healthyInfraCount_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ReservationSubBlockHealthInfo) {
        return mergeFrom((com.google.cloud.compute.v1.ReservationSubBlockHealthInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ReservationSubBlockHealthInfo other) {
      if (other == com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance())
        return this;
      if (other.hasDegradedHostCount()) {
        setDegradedHostCount(other.getDegradedHostCount());
      }
      if (other.hasDegradedInfraCount()) {
        setDegradedInfraCount(other.getDegradedInfraCount());
      }
      if (other.hasHealthStatus()) {
        healthStatus_ = other.healthStatus_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasHealthyHostCount()) {
        setHealthyHostCount(other.getHealthyHostCount());
      }
      if (other.hasHealthyInfraCount()) {
        setHealthyInfraCount(other.getHealthyInfraCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 325917904:
              {
                healthyHostCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 325917904
            case 1109111416:
              {
                degradedInfraCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 1109111416
            case -1250600534:
              {
                healthStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -1250600534
            case -1214549520:
              {
                healthyInfraCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case -1214549520
            case -14767288:
              {
                degradedHostCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case -14767288
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int degradedHostCount_;

    /**
     *
     *
     * <pre>
     * The number of degraded hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 degraded_host_count = 535025001;</code>
     *
     * @return Whether the degradedHostCount field is set.
     */
    @java.lang.Override
    public boolean hasDegradedHostCount() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The number of degraded hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 degraded_host_count = 535025001;</code>
     *
     * @return The degradedHostCount.
     */
    @java.lang.Override
    public int getDegradedHostCount() {
      return degradedHostCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of degraded hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 degraded_host_count = 535025001;</code>
     *
     * @param value The degradedHostCount to set.
     * @return This builder for chaining.
     */
    public Builder setDegradedHostCount(int value) {

      degradedHostCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of degraded hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 degraded_host_count = 535025001;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDegradedHostCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      degradedHostCount_ = 0;
      onChanged();
      return this;
    }

    private int degradedInfraCount_;

    /**
     *
     *
     * <pre>
     * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 degraded_infra_count = 138638927;</code>
     *
     * @return Whether the degradedInfraCount field is set.
     */
    @java.lang.Override
    public boolean hasDegradedInfraCount() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 degraded_infra_count = 138638927;</code>
     *
     * @return The degradedInfraCount.
     */
    @java.lang.Override
    public int getDegradedInfraCount() {
      return degradedInfraCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 degraded_infra_count = 138638927;</code>
     *
     * @param value The degradedInfraCount to set.
     * @return This builder for chaining.
     */
    public Builder setDegradedInfraCount(int value) {

      degradedInfraCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 degraded_infra_count = 138638927;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDegradedInfraCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      degradedInfraCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object healthStatus_ = "";

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock.
     * Check the HealthStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_status = 380545845;</code>
     *
     * @return Whether the healthStatus field is set.
     */
    public boolean hasHealthStatus() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock.
     * Check the HealthStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_status = 380545845;</code>
     *
     * @return The healthStatus.
     */
    public java.lang.String getHealthStatus() {
      java.lang.Object ref = healthStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock.
     * Check the HealthStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_status = 380545845;</code>
     *
     * @return The bytes for healthStatus.
     */
    public com.google.protobuf.ByteString getHealthStatusBytes() {
      java.lang.Object ref = healthStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock.
     * Check the HealthStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_status = 380545845;</code>
     *
     * @param value The healthStatus to set.
     * @return This builder for chaining.
     */
    public Builder setHealthStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      healthStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock.
     * Check the HealthStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_status = 380545845;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthStatus() {
      healthStatus_ = getDefaultInstance().getHealthStatus();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The health status of the reservation subBlock.
     * Check the HealthStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_status = 380545845;</code>
     *
     * @param value The bytes for healthStatus to set.
     * @return This builder for chaining.
     */
    public Builder setHealthStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      healthStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int healthyHostCount_;

    /**
     *
     *
     * <pre>
     * The number of healthy hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 healthy_host_count = 40739738;</code>
     *
     * @return Whether the healthyHostCount field is set.
     */
    @java.lang.Override
    public boolean hasHealthyHostCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The number of healthy hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 healthy_host_count = 40739738;</code>
     *
     * @return The healthyHostCount.
     */
    @java.lang.Override
    public int getHealthyHostCount() {
      return healthyHostCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of healthy hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 healthy_host_count = 40739738;</code>
     *
     * @param value The healthyHostCount to set.
     * @return This builder for chaining.
     */
    public Builder setHealthyHostCount(int value) {

      healthyHostCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of healthy hosts in the reservation subBlock.
     * </pre>
     *
     * <code>optional int32 healthy_host_count = 40739738;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthyHostCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      healthyHostCount_ = 0;
      onChanged();
      return this;
    }

    private int healthyInfraCount_;

    /**
     *
     *
     * <pre>
     * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 healthy_infra_count = 385052222;</code>
     *
     * @return Whether the healthyInfraCount field is set.
     */
    @java.lang.Override
    public boolean hasHealthyInfraCount() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 healthy_infra_count = 385052222;</code>
     *
     * @return The healthyInfraCount.
     */
    @java.lang.Override
    public int getHealthyInfraCount() {
      return healthyInfraCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 healthy_infra_count = 385052222;</code>
     *
     * @param value The healthyInfraCount to set.
     * @return This builder for chaining.
     */
    public Builder setHealthyInfraCount(int value) {

      healthyInfraCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
     * </pre>
     *
     * <code>optional int32 healthy_infra_count = 385052222;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthyInfraCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      healthyInfraCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ReservationSubBlockHealthInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ReservationSubBlockHealthInfo)
  private static final com.google.cloud.compute.v1.ReservationSubBlockHealthInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ReservationSubBlockHealthInfo();
  }

  public static com.google.cloud.compute.v1.ReservationSubBlockHealthInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReservationSubBlockHealthInfo> PARSER =
      new com.google.protobuf.AbstractParser<ReservationSubBlockHealthInfo>() {
        @java.lang.Override
        public ReservationSubBlockHealthInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReservationSubBlockHealthInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReservationSubBlockHealthInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
