/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a reservation subBlock resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ReservationSubBlock}
 */
public final class ReservationSubBlock extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ReservationSubBlock)
    ReservationSubBlockOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReservationSubBlock.newBuilder() to construct.
  private ReservationSubBlock(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReservationSubBlock() {
    creationTimestamp_ = "";
    kind_ = "";
    name_ = "";
    selfLink_ = "";
    selfLinkWithId_ = "";
    status_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReservationSubBlock();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ReservationSubBlock_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ReservationSubBlock_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ReservationSubBlock.class,
            com.google.cloud.compute.v1.ReservationSubBlock.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the reservation subBlock.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ReservationSubBlock.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Resources are being allocated for the reservation subBlock.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * Reservation subBlock is currently being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /**
     *
     *
     * <pre>
     * Reservation subBlock has allocated all its resources.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    READY(77848963),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Resources are being allocated for the reservation subBlock.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;

    /**
     *
     *
     * <pre>
     * Reservation subBlock is currently being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;

    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;

    /**
     *
     *
     * <pre>
     * Reservation subBlock has allocated all its resources.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    public static final int READY_VALUE = 77848963;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 530283991:
          return INVALID;
        case 77848963:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ReservationSubBlock.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ReservationSubBlock.Status)
  }

  private int bitField0_;
  public static final int COUNT_FIELD_NUMBER = 94851343;
  private int count_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] The number of hosts that are allocated in this reservation subBlock.
   * </pre>
   *
   * <code>optional int32 count = 94851343;</code>
   *
   * @return Whether the count field is set.
   */
  @java.lang.Override
  public boolean hasCount() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The number of hosts that are allocated in this reservation subBlock.
   * </pre>
   *
   * <code>optional int32 count = 94851343;</code>
   *
   * @return The count.
   */
  @java.lang.Override
  public int getCount() {
    return count_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_INFO_FIELD_NUMBER = 235287729;
  private com.google.cloud.compute.v1.ReservationSubBlockHealthInfo healthInfo_;

  /**
   *
   *
   * <pre>
   * [Output Only] Health information for the reservation subBlock.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
   * </code>
   *
   * @return Whether the healthInfo field is set.
   */
  @java.lang.Override
  public boolean hasHealthInfo() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Health information for the reservation subBlock.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
   * </code>
   *
   * @return The healthInfo.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo getHealthInfo() {
    return healthInfo_ == null
        ? com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance()
        : healthInfo_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Health information for the reservation subBlock.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationSubBlockHealthInfoOrBuilder
      getHealthInfoOrBuilder() {
    return healthInfo_ == null
        ? com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance()
        : healthInfo_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int IN_USE_COUNT_FIELD_NUMBER = 493458877;
  private int inUseCount_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] The number of instances that are currently in use on this reservation subBlock.
   * </pre>
   *
   * <code>optional int32 in_use_count = 493458877;</code>
   *
   * @return Whether the inUseCount field is set.
   */
  @java.lang.Override
  public boolean hasInUseCount() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The number of instances that are currently in use on this reservation subBlock.
   * </pre>
   *
   * <code>optional int32 in_use_count = 493458877;</code>
   *
   * @return The inUseCount.
   */
  @java.lang.Override
  public int getInUseCount() {
    return inUseCount_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHYSICAL_TOPOLOGY_FIELD_NUMBER = 279778519;
  private com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physicalTopology_;

  /**
   *
   *
   * <pre>
   * [Output Only] The physical topology of the reservation subBlock.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
   * </code>
   *
   * @return Whether the physicalTopology field is set.
   */
  @java.lang.Override
  public boolean hasPhysicalTopology() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The physical topology of the reservation subBlock.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
   * </code>
   *
   * @return The physicalTopology.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology getPhysicalTopology() {
    return physicalTopology_ == null
        ? com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.getDefaultInstance()
        : physicalTopology_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The physical topology of the reservation subBlock.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopologyOrBuilder
      getPhysicalTopologyOrBuilder() {
    return physicalTopology_ == null
        ? com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.getDefaultInstance()
        : physicalTopology_;
  }

  public static final int RESERVATION_SUB_BLOCK_MAINTENANCE_FIELD_NUMBER = 377005551;
  private com.google.cloud.compute.v1.GroupMaintenanceInfo reservationSubBlockMaintenance_;

  /**
   *
   *
   * <pre>
   * Maintenance information for this reservation subBlock.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
   * </code>
   *
   * @return Whether the reservationSubBlockMaintenance field is set.
   */
  @java.lang.Override
  public boolean hasReservationSubBlockMaintenance() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Maintenance information for this reservation subBlock.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
   * </code>
   *
   * @return The reservationSubBlockMaintenance.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GroupMaintenanceInfo getReservationSubBlockMaintenance() {
    return reservationSubBlockMaintenance_ == null
        ? com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance()
        : reservationSubBlockMaintenance_;
  }

  /**
   *
   *
   * <pre>
   * Maintenance information for this reservation subBlock.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GroupMaintenanceInfoOrBuilder
      getReservationSubBlockMaintenanceOrBuilder() {
    return reservationSubBlockMaintenance_ == null
        ? com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance()
        : reservationSubBlockMaintenance_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_WITH_ID_FIELD_NUMBER = 44520962;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLinkWithId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return Whether the selfLinkWithId field is set.
   */
  @java.lang.Override
  public boolean hasSelfLinkWithId() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The selfLinkWithId.
   */
  @java.lang.Override
  public java.lang.String getSelfLinkWithId() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLinkWithId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The bytes for selfLinkWithId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLinkWithId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the reservation subBlock.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the reservation subBlock.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the reservation subBlock.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Zone in which the reservation subBlock resides.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zone in which the reservation subBlock resides.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zone in which the reservation subBlock resides.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 44520962, selfLinkWithId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(94851343, count_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(235287729, getHealthInfo());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(279778519, getPhysicalTopology());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(377005551, getReservationSubBlockMaintenance());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(493458877, inUseCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(44520962, selfLinkWithId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(94851343, count_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(235287729, getHealthInfo());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              279778519, getPhysicalTopology());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              377005551, getReservationSubBlockMaintenance());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(493458877, inUseCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ReservationSubBlock)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ReservationSubBlock other =
        (com.google.cloud.compute.v1.ReservationSubBlock) obj;

    if (hasCount() != other.hasCount()) return false;
    if (hasCount()) {
      if (getCount() != other.getCount()) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasHealthInfo() != other.hasHealthInfo()) return false;
    if (hasHealthInfo()) {
      if (!getHealthInfo().equals(other.getHealthInfo())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInUseCount() != other.hasInUseCount()) return false;
    if (hasInUseCount()) {
      if (getInUseCount() != other.getInUseCount()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPhysicalTopology() != other.hasPhysicalTopology()) return false;
    if (hasPhysicalTopology()) {
      if (!getPhysicalTopology().equals(other.getPhysicalTopology())) return false;
    }
    if (hasReservationSubBlockMaintenance() != other.hasReservationSubBlockMaintenance())
      return false;
    if (hasReservationSubBlockMaintenance()) {
      if (!getReservationSubBlockMaintenance().equals(other.getReservationSubBlockMaintenance()))
        return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSelfLinkWithId() != other.hasSelfLinkWithId()) return false;
    if (hasSelfLinkWithId()) {
      if (!getSelfLinkWithId().equals(other.getSelfLinkWithId())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCount()) {
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCount();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasHealthInfo()) {
      hash = (37 * hash) + HEALTH_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getHealthInfo().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInUseCount()) {
      hash = (37 * hash) + IN_USE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getInUseCount();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPhysicalTopology()) {
      hash = (37 * hash) + PHYSICAL_TOPOLOGY_FIELD_NUMBER;
      hash = (53 * hash) + getPhysicalTopology().hashCode();
    }
    if (hasReservationSubBlockMaintenance()) {
      hash = (37 * hash) + RESERVATION_SUB_BLOCK_MAINTENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getReservationSubBlockMaintenance().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSelfLinkWithId()) {
      hash = (37 * hash) + SELF_LINK_WITH_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLinkWithId().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ReservationSubBlock prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a reservation subBlock resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ReservationSubBlock}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ReservationSubBlock)
      com.google.cloud.compute.v1.ReservationSubBlockOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ReservationSubBlock_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ReservationSubBlock_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ReservationSubBlock.class,
              com.google.cloud.compute.v1.ReservationSubBlock.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ReservationSubBlock.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHealthInfoFieldBuilder();
        getPhysicalTopologyFieldBuilder();
        getReservationSubBlockMaintenanceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      count_ = 0;
      creationTimestamp_ = "";
      healthInfo_ = null;
      if (healthInfoBuilder_ != null) {
        healthInfoBuilder_.dispose();
        healthInfoBuilder_ = null;
      }
      id_ = 0L;
      inUseCount_ = 0;
      kind_ = "";
      name_ = "";
      physicalTopology_ = null;
      if (physicalTopologyBuilder_ != null) {
        physicalTopologyBuilder_.dispose();
        physicalTopologyBuilder_ = null;
      }
      reservationSubBlockMaintenance_ = null;
      if (reservationSubBlockMaintenanceBuilder_ != null) {
        reservationSubBlockMaintenanceBuilder_.dispose();
        reservationSubBlockMaintenanceBuilder_ = null;
      }
      selfLink_ = "";
      selfLinkWithId_ = "";
      status_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ReservationSubBlock_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ReservationSubBlock getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ReservationSubBlock.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ReservationSubBlock build() {
      com.google.cloud.compute.v1.ReservationSubBlock result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ReservationSubBlock buildPartial() {
      com.google.cloud.compute.v1.ReservationSubBlock result =
          new com.google.cloud.compute.v1.ReservationSubBlock(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.ReservationSubBlock result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.count_ = count_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.healthInfo_ = healthInfoBuilder_ == null ? healthInfo_ : healthInfoBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.inUseCount_ = inUseCount_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.physicalTopology_ =
            physicalTopologyBuilder_ == null ? physicalTopology_ : physicalTopologyBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.reservationSubBlockMaintenance_ =
            reservationSubBlockMaintenanceBuilder_ == null
                ? reservationSubBlockMaintenance_
                : reservationSubBlockMaintenanceBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.selfLinkWithId_ = selfLinkWithId_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ReservationSubBlock) {
        return mergeFrom((com.google.cloud.compute.v1.ReservationSubBlock) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ReservationSubBlock other) {
      if (other == com.google.cloud.compute.v1.ReservationSubBlock.getDefaultInstance())
        return this;
      if (other.hasCount()) {
        setCount(other.getCount());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasHealthInfo()) {
        mergeHealthInfo(other.getHealthInfo());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInUseCount()) {
        setInUseCount(other.getInUseCount());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasPhysicalTopology()) {
        mergePhysicalTopology(other.getPhysicalTopology());
      }
      if (other.hasReservationSubBlockMaintenance()) {
        mergeReservationSubBlockMaintenance(other.getReservationSubBlockMaintenance());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasSelfLinkWithId()) {
        selfLinkWithId_ = other.selfLinkWithId_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26989658
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 356167698:
              {
                selfLinkWithId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 356167698
            case 758810744:
              {
                count_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 758810744
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1450082194
            case 1882301834:
              {
                input.readMessage(getHealthInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 1882301834
            case -2056739142:
              {
                input.readMessage(
                    getPhysicalTopologyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -2056739142
            case -1278922886:
              {
                input.readMessage(
                    getReservationSubBlockMaintenanceFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case -1278922886
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -645248918
            case -347296280:
              {
                inUseCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case -347296280
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int count_;

    /**
     *
     *
     * <pre>
     * [Output Only] The number of hosts that are allocated in this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 count = 94851343;</code>
     *
     * @return Whether the count field is set.
     */
    @java.lang.Override
    public boolean hasCount() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of hosts that are allocated in this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 count = 94851343;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public int getCount() {
      return count_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of hosts that are allocated in this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 count = 94851343;</code>
     *
     * @param value The count to set.
     * @return This builder for chaining.
     */
    public Builder setCount(int value) {

      count_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of hosts that are allocated in this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 count = 94851343;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      count_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ReservationSubBlockHealthInfo healthInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfo,
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder,
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfoOrBuilder>
        healthInfoBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     *
     * @return Whether the healthInfo field is set.
     */
    public boolean hasHealthInfo() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     *
     * @return The healthInfo.
     */
    public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo getHealthInfo() {
      if (healthInfoBuilder_ == null) {
        return healthInfo_ == null
            ? com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance()
            : healthInfo_;
      } else {
        return healthInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    public Builder setHealthInfo(com.google.cloud.compute.v1.ReservationSubBlockHealthInfo value) {
      if (healthInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        healthInfo_ = value;
      } else {
        healthInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    public Builder setHealthInfo(
        com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder builderForValue) {
      if (healthInfoBuilder_ == null) {
        healthInfo_ = builderForValue.build();
      } else {
        healthInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    public Builder mergeHealthInfo(
        com.google.cloud.compute.v1.ReservationSubBlockHealthInfo value) {
      if (healthInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && healthInfo_ != null
            && healthInfo_
                != com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance()) {
          getHealthInfoBuilder().mergeFrom(value);
        } else {
          healthInfo_ = value;
        }
      } else {
        healthInfoBuilder_.mergeFrom(value);
      }
      if (healthInfo_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    public Builder clearHealthInfo() {
      bitField0_ = (bitField0_ & ~0x00000004);
      healthInfo_ = null;
      if (healthInfoBuilder_ != null) {
        healthInfoBuilder_.dispose();
        healthInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder
        getHealthInfoBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getHealthInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationSubBlockHealthInfoOrBuilder
        getHealthInfoOrBuilder() {
      if (healthInfoBuilder_ != null) {
        return healthInfoBuilder_.getMessageOrBuilder();
      } else {
        return healthInfo_ == null
            ? com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.getDefaultInstance()
            : healthInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Health information for the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockHealthInfo health_info = 235287729;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfo,
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder,
            com.google.cloud.compute.v1.ReservationSubBlockHealthInfoOrBuilder>
        getHealthInfoFieldBuilder() {
      if (healthInfoBuilder_ == null) {
        healthInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ReservationSubBlockHealthInfo,
                com.google.cloud.compute.v1.ReservationSubBlockHealthInfo.Builder,
                com.google.cloud.compute.v1.ReservationSubBlockHealthInfoOrBuilder>(
                getHealthInfo(), getParentForChildren(), isClean());
        healthInfo_ = null;
      }
      return healthInfoBuilder_;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000008);
      id_ = 0L;
      onChanged();
      return this;
    }

    private int inUseCount_;

    /**
     *
     *
     * <pre>
     * [Output Only] The number of instances that are currently in use on this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 in_use_count = 493458877;</code>
     *
     * @return Whether the inUseCount field is set.
     */
    @java.lang.Override
    public boolean hasInUseCount() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of instances that are currently in use on this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 in_use_count = 493458877;</code>
     *
     * @return The inUseCount.
     */
    @java.lang.Override
    public int getInUseCount() {
      return inUseCount_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of instances that are currently in use on this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 in_use_count = 493458877;</code>
     *
     * @param value The inUseCount to set.
     * @return This builder for chaining.
     */
    public Builder setInUseCount(int value) {

      inUseCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of instances that are currently in use on this reservation subBlock.
     * </pre>
     *
     * <code>optional int32 in_use_count = 493458877;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInUseCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      inUseCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation subBlocks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 &#64;pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physicalTopology_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology,
            com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.Builder,
            com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopologyOrBuilder>
        physicalTopologyBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     *
     * @return Whether the physicalTopology field is set.
     */
    public boolean hasPhysicalTopology() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     *
     * @return The physicalTopology.
     */
    public com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology getPhysicalTopology() {
      if (physicalTopologyBuilder_ == null) {
        return physicalTopology_ == null
            ? com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.getDefaultInstance()
            : physicalTopology_;
      } else {
        return physicalTopologyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    public Builder setPhysicalTopology(
        com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology value) {
      if (physicalTopologyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        physicalTopology_ = value;
      } else {
        physicalTopologyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    public Builder setPhysicalTopology(
        com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.Builder builderForValue) {
      if (physicalTopologyBuilder_ == null) {
        physicalTopology_ = builderForValue.build();
      } else {
        physicalTopologyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    public Builder mergePhysicalTopology(
        com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology value) {
      if (physicalTopologyBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && physicalTopology_ != null
            && physicalTopology_
                != com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology
                    .getDefaultInstance()) {
          getPhysicalTopologyBuilder().mergeFrom(value);
        } else {
          physicalTopology_ = value;
        }
      } else {
        physicalTopologyBuilder_.mergeFrom(value);
      }
      if (physicalTopology_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    public Builder clearPhysicalTopology() {
      bitField0_ = (bitField0_ & ~0x00000080);
      physicalTopology_ = null;
      if (physicalTopologyBuilder_ != null) {
        physicalTopologyBuilder_.dispose();
        physicalTopologyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.Builder
        getPhysicalTopologyBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPhysicalTopologyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopologyOrBuilder
        getPhysicalTopologyOrBuilder() {
      if (physicalTopologyBuilder_ != null) {
        return physicalTopologyBuilder_.getMessageOrBuilder();
      } else {
        return physicalTopology_ == null
            ? com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.getDefaultInstance()
            : physicalTopology_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The physical topology of the reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationSubBlockPhysicalTopology physical_topology = 279778519;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology,
            com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.Builder,
            com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopologyOrBuilder>
        getPhysicalTopologyFieldBuilder() {
      if (physicalTopologyBuilder_ == null) {
        physicalTopologyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology,
                com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopology.Builder,
                com.google.cloud.compute.v1.ReservationSubBlockPhysicalTopologyOrBuilder>(
                getPhysicalTopology(), getParentForChildren(), isClean());
        physicalTopology_ = null;
      }
      return physicalTopologyBuilder_;
    }

    private com.google.cloud.compute.v1.GroupMaintenanceInfo reservationSubBlockMaintenance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.GroupMaintenanceInfo,
            com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder,
            com.google.cloud.compute.v1.GroupMaintenanceInfoOrBuilder>
        reservationSubBlockMaintenanceBuilder_;

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     *
     * @return Whether the reservationSubBlockMaintenance field is set.
     */
    public boolean hasReservationSubBlockMaintenance() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     *
     * @return The reservationSubBlockMaintenance.
     */
    public com.google.cloud.compute.v1.GroupMaintenanceInfo getReservationSubBlockMaintenance() {
      if (reservationSubBlockMaintenanceBuilder_ == null) {
        return reservationSubBlockMaintenance_ == null
            ? com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance()
            : reservationSubBlockMaintenance_;
      } else {
        return reservationSubBlockMaintenanceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    public Builder setReservationSubBlockMaintenance(
        com.google.cloud.compute.v1.GroupMaintenanceInfo value) {
      if (reservationSubBlockMaintenanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationSubBlockMaintenance_ = value;
      } else {
        reservationSubBlockMaintenanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    public Builder setReservationSubBlockMaintenance(
        com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder builderForValue) {
      if (reservationSubBlockMaintenanceBuilder_ == null) {
        reservationSubBlockMaintenance_ = builderForValue.build();
      } else {
        reservationSubBlockMaintenanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    public Builder mergeReservationSubBlockMaintenance(
        com.google.cloud.compute.v1.GroupMaintenanceInfo value) {
      if (reservationSubBlockMaintenanceBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && reservationSubBlockMaintenance_ != null
            && reservationSubBlockMaintenance_
                != com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance()) {
          getReservationSubBlockMaintenanceBuilder().mergeFrom(value);
        } else {
          reservationSubBlockMaintenance_ = value;
        }
      } else {
        reservationSubBlockMaintenanceBuilder_.mergeFrom(value);
      }
      if (reservationSubBlockMaintenance_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    public Builder clearReservationSubBlockMaintenance() {
      bitField0_ = (bitField0_ & ~0x00000100);
      reservationSubBlockMaintenance_ = null;
      if (reservationSubBlockMaintenanceBuilder_ != null) {
        reservationSubBlockMaintenanceBuilder_.dispose();
        reservationSubBlockMaintenanceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    public com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder
        getReservationSubBlockMaintenanceBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getReservationSubBlockMaintenanceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    public com.google.cloud.compute.v1.GroupMaintenanceInfoOrBuilder
        getReservationSubBlockMaintenanceOrBuilder() {
      if (reservationSubBlockMaintenanceBuilder_ != null) {
        return reservationSubBlockMaintenanceBuilder_.getMessageOrBuilder();
      } else {
        return reservationSubBlockMaintenance_ == null
            ? com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance()
            : reservationSubBlockMaintenance_;
      }
    }

    /**
     *
     *
     * <pre>
     * Maintenance information for this reservation subBlock.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.GroupMaintenanceInfo reservation_sub_block_maintenance = 377005551;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.GroupMaintenanceInfo,
            com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder,
            com.google.cloud.compute.v1.GroupMaintenanceInfoOrBuilder>
        getReservationSubBlockMaintenanceFieldBuilder() {
      if (reservationSubBlockMaintenanceBuilder_ == null) {
        reservationSubBlockMaintenanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.GroupMaintenanceInfo,
                com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder,
                com.google.cloud.compute.v1.GroupMaintenanceInfoOrBuilder>(
                getReservationSubBlockMaintenance(), getParentForChildren(), isClean());
        reservationSubBlockMaintenance_ = null;
      }
      return reservationSubBlockMaintenanceBuilder_;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object selfLinkWithId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return Whether the selfLinkWithId field is set.
     */
    public boolean hasSelfLinkWithId() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The selfLinkWithId.
     */
    public java.lang.String getSelfLinkWithId() {
      java.lang.Object ref = selfLinkWithId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLinkWithId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The bytes for selfLinkWithId.
     */
    public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
      java.lang.Object ref = selfLinkWithId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLinkWithId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLinkWithId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLinkWithId() {
      selfLinkWithId_ = getDefaultInstance().getSelfLinkWithId();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The bytes for selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLinkWithId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Status of the reservation subBlock.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status of the reservation subBlock.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status of the reservation subBlock.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status of the reservation subBlock.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status of the reservation subBlock.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status of the reservation subBlock.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Zone in which the reservation subBlock resides.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zone in which the reservation subBlock resides.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zone in which the reservation subBlock resides.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zone in which the reservation subBlock resides.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zone in which the reservation subBlock resides.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zone in which the reservation subBlock resides.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ReservationSubBlock)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ReservationSubBlock)
  private static final com.google.cloud.compute.v1.ReservationSubBlock DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ReservationSubBlock();
  }

  public static com.google.cloud.compute.v1.ReservationSubBlock getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReservationSubBlock> PARSER =
      new com.google.protobuf.AbstractParser<ReservationSubBlock>() {
        @java.lang.Override
        public ReservationSubBlock parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReservationSubBlock> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReservationSubBlock> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationSubBlock getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
