/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read Reserving zonal resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Reservation}
 */
public final class Reservation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Reservation)
    ReservationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Reservation.newBuilder() to construct.
  private Reservation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Reservation() {
    commitment_ = "";
    creationTimestamp_ = "";
    deleteAtTime_ = "";
    deploymentType_ = "";
    description_ = "";
    kind_ = "";
    linkedCommitments_ = com.google.protobuf.LazyStringArrayList.emptyList();
    name_ = "";
    schedulingType_ = "";
    selfLink_ = "";
    status_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Reservation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Reservation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 22220385:
        return internalGetResourcePolicies();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Reservation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Reservation.class,
            com.google.cloud.compute.v1.Reservation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the deployment strategy for this reservation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Reservation.DeploymentType}
   */
  public enum DeploymentType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DEPLOYMENT_TYPE = 0;</code>
     */
    UNDEFINED_DEPLOYMENT_TYPE(0),
    /**
     *
     *
     * <pre>
     * The reserved capacity is made up of densely deployed reservation blocks.
     * </pre>
     *
     * <code>DENSE = 64932607;</code>
     */
    DENSE(64932607),
    /** <code>DEPLOYMENT_TYPE_UNSPECIFIED = 234847180;</code> */
    DEPLOYMENT_TYPE_UNSPECIFIED(234847180),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DEPLOYMENT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_DEPLOYMENT_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The reserved capacity is made up of densely deployed reservation blocks.
     * </pre>
     *
     * <code>DENSE = 64932607;</code>
     */
    public static final int DENSE_VALUE = 64932607;

    /** <code>DEPLOYMENT_TYPE_UNSPECIFIED = 234847180;</code> */
    public static final int DEPLOYMENT_TYPE_UNSPECIFIED_VALUE = 234847180;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeploymentType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeploymentType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DEPLOYMENT_TYPE;
        case 64932607:
          return DENSE;
        case 234847180:
          return DEPLOYMENT_TYPE_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeploymentType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeploymentType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DeploymentType>() {
          public DeploymentType findValueByNumber(int number) {
            return DeploymentType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Reservation.getDescriptor().getEnumTypes().get(0);
    }

    private static final DeploymentType[] VALUES = values();

    public static DeploymentType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeploymentType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Reservation.DeploymentType)
  }

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Reservation.SchedulingType}
   */
  public enum SchedulingType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SCHEDULING_TYPE = 0;</code>
     */
    UNDEFINED_SCHEDULING_TYPE(0),
    /**
     *
     *
     * <pre>
     * Maintenance on all reserved instances in the reservation is synchronized.
     * </pre>
     *
     * <code>GROUPED = 474540862;</code>
     */
    GROUPED(474540862),
    /**
     *
     *
     * <pre>
     * Unknown maintenance type.
     * </pre>
     *
     * <code>GROUP_MAINTENANCE_TYPE_UNSPECIFIED = 447183678;</code>
     */
    GROUP_MAINTENANCE_TYPE_UNSPECIFIED(447183678),
    /**
     *
     *
     * <pre>
     * Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
     * </pre>
     *
     * <code>INDEPENDENT = 127011674;</code>
     */
    INDEPENDENT(127011674),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SCHEDULING_TYPE = 0;</code>
     */
    public static final int UNDEFINED_SCHEDULING_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Maintenance on all reserved instances in the reservation is synchronized.
     * </pre>
     *
     * <code>GROUPED = 474540862;</code>
     */
    public static final int GROUPED_VALUE = 474540862;

    /**
     *
     *
     * <pre>
     * Unknown maintenance type.
     * </pre>
     *
     * <code>GROUP_MAINTENANCE_TYPE_UNSPECIFIED = 447183678;</code>
     */
    public static final int GROUP_MAINTENANCE_TYPE_UNSPECIFIED_VALUE = 447183678;

    /**
     *
     *
     * <pre>
     * Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
     * </pre>
     *
     * <code>INDEPENDENT = 127011674;</code>
     */
    public static final int INDEPENDENT_VALUE = 127011674;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchedulingType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SchedulingType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SCHEDULING_TYPE;
        case 474540862:
          return GROUPED;
        case 447183678:
          return GROUP_MAINTENANCE_TYPE_UNSPECIFIED;
        case 127011674:
          return INDEPENDENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SchedulingType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SchedulingType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SchedulingType>() {
          public SchedulingType findValueByNumber(int number) {
            return SchedulingType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Reservation.getDescriptor().getEnumTypes().get(1);
    }

    private static final SchedulingType[] VALUES = values();

    public static SchedulingType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SchedulingType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Reservation.SchedulingType)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Reservation.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Reservation resources are being allocated.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * Reservation deletion is in progress.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /**
     *
     *
     * <pre>
     * Reservation resources have been allocated, and the reservation is ready for use.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    READY(77848963),
    /**
     *
     *
     * <pre>
     * Reservation update is in progress.
     * </pre>
     *
     * <code>UPDATING = 494614342;</code>
     */
    UPDATING(494614342),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Reservation resources are being allocated.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;

    /**
     *
     *
     * <pre>
     * Reservation deletion is in progress.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;

    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;

    /**
     *
     *
     * <pre>
     * Reservation resources have been allocated, and the reservation is ready for use.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    public static final int READY_VALUE = 77848963;

    /**
     *
     *
     * <pre>
     * Reservation update is in progress.
     * </pre>
     *
     * <code>UPDATING = 494614342;</code>
     */
    public static final int UPDATING_VALUE = 494614342;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 530283991:
          return INVALID;
        case 77848963:
          return READY;
        case 494614342:
          return UPDATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Reservation.getDescriptor().getEnumTypes().get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Reservation.Status)
  }

  private int bitField0_;
  public static final int ADVANCED_DEPLOYMENT_CONTROL_FIELD_NUMBER = 410618144;
  private com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl
      advancedDeploymentControl_;

  /**
   *
   *
   * <pre>
   * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
   * </code>
   *
   * @return Whether the advancedDeploymentControl field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedDeploymentControl() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
   * </code>
   *
   * @return The advancedDeploymentControl.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl
      getAdvancedDeploymentControl() {
    return advancedDeploymentControl_ == null
        ? com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.getDefaultInstance()
        : advancedDeploymentControl_;
  }

  /**
   *
   *
   * <pre>
   * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationAdvancedDeploymentControlOrBuilder
      getAdvancedDeploymentControlOrBuilder() {
    return advancedDeploymentControl_ == null
        ? com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.getDefaultInstance()
        : advancedDeploymentControl_;
  }

  public static final int AGGREGATE_RESERVATION_FIELD_NUMBER = 291567948;
  private com.google.cloud.compute.v1.AllocationAggregateReservation aggregateReservation_;

  /**
   *
   *
   * <pre>
   * Reservation for aggregated resources, providing shape flexibility.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
   * </code>
   *
   * @return Whether the aggregateReservation field is set.
   */
  @java.lang.Override
  public boolean hasAggregateReservation() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Reservation for aggregated resources, providing shape flexibility.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
   * </code>
   *
   * @return The aggregateReservation.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservation getAggregateReservation() {
    return aggregateReservation_ == null
        ? com.google.cloud.compute.v1.AllocationAggregateReservation.getDefaultInstance()
        : aggregateReservation_;
  }

  /**
   *
   *
   * <pre>
   * Reservation for aggregated resources, providing shape flexibility.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservationOrBuilder
      getAggregateReservationOrBuilder() {
    return aggregateReservation_ == null
        ? com.google.cloud.compute.v1.AllocationAggregateReservation.getDefaultInstance()
        : aggregateReservation_;
  }

  public static final int COMMITMENT_FIELD_NUMBER = 482134805;

  @SuppressWarnings("serial")
  private volatile java.lang.Object commitment_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
   * </pre>
   *
   * <code>optional string commitment = 482134805;</code>
   *
   * @return Whether the commitment field is set.
   */
  @java.lang.Override
  public boolean hasCommitment() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
   * </pre>
   *
   * <code>optional string commitment = 482134805;</code>
   *
   * @return The commitment.
   */
  @java.lang.Override
  public java.lang.String getCommitment() {
    java.lang.Object ref = commitment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      commitment_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
   * </pre>
   *
   * <code>optional string commitment = 482134805;</code>
   *
   * @return The bytes for commitment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommitmentBytes() {
    java.lang.Object ref = commitment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      commitment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_AFTER_DURATION_FIELD_NUMBER = 323997099;
  private com.google.cloud.compute.v1.Duration deleteAfterDuration_;

  /**
   *
   *
   * <pre>
   * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
   *
   * @return Whether the deleteAfterDuration field is set.
   */
  @java.lang.Override
  public boolean hasDeleteAfterDuration() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
   *
   * @return The deleteAfterDuration.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getDeleteAfterDuration() {
    return deleteAfterDuration_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : deleteAfterDuration_;
  }

  /**
   *
   *
   * <pre>
   * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getDeleteAfterDurationOrBuilder() {
    return deleteAfterDuration_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : deleteAfterDuration_;
  }

  public static final int DELETE_AT_TIME_FIELD_NUMBER = 83294405;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deleteAtTime_ = "";

  /**
   *
   *
   * <pre>
   * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
   * </pre>
   *
   * <code>optional string delete_at_time = 83294405;</code>
   *
   * @return Whether the deleteAtTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteAtTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
   * </pre>
   *
   * <code>optional string delete_at_time = 83294405;</code>
   *
   * @return The deleteAtTime.
   */
  @java.lang.Override
  public java.lang.String getDeleteAtTime() {
    java.lang.Object ref = deleteAtTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deleteAtTime_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
   * </pre>
   *
   * <code>optional string delete_at_time = 83294405;</code>
   *
   * @return The bytes for deleteAtTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeleteAtTimeBytes() {
    java.lang.Object ref = deleteAtTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deleteAtTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYMENT_TYPE_FIELD_NUMBER = 396722292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deploymentType_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the deployment strategy for this reservation.
   * Check the DeploymentType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string deployment_type = 396722292;</code>
   *
   * @return Whether the deploymentType field is set.
   */
  @java.lang.Override
  public boolean hasDeploymentType() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the deployment strategy for this reservation.
   * Check the DeploymentType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string deployment_type = 396722292;</code>
   *
   * @return The deploymentType.
   */
  @java.lang.Override
  public java.lang.String getDeploymentType() {
    java.lang.Object ref = deploymentType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deploymentType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the deployment strategy for this reservation.
   * Check the DeploymentType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string deployment_type = 396722292;</code>
   *
   * @return The bytes for deploymentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeploymentTypeBytes() {
    java.lang.Object ref = deploymentType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deploymentType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_EMERGENT_MAINTENANCE_FIELD_NUMBER = 353759497;
  private boolean enableEmergentMaintenance_ = false;

  /**
   *
   *
   * <pre>
   * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
   * </pre>
   *
   * <code>optional bool enable_emergent_maintenance = 353759497;</code>
   *
   * @return Whether the enableEmergentMaintenance field is set.
   */
  @java.lang.Override
  public boolean hasEnableEmergentMaintenance() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
   * </pre>
   *
   * <code>optional bool enable_emergent_maintenance = 353759497;</code>
   *
   * @return The enableEmergentMaintenance.
   */
  @java.lang.Override
  public boolean getEnableEmergentMaintenance() {
    return enableEmergentMaintenance_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#reservations for reservations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#reservations for reservations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#reservations for reservations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_COMMITMENTS_FIELD_NUMBER = 470957784;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList linkedCommitments_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
   * </pre>
   *
   * <code>repeated string linked_commitments = 470957784;</code>
   *
   * @return A list containing the linkedCommitments.
   */
  public com.google.protobuf.ProtocolStringList getLinkedCommitmentsList() {
    return linkedCommitments_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
   * </pre>
   *
   * <code>repeated string linked_commitments = 470957784;</code>
   *
   * @return The count of linkedCommitments.
   */
  public int getLinkedCommitmentsCount() {
    return linkedCommitments_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
   * </pre>
   *
   * <code>repeated string linked_commitments = 470957784;</code>
   *
   * @param index The index of the element to return.
   * @return The linkedCommitments at the given index.
   */
  public java.lang.String getLinkedCommitments(int index) {
    return linkedCommitments_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
   * </pre>
   *
   * <code>repeated string linked_commitments = 470957784;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the linkedCommitments at the given index.
   */
  public com.google.protobuf.ByteString getLinkedCommitmentsBytes(int index) {
    return linkedCommitments_.getByteString(index);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATION_SHARING_POLICY_FIELD_NUMBER = 205970120;
  private com.google.cloud.compute.v1.AllocationReservationSharingPolicy reservationSharingPolicy_;

  /**
   *
   *
   * <pre>
   * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
   * </code>
   *
   * @return Whether the reservationSharingPolicy field is set.
   */
  @java.lang.Override
  public boolean hasReservationSharingPolicy() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
   * </code>
   *
   * @return The reservationSharingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationReservationSharingPolicy
      getReservationSharingPolicy() {
    return reservationSharingPolicy_ == null
        ? com.google.cloud.compute.v1.AllocationReservationSharingPolicy.getDefaultInstance()
        : reservationSharingPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationReservationSharingPolicyOrBuilder
      getReservationSharingPolicyOrBuilder() {
    return reservationSharingPolicy_ == null
        ? com.google.cloud.compute.v1.AllocationReservationSharingPolicy.getDefaultInstance()
        : reservationSharingPolicy_;
  }

  public static final int RESOURCE_POLICIES_FIELD_NUMBER = 22220385;

  private static final class ResourcePoliciesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_Reservation_ResourcePoliciesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourcePolicies_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourcePolicies() {
    if (resourcePolicies_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourcePoliciesDefaultEntryHolder.defaultEntry);
    }
    return resourcePolicies_;
  }

  public int getResourcePoliciesCount() {
    return internalGetResourcePolicies().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
   */
  @java.lang.Override
  public boolean containsResourcePolicies(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourcePolicies().getMap().containsKey(key);
  }

  /** Use {@link #getResourcePoliciesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourcePolicies() {
    return getResourcePoliciesMap();
  }

  /**
   *
   *
   * <pre>
   * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourcePoliciesMap() {
    return internalGetResourcePolicies().getMap();
  }

  /**
   *
   *
   * <pre>
   * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourcePoliciesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourcePolicies().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
   */
  @java.lang.Override
  public java.lang.String getResourcePoliciesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourcePolicies().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESOURCE_STATUS_FIELD_NUMBER = 249429315;
  private com.google.cloud.compute.v1.AllocationResourceStatus resourceStatus_;

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for Reservation resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
   * </code>
   *
   * @return Whether the resourceStatus field is set.
   */
  @java.lang.Override
  public boolean hasResourceStatus() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for Reservation resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
   * </code>
   *
   * @return The resourceStatus.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationResourceStatus getResourceStatus() {
    return resourceStatus_ == null
        ? com.google.cloud.compute.v1.AllocationResourceStatus.getDefaultInstance()
        : resourceStatus_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for Reservation resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationResourceStatusOrBuilder
      getResourceStatusOrBuilder() {
    return resourceStatus_ == null
        ? com.google.cloud.compute.v1.AllocationResourceStatus.getDefaultInstance()
        : resourceStatus_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 480964267;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SCHEDULING_TYPE_FIELD_NUMBER = 199835397;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedulingType_ = "";

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * Check the SchedulingType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string scheduling_type = 199835397;</code>
   *
   * @return Whether the schedulingType field is set.
   */
  @java.lang.Override
  public boolean hasSchedulingType() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * Check the SchedulingType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string scheduling_type = 199835397;</code>
   *
   * @return The schedulingType.
   */
  @java.lang.Override
  public java.lang.String getSchedulingType() {
    java.lang.Object ref = schedulingType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedulingType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * Check the SchedulingType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string scheduling_type = 199835397;</code>
   *
   * @return The bytes for schedulingType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchedulingTypeBytes() {
    java.lang.Object ref = schedulingType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedulingType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHARE_SETTINGS_FIELD_NUMBER = 266668163;
  private com.google.cloud.compute.v1.ShareSettings shareSettings_;

  /**
   *
   *
   * <pre>
   * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
   *
   * @return Whether the shareSettings field is set.
   */
  @java.lang.Override
  public boolean hasShareSettings() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
   *
   * @return The shareSettings.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShareSettings getShareSettings() {
    return shareSettings_ == null
        ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
        : shareSettings_;
  }

  /**
   *
   *
   * <pre>
   * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShareSettingsOrBuilder getShareSettingsOrBuilder() {
    return shareSettings_ == null
        ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
        : shareSettings_;
  }

  public static final int SPECIFIC_RESERVATION_FIELD_NUMBER = 404901951;
  private com.google.cloud.compute.v1.AllocationSpecificSKUReservation specificReservation_;

  /**
   *
   *
   * <pre>
   * Reservation for instances with specific machine shapes.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
   * </code>
   *
   * @return Whether the specificReservation field is set.
   */
  @java.lang.Override
  public boolean hasSpecificReservation() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Reservation for instances with specific machine shapes.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
   * </code>
   *
   * @return The specificReservation.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationSpecificSKUReservation getSpecificReservation() {
    return specificReservation_ == null
        ? com.google.cloud.compute.v1.AllocationSpecificSKUReservation.getDefaultInstance()
        : specificReservation_;
  }

  /**
   *
   *
   * <pre>
   * Reservation for instances with specific machine shapes.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationSpecificSKUReservationOrBuilder
      getSpecificReservationOrBuilder() {
    return specificReservation_ == null
        ? com.google.cloud.compute.v1.AllocationSpecificSKUReservation.getDefaultInstance()
        : specificReservation_;
  }

  public static final int SPECIFIC_RESERVATION_REQUIRED_FIELD_NUMBER = 226550687;
  private boolean specificReservationRequired_ = false;

  /**
   *
   *
   * <pre>
   * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
   * </pre>
   *
   * <code>optional bool specific_reservation_required = 226550687;</code>
   *
   * @return Whether the specificReservationRequired field is set.
   */
  @java.lang.Override
  public boolean hasSpecificReservationRequired() {
    return ((bitField0_ & 0x00080000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
   * </pre>
   *
   * <code>optional bool specific_reservation_required = 226550687;</code>
   *
   * @return The specificReservationRequired.
   */
  @java.lang.Override
  public boolean getSpecificReservationRequired() {
    return specificReservationRequired_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00100000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00200000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetResourcePolicies(),
        ResourcePoliciesDefaultEntryHolder.defaultEntry,
        22220385);
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 83294405, deleteAtTime_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 199835397, schedulingType_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(205970120, getReservationSharingPolicy());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeBool(226550687, specificReservationRequired_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(249429315, getResourceStatus());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(266668163, getShareSettings());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(291567948, getAggregateReservation());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(323997099, getDeleteAfterDuration());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeBool(353759497, enableEmergentMaintenance_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 396722292, deploymentType_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(404901951, getSpecificReservation());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(410618144, getAdvancedDeploymentControl());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < linkedCommitments_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 470957784, linkedCommitments_.getRaw(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeBool(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 482134805, commitment_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourcePolicies().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourcePolicies__ =
          ResourcePoliciesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(22220385, resourcePolicies__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(83294405, deleteAtTime_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(199835397, schedulingType_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              205970120, getReservationSharingPolicy());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              226550687, specificReservationRequired_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(249429315, getResourceStatus());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(266668163, getShareSettings());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              291567948, getAggregateReservation());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              323997099, getDeleteAfterDuration());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              353759497, enableEmergentMaintenance_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(396722292, deploymentType_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              404901951, getSpecificReservation());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              410618144, getAdvancedDeploymentControl());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < linkedCommitments_.size(); i++) {
        dataSize += computeStringSizeNoTag(linkedCommitments_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getLinkedCommitmentsList().size();
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(482134805, commitment_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Reservation)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Reservation other = (com.google.cloud.compute.v1.Reservation) obj;

    if (hasAdvancedDeploymentControl() != other.hasAdvancedDeploymentControl()) return false;
    if (hasAdvancedDeploymentControl()) {
      if (!getAdvancedDeploymentControl().equals(other.getAdvancedDeploymentControl()))
        return false;
    }
    if (hasAggregateReservation() != other.hasAggregateReservation()) return false;
    if (hasAggregateReservation()) {
      if (!getAggregateReservation().equals(other.getAggregateReservation())) return false;
    }
    if (hasCommitment() != other.hasCommitment()) return false;
    if (hasCommitment()) {
      if (!getCommitment().equals(other.getCommitment())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDeleteAfterDuration() != other.hasDeleteAfterDuration()) return false;
    if (hasDeleteAfterDuration()) {
      if (!getDeleteAfterDuration().equals(other.getDeleteAfterDuration())) return false;
    }
    if (hasDeleteAtTime() != other.hasDeleteAtTime()) return false;
    if (hasDeleteAtTime()) {
      if (!getDeleteAtTime().equals(other.getDeleteAtTime())) return false;
    }
    if (hasDeploymentType() != other.hasDeploymentType()) return false;
    if (hasDeploymentType()) {
      if (!getDeploymentType().equals(other.getDeploymentType())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEnableEmergentMaintenance() != other.hasEnableEmergentMaintenance()) return false;
    if (hasEnableEmergentMaintenance()) {
      if (getEnableEmergentMaintenance() != other.getEnableEmergentMaintenance()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (!getLinkedCommitmentsList().equals(other.getLinkedCommitmentsList())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasReservationSharingPolicy() != other.hasReservationSharingPolicy()) return false;
    if (hasReservationSharingPolicy()) {
      if (!getReservationSharingPolicy().equals(other.getReservationSharingPolicy())) return false;
    }
    if (!internalGetResourcePolicies().equals(other.internalGetResourcePolicies())) return false;
    if (hasResourceStatus() != other.hasResourceStatus()) return false;
    if (hasResourceStatus()) {
      if (!getResourceStatus().equals(other.getResourceStatus())) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasSchedulingType() != other.hasSchedulingType()) return false;
    if (hasSchedulingType()) {
      if (!getSchedulingType().equals(other.getSchedulingType())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasShareSettings() != other.hasShareSettings()) return false;
    if (hasShareSettings()) {
      if (!getShareSettings().equals(other.getShareSettings())) return false;
    }
    if (hasSpecificReservation() != other.hasSpecificReservation()) return false;
    if (hasSpecificReservation()) {
      if (!getSpecificReservation().equals(other.getSpecificReservation())) return false;
    }
    if (hasSpecificReservationRequired() != other.hasSpecificReservationRequired()) return false;
    if (hasSpecificReservationRequired()) {
      if (getSpecificReservationRequired() != other.getSpecificReservationRequired()) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdvancedDeploymentControl()) {
      hash = (37 * hash) + ADVANCED_DEPLOYMENT_CONTROL_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedDeploymentControl().hashCode();
    }
    if (hasAggregateReservation()) {
      hash = (37 * hash) + AGGREGATE_RESERVATION_FIELD_NUMBER;
      hash = (53 * hash) + getAggregateReservation().hashCode();
    }
    if (hasCommitment()) {
      hash = (37 * hash) + COMMITMENT_FIELD_NUMBER;
      hash = (53 * hash) + getCommitment().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDeleteAfterDuration()) {
      hash = (37 * hash) + DELETE_AFTER_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteAfterDuration().hashCode();
    }
    if (hasDeleteAtTime()) {
      hash = (37 * hash) + DELETE_AT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteAtTime().hashCode();
    }
    if (hasDeploymentType()) {
      hash = (37 * hash) + DEPLOYMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getDeploymentType().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEnableEmergentMaintenance()) {
      hash = (37 * hash) + ENABLE_EMERGENT_MAINTENANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableEmergentMaintenance());
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (getLinkedCommitmentsCount() > 0) {
      hash = (37 * hash) + LINKED_COMMITMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedCommitmentsList().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasReservationSharingPolicy()) {
      hash = (37 * hash) + RESERVATION_SHARING_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getReservationSharingPolicy().hashCode();
    }
    if (!internalGetResourcePolicies().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourcePolicies().hashCode();
    }
    if (hasResourceStatus()) {
      hash = (37 * hash) + RESOURCE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceStatus().hashCode();
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasSchedulingType()) {
      hash = (37 * hash) + SCHEDULING_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getSchedulingType().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasShareSettings()) {
      hash = (37 * hash) + SHARE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getShareSettings().hashCode();
    }
    if (hasSpecificReservation()) {
      hash = (37 * hash) + SPECIFIC_RESERVATION_FIELD_NUMBER;
      hash = (53 * hash) + getSpecificReservation().hashCode();
    }
    if (hasSpecificReservationRequired()) {
      hash = (37 * hash) + SPECIFIC_RESERVATION_REQUIRED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSpecificReservationRequired());
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Reservation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Reservation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Reservation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Reservation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read Reserving zonal resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Reservation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Reservation)
      com.google.cloud.compute.v1.ReservationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Reservation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 22220385:
          return internalGetResourcePolicies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 22220385:
          return internalGetMutableResourcePolicies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Reservation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Reservation.class,
              com.google.cloud.compute.v1.Reservation.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Reservation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdvancedDeploymentControlFieldBuilder();
        getAggregateReservationFieldBuilder();
        getDeleteAfterDurationFieldBuilder();
        getReservationSharingPolicyFieldBuilder();
        getResourceStatusFieldBuilder();
        getShareSettingsFieldBuilder();
        getSpecificReservationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      advancedDeploymentControl_ = null;
      if (advancedDeploymentControlBuilder_ != null) {
        advancedDeploymentControlBuilder_.dispose();
        advancedDeploymentControlBuilder_ = null;
      }
      aggregateReservation_ = null;
      if (aggregateReservationBuilder_ != null) {
        aggregateReservationBuilder_.dispose();
        aggregateReservationBuilder_ = null;
      }
      commitment_ = "";
      creationTimestamp_ = "";
      deleteAfterDuration_ = null;
      if (deleteAfterDurationBuilder_ != null) {
        deleteAfterDurationBuilder_.dispose();
        deleteAfterDurationBuilder_ = null;
      }
      deleteAtTime_ = "";
      deploymentType_ = "";
      description_ = "";
      enableEmergentMaintenance_ = false;
      id_ = 0L;
      kind_ = "";
      linkedCommitments_ = com.google.protobuf.LazyStringArrayList.emptyList();
      name_ = "";
      reservationSharingPolicy_ = null;
      if (reservationSharingPolicyBuilder_ != null) {
        reservationSharingPolicyBuilder_.dispose();
        reservationSharingPolicyBuilder_ = null;
      }
      internalGetMutableResourcePolicies().clear();
      resourceStatus_ = null;
      if (resourceStatusBuilder_ != null) {
        resourceStatusBuilder_.dispose();
        resourceStatusBuilder_ = null;
      }
      satisfiesPzs_ = false;
      schedulingType_ = "";
      selfLink_ = "";
      shareSettings_ = null;
      if (shareSettingsBuilder_ != null) {
        shareSettingsBuilder_.dispose();
        shareSettingsBuilder_ = null;
      }
      specificReservation_ = null;
      if (specificReservationBuilder_ != null) {
        specificReservationBuilder_.dispose();
        specificReservationBuilder_ = null;
      }
      specificReservationRequired_ = false;
      status_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Reservation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Reservation getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Reservation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Reservation build() {
      com.google.cloud.compute.v1.Reservation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Reservation buildPartial() {
      com.google.cloud.compute.v1.Reservation result =
          new com.google.cloud.compute.v1.Reservation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.Reservation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.advancedDeploymentControl_ =
            advancedDeploymentControlBuilder_ == null
                ? advancedDeploymentControl_
                : advancedDeploymentControlBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.aggregateReservation_ =
            aggregateReservationBuilder_ == null
                ? aggregateReservation_
                : aggregateReservationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.commitment_ = commitment_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deleteAfterDuration_ =
            deleteAfterDurationBuilder_ == null
                ? deleteAfterDuration_
                : deleteAfterDurationBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.deleteAtTime_ = deleteAtTime_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.deploymentType_ = deploymentType_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.enableEmergentMaintenance_ = enableEmergentMaintenance_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        linkedCommitments_.makeImmutable();
        result.linkedCommitments_ = linkedCommitments_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.reservationSharingPolicy_ =
            reservationSharingPolicyBuilder_ == null
                ? reservationSharingPolicy_
                : reservationSharingPolicyBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.resourcePolicies_ = internalGetResourcePolicies();
        result.resourcePolicies_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.resourceStatus_ =
            resourceStatusBuilder_ == null ? resourceStatus_ : resourceStatusBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.schedulingType_ = schedulingType_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.shareSettings_ =
            shareSettingsBuilder_ == null ? shareSettings_ : shareSettingsBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.specificReservation_ =
            specificReservationBuilder_ == null
                ? specificReservation_
                : specificReservationBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.specificReservationRequired_ = specificReservationRequired_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00200000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Reservation) {
        return mergeFrom((com.google.cloud.compute.v1.Reservation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Reservation other) {
      if (other == com.google.cloud.compute.v1.Reservation.getDefaultInstance()) return this;
      if (other.hasAdvancedDeploymentControl()) {
        mergeAdvancedDeploymentControl(other.getAdvancedDeploymentControl());
      }
      if (other.hasAggregateReservation()) {
        mergeAggregateReservation(other.getAggregateReservation());
      }
      if (other.hasCommitment()) {
        commitment_ = other.commitment_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDeleteAfterDuration()) {
        mergeDeleteAfterDuration(other.getDeleteAfterDuration());
      }
      if (other.hasDeleteAtTime()) {
        deleteAtTime_ = other.deleteAtTime_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasDeploymentType()) {
        deploymentType_ = other.deploymentType_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasEnableEmergentMaintenance()) {
        setEnableEmergentMaintenance(other.getEnableEmergentMaintenance());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.linkedCommitments_.isEmpty()) {
        if (linkedCommitments_.isEmpty()) {
          linkedCommitments_ = other.linkedCommitments_;
          bitField0_ |= 0x00000800;
        } else {
          ensureLinkedCommitmentsIsMutable();
          linkedCommitments_.addAll(other.linkedCommitments_);
        }
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasReservationSharingPolicy()) {
        mergeReservationSharingPolicy(other.getReservationSharingPolicy());
      }
      internalGetMutableResourcePolicies().mergeFrom(other.internalGetResourcePolicies());
      bitField0_ |= 0x00004000;
      if (other.hasResourceStatus()) {
        mergeResourceStatus(other.getResourceStatus());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasSchedulingType()) {
        schedulingType_ = other.schedulingType_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasShareSettings()) {
        mergeShareSettings(other.getShareSettings());
      }
      if (other.hasSpecificReservation()) {
        mergeSpecificReservation(other.getSpecificReservation());
      }
      if (other.hasSpecificReservationRequired()) {
        setSpecificReservationRequired(other.getSpecificReservationRequired());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 26989658
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 29957474
            case 177763082:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    resourcePolicies__ =
                        input.readMessage(
                            ResourcePoliciesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableResourcePolicies()
                    .getMutableMap()
                    .put(resourcePolicies__.getKey(), resourcePolicies__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 177763082
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 244202930
            case 666355242:
              {
                deleteAtTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 666355242
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 1450082194
            case 1598683178:
              {
                schedulingType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 1598683178
            case 1647760962:
              {
                input.readMessage(
                    getReservationSharingPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 1647760962
            case 1812405496:
              {
                specificReservationRequired_ = input.readBool();
                bitField0_ |= 0x00200000;
                break;
              } // case 1812405496
            case 1995434522:
              {
                input.readMessage(getResourceStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 1995434522
            case 2133345306:
              {
                input.readMessage(getShareSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 2133345306
            case -1962423710:
              {
                input.readMessage(
                    getAggregateReservationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1962423710
            case -1702990502:
              {
                input.readMessage(
                    getDeleteAfterDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -1702990502
            case -1464891320:
              {
                enableEmergentMaintenance_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case -1464891320
            case -1121188958:
              {
                deploymentType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -1121188958
            case -1055751686:
              {
                input.readMessage(
                    getSpecificReservationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case -1055751686
            case -1010022142:
              {
                input.readMessage(
                    getAdvancedDeploymentControlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1010022142
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -645248918
            case -527305022:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLinkedCommitmentsIsMutable();
                linkedCommitments_.add(s);
                break;
              } // case -527305022
            case -447253160:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case -447253160
            case -437888854:
              {
                commitment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -437888854
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl
        advancedDeploymentControl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl,
            com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.Builder,
            com.google.cloud.compute.v1.ReservationAdvancedDeploymentControlOrBuilder>
        advancedDeploymentControlBuilder_;

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     *
     * @return Whether the advancedDeploymentControl field is set.
     */
    public boolean hasAdvancedDeploymentControl() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     *
     * @return The advancedDeploymentControl.
     */
    public com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl
        getAdvancedDeploymentControl() {
      if (advancedDeploymentControlBuilder_ == null) {
        return advancedDeploymentControl_ == null
            ? com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.getDefaultInstance()
            : advancedDeploymentControl_;
      } else {
        return advancedDeploymentControlBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    public Builder setAdvancedDeploymentControl(
        com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl value) {
      if (advancedDeploymentControlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedDeploymentControl_ = value;
      } else {
        advancedDeploymentControlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    public Builder setAdvancedDeploymentControl(
        com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.Builder builderForValue) {
      if (advancedDeploymentControlBuilder_ == null) {
        advancedDeploymentControl_ = builderForValue.build();
      } else {
        advancedDeploymentControlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    public Builder mergeAdvancedDeploymentControl(
        com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl value) {
      if (advancedDeploymentControlBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && advancedDeploymentControl_ != null
            && advancedDeploymentControl_
                != com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl
                    .getDefaultInstance()) {
          getAdvancedDeploymentControlBuilder().mergeFrom(value);
        } else {
          advancedDeploymentControl_ = value;
        }
      } else {
        advancedDeploymentControlBuilder_.mergeFrom(value);
      }
      if (advancedDeploymentControl_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    public Builder clearAdvancedDeploymentControl() {
      bitField0_ = (bitField0_ & ~0x00000001);
      advancedDeploymentControl_ = null;
      if (advancedDeploymentControlBuilder_ != null) {
        advancedDeploymentControlBuilder_.dispose();
        advancedDeploymentControlBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.Builder
        getAdvancedDeploymentControlBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAdvancedDeploymentControlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationAdvancedDeploymentControlOrBuilder
        getAdvancedDeploymentControlOrBuilder() {
      if (advancedDeploymentControlBuilder_ != null) {
        return advancedDeploymentControlBuilder_.getMessageOrBuilder();
      } else {
        return advancedDeploymentControl_ == null
            ? com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.getDefaultInstance()
            : advancedDeploymentControl_;
      }
    }

    /**
     *
     *
     * <pre>
     * Advanced control for cluster management, applicable only to DENSE deployment type reservations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ReservationAdvancedDeploymentControl advanced_deployment_control = 410618144;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl,
            com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.Builder,
            com.google.cloud.compute.v1.ReservationAdvancedDeploymentControlOrBuilder>
        getAdvancedDeploymentControlFieldBuilder() {
      if (advancedDeploymentControlBuilder_ == null) {
        advancedDeploymentControlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl,
                com.google.cloud.compute.v1.ReservationAdvancedDeploymentControl.Builder,
                com.google.cloud.compute.v1.ReservationAdvancedDeploymentControlOrBuilder>(
                getAdvancedDeploymentControl(), getParentForChildren(), isClean());
        advancedDeploymentControl_ = null;
      }
      return advancedDeploymentControlBuilder_;
    }

    private com.google.cloud.compute.v1.AllocationAggregateReservation aggregateReservation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationAggregateReservation,
            com.google.cloud.compute.v1.AllocationAggregateReservation.Builder,
            com.google.cloud.compute.v1.AllocationAggregateReservationOrBuilder>
        aggregateReservationBuilder_;

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     *
     * @return Whether the aggregateReservation field is set.
     */
    public boolean hasAggregateReservation() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     *
     * @return The aggregateReservation.
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservation getAggregateReservation() {
      if (aggregateReservationBuilder_ == null) {
        return aggregateReservation_ == null
            ? com.google.cloud.compute.v1.AllocationAggregateReservation.getDefaultInstance()
            : aggregateReservation_;
      } else {
        return aggregateReservationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    public Builder setAggregateReservation(
        com.google.cloud.compute.v1.AllocationAggregateReservation value) {
      if (aggregateReservationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregateReservation_ = value;
      } else {
        aggregateReservationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    public Builder setAggregateReservation(
        com.google.cloud.compute.v1.AllocationAggregateReservation.Builder builderForValue) {
      if (aggregateReservationBuilder_ == null) {
        aggregateReservation_ = builderForValue.build();
      } else {
        aggregateReservationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    public Builder mergeAggregateReservation(
        com.google.cloud.compute.v1.AllocationAggregateReservation value) {
      if (aggregateReservationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && aggregateReservation_ != null
            && aggregateReservation_
                != com.google.cloud.compute.v1.AllocationAggregateReservation
                    .getDefaultInstance()) {
          getAggregateReservationBuilder().mergeFrom(value);
        } else {
          aggregateReservation_ = value;
        }
      } else {
        aggregateReservationBuilder_.mergeFrom(value);
      }
      if (aggregateReservation_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    public Builder clearAggregateReservation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      aggregateReservation_ = null;
      if (aggregateReservationBuilder_ != null) {
        aggregateReservationBuilder_.dispose();
        aggregateReservationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservation.Builder
        getAggregateReservationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAggregateReservationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationOrBuilder
        getAggregateReservationOrBuilder() {
      if (aggregateReservationBuilder_ != null) {
        return aggregateReservationBuilder_.getMessageOrBuilder();
      } else {
        return aggregateReservation_ == null
            ? com.google.cloud.compute.v1.AllocationAggregateReservation.getDefaultInstance()
            : aggregateReservation_;
      }
    }

    /**
     *
     *
     * <pre>
     * Reservation for aggregated resources, providing shape flexibility.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationAggregateReservation aggregate_reservation = 291567948;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationAggregateReservation,
            com.google.cloud.compute.v1.AllocationAggregateReservation.Builder,
            com.google.cloud.compute.v1.AllocationAggregateReservationOrBuilder>
        getAggregateReservationFieldBuilder() {
      if (aggregateReservationBuilder_ == null) {
        aggregateReservationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AllocationAggregateReservation,
                com.google.cloud.compute.v1.AllocationAggregateReservation.Builder,
                com.google.cloud.compute.v1.AllocationAggregateReservationOrBuilder>(
                getAggregateReservation(), getParentForChildren(), isClean());
        aggregateReservation_ = null;
      }
      return aggregateReservationBuilder_;
    }

    private java.lang.Object commitment_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
     * </pre>
     *
     * <code>optional string commitment = 482134805;</code>
     *
     * @return Whether the commitment field is set.
     */
    public boolean hasCommitment() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
     * </pre>
     *
     * <code>optional string commitment = 482134805;</code>
     *
     * @return The commitment.
     */
    public java.lang.String getCommitment() {
      java.lang.Object ref = commitment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        commitment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
     * </pre>
     *
     * <code>optional string commitment = 482134805;</code>
     *
     * @return The bytes for commitment.
     */
    public com.google.protobuf.ByteString getCommitmentBytes() {
      java.lang.Object ref = commitment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        commitment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
     * </pre>
     *
     * <code>optional string commitment = 482134805;</code>
     *
     * @param value The commitment to set.
     * @return This builder for chaining.
     */
    public Builder setCommitment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      commitment_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
     * </pre>
     *
     * <code>optional string commitment = 482134805;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitment() {
      commitment_ = getDefaultInstance().getCommitment();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
     * </pre>
     *
     * <code>optional string commitment = 482134805;</code>
     *
     * @param value The bytes for commitment to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      commitment_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Duration deleteAfterDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        deleteAfterDurationBuilder_;

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     *
     * @return Whether the deleteAfterDuration field is set.
     */
    public boolean hasDeleteAfterDuration() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     *
     * @return The deleteAfterDuration.
     */
    public com.google.cloud.compute.v1.Duration getDeleteAfterDuration() {
      if (deleteAfterDurationBuilder_ == null) {
        return deleteAfterDuration_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : deleteAfterDuration_;
      } else {
        return deleteAfterDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    public Builder setDeleteAfterDuration(com.google.cloud.compute.v1.Duration value) {
      if (deleteAfterDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteAfterDuration_ = value;
      } else {
        deleteAfterDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    public Builder setDeleteAfterDuration(
        com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (deleteAfterDurationBuilder_ == null) {
        deleteAfterDuration_ = builderForValue.build();
      } else {
        deleteAfterDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    public Builder mergeDeleteAfterDuration(com.google.cloud.compute.v1.Duration value) {
      if (deleteAfterDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && deleteAfterDuration_ != null
            && deleteAfterDuration_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getDeleteAfterDurationBuilder().mergeFrom(value);
        } else {
          deleteAfterDuration_ = value;
        }
      } else {
        deleteAfterDurationBuilder_.mergeFrom(value);
      }
      if (deleteAfterDuration_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    public Builder clearDeleteAfterDuration() {
      bitField0_ = (bitField0_ & ~0x00000010);
      deleteAfterDuration_ = null;
      if (deleteAfterDurationBuilder_ != null) {
        deleteAfterDurationBuilder_.dispose();
        deleteAfterDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getDeleteAfterDurationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDeleteAfterDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getDeleteAfterDurationOrBuilder() {
      if (deleteAfterDurationBuilder_ != null) {
        return deleteAfterDurationBuilder_.getMessageOrBuilder();
      } else {
        return deleteAfterDuration_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : deleteAfterDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration delete_after_duration = 323997099;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getDeleteAfterDurationFieldBuilder() {
      if (deleteAfterDurationBuilder_ == null) {
        deleteAfterDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getDeleteAfterDuration(), getParentForChildren(), isClean());
        deleteAfterDuration_ = null;
      }
      return deleteAfterDurationBuilder_;
    }

    private java.lang.Object deleteAtTime_ = "";

    /**
     *
     *
     * <pre>
     * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
     * </pre>
     *
     * <code>optional string delete_at_time = 83294405;</code>
     *
     * @return Whether the deleteAtTime field is set.
     */
    public boolean hasDeleteAtTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
     * </pre>
     *
     * <code>optional string delete_at_time = 83294405;</code>
     *
     * @return The deleteAtTime.
     */
    public java.lang.String getDeleteAtTime() {
      java.lang.Object ref = deleteAtTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deleteAtTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
     * </pre>
     *
     * <code>optional string delete_at_time = 83294405;</code>
     *
     * @return The bytes for deleteAtTime.
     */
    public com.google.protobuf.ByteString getDeleteAtTimeBytes() {
      java.lang.Object ref = deleteAtTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deleteAtTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
     * </pre>
     *
     * <code>optional string delete_at_time = 83294405;</code>
     *
     * @param value The deleteAtTime to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteAtTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deleteAtTime_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
     * </pre>
     *
     * <code>optional string delete_at_time = 83294405;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleteAtTime() {
      deleteAtTime_ = getDefaultInstance().getDeleteAtTime();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
     * </pre>
     *
     * <code>optional string delete_at_time = 83294405;</code>
     *
     * @param value The bytes for deleteAtTime to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteAtTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deleteAtTime_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object deploymentType_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the deployment strategy for this reservation.
     * Check the DeploymentType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string deployment_type = 396722292;</code>
     *
     * @return Whether the deploymentType field is set.
     */
    public boolean hasDeploymentType() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the deployment strategy for this reservation.
     * Check the DeploymentType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string deployment_type = 396722292;</code>
     *
     * @return The deploymentType.
     */
    public java.lang.String getDeploymentType() {
      java.lang.Object ref = deploymentType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deploymentType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the deployment strategy for this reservation.
     * Check the DeploymentType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string deployment_type = 396722292;</code>
     *
     * @return The bytes for deploymentType.
     */
    public com.google.protobuf.ByteString getDeploymentTypeBytes() {
      java.lang.Object ref = deploymentType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deploymentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the deployment strategy for this reservation.
     * Check the DeploymentType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string deployment_type = 396722292;</code>
     *
     * @param value The deploymentType to set.
     * @return This builder for chaining.
     */
    public Builder setDeploymentType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deploymentType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the deployment strategy for this reservation.
     * Check the DeploymentType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string deployment_type = 396722292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeploymentType() {
      deploymentType_ = getDefaultInstance().getDeploymentType();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the deployment strategy for this reservation.
     * Check the DeploymentType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string deployment_type = 396722292;</code>
     *
     * @param value The bytes for deploymentType to set.
     * @return This builder for chaining.
     */
    public Builder setDeploymentTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deploymentType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean enableEmergentMaintenance_;

    /**
     *
     *
     * <pre>
     * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
     * </pre>
     *
     * <code>optional bool enable_emergent_maintenance = 353759497;</code>
     *
     * @return Whether the enableEmergentMaintenance field is set.
     */
    @java.lang.Override
    public boolean hasEnableEmergentMaintenance() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
     * </pre>
     *
     * <code>optional bool enable_emergent_maintenance = 353759497;</code>
     *
     * @return The enableEmergentMaintenance.
     */
    @java.lang.Override
    public boolean getEnableEmergentMaintenance() {
      return enableEmergentMaintenance_;
    }

    /**
     *
     *
     * <pre>
     * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
     * </pre>
     *
     * <code>optional bool enable_emergent_maintenance = 353759497;</code>
     *
     * @param value The enableEmergentMaintenance to set.
     * @return This builder for chaining.
     */
    public Builder setEnableEmergentMaintenance(boolean value) {

      enableEmergentMaintenance_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
     * </pre>
     *
     * <code>optional bool enable_emergent_maintenance = 353759497;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableEmergentMaintenance() {
      bitField0_ = (bitField0_ & ~0x00000100);
      enableEmergentMaintenance_ = false;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000200);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservations for reservations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservations for reservations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservations for reservations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservations for reservations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservations for reservations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#reservations for reservations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList linkedCommitments_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLinkedCommitmentsIsMutable() {
      if (!linkedCommitments_.isModifiable()) {
        linkedCommitments_ = new com.google.protobuf.LazyStringArrayList(linkedCommitments_);
      }
      bitField0_ |= 0x00000800;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @return A list containing the linkedCommitments.
     */
    public com.google.protobuf.ProtocolStringList getLinkedCommitmentsList() {
      linkedCommitments_.makeImmutable();
      return linkedCommitments_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @return The count of linkedCommitments.
     */
    public int getLinkedCommitmentsCount() {
      return linkedCommitments_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @param index The index of the element to return.
     * @return The linkedCommitments at the given index.
     */
    public java.lang.String getLinkedCommitments(int index) {
      return linkedCommitments_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the linkedCommitments at the given index.
     */
    public com.google.protobuf.ByteString getLinkedCommitmentsBytes(int index) {
      return linkedCommitments_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @param index The index to set the value at.
     * @param value The linkedCommitments to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedCommitments(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLinkedCommitmentsIsMutable();
      linkedCommitments_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @param value The linkedCommitments to add.
     * @return This builder for chaining.
     */
    public Builder addLinkedCommitments(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLinkedCommitmentsIsMutable();
      linkedCommitments_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @param values The linkedCommitments to add.
     * @return This builder for chaining.
     */
    public Builder addAllLinkedCommitments(java.lang.Iterable<java.lang.String> values) {
      ensureLinkedCommitmentsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, linkedCommitments_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedCommitments() {
      linkedCommitments_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
     * </pre>
     *
     * <code>repeated string linked_commitments = 470957784;</code>
     *
     * @param value The bytes of the linkedCommitments to add.
     * @return This builder for chaining.
     */
    public Builder addLinkedCommitmentsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLinkedCommitmentsIsMutable();
      linkedCommitments_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.AllocationReservationSharingPolicy
        reservationSharingPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationReservationSharingPolicy,
            com.google.cloud.compute.v1.AllocationReservationSharingPolicy.Builder,
            com.google.cloud.compute.v1.AllocationReservationSharingPolicyOrBuilder>
        reservationSharingPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     *
     * @return Whether the reservationSharingPolicy field is set.
     */
    public boolean hasReservationSharingPolicy() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     *
     * @return The reservationSharingPolicy.
     */
    public com.google.cloud.compute.v1.AllocationReservationSharingPolicy
        getReservationSharingPolicy() {
      if (reservationSharingPolicyBuilder_ == null) {
        return reservationSharingPolicy_ == null
            ? com.google.cloud.compute.v1.AllocationReservationSharingPolicy.getDefaultInstance()
            : reservationSharingPolicy_;
      } else {
        return reservationSharingPolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    public Builder setReservationSharingPolicy(
        com.google.cloud.compute.v1.AllocationReservationSharingPolicy value) {
      if (reservationSharingPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationSharingPolicy_ = value;
      } else {
        reservationSharingPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    public Builder setReservationSharingPolicy(
        com.google.cloud.compute.v1.AllocationReservationSharingPolicy.Builder builderForValue) {
      if (reservationSharingPolicyBuilder_ == null) {
        reservationSharingPolicy_ = builderForValue.build();
      } else {
        reservationSharingPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    public Builder mergeReservationSharingPolicy(
        com.google.cloud.compute.v1.AllocationReservationSharingPolicy value) {
      if (reservationSharingPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && reservationSharingPolicy_ != null
            && reservationSharingPolicy_
                != com.google.cloud.compute.v1.AllocationReservationSharingPolicy
                    .getDefaultInstance()) {
          getReservationSharingPolicyBuilder().mergeFrom(value);
        } else {
          reservationSharingPolicy_ = value;
        }
      } else {
        reservationSharingPolicyBuilder_.mergeFrom(value);
      }
      if (reservationSharingPolicy_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    public Builder clearReservationSharingPolicy() {
      bitField0_ = (bitField0_ & ~0x00002000);
      reservationSharingPolicy_ = null;
      if (reservationSharingPolicyBuilder_ != null) {
        reservationSharingPolicyBuilder_.dispose();
        reservationSharingPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationReservationSharingPolicy.Builder
        getReservationSharingPolicyBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getReservationSharingPolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationReservationSharingPolicyOrBuilder
        getReservationSharingPolicyOrBuilder() {
      if (reservationSharingPolicyBuilder_ != null) {
        return reservationSharingPolicyBuilder_.getMessageOrBuilder();
      } else {
        return reservationSharingPolicy_ == null
            ? com.google.cloud.compute.v1.AllocationReservationSharingPolicy.getDefaultInstance()
            : reservationSharingPolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationReservationSharingPolicy reservation_sharing_policy = 205970120;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationReservationSharingPolicy,
            com.google.cloud.compute.v1.AllocationReservationSharingPolicy.Builder,
            com.google.cloud.compute.v1.AllocationReservationSharingPolicyOrBuilder>
        getReservationSharingPolicyFieldBuilder() {
      if (reservationSharingPolicyBuilder_ == null) {
        reservationSharingPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AllocationReservationSharingPolicy,
                com.google.cloud.compute.v1.AllocationReservationSharingPolicy.Builder,
                com.google.cloud.compute.v1.AllocationReservationSharingPolicyOrBuilder>(
                getReservationSharingPolicy(), getParentForChildren(), isClean());
        reservationSharingPolicy_ = null;
      }
      return reservationSharingPolicyBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourcePolicies_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourcePolicies() {
      if (resourcePolicies_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourcePoliciesDefaultEntryHolder.defaultEntry);
      }
      return resourcePolicies_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourcePolicies() {
      if (resourcePolicies_ == null) {
        resourcePolicies_ =
            com.google.protobuf.MapField.newMapField(
                ResourcePoliciesDefaultEntryHolder.defaultEntry);
      }
      if (!resourcePolicies_.isMutable()) {
        resourcePolicies_ = resourcePolicies_.copy();
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return resourcePolicies_;
    }

    public int getResourcePoliciesCount() {
      return internalGetResourcePolicies().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    @java.lang.Override
    public boolean containsResourcePolicies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourcePolicies().getMap().containsKey(key);
    }

    /** Use {@link #getResourcePoliciesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourcePolicies() {
      return getResourcePoliciesMap();
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourcePoliciesMap() {
      return internalGetResourcePolicies().getMap();
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourcePoliciesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourcePolicies().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    @java.lang.Override
    public java.lang.String getResourcePoliciesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourcePolicies().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourcePolicies() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableResourcePolicies().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    public Builder removeResourcePolicies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourcePolicies().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourcePolicies() {
      bitField0_ |= 0x00004000;
      return internalGetMutableResourcePolicies().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    public Builder putResourcePolicies(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourcePolicies().getMutableMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_policies = 22220385;</code>
     */
    public Builder putAllResourcePolicies(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourcePolicies().getMutableMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }

    private com.google.cloud.compute.v1.AllocationResourceStatus resourceStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationResourceStatus,
            com.google.cloud.compute.v1.AllocationResourceStatus.Builder,
            com.google.cloud.compute.v1.AllocationResourceStatusOrBuilder>
        resourceStatusBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     *
     * @return Whether the resourceStatus field is set.
     */
    public boolean hasResourceStatus() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     *
     * @return The resourceStatus.
     */
    public com.google.cloud.compute.v1.AllocationResourceStatus getResourceStatus() {
      if (resourceStatusBuilder_ == null) {
        return resourceStatus_ == null
            ? com.google.cloud.compute.v1.AllocationResourceStatus.getDefaultInstance()
            : resourceStatus_;
      } else {
        return resourceStatusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder setResourceStatus(com.google.cloud.compute.v1.AllocationResourceStatus value) {
      if (resourceStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceStatus_ = value;
      } else {
        resourceStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder setResourceStatus(
        com.google.cloud.compute.v1.AllocationResourceStatus.Builder builderForValue) {
      if (resourceStatusBuilder_ == null) {
        resourceStatus_ = builderForValue.build();
      } else {
        resourceStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder mergeResourceStatus(com.google.cloud.compute.v1.AllocationResourceStatus value) {
      if (resourceStatusBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && resourceStatus_ != null
            && resourceStatus_
                != com.google.cloud.compute.v1.AllocationResourceStatus.getDefaultInstance()) {
          getResourceStatusBuilder().mergeFrom(value);
        } else {
          resourceStatus_ = value;
        }
      } else {
        resourceStatusBuilder_.mergeFrom(value);
      }
      if (resourceStatus_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder clearResourceStatus() {
      bitField0_ = (bitField0_ & ~0x00008000);
      resourceStatus_ = null;
      if (resourceStatusBuilder_ != null) {
        resourceStatusBuilder_.dispose();
        resourceStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationResourceStatus.Builder getResourceStatusBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getResourceStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationResourceStatusOrBuilder
        getResourceStatusOrBuilder() {
      if (resourceStatusBuilder_ != null) {
        return resourceStatusBuilder_.getMessageOrBuilder();
      } else {
        return resourceStatus_ == null
            ? com.google.cloud.compute.v1.AllocationResourceStatus.getDefaultInstance()
            : resourceStatus_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Status information for Reservation resource.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AllocationResourceStatus resource_status = 249429315;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationResourceStatus,
            com.google.cloud.compute.v1.AllocationResourceStatus.Builder,
            com.google.cloud.compute.v1.AllocationResourceStatusOrBuilder>
        getResourceStatusFieldBuilder() {
      if (resourceStatusBuilder_ == null) {
        resourceStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AllocationResourceStatus,
                com.google.cloud.compute.v1.AllocationResourceStatus.Builder,
                com.google.cloud.compute.v1.AllocationResourceStatusOrBuilder>(
                getResourceStatus(), getParentForChildren(), isClean());
        resourceStatus_ = null;
      }
      return resourceStatusBuilder_;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00010000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object schedulingType_ = "";

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return Whether the schedulingType field is set.
     */
    public boolean hasSchedulingType() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return The schedulingType.
     */
    public java.lang.String getSchedulingType() {
      java.lang.Object ref = schedulingType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedulingType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return The bytes for schedulingType.
     */
    public com.google.protobuf.ByteString getSchedulingTypeBytes() {
      java.lang.Object ref = schedulingType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedulingType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @param value The schedulingType to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulingType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedulingType_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedulingType() {
      schedulingType_ = getDefaultInstance().getSchedulingType();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @param value The bytes for schedulingType to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulingTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedulingType_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ShareSettings shareSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShareSettings,
            com.google.cloud.compute.v1.ShareSettings.Builder,
            com.google.cloud.compute.v1.ShareSettingsOrBuilder>
        shareSettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     *
     * @return Whether the shareSettings field is set.
     */
    public boolean hasShareSettings() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     *
     * @return The shareSettings.
     */
    public com.google.cloud.compute.v1.ShareSettings getShareSettings() {
      if (shareSettingsBuilder_ == null) {
        return shareSettings_ == null
            ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
            : shareSettings_;
      } else {
        return shareSettingsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder setShareSettings(com.google.cloud.compute.v1.ShareSettings value) {
      if (shareSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shareSettings_ = value;
      } else {
        shareSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder setShareSettings(
        com.google.cloud.compute.v1.ShareSettings.Builder builderForValue) {
      if (shareSettingsBuilder_ == null) {
        shareSettings_ = builderForValue.build();
      } else {
        shareSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder mergeShareSettings(com.google.cloud.compute.v1.ShareSettings value) {
      if (shareSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && shareSettings_ != null
            && shareSettings_ != com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()) {
          getShareSettingsBuilder().mergeFrom(value);
        } else {
          shareSettings_ = value;
        }
      } else {
        shareSettingsBuilder_.mergeFrom(value);
      }
      if (shareSettings_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder clearShareSettings() {
      bitField0_ = (bitField0_ & ~0x00080000);
      shareSettings_ = null;
      if (shareSettingsBuilder_ != null) {
        shareSettingsBuilder_.dispose();
        shareSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public com.google.cloud.compute.v1.ShareSettings.Builder getShareSettingsBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getShareSettingsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public com.google.cloud.compute.v1.ShareSettingsOrBuilder getShareSettingsOrBuilder() {
      if (shareSettingsBuilder_ != null) {
        return shareSettingsBuilder_.getMessageOrBuilder();
      } else {
        return shareSettings_ == null
            ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
            : shareSettings_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShareSettings,
            com.google.cloud.compute.v1.ShareSettings.Builder,
            com.google.cloud.compute.v1.ShareSettingsOrBuilder>
        getShareSettingsFieldBuilder() {
      if (shareSettingsBuilder_ == null) {
        shareSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ShareSettings,
                com.google.cloud.compute.v1.ShareSettings.Builder,
                com.google.cloud.compute.v1.ShareSettingsOrBuilder>(
                getShareSettings(), getParentForChildren(), isClean());
        shareSettings_ = null;
      }
      return shareSettingsBuilder_;
    }

    private com.google.cloud.compute.v1.AllocationSpecificSKUReservation specificReservation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationSpecificSKUReservation,
            com.google.cloud.compute.v1.AllocationSpecificSKUReservation.Builder,
            com.google.cloud.compute.v1.AllocationSpecificSKUReservationOrBuilder>
        specificReservationBuilder_;

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     *
     * @return Whether the specificReservation field is set.
     */
    public boolean hasSpecificReservation() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     *
     * @return The specificReservation.
     */
    public com.google.cloud.compute.v1.AllocationSpecificSKUReservation getSpecificReservation() {
      if (specificReservationBuilder_ == null) {
        return specificReservation_ == null
            ? com.google.cloud.compute.v1.AllocationSpecificSKUReservation.getDefaultInstance()
            : specificReservation_;
      } else {
        return specificReservationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    public Builder setSpecificReservation(
        com.google.cloud.compute.v1.AllocationSpecificSKUReservation value) {
      if (specificReservationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        specificReservation_ = value;
      } else {
        specificReservationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    public Builder setSpecificReservation(
        com.google.cloud.compute.v1.AllocationSpecificSKUReservation.Builder builderForValue) {
      if (specificReservationBuilder_ == null) {
        specificReservation_ = builderForValue.build();
      } else {
        specificReservationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    public Builder mergeSpecificReservation(
        com.google.cloud.compute.v1.AllocationSpecificSKUReservation value) {
      if (specificReservationBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && specificReservation_ != null
            && specificReservation_
                != com.google.cloud.compute.v1.AllocationSpecificSKUReservation
                    .getDefaultInstance()) {
          getSpecificReservationBuilder().mergeFrom(value);
        } else {
          specificReservation_ = value;
        }
      } else {
        specificReservationBuilder_.mergeFrom(value);
      }
      if (specificReservation_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    public Builder clearSpecificReservation() {
      bitField0_ = (bitField0_ & ~0x00100000);
      specificReservation_ = null;
      if (specificReservationBuilder_ != null) {
        specificReservationBuilder_.dispose();
        specificReservationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationSpecificSKUReservation.Builder
        getSpecificReservationBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getSpecificReservationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationSpecificSKUReservationOrBuilder
        getSpecificReservationOrBuilder() {
      if (specificReservationBuilder_ != null) {
        return specificReservationBuilder_.getMessageOrBuilder();
      } else {
        return specificReservation_ == null
            ? com.google.cloud.compute.v1.AllocationSpecificSKUReservation.getDefaultInstance()
            : specificReservation_;
      }
    }

    /**
     *
     *
     * <pre>
     * Reservation for instances with specific machine shapes.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AllocationSpecificSKUReservation specific_reservation = 404901951;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationSpecificSKUReservation,
            com.google.cloud.compute.v1.AllocationSpecificSKUReservation.Builder,
            com.google.cloud.compute.v1.AllocationSpecificSKUReservationOrBuilder>
        getSpecificReservationFieldBuilder() {
      if (specificReservationBuilder_ == null) {
        specificReservationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AllocationSpecificSKUReservation,
                com.google.cloud.compute.v1.AllocationSpecificSKUReservation.Builder,
                com.google.cloud.compute.v1.AllocationSpecificSKUReservationOrBuilder>(
                getSpecificReservation(), getParentForChildren(), isClean());
        specificReservation_ = null;
      }
      return specificReservationBuilder_;
    }

    private boolean specificReservationRequired_;

    /**
     *
     *
     * <pre>
     * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
     * </pre>
     *
     * <code>optional bool specific_reservation_required = 226550687;</code>
     *
     * @return Whether the specificReservationRequired field is set.
     */
    @java.lang.Override
    public boolean hasSpecificReservationRequired() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
     * </pre>
     *
     * <code>optional bool specific_reservation_required = 226550687;</code>
     *
     * @return The specificReservationRequired.
     */
    @java.lang.Override
    public boolean getSpecificReservationRequired() {
      return specificReservationRequired_;
    }

    /**
     *
     *
     * <pre>
     * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
     * </pre>
     *
     * <code>optional bool specific_reservation_required = 226550687;</code>
     *
     * @param value The specificReservationRequired to set.
     * @return This builder for chaining.
     */
    public Builder setSpecificReservationRequired(boolean value) {

      specificReservationRequired_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
     * </pre>
     *
     * <code>optional bool specific_reservation_required = 226550687;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpecificReservationRequired() {
      bitField0_ = (bitField0_ & ~0x00200000);
      specificReservationRequired_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00400000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Reservation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Reservation)
  private static final com.google.cloud.compute.v1.Reservation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Reservation();
  }

  public static com.google.cloud.compute.v1.Reservation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Reservation> PARSER =
      new com.google.protobuf.AbstractParser<Reservation>() {
        @java.lang.Override
        public Reservation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Reservation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Reservation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Reservation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
