/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The status of update/delete for a consensus peering connection. Only set when connection_status.update_strategy is CONSENSUS or a network peering is proposing to update the strategy to CONSENSUS.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState}
 */
public final class NetworkPeeringConnectionStatusConsensusState
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState)
    NetworkPeeringConnectionStatusConsensusStateOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NetworkPeeringConnectionStatusConsensusState.newBuilder() to construct.
  private NetworkPeeringConnectionStatusConsensusState(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkPeeringConnectionStatusConsensusState() {
    deleteStatus_ = "";
    updateStatus_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkPeeringConnectionStatusConsensusState();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusConsensusState_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusConsensusState_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.class,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The status of the delete request.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.DeleteStatus}
   */
  public enum DeleteStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DELETE_STATUS = 0;</code>
     */
    UNDEFINED_DELETE_STATUS(0),
    /**
     *
     *
     * <pre>
     * Both network admins have agreed this consensus peering connection can be deleted.
     * </pre>
     *
     * <code>DELETE_ACKNOWLEDGED = 325293916;</code>
     */
    DELETE_ACKNOWLEDGED(325293916),
    /** <code>DELETE_STATUS_UNSPECIFIED = 395396446;</code> */
    DELETE_STATUS_UNSPECIFIED(395396446),
    /**
     *
     *
     * <pre>
     * Network admin has requested deletion of this peering connection.
     * </pre>
     *
     * <code>LOCAL_DELETE_REQUESTED = 227335214;</code>
     */
    LOCAL_DELETE_REQUESTED(227335214),
    /**
     *
     *
     * <pre>
     * The peer network admin has requested deletion of this peering connection.
     * </pre>
     *
     * <code>PEER_DELETE_REQUESTED = 197847799;</code>
     */
    PEER_DELETE_REQUESTED(197847799),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DELETE_STATUS = 0;</code>
     */
    public static final int UNDEFINED_DELETE_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Both network admins have agreed this consensus peering connection can be deleted.
     * </pre>
     *
     * <code>DELETE_ACKNOWLEDGED = 325293916;</code>
     */
    public static final int DELETE_ACKNOWLEDGED_VALUE = 325293916;

    /** <code>DELETE_STATUS_UNSPECIFIED = 395396446;</code> */
    public static final int DELETE_STATUS_UNSPECIFIED_VALUE = 395396446;

    /**
     *
     *
     * <pre>
     * Network admin has requested deletion of this peering connection.
     * </pre>
     *
     * <code>LOCAL_DELETE_REQUESTED = 227335214;</code>
     */
    public static final int LOCAL_DELETE_REQUESTED_VALUE = 227335214;

    /**
     *
     *
     * <pre>
     * The peer network admin has requested deletion of this peering connection.
     * </pre>
     *
     * <code>PEER_DELETE_REQUESTED = 197847799;</code>
     */
    public static final int PEER_DELETE_REQUESTED_VALUE = 197847799;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeleteStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeleteStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DELETE_STATUS;
        case 325293916:
          return DELETE_ACKNOWLEDGED;
        case 395396446:
          return DELETE_STATUS_UNSPECIFIED;
        case 227335214:
          return LOCAL_DELETE_REQUESTED;
        case 197847799:
          return PEER_DELETE_REQUESTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeleteStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeleteStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DeleteStatus>() {
          public DeleteStatus findValueByNumber(int number) {
            return DeleteStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DeleteStatus[] VALUES = values();

    public static DeleteStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeleteStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.DeleteStatus)
  }

  /**
   *
   *
   * <pre>
   * The status of the update request.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.UpdateStatus}
   */
  public enum UpdateStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_UPDATE_STATUS = 0;</code>
     */
    UNDEFINED_UPDATE_STATUS(0),
    /**
     *
     *
     * <pre>
     * No pending configuration update proposals to the peering connection.
     * </pre>
     *
     * <code>IN_SYNC = 2273653;</code>
     */
    IN_SYNC(2273653),
    /**
     *
     *
     * <pre>
     * The peer network admin has made an updatePeering call. The change is awaiting acknowledgment from this peering's network admin.
     * </pre>
     *
     * <code>PENDING_LOCAL_ACKNOWLEDMENT = 229926592;</code>
     */
    PENDING_LOCAL_ACKNOWLEDMENT(229926592),
    /**
     *
     *
     * <pre>
     * The local network admin has made an updatePeering call. The change is awaiting acknowledgment from the peer network admin.
     * </pre>
     *
     * <code>PENDING_PEER_ACKNOWLEDGEMENT = 420185797;</code>
     */
    PENDING_PEER_ACKNOWLEDGEMENT(420185797),
    /** <code>UPDATE_STATUS_UNSPECIFIED = 120836480;</code> */
    UPDATE_STATUS_UNSPECIFIED(120836480),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_UPDATE_STATUS = 0;</code>
     */
    public static final int UNDEFINED_UPDATE_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * No pending configuration update proposals to the peering connection.
     * </pre>
     *
     * <code>IN_SYNC = 2273653;</code>
     */
    public static final int IN_SYNC_VALUE = 2273653;

    /**
     *
     *
     * <pre>
     * The peer network admin has made an updatePeering call. The change is awaiting acknowledgment from this peering's network admin.
     * </pre>
     *
     * <code>PENDING_LOCAL_ACKNOWLEDMENT = 229926592;</code>
     */
    public static final int PENDING_LOCAL_ACKNOWLEDMENT_VALUE = 229926592;

    /**
     *
     *
     * <pre>
     * The local network admin has made an updatePeering call. The change is awaiting acknowledgment from the peer network admin.
     * </pre>
     *
     * <code>PENDING_PEER_ACKNOWLEDGEMENT = 420185797;</code>
     */
    public static final int PENDING_PEER_ACKNOWLEDGEMENT_VALUE = 420185797;

    /** <code>UPDATE_STATUS_UNSPECIFIED = 120836480;</code> */
    public static final int UPDATE_STATUS_UNSPECIFIED_VALUE = 120836480;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UpdateStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UpdateStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_UPDATE_STATUS;
        case 2273653:
          return IN_SYNC;
        case 229926592:
          return PENDING_LOCAL_ACKNOWLEDMENT;
        case 420185797:
          return PENDING_PEER_ACKNOWLEDGEMENT;
        case 120836480:
          return UPDATE_STATUS_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UpdateStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<UpdateStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<UpdateStatus>() {
          public UpdateStatus findValueByNumber(int number) {
            return UpdateStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
          .getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final UpdateStatus[] VALUES = values();

    public static UpdateStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UpdateStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.UpdateStatus)
  }

  private int bitField0_;
  public static final int DELETE_STATUS_FIELD_NUMBER = 483434758;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deleteStatus_ = "";

  /**
   *
   *
   * <pre>
   * The status of the delete request.
   * Check the DeleteStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string delete_status = 483434758;</code>
   *
   * @return Whether the deleteStatus field is set.
   */
  @java.lang.Override
  public boolean hasDeleteStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The status of the delete request.
   * Check the DeleteStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string delete_status = 483434758;</code>
   *
   * @return The deleteStatus.
   */
  @java.lang.Override
  public java.lang.String getDeleteStatus() {
    java.lang.Object ref = deleteStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deleteStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The status of the delete request.
   * Check the DeleteStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string delete_status = 483434758;</code>
   *
   * @return The bytes for deleteStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeleteStatusBytes() {
    java.lang.Object ref = deleteStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deleteStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_STATUS_FIELD_NUMBER = 265998376;

  @SuppressWarnings("serial")
  private volatile java.lang.Object updateStatus_ = "";

  /**
   *
   *
   * <pre>
   * The status of the update request.
   * Check the UpdateStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string update_status = 265998376;</code>
   *
   * @return Whether the updateStatus field is set.
   */
  @java.lang.Override
  public boolean hasUpdateStatus() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The status of the update request.
   * Check the UpdateStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string update_status = 265998376;</code>
   *
   * @return The updateStatus.
   */
  @java.lang.Override
  public java.lang.String getUpdateStatus() {
    java.lang.Object ref = updateStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      updateStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The status of the update request.
   * Check the UpdateStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string update_status = 265998376;</code>
   *
   * @return The bytes for updateStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUpdateStatusBytes() {
    java.lang.Object ref = updateStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      updateStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 265998376, updateStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 483434758, deleteStatus_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(265998376, updateStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(483434758, deleteStatus_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState other =
        (com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState) obj;

    if (hasDeleteStatus() != other.hasDeleteStatus()) return false;
    if (hasDeleteStatus()) {
      if (!getDeleteStatus().equals(other.getDeleteStatus())) return false;
    }
    if (hasUpdateStatus() != other.hasUpdateStatus()) return false;
    if (hasUpdateStatus()) {
      if (!getUpdateStatus().equals(other.getUpdateStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDeleteStatus()) {
      hash = (37 * hash) + DELETE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteStatus().hashCode();
    }
    if (hasUpdateStatus()) {
      hash = (37 * hash) + UPDATE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The status of update/delete for a consensus peering connection. Only set when connection_status.update_strategy is CONSENSUS or a network peering is proposing to update the strategy to CONSENSUS.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState)
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusStateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusConsensusState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusConsensusState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.class,
              com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      deleteStatus_ = "";
      updateStatus_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusConsensusState_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState build() {
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState buildPartial() {
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState result =
          new com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.deleteStatus_ = deleteStatus_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateStatus_ = updateStatus_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState) {
        return mergeFrom(
            (com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState other) {
      if (other
          == com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
              .getDefaultInstance()) return this;
      if (other.hasDeleteStatus()) {
        deleteStatus_ = other.deleteStatus_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasUpdateStatus()) {
        updateStatus_ = other.updateStatus_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 2127987010:
              {
                updateStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 2127987010
            case -427489230:
              {
                deleteStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -427489230
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object deleteStatus_ = "";

    /**
     *
     *
     * <pre>
     * The status of the delete request.
     * Check the DeleteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string delete_status = 483434758;</code>
     *
     * @return Whether the deleteStatus field is set.
     */
    public boolean hasDeleteStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The status of the delete request.
     * Check the DeleteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string delete_status = 483434758;</code>
     *
     * @return The deleteStatus.
     */
    public java.lang.String getDeleteStatus() {
      java.lang.Object ref = deleteStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deleteStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The status of the delete request.
     * Check the DeleteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string delete_status = 483434758;</code>
     *
     * @return The bytes for deleteStatus.
     */
    public com.google.protobuf.ByteString getDeleteStatusBytes() {
      java.lang.Object ref = deleteStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deleteStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The status of the delete request.
     * Check the DeleteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string delete_status = 483434758;</code>
     *
     * @param value The deleteStatus to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deleteStatus_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The status of the delete request.
     * Check the DeleteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string delete_status = 483434758;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleteStatus() {
      deleteStatus_ = getDefaultInstance().getDeleteStatus();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The status of the delete request.
     * Check the DeleteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string delete_status = 483434758;</code>
     *
     * @param value The bytes for deleteStatus to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deleteStatus_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object updateStatus_ = "";

    /**
     *
     *
     * <pre>
     * The status of the update request.
     * Check the UpdateStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_status = 265998376;</code>
     *
     * @return Whether the updateStatus field is set.
     */
    public boolean hasUpdateStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The status of the update request.
     * Check the UpdateStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_status = 265998376;</code>
     *
     * @return The updateStatus.
     */
    public java.lang.String getUpdateStatus() {
      java.lang.Object ref = updateStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        updateStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The status of the update request.
     * Check the UpdateStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_status = 265998376;</code>
     *
     * @return The bytes for updateStatus.
     */
    public com.google.protobuf.ByteString getUpdateStatusBytes() {
      java.lang.Object ref = updateStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        updateStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The status of the update request.
     * Check the UpdateStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_status = 265998376;</code>
     *
     * @param value The updateStatus to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      updateStatus_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The status of the update request.
     * Check the UpdateStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_status = 265998376;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpdateStatus() {
      updateStatus_ = getDefaultInstance().getUpdateStatus();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The status of the update request.
     * Check the UpdateStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_status = 265998376;</code>
     *
     * @param value The bytes for updateStatus to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      updateStatus_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState)
  private static final com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState();
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkPeeringConnectionStatusConsensusState>
      PARSER =
          new com.google.protobuf.AbstractParser<NetworkPeeringConnectionStatusConsensusState>() {
            @java.lang.Override
            public NetworkPeeringConnectionStatusConsensusState parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<NetworkPeeringConnectionStatusConsensusState> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkPeeringConnectionStatusConsensusState>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
