/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Output Only] Describes the state of a peering connection, not just the local peering. This field provides information about the effective settings for the connection as a whole, including pending delete/update requests for CONSENSUS peerings.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NetworkPeeringConnectionStatus}
 */
public final class NetworkPeeringConnectionStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NetworkPeeringConnectionStatus)
    NetworkPeeringConnectionStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NetworkPeeringConnectionStatus.newBuilder() to construct.
  private NetworkPeeringConnectionStatus(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkPeeringConnectionStatus() {
    updateStrategy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkPeeringConnectionStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.class,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The update strategy determines the update/delete semantics for this peering connection.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkPeeringConnectionStatus.UpdateStrategy}
   */
  public enum UpdateStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_UPDATE_STRATEGY = 0;</code>
     */
    UNDEFINED_UPDATE_STRATEGY(0),
    /**
     *
     *
     * <pre>
     * Updates are reflected in the local peering but aren't applied to the peering connection until a complementary change is made to the matching peering. To delete a peering with the consensus update strategy, both the peerings must request the deletion of the peering before the peering can be deleted.
     * </pre>
     *
     * <code>CONSENSUS = 203373655;</code>
     */
    CONSENSUS(203373655),
    /**
     *
     *
     * <pre>
     * In this mode, changes to the peering configuration can be unilaterally altered by changing either side of the peering. This is the default value if the field is unspecified.
     * </pre>
     *
     * <code>INDEPENDENT = 127011674;</code>
     */
    INDEPENDENT(127011674),
    /**
     *
     *
     * <pre>
     * Peerings with update strategy UNSPECIFIED are created with update strategy INDEPENDENT.
     * </pre>
     *
     * <code>UNSPECIFIED = 526786327;</code>
     */
    UNSPECIFIED(526786327),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_UPDATE_STRATEGY = 0;</code>
     */
    public static final int UNDEFINED_UPDATE_STRATEGY_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Updates are reflected in the local peering but aren't applied to the peering connection until a complementary change is made to the matching peering. To delete a peering with the consensus update strategy, both the peerings must request the deletion of the peering before the peering can be deleted.
     * </pre>
     *
     * <code>CONSENSUS = 203373655;</code>
     */
    public static final int CONSENSUS_VALUE = 203373655;

    /**
     *
     *
     * <pre>
     * In this mode, changes to the peering configuration can be unilaterally altered by changing either side of the peering. This is the default value if the field is unspecified.
     * </pre>
     *
     * <code>INDEPENDENT = 127011674;</code>
     */
    public static final int INDEPENDENT_VALUE = 127011674;

    /**
     *
     *
     * <pre>
     * Peerings with update strategy UNSPECIFIED are created with update strategy INDEPENDENT.
     * </pre>
     *
     * <code>UNSPECIFIED = 526786327;</code>
     */
    public static final int UNSPECIFIED_VALUE = 526786327;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UpdateStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UpdateStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_UPDATE_STRATEGY;
        case 203373655:
          return CONSENSUS;
        case 127011674:
          return INDEPENDENT;
        case 526786327:
          return UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UpdateStrategy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<UpdateStrategy> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<UpdateStrategy>() {
          public UpdateStrategy findValueByNumber(int number) {
            return UpdateStrategy.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final UpdateStrategy[] VALUES = values();

    public static UpdateStrategy valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UpdateStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatus.UpdateStrategy)
  }

  private int bitField0_;
  public static final int CONSENSUS_STATE_FIELD_NUMBER = 379772617;
  private com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensusState_;

  /**
   *
   *
   * <pre>
   * The consensus state contains information about the status of update and delete for a consensus peering connection.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
   * </code>
   *
   * @return Whether the consensusState field is set.
   */
  @java.lang.Override
  public boolean hasConsensusState() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The consensus state contains information about the status of update and delete for a consensus peering connection.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
   * </code>
   *
   * @return The consensusState.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
      getConsensusState() {
    return consensusState_ == null
        ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
            .getDefaultInstance()
        : consensusState_;
  }

  /**
   *
   *
   * <pre>
   * The consensus state contains information about the status of update and delete for a consensus peering connection.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusStateOrBuilder
      getConsensusStateOrBuilder() {
    return consensusState_ == null
        ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
            .getDefaultInstance()
        : consensusState_;
  }

  public static final int TRAFFIC_CONFIGURATION_FIELD_NUMBER = 133016116;
  private com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      trafficConfiguration_;

  /**
   *
   *
   * <pre>
   * The active connectivity settings for the peering connection based on the settings of the network peerings.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
   * </code>
   *
   * @return Whether the trafficConfiguration field is set.
   */
  @java.lang.Override
  public boolean hasTrafficConfiguration() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The active connectivity settings for the peering connection based on the settings of the network peerings.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
   * </code>
   *
   * @return The trafficConfiguration.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      getTrafficConfiguration() {
    return trafficConfiguration_ == null
        ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
            .getDefaultInstance()
        : trafficConfiguration_;
  }

  /**
   *
   *
   * <pre>
   * The active connectivity settings for the peering connection based on the settings of the network peerings.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder
      getTrafficConfigurationOrBuilder() {
    return trafficConfiguration_ == null
        ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
            .getDefaultInstance()
        : trafficConfiguration_;
  }

  public static final int UPDATE_STRATEGY_FIELD_NUMBER = 6123049;

  @SuppressWarnings("serial")
  private volatile java.lang.Object updateStrategy_ = "";

  /**
   *
   *
   * <pre>
   * The update strategy determines the update/delete semantics for this peering connection.
   * Check the UpdateStrategy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string update_strategy = 6123049;</code>
   *
   * @return Whether the updateStrategy field is set.
   */
  @java.lang.Override
  public boolean hasUpdateStrategy() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The update strategy determines the update/delete semantics for this peering connection.
   * Check the UpdateStrategy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string update_strategy = 6123049;</code>
   *
   * @return The updateStrategy.
   */
  @java.lang.Override
  public java.lang.String getUpdateStrategy() {
    java.lang.Object ref = updateStrategy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      updateStrategy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The update strategy determines the update/delete semantics for this peering connection.
   * Check the UpdateStrategy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string update_strategy = 6123049;</code>
   *
   * @return The bytes for updateStrategy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUpdateStrategyBytes() {
    java.lang.Object ref = updateStrategy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      updateStrategy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6123049, updateStrategy_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(133016116, getTrafficConfiguration());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(379772617, getConsensusState());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6123049, updateStrategy_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              133016116, getTrafficConfiguration());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(379772617, getConsensusState());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NetworkPeeringConnectionStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NetworkPeeringConnectionStatus other =
        (com.google.cloud.compute.v1.NetworkPeeringConnectionStatus) obj;

    if (hasConsensusState() != other.hasConsensusState()) return false;
    if (hasConsensusState()) {
      if (!getConsensusState().equals(other.getConsensusState())) return false;
    }
    if (hasTrafficConfiguration() != other.hasTrafficConfiguration()) return false;
    if (hasTrafficConfiguration()) {
      if (!getTrafficConfiguration().equals(other.getTrafficConfiguration())) return false;
    }
    if (hasUpdateStrategy() != other.hasUpdateStrategy()) return false;
    if (hasUpdateStrategy()) {
      if (!getUpdateStrategy().equals(other.getUpdateStrategy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConsensusState()) {
      hash = (37 * hash) + CONSENSUS_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getConsensusState().hashCode();
    }
    if (hasTrafficConfiguration()) {
      hash = (37 * hash) + TRAFFIC_CONFIGURATION_FIELD_NUMBER;
      hash = (53 * hash) + getTrafficConfiguration().hashCode();
    }
    if (hasUpdateStrategy()) {
      hash = (37 * hash) + UPDATE_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateStrategy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Describes the state of a peering connection, not just the local peering. This field provides information about the effective settings for the connection as a whole, including pending delete/update requests for CONSENSUS peerings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NetworkPeeringConnectionStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NetworkPeeringConnectionStatus)
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.class,
              com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConsensusStateFieldBuilder();
        getTrafficConfigurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      consensusState_ = null;
      if (consensusStateBuilder_ != null) {
        consensusStateBuilder_.dispose();
        consensusStateBuilder_ = null;
      }
      trafficConfiguration_ = null;
      if (trafficConfigurationBuilder_ != null) {
        trafficConfigurationBuilder_.dispose();
        trafficConfigurationBuilder_ = null;
      }
      updateStrategy_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatus build() {
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatus buildPartial() {
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatus result =
          new com.google.cloud.compute.v1.NetworkPeeringConnectionStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.NetworkPeeringConnectionStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.consensusState_ =
            consensusStateBuilder_ == null ? consensusState_ : consensusStateBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.trafficConfiguration_ =
            trafficConfigurationBuilder_ == null
                ? trafficConfiguration_
                : trafficConfigurationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateStrategy_ = updateStrategy_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NetworkPeeringConnectionStatus) {
        return mergeFrom((com.google.cloud.compute.v1.NetworkPeeringConnectionStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NetworkPeeringConnectionStatus other) {
      if (other == com.google.cloud.compute.v1.NetworkPeeringConnectionStatus.getDefaultInstance())
        return this;
      if (other.hasConsensusState()) {
        mergeConsensusState(other.getConsensusState());
      }
      if (other.hasTrafficConfiguration()) {
        mergeTrafficConfiguration(other.getTrafficConfiguration());
      }
      if (other.hasUpdateStrategy()) {
        updateStrategy_ = other.updateStrategy_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 48984394:
              {
                updateStrategy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 48984394
            case 1064128930:
              {
                input.readMessage(
                    getTrafficConfigurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 1064128930
            case -1256786358:
              {
                input.readMessage(getConsensusStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1256786358
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
        consensusState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusStateOrBuilder>
        consensusStateBuilder_;

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     *
     * @return Whether the consensusState field is set.
     */
    public boolean hasConsensusState() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     *
     * @return The consensusState.
     */
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
        getConsensusState() {
      if (consensusStateBuilder_ == null) {
        return consensusState_ == null
            ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
                .getDefaultInstance()
            : consensusState_;
      } else {
        return consensusStateBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    public Builder setConsensusState(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState value) {
      if (consensusStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consensusState_ = value;
      } else {
        consensusStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    public Builder setConsensusState(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder
            builderForValue) {
      if (consensusStateBuilder_ == null) {
        consensusState_ = builderForValue.build();
      } else {
        consensusStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    public Builder mergeConsensusState(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState value) {
      if (consensusStateBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && consensusState_ != null
            && consensusState_
                != com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
                    .getDefaultInstance()) {
          getConsensusStateBuilder().mergeFrom(value);
        } else {
          consensusState_ = value;
        }
      } else {
        consensusStateBuilder_.mergeFrom(value);
      }
      if (consensusState_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    public Builder clearConsensusState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      consensusState_ = null;
      if (consensusStateBuilder_ != null) {
        consensusStateBuilder_.dispose();
        consensusStateBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder
        getConsensusStateBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConsensusStateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusStateOrBuilder
        getConsensusStateOrBuilder() {
      if (consensusStateBuilder_ != null) {
        return consensusStateBuilder_.getMessageOrBuilder();
      } else {
        return consensusState_ == null
            ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState
                .getDefaultInstance()
            : consensusState_;
      }
    }

    /**
     *
     *
     * <pre>
     * The consensus state contains information about the status of update and delete for a consensus peering connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState consensus_state = 379772617;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusStateOrBuilder>
        getConsensusStateFieldBuilder() {
      if (consensusStateBuilder_ == null) {
        consensusStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState,
                com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusState.Builder,
                com.google.cloud.compute.v1.NetworkPeeringConnectionStatusConsensusStateOrBuilder>(
                getConsensusState(), getParentForChildren(), isClean());
        consensusState_ = null;
      }
      return consensusStateBuilder_;
    }

    private com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
        trafficConfiguration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.Builder,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder>
        trafficConfigurationBuilder_;

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     *
     * @return Whether the trafficConfiguration field is set.
     */
    public boolean hasTrafficConfiguration() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     *
     * @return The trafficConfiguration.
     */
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
        getTrafficConfiguration() {
      if (trafficConfigurationBuilder_ == null) {
        return trafficConfiguration_ == null
            ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
                .getDefaultInstance()
            : trafficConfiguration_;
      } else {
        return trafficConfigurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    public Builder setTrafficConfiguration(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration value) {
      if (trafficConfigurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trafficConfiguration_ = value;
      } else {
        trafficConfigurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    public Builder setTrafficConfiguration(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.Builder
            builderForValue) {
      if (trafficConfigurationBuilder_ == null) {
        trafficConfiguration_ = builderForValue.build();
      } else {
        trafficConfigurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    public Builder mergeTrafficConfiguration(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration value) {
      if (trafficConfigurationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && trafficConfiguration_ != null
            && trafficConfiguration_
                != com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
                    .getDefaultInstance()) {
          getTrafficConfigurationBuilder().mergeFrom(value);
        } else {
          trafficConfiguration_ = value;
        }
      } else {
        trafficConfigurationBuilder_.mergeFrom(value);
      }
      if (trafficConfiguration_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    public Builder clearTrafficConfiguration() {
      bitField0_ = (bitField0_ & ~0x00000002);
      trafficConfiguration_ = null;
      if (trafficConfigurationBuilder_ != null) {
        trafficConfigurationBuilder_.dispose();
        trafficConfigurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.Builder
        getTrafficConfigurationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTrafficConfigurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder
        getTrafficConfigurationOrBuilder() {
      if (trafficConfigurationBuilder_ != null) {
        return trafficConfigurationBuilder_.getMessageOrBuilder();
      } else {
        return trafficConfiguration_ == null
            ? com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
                .getDefaultInstance()
            : trafficConfiguration_;
      }
    }

    /**
     *
     *
     * <pre>
     * The active connectivity settings for the peering connection based on the settings of the network peerings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration traffic_configuration = 133016116;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.Builder,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder>
        getTrafficConfigurationFieldBuilder() {
      if (trafficConfigurationBuilder_ == null) {
        trafficConfigurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration,
                com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
                    .Builder,
                com.google.cloud.compute.v1
                    .NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder>(
                getTrafficConfiguration(), getParentForChildren(), isClean());
        trafficConfiguration_ = null;
      }
      return trafficConfigurationBuilder_;
    }

    private java.lang.Object updateStrategy_ = "";

    /**
     *
     *
     * <pre>
     * The update strategy determines the update/delete semantics for this peering connection.
     * Check the UpdateStrategy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_strategy = 6123049;</code>
     *
     * @return Whether the updateStrategy field is set.
     */
    public boolean hasUpdateStrategy() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The update strategy determines the update/delete semantics for this peering connection.
     * Check the UpdateStrategy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_strategy = 6123049;</code>
     *
     * @return The updateStrategy.
     */
    public java.lang.String getUpdateStrategy() {
      java.lang.Object ref = updateStrategy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        updateStrategy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The update strategy determines the update/delete semantics for this peering connection.
     * Check the UpdateStrategy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_strategy = 6123049;</code>
     *
     * @return The bytes for updateStrategy.
     */
    public com.google.protobuf.ByteString getUpdateStrategyBytes() {
      java.lang.Object ref = updateStrategy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        updateStrategy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The update strategy determines the update/delete semantics for this peering connection.
     * Check the UpdateStrategy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_strategy = 6123049;</code>
     *
     * @param value The updateStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateStrategy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      updateStrategy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The update strategy determines the update/delete semantics for this peering connection.
     * Check the UpdateStrategy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_strategy = 6123049;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpdateStrategy() {
      updateStrategy_ = getDefaultInstance().getUpdateStrategy();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The update strategy determines the update/delete semantics for this peering connection.
     * Check the UpdateStrategy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string update_strategy = 6123049;</code>
     *
     * @param value The bytes for updateStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateStrategyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      updateStrategy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatus)
  private static final com.google.cloud.compute.v1.NetworkPeeringConnectionStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NetworkPeeringConnectionStatus();
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkPeeringConnectionStatus> PARSER =
      new com.google.protobuf.AbstractParser<NetworkPeeringConnectionStatus>() {
        @java.lang.Override
        public NetworkPeeringConnectionStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkPeeringConnectionStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkPeeringConnectionStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
