/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

public interface InterconnectGroupsCreateMembersInterconnectInputOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  boolean hasAdminEnabled();

  /**
   *
   *
   * <pre>
   * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  boolean getAdminEnabled();

  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return Whether the customerName field is set.
   */
  boolean hasCustomerName();

  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return The customerName.
   */
  java.lang.String getCustomerName();

  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return The bytes for customerName.
   */
  com.google.protobuf.ByteString getCustomerNameBytes();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * </pre>
   *
   * <code>optional string facility = 501116579;</code>
   *
   * @return Whether the facility field is set.
   */
  boolean hasFacility();

  /**
   *
   *
   * <pre>
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * </pre>
   *
   * <code>optional string facility = 501116579;</code>
   *
   * @return The facility.
   */
  java.lang.String getFacility();

  /**
   *
   *
   * <pre>
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * </pre>
   *
   * <code>optional string facility = 501116579;</code>
   *
   * @return The bytes for facility.
   */
  com.google.protobuf.ByteString getFacilityBytes();

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return Whether the interconnectType field is set.
   */
  boolean hasInterconnectType();

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return The interconnectType.
   */
  java.lang.String getInterconnectType();

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return The bytes for interconnectType.
   */
  com.google.protobuf.ByteString getInterconnectTypeBytes();

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return Whether the linkType field is set.
   */
  boolean hasLinkType();

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return The linkType.
   */
  java.lang.String getLinkType();

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return The bytes for linkType.
   */
  com.google.protobuf.ByteString getLinkTypeBytes();

  /**
   *
   *
   * <pre>
   * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return Whether the nocContactEmail field is set.
   */
  boolean hasNocContactEmail();

  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return The nocContactEmail.
   */
  java.lang.String getNocContactEmail();

  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return The bytes for nocContactEmail.
   */
  com.google.protobuf.ByteString getNocContactEmailBytes();

  /**
   *
   *
   * <pre>
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
   * </pre>
   *
   * <code>optional string remote_location = 324388750;</code>
   *
   * @return Whether the remoteLocation field is set.
   */
  boolean hasRemoteLocation();

  /**
   *
   *
   * <pre>
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
   * </pre>
   *
   * <code>optional string remote_location = 324388750;</code>
   *
   * @return The remoteLocation.
   */
  java.lang.String getRemoteLocation();

  /**
   *
   *
   * <pre>
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
   * </pre>
   *
   * <code>optional string remote_location = 324388750;</code>
   *
   * @return The bytes for remoteLocation.
   */
  com.google.protobuf.ByteString getRemoteLocationBytes();

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @return A list containing the requestedFeatures.
   */
  java.util.List<java.lang.String> getRequestedFeaturesList();

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @return The count of requestedFeatures.
   */
  int getRequestedFeaturesCount();

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @param index The index of the element to return.
   * @return The requestedFeatures at the given index.
   */
  java.lang.String getRequestedFeatures(int index);

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requestedFeatures at the given index.
   */
  com.google.protobuf.ByteString getRequestedFeaturesBytes(int index);

  /**
   *
   *
   * <pre>
   * Target number of physical links in the link bundle, as requested by the customer.
   * </pre>
   *
   * <code>optional int32 requested_link_count = 45051387;</code>
   *
   * @return Whether the requestedLinkCount field is set.
   */
  boolean hasRequestedLinkCount();

  /**
   *
   *
   * <pre>
   * Target number of physical links in the link bundle, as requested by the customer.
   * </pre>
   *
   * <code>optional int32 requested_link_count = 45051387;</code>
   *
   * @return The requestedLinkCount.
   */
  int getRequestedLinkCount();
}
