/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Output Only] Reasons why configuration.topologyCapability.sla differs from intent.topologyCapability. This list is empty if and only if those are the same.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers}
 */
public final class InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)
    InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockersOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.newBuilder() to
  // construct.
  private InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers() {
    blockerType_ = "";
    documentationLink_ = "";
    explanation_ = "";
    facilities_ = com.google.protobuf.LazyStringArrayList.emptyList();
    interconnects_ = com.google.protobuf.LazyStringArrayList.emptyList();
    metros_ = com.google.protobuf.LazyStringArrayList.emptyList();
    zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1
                .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.class,
            com.google.cloud.compute.v1
                .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.BlockerType}
   */
  public enum BlockerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BLOCKER_TYPE = 0;</code>
     */
    UNDEFINED_BLOCKER_TYPE(0),
    /** <code>INCOMPATIBLE_METROS = 290410432;</code> */
    INCOMPATIBLE_METROS(290410432),
    /** <code>NOT_AVAILABLE = 140722205;</code> */
    NOT_AVAILABLE(140722205),
    /** <code>NO_INTERCONNECTS = 523549575;</code> */
    NO_INTERCONNECTS(523549575),
    /** <code>NO_INTERCONNECTS_IN_METRO_AND_ZONE = 440966492;</code> */
    NO_INTERCONNECTS_IN_METRO_AND_ZONE(440966492),
    /** <code>OTHER = 75532016;</code> */
    OTHER(75532016),
    /** <code>UNSPECIFIED = 526786327;</code> */
    UNSPECIFIED(526786327),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BLOCKER_TYPE = 0;</code>
     */
    public static final int UNDEFINED_BLOCKER_TYPE_VALUE = 0;

    /** <code>INCOMPATIBLE_METROS = 290410432;</code> */
    public static final int INCOMPATIBLE_METROS_VALUE = 290410432;

    /** <code>NOT_AVAILABLE = 140722205;</code> */
    public static final int NOT_AVAILABLE_VALUE = 140722205;

    /** <code>NO_INTERCONNECTS = 523549575;</code> */
    public static final int NO_INTERCONNECTS_VALUE = 523549575;

    /** <code>NO_INTERCONNECTS_IN_METRO_AND_ZONE = 440966492;</code> */
    public static final int NO_INTERCONNECTS_IN_METRO_AND_ZONE_VALUE = 440966492;

    /** <code>OTHER = 75532016;</code> */
    public static final int OTHER_VALUE = 75532016;

    /** <code>UNSPECIFIED = 526786327;</code> */
    public static final int UNSPECIFIED_VALUE = 526786327;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BlockerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BlockerType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BLOCKER_TYPE;
        case 290410432:
          return INCOMPATIBLE_METROS;
        case 140722205:
          return NOT_AVAILABLE;
        case 523549575:
          return NO_INTERCONNECTS;
        case 440966492:
          return NO_INTERCONNECTS_IN_METRO_AND_ZONE;
        case 75532016:
          return OTHER;
        case 526786327:
          return UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BlockerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BlockerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BlockerType>() {
          public BlockerType findValueByNumber(int number) {
            return BlockerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final BlockerType[] VALUES = values();

    public static BlockerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BlockerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.BlockerType)
  }

  private int bitField0_;
  public static final int BLOCKER_TYPE_FIELD_NUMBER = 381194847;

  @SuppressWarnings("serial")
  private volatile java.lang.Object blockerType_ = "";

  /**
   *
   *
   * <pre>
   *
   * Check the BlockerType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string blocker_type = 381194847;</code>
   *
   * @return Whether the blockerType field is set.
   */
  @java.lang.Override
  public boolean hasBlockerType() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   *
   * Check the BlockerType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string blocker_type = 381194847;</code>
   *
   * @return The blockerType.
   */
  @java.lang.Override
  public java.lang.String getBlockerType() {
    java.lang.Object ref = blockerType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      blockerType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   *
   * Check the BlockerType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string blocker_type = 381194847;</code>
   *
   * @return The bytes for blockerType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBlockerTypeBytes() {
    java.lang.Object ref = blockerType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      blockerType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTATION_LINK_FIELD_NUMBER = 93465183;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentationLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string documentation_link = 93465183;</code>
   *
   * @return Whether the documentationLink field is set.
   */
  @java.lang.Override
  public boolean hasDocumentationLink() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string documentation_link = 93465183;</code>
   *
   * @return The documentationLink.
   */
  @java.lang.Override
  public java.lang.String getDocumentationLink() {
    java.lang.Object ref = documentationLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentationLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string documentation_link = 93465183;</code>
   *
   * @return The bytes for documentationLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentationLinkBytes() {
    java.lang.Object ref = documentationLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentationLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPLANATION_FIELD_NUMBER = 504745497;

  @SuppressWarnings("serial")
  private volatile java.lang.Object explanation_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string explanation = 504745497;</code>
   *
   * @return Whether the explanation field is set.
   */
  @java.lang.Override
  public boolean hasExplanation() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string explanation = 504745497;</code>
   *
   * @return The explanation.
   */
  @java.lang.Override
  public java.lang.String getExplanation() {
    java.lang.Object ref = explanation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      explanation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string explanation = 504745497;</code>
   *
   * @return The bytes for explanation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExplanationBytes() {
    java.lang.Object ref = explanation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      explanation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACILITIES_FIELD_NUMBER = 536683137;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList facilities_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
   * </pre>
   *
   * <code>repeated string facilities = 536683137;</code>
   *
   * @return A list containing the facilities.
   */
  public com.google.protobuf.ProtocolStringList getFacilitiesList() {
    return facilities_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
   * </pre>
   *
   * <code>repeated string facilities = 536683137;</code>
   *
   * @return The count of facilities.
   */
  public int getFacilitiesCount() {
    return facilities_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
   * </pre>
   *
   * <code>repeated string facilities = 536683137;</code>
   *
   * @param index The index of the element to return.
   * @return The facilities at the given index.
   */
  public java.lang.String getFacilities(int index) {
    return facilities_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
   * </pre>
   *
   * <code>repeated string facilities = 536683137;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the facilities at the given index.
   */
  public com.google.protobuf.ByteString getFacilitiesBytes(int index) {
    return facilities_.getByteString(index);
  }

  public static final int INTERCONNECTS_FIELD_NUMBER = 520187301;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList interconnects_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Interconnects used to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string interconnects = 520187301;</code>
   *
   * @return A list containing the interconnects.
   */
  public com.google.protobuf.ProtocolStringList getInterconnectsList() {
    return interconnects_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Interconnects used to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string interconnects = 520187301;</code>
   *
   * @return The count of interconnects.
   */
  public int getInterconnectsCount() {
    return interconnects_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Interconnects used to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string interconnects = 520187301;</code>
   *
   * @param index The index of the element to return.
   * @return The interconnects at the given index.
   */
  public java.lang.String getInterconnects(int index) {
    return interconnects_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Interconnects used to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string interconnects = 520187301;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the interconnects at the given index.
   */
  public com.google.protobuf.ByteString getInterconnectsBytes(int index) {
    return interconnects_.getByteString(index);
  }

  public static final int METROS_FIELD_NUMBER = 533067386;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList metros_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @return A list containing the metros.
   */
  public com.google.protobuf.ProtocolStringList getMetrosList() {
    return metros_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @return The count of metros.
   */
  public int getMetrosCount() {
    return metros_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @param index The index of the element to return.
   * @return The metros at the given index.
   */
  public java.lang.String getMetros(int index) {
    return metros_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the metros at the given index.
   */
  public com.google.protobuf.ByteString getMetrosBytes(int index) {
    return metros_.getByteString(index);
  }

  public static final int ZONES_FIELD_NUMBER = 116085319;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList zones_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @return A list containing the zones.
   */
  public com.google.protobuf.ProtocolStringList getZonesList() {
    return zones_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @return The count of zones.
   */
  public int getZonesCount() {
    return zones_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @param index The index of the element to return.
   * @return The zones at the given index.
   */
  public java.lang.String getZones(int index) {
    return zones_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the zones at the given index.
   */
  public com.google.protobuf.ByteString getZonesBytes(int index) {
    return zones_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 93465183, documentationLink_);
    }
    for (int i = 0; i < zones_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 116085319, zones_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 381194847, blockerType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 504745497, explanation_);
    }
    for (int i = 0; i < interconnects_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 520187301, interconnects_.getRaw(i));
    }
    for (int i = 0; i < metros_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 533067386, metros_.getRaw(i));
    }
    for (int i = 0; i < facilities_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 536683137, facilities_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(93465183, documentationLink_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < zones_.size(); i++) {
        dataSize += computeStringSizeNoTag(zones_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getZonesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(381194847, blockerType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(504745497, explanation_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < interconnects_.size(); i++) {
        dataSize += computeStringSizeNoTag(interconnects_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getInterconnectsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < metros_.size(); i++) {
        dataSize += computeStringSizeNoTag(metros_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getMetrosList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < facilities_.size(); i++) {
        dataSize += computeStringSizeNoTag(facilities_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getFacilitiesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1
            .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1
            .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
        other =
            (com.google.cloud.compute.v1
                    .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)
                obj;

    if (hasBlockerType() != other.hasBlockerType()) return false;
    if (hasBlockerType()) {
      if (!getBlockerType().equals(other.getBlockerType())) return false;
    }
    if (hasDocumentationLink() != other.hasDocumentationLink()) return false;
    if (hasDocumentationLink()) {
      if (!getDocumentationLink().equals(other.getDocumentationLink())) return false;
    }
    if (hasExplanation() != other.hasExplanation()) return false;
    if (hasExplanation()) {
      if (!getExplanation().equals(other.getExplanation())) return false;
    }
    if (!getFacilitiesList().equals(other.getFacilitiesList())) return false;
    if (!getInterconnectsList().equals(other.getInterconnectsList())) return false;
    if (!getMetrosList().equals(other.getMetrosList())) return false;
    if (!getZonesList().equals(other.getZonesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBlockerType()) {
      hash = (37 * hash) + BLOCKER_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getBlockerType().hashCode();
    }
    if (hasDocumentationLink()) {
      hash = (37 * hash) + DOCUMENTATION_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentationLink().hashCode();
    }
    if (hasExplanation()) {
      hash = (37 * hash) + EXPLANATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplanation().hashCode();
    }
    if (getFacilitiesCount() > 0) {
      hash = (37 * hash) + FACILITIES_FIELD_NUMBER;
      hash = (53 * hash) + getFacilitiesList().hashCode();
    }
    if (getInterconnectsCount() > 0) {
      hash = (37 * hash) + INTERCONNECTS_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnectsList().hashCode();
    }
    if (getMetrosCount() > 0) {
      hash = (37 * hash) + METROS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrosList().hashCode();
    }
    if (getZonesCount() > 0) {
      hash = (37 * hash) + ZONES_FIELD_NUMBER;
      hash = (53 * hash) + getZonesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1
              .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reasons why configuration.topologyCapability.sla differs from intent.topologyCapability. This list is empty if and only if those are the same.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)
      com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1
                  .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.class,
              com.google.cloud.compute.v1
                  .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      blockerType_ = "";
      documentationLink_ = "";
      explanation_ = "";
      facilities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      interconnects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      metros_ = com.google.protobuf.LazyStringArrayList.emptyList();
      zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1
            .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1
            .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
        build() {
      com.google.cloud.compute.v1
              .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1
            .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
        buildPartial() {
      com.google.cloud.compute.v1
              .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
          result =
              new com.google.cloud.compute.v1
                  .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1
                .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
            result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.blockerType_ = blockerType_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.documentationLink_ = documentationLink_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.explanation_ = explanation_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        facilities_.makeImmutable();
        result.facilities_ = facilities_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        interconnects_.makeImmutable();
        result.interconnects_ = interconnects_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        metros_.makeImmutable();
        result.metros_ = metros_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        zones_.makeImmutable();
        result.zones_ = zones_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1
              .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers) {
        return mergeFrom(
            (com.google.cloud.compute.v1
                    .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1
                .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
            other) {
      if (other
          == com.google.cloud.compute.v1
              .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
              .getDefaultInstance()) return this;
      if (other.hasBlockerType()) {
        blockerType_ = other.blockerType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDocumentationLink()) {
        documentationLink_ = other.documentationLink_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasExplanation()) {
        explanation_ = other.explanation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.facilities_.isEmpty()) {
        if (facilities_.isEmpty()) {
          facilities_ = other.facilities_;
          bitField0_ |= 0x00000008;
        } else {
          ensureFacilitiesIsMutable();
          facilities_.addAll(other.facilities_);
        }
        onChanged();
      }
      if (!other.interconnects_.isEmpty()) {
        if (interconnects_.isEmpty()) {
          interconnects_ = other.interconnects_;
          bitField0_ |= 0x00000010;
        } else {
          ensureInterconnectsIsMutable();
          interconnects_.addAll(other.interconnects_);
        }
        onChanged();
      }
      if (!other.metros_.isEmpty()) {
        if (metros_.isEmpty()) {
          metros_ = other.metros_;
          bitField0_ |= 0x00000020;
        } else {
          ensureMetrosIsMutable();
          metros_.addAll(other.metros_);
        }
        onChanged();
      }
      if (!other.zones_.isEmpty()) {
        if (zones_.isEmpty()) {
          zones_ = other.zones_;
          bitField0_ |= 0x00000040;
        } else {
          ensureZonesIsMutable();
          zones_.addAll(other.zones_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 747721466:
              {
                documentationLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 747721466
            case 928682554:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureZonesIsMutable();
                zones_.add(s);
                break;
              } // case 928682554
            case -1245408518:
              {
                blockerType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1245408518
            case -257003318:
              {
                explanation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -257003318
            case -133468886:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInterconnectsIsMutable();
                interconnects_.add(s);
                break;
              } // case -133468886
            case -30428206:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMetrosIsMutable();
                metros_.add(s);
                break;
              } // case -30428206
            case -1502198:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFacilitiesIsMutable();
                facilities_.add(s);
                break;
              } // case -1502198
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object blockerType_ = "";

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return Whether the blockerType field is set.
     */
    public boolean hasBlockerType() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return The blockerType.
     */
    public java.lang.String getBlockerType() {
      java.lang.Object ref = blockerType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        blockerType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return The bytes for blockerType.
     */
    public com.google.protobuf.ByteString getBlockerTypeBytes() {
      java.lang.Object ref = blockerType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        blockerType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @param value The blockerType to set.
     * @return This builder for chaining.
     */
    public Builder setBlockerType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      blockerType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockerType() {
      blockerType_ = getDefaultInstance().getBlockerType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @param value The bytes for blockerType to set.
     * @return This builder for chaining.
     */
    public Builder setBlockerTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      blockerType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object documentationLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return Whether the documentationLink field is set.
     */
    public boolean hasDocumentationLink() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return The documentationLink.
     */
    public java.lang.String getDocumentationLink() {
      java.lang.Object ref = documentationLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentationLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return The bytes for documentationLink.
     */
    public com.google.protobuf.ByteString getDocumentationLinkBytes() {
      java.lang.Object ref = documentationLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentationLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @param value The documentationLink to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentationLink_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentationLink() {
      documentationLink_ = getDefaultInstance().getDocumentationLink();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @param value The bytes for documentationLink to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentationLink_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object explanation_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return Whether the explanation field is set.
     */
    public boolean hasExplanation() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return The explanation.
     */
    public java.lang.String getExplanation() {
      java.lang.Object ref = explanation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        explanation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return The bytes for explanation.
     */
    public com.google.protobuf.ByteString getExplanationBytes() {
      java.lang.Object ref = explanation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        explanation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @param value The explanation to set.
     * @return This builder for chaining.
     */
    public Builder setExplanation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      explanation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExplanation() {
      explanation_ = getDefaultInstance().getExplanation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @param value The bytes for explanation to set.
     * @return This builder for chaining.
     */
    public Builder setExplanationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      explanation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList facilities_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFacilitiesIsMutable() {
      if (!facilities_.isModifiable()) {
        facilities_ = new com.google.protobuf.LazyStringArrayList(facilities_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @return A list containing the facilities.
     */
    public com.google.protobuf.ProtocolStringList getFacilitiesList() {
      facilities_.makeImmutable();
      return facilities_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @return The count of facilities.
     */
    public int getFacilitiesCount() {
      return facilities_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @param index The index of the element to return.
     * @return The facilities at the given index.
     */
    public java.lang.String getFacilities(int index) {
      return facilities_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the facilities at the given index.
     */
    public com.google.protobuf.ByteString getFacilitiesBytes(int index) {
      return facilities_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @param index The index to set the value at.
     * @param value The facilities to set.
     * @return This builder for chaining.
     */
    public Builder setFacilities(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFacilitiesIsMutable();
      facilities_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @param value The facilities to add.
     * @return This builder for chaining.
     */
    public Builder addFacilities(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFacilitiesIsMutable();
      facilities_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @param values The facilities to add.
     * @return This builder for chaining.
     */
    public Builder addAllFacilities(java.lang.Iterable<java.lang.String> values) {
      ensureFacilitiesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facilities_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacilities() {
      facilities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
     * </pre>
     *
     * <code>repeated string facilities = 536683137;</code>
     *
     * @param value The bytes of the facilities to add.
     * @return This builder for chaining.
     */
    public Builder addFacilitiesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFacilitiesIsMutable();
      facilities_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList interconnects_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInterconnectsIsMutable() {
      if (!interconnects_.isModifiable()) {
        interconnects_ = new com.google.protobuf.LazyStringArrayList(interconnects_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @return A list containing the interconnects.
     */
    public com.google.protobuf.ProtocolStringList getInterconnectsList() {
      interconnects_.makeImmutable();
      return interconnects_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @return The count of interconnects.
     */
    public int getInterconnectsCount() {
      return interconnects_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @param index The index of the element to return.
     * @return The interconnects at the given index.
     */
    public java.lang.String getInterconnects(int index) {
      return interconnects_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the interconnects at the given index.
     */
    public com.google.protobuf.ByteString getInterconnectsBytes(int index) {
      return interconnects_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @param index The index to set the value at.
     * @param value The interconnects to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnects(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInterconnectsIsMutable();
      interconnects_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @param value The interconnects to add.
     * @return This builder for chaining.
     */
    public Builder addInterconnects(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInterconnectsIsMutable();
      interconnects_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @param values The interconnects to add.
     * @return This builder for chaining.
     */
    public Builder addAllInterconnects(java.lang.Iterable<java.lang.String> values) {
      ensureInterconnectsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, interconnects_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnects() {
      interconnects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Interconnects used to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string interconnects = 520187301;</code>
     *
     * @param value The bytes of the interconnects to add.
     * @return This builder for chaining.
     */
    public Builder addInterconnectsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInterconnectsIsMutable();
      interconnects_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList metros_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMetrosIsMutable() {
      if (!metros_.isModifiable()) {
        metros_ = new com.google.protobuf.LazyStringArrayList(metros_);
      }
      bitField0_ |= 0x00000020;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @return A list containing the metros.
     */
    public com.google.protobuf.ProtocolStringList getMetrosList() {
      metros_.makeImmutable();
      return metros_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @return The count of metros.
     */
    public int getMetrosCount() {
      return metros_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param index The index of the element to return.
     * @return The metros at the given index.
     */
    public java.lang.String getMetros(int index) {
      return metros_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metros at the given index.
     */
    public com.google.protobuf.ByteString getMetrosBytes(int index) {
      return metros_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param index The index to set the value at.
     * @param value The metros to set.
     * @return This builder for chaining.
     */
    public Builder setMetros(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetrosIsMutable();
      metros_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param value The metros to add.
     * @return This builder for chaining.
     */
    public Builder addMetros(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetrosIsMutable();
      metros_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param values The metros to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetros(java.lang.Iterable<java.lang.String> values) {
      ensureMetrosIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metros_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetros() {
      metros_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param value The bytes of the metros to add.
     * @return This builder for chaining.
     */
    public Builder addMetrosBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMetrosIsMutable();
      metros_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList zones_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureZonesIsMutable() {
      if (!zones_.isModifiable()) {
        zones_ = new com.google.protobuf.LazyStringArrayList(zones_);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @return A list containing the zones.
     */
    public com.google.protobuf.ProtocolStringList getZonesList() {
      zones_.makeImmutable();
      return zones_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @return The count of zones.
     */
    public int getZonesCount() {
      return zones_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param index The index of the element to return.
     * @return The zones at the given index.
     */
    public java.lang.String getZones(int index) {
      return zones_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the zones at the given index.
     */
    public com.google.protobuf.ByteString getZonesBytes(int index) {
      return zones_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param index The index to set the value at.
     * @param value The zones to set.
     * @return This builder for chaining.
     */
    public Builder setZones(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZonesIsMutable();
      zones_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param value The zones to add.
     * @return This builder for chaining.
     */
    public Builder addZones(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZonesIsMutable();
      zones_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param values The zones to add.
     * @return This builder for chaining.
     */
    public Builder addAllZones(java.lang.Iterable<java.lang.String> values) {
      ensureZonesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, zones_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZones() {
      zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param value The bytes of the zones to add.
     * @return This builder for chaining.
     */
    public Builder addZonesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureZonesIsMutable();
      zones_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers)
  private static final com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1
            .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers();
  }

  public static com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers>
      PARSER =
          new com.google.protobuf.AbstractParser<
              InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers>() {
            @java.lang.Override
            public InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
                parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<
          InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<
          InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
